/*
 * $RCSfile: ResAdmin.java,v $
 *
 * Copyright (c) 1999-2002. The Res Medicinae Developers. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.application.healthcare.resadmin;

import org.resmedicinae.application.common.basic.BasicApplication;
import org.resmedicinae.application.healthcare.resadmin.data.*;
import org.resmedicinae.application.healthcare.resadmin.table.*;
import org.resmedicinae.resmedlib.component.view.View;

import javax.swing.*;
import javax.swing.event.*;
import java.awt.event.*;

import java.io.*;
import java.util.*;


/**
 * This class represents a resadmin application.
 *
 * @version $Revision: 1.6 $ $Date: 2003/01/26 23:36:57 $ $Author: kumanan $
 * @author Kumanan Kanagasabapathy <kumanan@uni.de>
 * @author Christian Heller <christian.heller@tuxtax.de>
 */
public class ResAdmin extends BasicApplication implements ActionListener, TableModelListener {

    public static final String FILE_NEW = "FILE_NEW";
    public static final String FILE_OPEN_FILE = "FILE_OPEN_FILE";
    public static final String FILE_OPEN_DIR = "FILE_OPEN_DIR";
    public static final String FILE_REOPEN = "FILE_REOPEN";
    public static final String FILE_PRINT = "FILE_PRINT";
    public static final String FILE_EXIT = "FILE_EXIT";

    public static final String DATA_NEW_BUTTON_ID = "DATA_NEW_BUTTON_ID";
    public static final String DATA_EDIT_BUTTON_ID = "DATA_EDIT_BUTTON_ID";
    public static final String DATA_VIEW_BUTTON_ID = "DATA_VIEW_BUTTON_ID";
    public static final String DATA_SEARCH_BUTTON_ID = "DATA_SEARCH_BUTTON_ID";
    public static final String DATA_DELETE_BUTTON_ID = "DATA_DELETE_BUTTON_ID";
    public static final String DATA_PRINT_BUTTON_ID = "DATA_PRINT_BUTTON_ID";


    public static final String SETTING_LANGUAGE = "SETTING_LANGUAGE";
    public static final String SETTING_XMLSTRUCTURE = "SETTING_XMLSTRUCTURE";
    public static final String SETTING_LANGUAGE_GERMAN = "SETTING_LANGUAGE_GERMAN";
    public static final String SETTING_LANGUAGE_ENGLISH = "SETTING_LANGUAGE_ENGLISH";
    public static final String SETTING_LANGUAGE_DEFAULT = "SETTING_LANGUAGE_DEFAULT";
    public static final String SETTING_LANGUAGE_TAMIL = "SETTING_LANGUAGE_TAMIL";

    public static final String SETTING_OPTION = "SETTING_OPTION";

    public static final String HELP_ABOUT = "HELP_ABOUT";
    public static final String HELP_CONTEXT = "HELP_CONTEXT";

    //Data New Buttons
    public static final String NEW_DATA_CANCEL_BUTTON = "CANCEL_NEW_DATA";
    public static final String NEW_DATA_SAVE_BUTTON = "SAVE_NEW_DATA";
    public static final String NEW_DATA_CLEAR_BUTTON = "CLEAR_NEW_DATA";

    //Data Edit Buttons
    public static final String EDIT_DATA_CANCEL_BUTTON = "CANCEL_EDIT_DATA";
    public static final String EDIT_DATA_SAVE_BUTTON = "UPDATE_EDIT_DATA";
    public static final String EDIT_DATA_CLEAR_BUTTON = "CLEAR_EDIT_DATA";
    public static final String EDIT_DATA_RESET_BUTTON = "RESET_EDIT_DATA";

    //Data search Buttons
    public static final String SEARCH_DATA_SEARCH_BUTTON = "SEARCH_SEARCH_DATA";
    public static final String SEARCH_DATA_CANCEL_BUTTON = "CANCEL_SEARCH_DATA";
    public static final String SEARCH_DATA_CLEAR_BUTTON = "CLEAR_SEARCH_DATA";

    //XmlStructure Buttons
    public static final String XMLSTRDIALOG_SAVE_BUTTON = "XMLSTRDIALOG_SAVE_BUTTON";
    public static final String XMLSTRDIALOG_CANCEL_BUTTON = "XMLSTRDIALOG_CANCEL_BUTTON";
    public static final String XMLSTRDIALOG_RESET_BUTTON = "XMLSTRDIALOG_RESET_BUTTON";

    //Directory path for icon, locale
    public static final String userDir = System.getProperty("user.dir").toString();
    public static final String shareAdmin = userDir + File.separator + "share" + File.separator + "application" + File.separator + "healthcare" + File.separator + "resadmin" + File.separator;
    public static final String iconDir = shareAdmin + "icon" + File.separator;
    public static final String localeDir = shareAdmin + "locale" + File.separator;

    //  Creates a model
    //
    // @exception NullPointerException if the view is null

    public Object createModel() throws Exception {

        ResAdminModel m = new ResAdminModel();
        if (m != null) {
            m.initialize();

            System.out.println("ResAdminModel created");
        }
        else {
            throw new NullPointerException("Could not create model. The model is null.");
        }
        return (Object) m;
    }

    /**
     * Creates a view.
     *
     * @return the view
     * @exception NullPointerException if the view is null
     */
    public View createView() throws Exception, NullPointerException {

        ResAdminView v = new ResAdminView();

        if (v != null) {

            //?? Only temporary! Remove this line later, when Controller does not need to be set
            //?? and when assigning ControlId to GUI components is enough.
            v.setController(this);

            v.configure(getConfigurationManager());
            v.initialize();
            System.out.println("ResAdminView created.");

        }
        else {

            throw new NullPointerException("Could not create view. The view is null.");
        }

        return v;
    }

    //
    //
    //
    public void initialize() throws Exception {

        super.initialize();

        ResAdminModel model = (ResAdminModel) getModel();
        getView().setModel(model);

        if (model != null) {

            model.setView((ResAdminView) getView());

            ResAdminView view = (ResAdminView) getView();

            model.setView(view);
            view.setResAdminTableModel(model.getResTableModel());
            //view.setXmlStructureDialog(view.createXmlStructureDialog());
            // resAdminTableModel.addTableModelListener((ResAdmin) getController());
            model.getResTableModel().addTableModelListener(this);
        }
        else
            System.out.println("NO MODEL FOUND!");
    }

    /**
     * Handles the action event.
     *
     * @param evt the action event
     */
    public void actionPerformed(ActionEvent e) {

        ResAdminModel model = (ResAdminModel) getModel();
        ResAdminView view = (ResAdminView) getView();

        if (e.getActionCommand() == ResAdmin.FILE_NEW) {

            JFileChooser jfc = view.getFileNewDialog();

            int value = jfc.showOpenDialog(new JFrame());

            if (value == JFileChooser.APPROVE_OPTION) {

                File file = jfc.getSelectedFile();

                try {

                    if (file.isDirectory()) {

                        System.out.println("Directory opened: " + file.toString());
                        model.setWorkingDir(file);
                        model.clearResTableModel();
                        view.setDataFieldtoClear();
                        view.setFieldId("");
                        view.changeDataButtonPanel("view");
                        view.setPrintButton(false);
                        view.setNewButton(true);
                        view.setViewButton(false);
                        view.setEditButton(false);
                        view.setDeleteButton(false);
                        view.setSearchButton(false);

                        this.updateStatus();

                    }
                    else
                        System.out.println(file + "..is not a Directory!!");
                } catch (Exception ex) {
                    System.out.println("FILE_OPEN_DIR: " + ex);
                }

            }
        }
        else if (e.getActionCommand() == ResAdmin.FILE_OPEN_FILE) {

            JFileChooser jfc = view.getFileDialog();

            int value = jfc.showOpenDialog(new JFrame());

            if (value == JFileChooser.APPROVE_OPTION) {

                File file = jfc.getSelectedFile();

                try {

                    if (file.isFile()) {

                        System.out.println("open : " + file.getParentFile() );
                        System.out.println("File opened: " + file.toString());
                        model.clearResTableModel();
                        model.setWorkingDir(file.getParentFile());

                        Person p = model.openXmlFile(file);
                        model.addPersonToTable(p);
                        this.updateStatus();
                    }
                    else System.out.println(file + "..File not exists");

                }
                catch (Exception ex) {
                    System.out.println("FILE_OPEN_FILE: " + ex);
                }
            }
        }

        else if (e.getActionCommand() == ResAdmin.FILE_OPEN_DIR) {

            System.out.println("File Directory clicked");

            JFileChooser jfc = view.getFileDirDialog();

            int value = jfc.showOpenDialog(new JFrame());

            if (value == JFileChooser.APPROVE_OPTION) {

                File dirFile = jfc.getSelectedFile();

                try {

                    if (dirFile.isDirectory()) {

                        System.out.println("Directory opened: " + dirFile.toString());

                        view.setDataFieldtoClear();
                        view.setFieldId("");
                        System.out.println("XML Files exist? " + model.loadFileFromDir(dirFile));
                        this.updateStatus();

                    }
                    else
                        System.out.println(dirFile + "..File not exists");
                } catch (Exception ex) {
                    System.out.println("FILE_OPEN_DIR: " + ex);
                }

            }

        }
        else if (e.getActionCommand() == ResAdmin.FILE_REOPEN) {

            System.out.println("File Reopen clicked");


        }
        else if (e.getActionCommand() == ResAdmin.FILE_PRINT) {

            System.out.println("File Print clicked");

           view.printTable();

        }
        else if (e.getActionCommand() == ResAdmin.FILE_EXIT) {

            System.out.println("File exit clicked");
            System.exit(0);
        }

        else if(e.getActionCommand() == ResAdmin.SETTING_LANGUAGE_ENGLISH){

            Locale locale = new Locale("en","US");
            System.out.println("Selected Locale: en_US");
            System.out.println(new Locale("ENGLISH"));
            this.languageChange(locale);
        }


        else if(e.getActionCommand() == ResAdmin.SETTING_LANGUAGE_GERMAN){

            Locale locale = new Locale("de","DE");
            System.out.println("Selected Locale: de_DE");
            System.out.println(new Locale("GERMAN"));
            this.languageChange(locale);
        }

        else if(e.getActionCommand() == ResAdmin.SETTING_LANGUAGE_TAMIL){

            Locale locale = new Locale("ta","IN");
            System.out.println("Selected Locale: ta_IN");
            System.out.println(new Locale("TAMIL"));
            this.languageChange(locale);
        }


        else if (e.getActionCommand() == ResAdmin.SETTING_XMLSTRUCTURE) {

            try {

                view.setXmlStructureDialog(view.createXmlStructureDialog());
                show(view.getXmlStructureDialog());
            } catch (Exception exp) {
                System.out.println("SETTING_XMLSTRUCTURE: " + exp);
            }


        }
        else if (e.getActionCommand() == ResAdmin.XMLSTRDIALOG_CANCEL_BUTTON) {


            try {

                System.out.println("ResAdmin.XMLSTRDIALOG_CANCEL_BUTTON click...");

                hide(view.getXmlStructureDialog());

            } catch (Exception exp) {
                System.out.println("SETTING_XMLSTRUCTURE XMLSTRDIALOG_CANCEL_BUTTON: " + exp);
            }

        }
        else if (e.getActionCommand() == ResAdmin.XMLSTRDIALOG_RESET_BUTTON) {

            view.getXmlStructureDialog().setXmlPersonTag();

        }
        else if (e.getActionCommand() == ResAdmin.XMLSTRDIALOG_SAVE_BUTTON) {

            try {

                model.setPersonTag(view.getXmlStructureDialog().getXmlPersonTag());
                hide(view.getXmlStructureDialog());

            } catch (Exception exp) {
                System.out.println("SETTING_XMLSTRUCTURE XMLSTRDIALOG_SAVE_BUTTON: " + exp);
            }

        }
        else if (e.getActionCommand() == ResAdmin.DATA_NEW_BUTTON_ID) {

            view.changeDataButtonPanel("new");
            view.setDataFieldtoClear();
            view.setFieldId(model.createTimeBasedID());

        }
        else if (e.getActionCommand() == ResAdmin.DATA_VIEW_BUTTON_ID) {

         int row = view.getTable().getSelectedRow();

         if(row>=0 && row < view.getTable().getRowCount()){

             Person p = this.getPersonFromRow(view.getTable().getSelectedRow());

             if(p!=null) {
                model.setPerson(p);
                model.setSelectedRow(row);
                view.changeDataButtonPanel("view");
                view.setPersonFields(p);
             }
         }
         else {

             System.out.println("Select a row");
             view.showMessage("srow");
         }
        }

        else if (e.getActionCommand() == ResAdmin.DATA_EDIT_BUTTON_ID) {

            int row = view.getTable().getSelectedRow();

            if(row>=0 && row < view.getTable().getRowCount()){

                Person p = this.getPersonFromRow(view.getTable().getSelectedRow());

                if(p!=null) {
                    model.setPerson(p);
                    model.setSelectedRow(row);
                    view.changeDataButtonPanel("edit");
                    view.setPersonFields(p);
                }
            }
            else{

                System.out.println("Select a row");
                view.showMessage("srow");
            }
        }
        else if (e.getActionCommand() == ResAdmin.DATA_DELETE_BUTTON_ID) {

            System.out.println("data delete ");

            int rows[] = view.getTable().getSelectedRows();

            Vector IDVector = new Vector();

            if(rows.length == 0) {

                System.out.println("Not Selected...");
                JOptionPane.showMessageDialog( null, "Select rows from the table to Delete"
                          ,"Message",JOptionPane.INFORMATION_MESSAGE);
            }

            else {

                for(int i=0; i < rows.length; i++) {

                    if(rows[i] < view.getTable().getRowCount() && rows[i] >= 0) {
                        TPerson p = (TPerson) model.getResTableModel().get(rows[i]);
                        IDVector.add(p.getPersonId());
                    }
                }

                try {

                    String del = new String();

                    for(int x=0; x <IDVector.size(); x++) {

                        del = del + IDVector.elementAt(x) + ".xml" + "\n";
                    }

                    int value =  JOptionPane.showConfirmDialog(null,
                        "Delete the following files? " + "\n" + "\n" +
                            del + "\n",
                        "Message",JOptionPane.YES_NO_OPTION, JOptionPane.QUESTION_MESSAGE);

                    if(value == JOptionPane.YES_OPTION){

                        for(int i=0;i < IDVector.size();i++) {

                            File delFile = new File(model.getWorkingDir() + File.separator + IDVector.elementAt(i) + ".xml");
                            model.getResTableModel().remove(rows[i]);

                            if(delFile.delete()) {

                                System.out.println("Following file is deleted: " + delFile);
                            }

                            else System.out.println("File not deleted");

                        }

                    }
                }
                catch (Exception ex) { System.out.println("data_view_button :" + ex);}

            }
        }

        else if (e.getActionCommand() == ResAdmin.DATA_SEARCH_BUTTON_ID) {

            view.changeDataButtonPanel("search");
            view.getTable().clearSelection();
            view.setFieldId("");

        }
        else if (e.getActionCommand() == ResAdmin.DATA_PRINT_BUTTON_ID) {


        }

        //Action for NewData Buttons
        else if (e.getActionCommand() == ResAdmin.NEW_DATA_CLEAR_BUTTON) {

            view.setDataFieldtoClear();

        }
        else if (e.getActionCommand() == ResAdmin.NEW_DATA_SAVE_BUTTON) {


            Person p = view.getPersonFields();
            if (p.getPersonId().equals("") || p.getFirstName().equals("") ||
                    p.getLastName().equals("") || p.getStreet().equals("") ||
                    p.getZip().equals("") || p.getCity().equals("") || p.getState().equals("")
                    || p.getCountry().equals("")) {

                JOptionPane.showMessageDialog(null, "Fill_all_requested Fields" + "\n"

                        , "ErrorMessage", JOptionPane.ERROR_MESSAGE);
            }
            else {

                if (model.saveNewFile(p)) {
                    JOptionPane.showMessageDialog(null, "File_successfull_saved" + "\n"

                            , "Message", JOptionPane.INFORMATION_MESSAGE);

                  int siz = model.getResTableModel().getRowCount();
                  model.addPersonToTable(p);

                  try {

                      view.getTable().setRowSelectionInterval(siz,siz);
                      view.getToolBarViewButton().doClick();
                  }
                  catch (Exception exp) { System.out.println("selectrow: " + exp); }
                }
                else {

                    JOptionPane.showMessageDialog(null, "There_was_some_error_save" + "\n"

                            , "ErrorMessage", JOptionPane.ERROR_MESSAGE);
                }

            }
        }
        else if (e.getActionCommand() == ResAdmin.NEW_DATA_CANCEL_BUTTON) {

            System.out.println("cancel button");
            view.getToolBarViewButton().doClick();

        }
        //Action for EditData Buttons
        else if (e.getActionCommand() == ResAdmin.EDIT_DATA_CLEAR_BUTTON) {

            view.setDataFieldtoClear();

        }
        else if (e.getActionCommand() == ResAdmin.EDIT_DATA_RESET_BUTTON) {

            view.setPersonFields(model.getPerson());

        }
        else if (e.getActionCommand() == ResAdmin.EDIT_DATA_SAVE_BUTTON) {

            System.out.println("Edit SaveButton clicked..");
            // view.setPersonFields(view.getPersonFields());
            Person p = view.getPersonFields();

            if (p.getPersonId().equals("") || p.getFirstName().equals("") ||
                    p.getLastName().equals("") || p.getStreet().equals("") ||
                    p.getZip().equals("") || p.getCity().equals("") || p.getState().equals("")
                    || p.getCountry().equals("")) {

                JOptionPane.showMessageDialog(null, "Fill_all_requested Fields" + "\n"

                        , "ErrorMessage", JOptionPane.ERROR_MESSAGE);
            }
            else {

                model.setPerson(view.getPersonFields());
                int row = view.getTable().getSelectedRow();
                model.saveEditFile(view.getPersonFields(), row);

                view.setPersonFields(model.getPerson());
                view.getTable().setRowSelectionInterval(model.getSelectedRow(),model.getSelectedRow());
                view.getToolBarViewButton().doClick();
            }

        }
        else if (e.getActionCommand() == ResAdmin.EDIT_DATA_CANCEL_BUTTON) {

            view.setPersonFields(model.getPerson());
            view.getToolBarViewButton().doClick();

        }
        //Action for SearchData Buttons ends

        else if (e.getActionCommand() == ResAdmin.SEARCH_DATA_SEARCH_BUTTON) {

            Person p = view.getPersonFields();
            Vector result = model.searchPerson(p);
        }

        else if (e.getActionCommand() == ResAdmin.SEARCH_DATA_CANCEL_BUTTON) {

            view.getToolBarViewButton().doClick();
        }
    }

    public Person getPersonFromRow(int row){

        ResAdminView view = (ResAdminView) getView();
        ResAdminModel model = (ResAdminModel) getModel();

        TPerson tp = model.getResTableModel().get(row);

        File file = new File(model.getWorkingDir() + File.separator + tp.getPersonId() + ".xml");

        Person p = model.openXmlFile(file);
        return p;
    }

    public void valueChanged(ListSelectionEvent e) {

      ResAdminView view = (ResAdminView) getView();
      ResAdminModel model = (ResAdminModel) getModel();
  }

   public void updateStatus(){

       ResAdminModel model = (ResAdminModel) getModel();
       ResAdminView view = (ResAdminView) getView();

       view.setStatusMessage(model.getWorkingDir().toString());

       if(model.getResTableModel().size()>0){

           view.getTable().setRowSelectionInterval(0, 0);
       }
       System.out.println("updateStauts");

   }

   public void tableChanged(TableModelEvent e){

       ResAdminModel model = (ResAdminModel) getModel();
       ResAdminView view = (ResAdminView) getView();

       if(model.getResTableModel().getRowCount() >=1) {

           view.setPrintButton(true);
           view.setNewButton(true);
           view.setViewButton(true);
           view.setEditButton(true);
           view.setDeleteButton(true);
           view.setSearchButton(true);

       }
        else {

           view.setPrintButton(false);
          // view.setNewButton(false);
           view.setViewButton(false);
           view.setEditButton(false);
           view.setDeleteButton(false);
           view.setSearchButton(false);
        }
   }

    public void languageChange(Locale l){

       ResAdminView view = (ResAdminView) getView();
       ResAdminModel model = (ResAdminModel) getModel();

       view.setResAdminLocale(l);
       view.populate();

       model.setResAdminLocale(l);
       model.populate();
    }

}
