/*
 * $RCSfile: NewHealthRecord.java,v $
 *
 * Copyright (c) 1999-2002. Torsten Kunze. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.application.healthcare.reform.xml;

import org.resmedicinae.application.controller.basic.*;
import org.resmedicinae.resmedlib.component.control.*;
import org.resmedicinae.resmedlib.component.view.swing.*;

import javax.swing.*;
import java.awt.*;

/**
 * This class creates a new healthRecord. It extends the javax.swing.JFrame.
 * @see JFrame
 */
public class NewHealthRecord extends SwingView {
    public static final String ADD_NEW_HEALTHRECORD_DIALOG_CONTROL_ID = "_Add";
    public static final String NEW_NEW_HEALTHRECORD_DIALOG_CONTROL_ID = "_New";
    public static final String DESTROY_NEW_HEALTHRECORD_DIALOG_CONTROL_ID = "_Close";

    /** JTextField that includes the name of the patient */
    private JTextField tfName;

    /** JTextField that includes the first name of the patient */
    private JTextField tfFirstname;

    /** JTextField that includes the birth date of the patient */
    private JTextField tfBirthday;

    /** JTextField that includes the street of the patient */
    private JTextField tfStreet;

    /** JTextField that includes the zip code of the patient */
    private JTextField tfZipCode;

    /** JTextField that includes the town of the patient */
    private JTextField tfTown;

    /** JTextField that includes the country of the patient */
    private JTextField tfCountry;

    /** JTextField that includes the country of the patient */
    private JTextField tfPhoneNumber;

    /** JTextField that includes the insurance  of the patient */
    private JTextField tfInsurance;

    /** JTextField that includes the insurance number of the patient */
    private JTextField tfInsuranceNumber;

    /** JTextField that includes the blood type of the patient */
    private JTextField tfBloodType;

    /** JTextField that includes the height of the patient */
    private JTextField tfHeight;

    /** JTextField that includes the weight of the patient */
    private JTextField tfWeight;


    /** sets the member variables, calls initLayout() and shows this frame. */
    public void initialize() {
        try {
            super.initialize();
            //?? Temporary! The display mode of this about dialog is read from the configuration of the application (and such is FRAME_DISPLAY)!
            setDisplayMode(DisplayFactory.MODELESS_DIALOG_DISPLAY);
            //?? Temporary! The dialog bounds of this about dialog are read from the configuration of the application!
            setDialogBounds(createDialogBounds());
            // Set parameters.
            setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            // Set panel properties and add child components.
            this.initLayout();
            this.setTitle("New healthRecord");
          //  this.setSize(300, 265);
            this.setLocation(0, 300);
        } catch (Exception e) {
            //?? getLogger().log("");
            System.out.println("Fehler: " + e);
        }
    }

    /** initializes the layout */
    public void initLayout() {
        JPanel text = new JPanel();
        text.setLayout(new GridLayout(13, 2));
        JLabel lName = new JLabel("Name: ");
        JLabel lFirstName = new JLabel("FirstName: ");
        JLabel lBirthday = new JLabel("Birthday: ");
        JLabel lStreet = new JLabel("Street: ");
        JLabel lZipCode = new JLabel("ZipCode: ");
        JLabel lTown = new JLabel("Town: ");
        JLabel lCountry = new JLabel("Country: ");
        JLabel lPhoneNumber = new JLabel("PhoneNumber: ");
        JLabel lInsurance = new JLabel("Insurance: ");
        JLabel lInsuranceNumber = new JLabel("Insurance number: ");
        JLabel lBloodType = new JLabel("Blood type: ");
        JLabel lHeight = new JLabel("Height: ");
        JLabel lWeight = new JLabel("Weight: ");

        tfName = new JTextField();
        tfName.setColumns(10);
        tfFirstname = new JTextField();
        tfFirstname.setColumns(10);
        tfBirthday = new JTextField();
        tfBirthday.setColumns(10);
        tfStreet = new JTextField();
        tfStreet.setColumns(10);
        tfZipCode = new JTextField();
        tfZipCode.setColumns(10);
        tfTown = new JTextField();
        tfTown.setColumns(10);
        tfCountry = new JTextField();
        tfCountry.setColumns(10);
        tfPhoneNumber = new JTextField();
        tfPhoneNumber.setColumns(10);
        tfInsurance = new JTextField();
        tfInsurance.setColumns(10);
        tfInsuranceNumber = new JTextField();
        tfInsuranceNumber.setColumns(10);
        tfBloodType = new JTextField();
        tfBloodType.setColumns(10);
        tfHeight = new JTextField();
        tfHeight.setColumns(10);
        tfWeight = new JTextField();
        tfWeight.setColumns(10);

        text.add(lName);
        text.add(tfName);
        text.add(lFirstName);
        text.add(tfFirstname);
        text.add(lBirthday);
        text.add(tfBirthday);
        text.add(lStreet);
        text.add(tfStreet);
        text.add(lZipCode);
        text.add(tfZipCode);
        text.add(lTown);
        text.add(tfTown);
        text.add(lCountry);
        text.add(tfCountry);
        text.add(lPhoneNumber);
        text.add(tfPhoneNumber);
        text.add(lInsurance);
        text.add(tfInsurance);
        text.add(lInsuranceNumber);
        text.add(tfInsuranceNumber);
        text.add(lBloodType);
        text.add(tfBloodType);
        text.add(lHeight);
        text.add(tfHeight);
        text.add(lWeight);
        text.add(tfWeight);

        JPanel button = new JPanel();
        button.setLayout(new GridLayout(1, 3));
        JButton bAdd = new JButton("Add");
        bAdd.addActionListener(getActionListener());
        bAdd.setActionCommand(ADD_NEW_HEALTHRECORD_DIALOG_CONTROL_ID);
        bAdd.setToolTipText("Close this window");
        JButton bNew = new JButton("New");
        bNew.addActionListener(getActionListener());
        bNew.setActionCommand(NEW_NEW_HEALTHRECORD_DIALOG_CONTROL_ID);
        bNew.setToolTipText("Close this window");
        JButton bClose = new JButton("Close");
        bClose.addActionListener(getActionListener());
        bClose.setActionCommand(DESTROY_NEW_HEALTHRECORD_DIALOG_CONTROL_ID);
        bClose.setToolTipText("Close this window");
        button.add(bAdd);
        button.add(bNew);
        button.add(bClose);
        this.setLayout(new BorderLayout());
        this.add(text, BorderLayout.CENTER);
        this.add(button, BorderLayout.SOUTH);
    }

    /** Clears all JTextFields. */
    public void clearAllTextFields() {
        getTfName().setText("");
        getTfFirstname().setText("");
        getTfBirthday().setText("");
        getTfStreet().setText("");
        getTfZipCode().setText("");
        getTfTown().setText("");
        getTfCountry().setText("");
        getTfPhoneNumber().setText("");
        getTfInsurance().setText("");
        getTfInsuranceNumber().setText("");
        getTfBloodType().setText("");
        getTfHeight().setText("");
        getTfWeight().setText("");
    }

    public BasicController getActionListener() {
        return (BasicController) getController();
    }

    /**
     * Creates a rectangle storing the dialog bounds.
     * @return the rectangle storing the dialog bounds
     */
    public Rectangle createDialogBounds() {
        // Determine width.
        int screenWidth = (int) Math.floor(Toolkit.getDefaultToolkit().getScreenSize().getWidth());
        int w = 300;
        if (w > screenWidth) {
            w = screenWidth;
        }
        // Use centered x position by default.
        int x = (screenWidth - w) / 2;
        // Determine height.
        int screenHeight = (int) Math.floor(Toolkit.getDefaultToolkit().getScreenSize().getHeight());
        int h = 360;
        if (h > screenHeight) {
            h = screenHeight;
        }
        // Use centered y position by default.
        int y = (screenHeight - h) / 2;
        return new Rectangle(x, y, w, h);
    }
    //
    // Display mode.
    //

    /**
     * Creates a display mode.
     * @return the display mode
     */
    public int createDisplayMode() {
        return DisplayFactory.MODELESS_DIALOG_DISPLAY;
    }
    //
    // Close control.
    //

    /**
     * Creates a control issued when the window containing this view is closed.
     * @return the control issued when the window containing this view is closed
     * @exception NullPointerException if the control is null
     */
    public Control createCloseControl() throws NullPointerException {
        Control c = new Control();
        if (c != null) {
            c.setId(NewHealthRecord.DESTROY_NEW_HEALTHRECORD_DIALOG_CONTROL_ID);
            c.setSender((Controller) getController());
        } else {
            throw new NullPointerException("Could not create close control. The control is null.");
        }
        return c;
    }

    public JTextField getTfName() {
        return this.tfName;
    }

    public void setTfName(JTextField tfName) {
        this.tfName = tfName;
    }

    public JTextField getTfFirstname() {
        return this.tfFirstname;
    }

    public void setTfFirstname(JTextField tfFirstname) {
        this.tfFirstname = tfFirstname;
    }

    public JTextField getTfBirthday() {
        return this.tfBirthday;
    }

    public void setTfBirthday(JTextField tfBirthday) {
        this.tfBirthday = tfBirthday;
    }

    public JTextField getTfStreet() {
        return this.tfStreet;
    }

    public void setTfStreet(JTextField tfStreet) {
        this.tfStreet = tfStreet;
    }

    public JTextField getTfTown() {
        return this.tfTown;
    }

    public void setTfTown(JTextField tfTown) {
        this.tfTown = tfTown;
    }

    public JTextField getTfZipCode() {
        return this.tfZipCode;
    }

    public void setTfZipCode(JTextField tfZipCode) {
        this.tfZipCode = tfZipCode;
    }

    public JTextField getTfCountry() {
        return this.tfCountry;
    }

    public void setTfCountry(JTextField tfCountry) {
        this.tfCountry = tfCountry;
    }

    public JTextField getTfPhoneNumber() {
        return tfPhoneNumber;
    }

    public void setTfPhoneNumber(JTextField tfPhoneNumber) {
        this.tfPhoneNumber = tfPhoneNumber;
    }

    public JTextField getTfInsurance() {
        return this.tfInsurance;
    }

    public void setTfInsurance(JTextField tfInsurance) {
        this.tfInsurance = tfInsurance;
    }

    public JTextField getTfInsuranceNumber() {
        return tfInsuranceNumber;
    }

    public void setTfInsuranceNumber(JTextField tfInsuranceNumber) {
        this.tfInsuranceNumber = tfInsuranceNumber;
    }

    public JTextField getTfBloodType() {
        return tfBloodType;
    }

    public void setTfBloodType(JTextField tfBloodType) {
        this.tfBloodType = tfBloodType;
    }

    public JTextField getTfHeight() {
        return tfHeight;
    }

    public void setTfHeight(JTextField tfHeight) {
        this.tfHeight = tfHeight;
    }

    public JTextField getTfWeight() {
        return tfWeight;
    }

    public void setTfWeight(JTextField tfWeight) {
        this.tfWeight = tfWeight;
    }

}
