/*
 * $RCSfile: LoadedHealthRecords.java,v $
 *
 * Copyright (c) 1999-2002. Torsten Kunze. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.application.healthcare.reform.xml;

import org.resmedicinae.domain.healthcare.*;

import java.util.*;

/**
 * This class represents a store object that includes all healthRecords that were already loaded.
 * It extends the java.util.Hashtable.
 */
public class LoadedHealthRecords extends Hashtable {
    private boolean dataWasModified = false;

    /** The Consturctor calls its super() -method. */
    public LoadedHealthRecords() {
        super();
    }

    /**
     * Adds a new HealthRecord.
     * @param healthRecord the healthRecord to add
     */
    public void addHealthRecord(HealthRecord healthRecord) {
        this.put(healthRecord.getIdentifier(), healthRecord);
        setDataModified(true);
    }

    /**
     * Looks for a HealthRecord with the given healthRecordId.
     * @param healthRecordId a String that represents the key for the healthRecord in this hashtable
     * @return the wanted healthRecord
     */
    public HealthRecord getHealthRecord(org.resmedicinae.resmedlib.term.String healthRecordId) {
        return (HealthRecord) this.get(healthRecordId.getValue());
    }

    /**
     * Checks if a HealthRecord is stored in this hashtable
     * @param healthRecordId a String that represents the key for the healthRecord in this hashtable
     * @return true, if HealthRecord exists
     * @return false, if HealthRecord doesn't exist
     */
    public boolean isLoadedHealthRecord(org.resmedicinae.resmedlib.term.String healthRecordId) {
        return this.containsKey(healthRecordId.getValue());
    }

    /**
     * Returns all stored HealthRecords as a LoadedHealthRecords object
     * @return itself
     */
    public LoadedHealthRecords getAllHealthRecords() {
        return this;
    }

    /**
     * Updates a stored HealthRecord or store it, if it doesn't exist
     * @param healthRecord to update
     */
    public void updateHealthRecord(HealthRecord healthRecord) {
        if (isLoadedHealthRecord(healthRecord.getIdentifier())) {
            this.remove(healthRecord.getIdentifier());
            addHealthRecord(healthRecord);
        } else
            addHealthRecord(healthRecord);
    }

    /**
     * Removes a HealthRecord from this hastable
     * @param healthRecordId a String that represents the key for the healthRecord in this hashtable
     */
    public void removeHealthRecord(org.resmedicinae.resmedlib.term.String healthRecordId) {
        if (isLoadedHealthRecord(healthRecordId)) {
            this.remove(healthRecordId);
            setDataModified(true);
        }
    }

    public void setDataModified(boolean dataWasModified) {
        this.dataWasModified = dataWasModified;
    }

    public boolean dataModified() {
        return this.dataWasModified;
    }
}
