/*
 * $RCSfile: HealthRecordManager.java,v $
 *
 * Copyright (c) 1999-2002. Torsten Kunze. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.application.healthcare.reform.xml;

import org.resmedicinae.application.controller.basic.*;
import org.resmedicinae.resmedlib.component.control.*;
import org.resmedicinae.resmedlib.component.view.swing.*;

import javax.swing.*;
import java.awt.*;

/**
 * This class controls the input and output of the data and stores them in xml-files.
 * @see HealthRecordIndex
 * @see IndexFileManager
 * @see HealthRecord
 */
public class HealthRecordManager extends SwingView {
    public static final String SELECT_HEALTHRECORD_FILE_MANAGER_DIALOG_CONTROL_ID = "Select";
    public static final String REMOVE_HEALTHRECORD_FILE_MANAGER_DIALOG_CONTROL_ID = "Remove";
    public static final String DESTROY_HEALTHRECORD_FILE_MANAGER_DIALOG_CONTROL_ID = "Close";

    /** JList that inculdes the names of all availlable healthRecords */
    private JList chooseList;

    /** JTextField that inculdes the name or a fragment of the name of the wanted healthRecord */
    private JTextField tfHealthRecordName;

    /** JButton for removing a healthRecord */
    private JButton bRemove;

    /** JButton for selecting a healthRecord */
    private JButton bSelect;

    /** JButton for hiding this dialog */
    private JButton bClose;

    /** initializes the member variables, calls initLayout() */
    public void initialize() {
        try {
            super.initialize();
            //?? Temporary! The display mode of this about dialog is read from the configuration of the application (and such is FRAME_DISPLAY)!
            setDisplayMode(DisplayFactory.MODELESS_DIALOG_DISPLAY);
            //?? Temporary! The dialog bounds of this about dialog are read from the configuration of the application!
            setDialogBounds(createDialogBounds());
            // Set parameters.
            setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));

            setTitle("List of all availlable health records");
            // Set panel properties and add child components.
            initLayout();
        } catch (Exception e) {
            //?? getLogger().log("");
            System.out.println("Fehler: " + e);
        }
    }

    /**
     * @param fileName the fileName of the file to parse
     * @return the Document that include the parsed data
     */
    public void initLayout() {
        JPanel north = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        JLabel lHealthRecordName = new JLabel("health record name:");
        tfHealthRecordName = new JTextField();
        tfHealthRecordName.setColumns(14);
        tfHealthRecordName.getDocument().addDocumentListener(getDocumentListener());
        chooseList = new JList();
        chooseList.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        chooseList.setFixedCellWidth(150);
        chooseList.addListSelectionListener(getListSelectionListener());
        chooseList.addMouseListener(getMouseListener());
        JScrollPane scrollPane = new JScrollPane(chooseList);
        scrollPane.createHorizontalScrollBar();
        scrollPane.createVerticalScrollBar();
        north.setLayout(gridbag);
        north.setBorder(BorderFactory.createTitledBorder("Select health record"));
        c.fill = GridBagConstraints.NONE;
        c.anchor = GridBagConstraints.NORTHWEST;
        c.gridx = 0;
        c.gridy = 0;
        gridbag.setConstraints(lHealthRecordName, c);
        north.add(lHealthRecordName);
        c.gridx = 1;
        c.gridwidth = 2;
        c.insets = new Insets(0, 20, 0, 0);
        gridbag.setConstraints(tfHealthRecordName, c);
        north.add(tfHealthRecordName);
        c.gridy = 2;
        c.gridheight = 13;
        c.insets = new Insets(10, 20, 0, 0);
        gridbag.setConstraints(scrollPane, c);
        north.add(scrollPane);
        //	c.anchor = GridBagConstraints.SOUTH;
        bRemove = new JButton("Remove");
        bRemove.addActionListener(getActionListener());
        bRemove.setActionCommand(REMOVE_HEALTHRECORD_FILE_MANAGER_DIALOG_CONTROL_ID);
        bRemove.setToolTipText("Remove focused health record");
        c.insets = new Insets(5, 10, 0, 0);
        c.gridx = 0;
        c.gridy = 20;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.insets = new Insets(10, 0, 10, 0);
        gridbag.setConstraints(bRemove, c);
        north.add(bRemove);
        bSelect = new JButton("Select");
        bSelect.addActionListener(getActionListener());
        bSelect.setActionCommand(SELECT_HEALTHRECORD_FILE_MANAGER_DIALOG_CONTROL_ID);
        bSelect.setToolTipText("Select focused health record globaly");
        c.gridx = 1;
        c.insets = new Insets(10, 20, 10, 0);
        gridbag.setConstraints(bSelect, c);
        north.add(bSelect);
        bClose = new JButton("Close");
        bClose.addActionListener(getActionListener());
        bClose.setActionCommand(DESTROY_HEALTHRECORD_FILE_MANAGER_DIALOG_CONTROL_ID);
        bClose.setToolTipText("Close this dialog");
        c.gridx = 2;
        c.insets = new Insets(10, 17, 10, 0);
        gridbag.setConstraints(bClose, c);
        north.add(bClose);
        this.add(north);
        bSelect.setEnabled(false);
        bRemove.setEnabled(false);
        this.setSize(300, 280);
        this.setLocation(300, 300);
        this.setTitle("Choose a health record");
    }

    public BasicController getActionListener() {
        return (BasicController) getController();
    }

    public BasicController getMouseListener() {
        return (BasicController) getController();
    }

    public BasicController getDocumentListener() {
        return (BasicController) getController();
    }

    public BasicController getListSelectionListener() {
        return (BasicController) getController();
    }

    /**
     * Creates a rectangle storing the dialog bounds.
     * @return the rectangle storing the dialog bounds
     */
    public Rectangle createDialogBounds() {
        // Determine width.
        int screenWidth = (int) Math.floor(Toolkit.getDefaultToolkit().getScreenSize().getWidth());
        int w = 350;
        if (w > screenWidth) {
            w = screenWidth;
        }
        // Use centered x position by default.
        int x = (screenWidth - w) / 2;
        // Determine height.
        int screenHeight = (int) Math.floor(Toolkit.getDefaultToolkit().getScreenSize().getHeight());
        int h = 300;
        if (h > screenHeight) {
            h = screenHeight;
        }
        // Use centered y position by default.
        int y = (screenHeight - h) / 2;
        return new Rectangle(x, y, w, h);
    }
    //
    // Display mode.
    //

    /**
     * Creates a display mode.
     * @return the display mode
     */
    public int createDisplayMode() {
        return DisplayFactory.MODELESS_DIALOG_DISPLAY;
    }
    //
    // Close control.
    //

    /**
     * Creates a control issued when the window containing this view is closed.
     * @return the control issued when the window containing this view is closed
     * @exception NullPointerException if the control is null
     */
    public Control createCloseControl() throws NullPointerException {
        Control c = new Control();
        if (c != null) {
            c.setId(HealthRecordManager.DESTROY_HEALTHRECORD_FILE_MANAGER_DIALOG_CONTROL_ID);
            c.setSender((Controller) getController());
        } else {
            throw new NullPointerException("Could not create close control. The control is null.");
        }
        return c;
    }

    public JList getChooseList() {
        return this.chooseList;
    }

    public void setChooseList(JList chooseList) {
        this.chooseList = chooseList;
    }

    public JButton getBClose() {
        return this.bClose;
    }

    public void setBClose(JButton bClose) {
        this.bClose = bClose;
    }

    public JButton getBRemove() {
        return this.bRemove;
    }

    public void setBRemove(JButton bRemove) {
        this.bRemove = bRemove;
    }

    public JButton getBSelect() {
        return this.bSelect;
    }

    public void setBSelect(JButton bSelect) {
        this.bSelect = bSelect;
    }

    public JTextField getTfHealthRecordName() {
        return this.tfHealthRecordName;
    }

    public void setTfHealthRecordName(JTextField tfHealthRecordName) {
        this.tfHealthRecordName = tfHealthRecordName;
    }
}
