package org.resmedicinae.application.healthcare.reform.system.server.rmi;

import java.net.*;
import java.io.*;


/**
 * User: zonie
 * Date: Jan 14, 2003
 * Time: 2:56:02 PM
 */
public class RMIServerLauncher implements Runnable {
    private Thread thread;
    private Process process;
    private String idString;

    public RMIServerLauncher(String idString) {
        this.idString = idString;
        setThread(new Thread(this, "SquirrelLauncher"));
        getThread().start();
    }

    public void run() {
        try {
            Runtime r = Runtime.getRuntime();
            String idString = InetAddress.getLocalHost().toString();
            idString = idString.substring(0,idString.indexOf("/"));
            System.out.println("Starting RMI-Server on "+idString+"...");
            if (r != null) {
                String executeString = System.getProperty("java.home") + "/bin/java.exe "+
                        "-cp C:\\Diplom\\cvsroot\\resmedicinae\\build\\ "+
                        "-Djava.rmi.server.codebase=file:/C:/Diplom/cvsroot/resmedicinae/build/ "+
                        "-Djava.rmi.server.hostname="+idString+
                        " -Djava.security.policy=C:/Diplom/cvsroot/resmedicinae/build/org/resmedicinae/application/healthcare/reform/rmi.policy "+
                        "org.resmedicinae.application.healthcare.reform.system.server.rmi.RMIGeneralServicesImpl "+ this.idString;

                // System.out.println(executeString);
                process = r.exec(executeString);

                BufferedReader dInnOK = new BufferedReader(new InputStreamReader(process.getInputStream()));
                BufferedReader dInnErr = new BufferedReader(new InputStreamReader(process.getErrorStream()));

                while (!dInnOK.ready() && !dInnErr.ready()) {
                    getThread().sleep(150);
                }

                if (dInnErr.ready()) {
                    if (dInnErr.readLine() != null) {
                        process.destroy();
                        throw new Exception("Error while executing RMIServerLauncher:\n" + dInnErr.readLine());
                    }
                }

                if (dInnOK.ready()) {
                    if (dInnOK.readLine() != null) {
                        System.out.println("RMIServerLauncher: " + dInnOK.readLine());
                    }

                }

            } else {
                throw new NullPointerException("Could not run RMIServer. The application runner is null.");
            }
        } catch (Exception e) {
            System.out.println("Error with RMIServer:" + e);
            e.printStackTrace();
        }
    }

    public void killProcess() {
        if (process != null)
            this.process.destroy();
    }

    public void setThread(Thread thread) {
        this.thread = thread;
    }

    public Thread getThread() {
        return this.thread;
    }
}