package org.resmedicinae.application.healthcare.reform.system;

import org.resmedicinae.resmedlib.component.view.swing.*;
import org.resmedicinae.resmedlib.component.control.*;
import org.resmedicinae.application.controller.basic.*;
import org.resmedicinae.application.healthcare.reform.xml.*;
import org.resmedicinae.application.healthcare.reform.application.common.basic.*;

import javax.swing.*;
import java.awt.*;

/**
 * User: zonie
 * Date: Jan 15, 2003
 * Time: 1:53:03 PM
 */
public class RMIPartnerNameListDialog extends SwingView {

    private JTextField tfRMIPartnerName;

    private JList chooseList;

    /** JButton for updating the list */
    private JButton bUpdateList;

    /** JButton for selecting a rmi communication partner */
    private JButton bSelect;

    /** JButton for hiding this dialog */
    private JButton bClose;

    /** initializes the member variables, calls initLayout() */
    public void initialize() {
        try {
            super.initialize();
            //?? Temporary! The display mode of this about dialog is read from the configuration of the application (and such is FRAME_DISPLAY)!
            setDisplayMode(DisplayFactory.MODELESS_DIALOG_DISPLAY);
            //?? Temporary! The dialog bounds of this about dialog are read from the configuration of the application!
            setDialogBounds(createDialogBounds());
            // Set parameters.
            setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));

          //  setResizable(true);

            setTitle("List of RMI communication partners");
            // Set panel properties and add child components.
            initLayout();
        } catch(Exception e) {
            //?? getLogger().log("");
            System.out.println("Error: " + e);
        }
    }

    /**
     *
     */
    public void initLayout() {
    try {
        JPanel north = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        JLabel lRMIPartnerName = new JLabel("RMI communication partner:");
        tfRMIPartnerName = new JTextField();
        tfRMIPartnerName.setColumns(14);
        tfRMIPartnerName.getDocument().addDocumentListener(getDocumentListener());
        setChooseList(new JList());
        getChooseList().setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        getChooseList().setFixedCellWidth(150);
        getChooseList().addListSelectionListener(getListSelectionListener());
        getChooseList().addMouseListener(getMouseListener());
        JScrollPane scrollPane = new JScrollPane(getChooseList());
        scrollPane.createHorizontalScrollBar();
        scrollPane.createVerticalScrollBar();
        north.setLayout(gridbag);
        north.setBorder(BorderFactory.createTitledBorder("Select a communication partner"));
        c.fill = GridBagConstraints.NONE;
        c.anchor = GridBagConstraints.NORTHWEST;
        c.gridx = 0;
        c.gridy = 0;
        gridbag.setConstraints(lRMIPartnerName, c);
        north.add(lRMIPartnerName);
        c.gridx = 1;
        c.gridwidth = 2;
        c.insets = new Insets(0, 20, 0, 0);
        gridbag.setConstraints(tfRMIPartnerName, c);
        north.add(tfRMIPartnerName);
        c.gridy = 2;
        c.gridheight = 13;
        c.insets = new Insets(10, 20, 0, 0);
        gridbag.setConstraints(scrollPane, c);
        north.add(scrollPane);
        //	c.anchor = GridBagConstraints.SOUTH;

        bUpdateList = new JButton("Update");
        bUpdateList.addActionListener(getActionListener());
        bUpdateList.setActionCommand(AdvancedBasicApplication.UPDATE_RMI_COMMUNICATION_PARTNER_DIALOG_CONTROL_ID);
        bUpdateList.setToolTipText("Update the list of rgistered rmi communication partners");
        c.insets = new Insets(70, 10, 0, 0);
        c.gridx = 0;
        c.gridy = 20;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.insets = new Insets(10, 0, 10, 0);
        gridbag.setConstraints(bUpdateList, c);
        north.add(bUpdateList);

        bSelect = new JButton("Select");
        bSelect.addActionListener(getActionListener());
        bSelect.setActionCommand(AdvancedBasicApplication.SELECT_RMI_COMMUNICATION_PARTNER_DIALOG_CONTROL_ID);
        bSelect.setToolTipText("Select the focused rmi communication partner");
        c.insets = new Insets(5, 10, 0, 0);
        c.gridx = 1;
        c.insets = new Insets(10, 20, 10, 0);
        gridbag.setConstraints(bSelect, c);
        north.add(bSelect);

        bClose = new JButton("Close");
        bClose.addActionListener(getActionListener());
        bClose.setActionCommand(AdvancedBasicApplication.DESTROY_RMI_COMMUNICATION_PARTNER_DIALOG_CONTROL_ID);
        bClose.setToolTipText("Close this dialog");
        c.gridx = 2;
//        c.insets = new Insets(10, 20, 10, 0);
        gridbag.setConstraints(bClose, c);
        north.add(bClose);

        this.add(north);
        bSelect.setEnabled(false);
        this.setLocation(300, 300);
    }catch (Exception e) {
        e.printStackTrace();
    }
    }

    public BasicController getActionListener() {
        return (BasicController) getController();
    }

    public BasicController getMouseListener() {
        return (BasicController) getController();
    }

    public BasicController getDocumentListener() {
        return (BasicController) getController();
    }

    public BasicController getListSelectionListener() {
        return (BasicController) getController();
    }

    /**
     * Creates a rectangle storing the dialog bounds.
     * @return the rectangle storing the dialog bounds
     */
    public Rectangle createDialogBounds() {
        // Determine width.
        int screenWidth = (int) Math.floor(Toolkit.getDefaultToolkit().getScreenSize().getWidth());
        int w = 450;
        if (w > screenWidth) {
            w = screenWidth;
        }
        // Use centered x position by default.
        int x = (screenWidth - w) / 2;
        // Determine height.
        int screenHeight = (int) Math.floor(Toolkit.getDefaultToolkit().getScreenSize().getHeight());
        int h = 350;
        if (h > screenHeight) {
            h = screenHeight;
        }
        // Use centered y position by default.
        int y = (screenHeight - h) / 2;
        return new Rectangle(x, y, w, h);
    }
    //
    // Display mode.
    //

    /**
     * Creates a display mode.
     * @return the display mode
     */
    public int createDisplayMode() {
        return DisplayFactory.MODELESS_DIALOG_DISPLAY;
    }
    //
    // Close control.
    //

    /**
     * Creates a control issued when the window containing this view is closed.
     * @return the control issued when the window containing this view is closed
     * @exception NullPointerException if the control is null
     */
    public Control createCloseControl() throws NullPointerException {
        Control c = new Control();
        if (c != null) {
            c.setId(AdvancedBasicApplication.DESTROY_RMI_COMMUNICATION_PARTNER_DIALOG_CONTROL_ID);
            c.setSender(getController());
        } else {
            throw new NullPointerException("Could not create close control. The control is null.");
        }
        return c;
    }

    public JList getChooseList() {
        return this.chooseList;
    }

    public void setChooseList(JList chooseList) {
        this.chooseList = chooseList;
    }

}
