/*
 * $RCSfile: SquirrelLauncher.java,v $
 *
 * Copyright (c) 1999-2002. Christian Heller. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.application.healthcare.reform.squirrel;

import java.io.*;

/**
 * This class represents the launcher for the data base viewer program Squirrel.
 * @version $Revision: 1.3 $ $Date: 2002/12/17 22:14:41 $ $Author: zone3 $
 * @author Torsten Kunze <zone3@gmx.de>
 */
public class SquirrelLauncher implements Runnable {
    private Thread thread;
    private Process process;

    public SquirrelLauncher() {
        setThread(new Thread(this, "SquirrelLauncher"));
        getThread().start();
    }

    public void run() {
        try {
            Runtime r = Runtime.getRuntime();
            if (r != null) {
                process = r.exec(System.getProperty("java.home") + "/bin/java.exe -cp " +
                        System.getProperty("java.class.path") + " com.bigfoot.colbell.squirrel.Main");

                /*-cp "+System.getProperty("java.class.path") +"*/

                BufferedReader dInnOK = new BufferedReader(new InputStreamReader(process.getInputStream()));
                BufferedReader dInnErr = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                while (!dInnOK.ready() && !dInnErr.ready()) {
                    getThread().sleep(150);
                }
                if (dInnErr.ready()) {
                    if (dInnErr.readLine() != null) {
                        process.destroy();
                        throw new Exception("Error while executing Squirrel:\n" + dInnErr.readLine());
                    }
                }
                if (dInnOK.ready()) {
                    if (dInnOK.readLine() != null) {
                        System.out.println("Squirrel: " + dInnOK.readLine());
                    }
                }
            } else {
                throw new NullPointerException("Could not run Squirrel. The application runner is null.");
            }
        } catch (Exception e) {
            System.out.println("Error with Squirrel:" + e);
            e.printStackTrace();
        }
    }

    public void killProcess() {
        if (process != null)
            this.process.destroy();
    }

    public void setThread(Thread thread) {
        this.thread = thread;
    }

    public Thread getThread() {
        return this.thread;
    }
}
