/*
 * $RCSfile: CreateTableObjectives.java,v $
 *
 * Copyright (c) 1999-2002. Christian Heller. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */
package org.resmedicinae.application.healthcare.reform.sqlstatement.create;

import org.resmedicinae.application.healthcare.reform.sqlstatement.*;

/**
 * This class represents a SQL statement.
 * @version $Revision: 1.3 $ $Date: 2002/12/05 11:58:48 $ $Author: tristan24 $
 * @author Torsten Kunze <zone3@gmx.de>
 */
public class CreateTableObjectives extends CreateTable {

    public void initialize() throws Exception {
        super.initialize();
        setTableName(new org.resmedicinae.resmedlib.term.String("objectives"));
        setStatement(new org.resmedicinae.resmedlib.term.String(
                "CREATE TABLE Objectives ( ObjectiveID VARCHAR(90) NOT NULL," +
                "PartialContactID VARCHAR(80), EpisodeID VARCHAR(70), ProblemID VARCHAR(60)," +
                "HRID VARCHAR(50), Text VARCHAR(1000), Timestamp VARCHAR(32), PRIMARY KEY (ObjectiveID)," +
                "FOREIGN KEY (PartialContactID) REFERENCES PartialContacts (PartialContactID) ON DELETE " +
                "CASCADE ON UPDATE CASCADE NOT DEFERRABLE INITIALLY IMMEDIATE, FOREIGN KEY (EpisodeID) " +
                "REFERENCES Episodes (EpisodeID) ON DELETE CASCADE ON UPDATE CASCADE NOT DEFERRABLE " +
                "INITIALLY IMMEDIATE, FOREIGN KEY (ProblemID) REFERENCES Problems (ProblemID) ON DELETE " +
                "CASCADE ON UPDATE CASCADE NOT DEFERRABLE INITIALLY IMMEDIATE, FOREIGN KEY (HRID) REFERENCES " +
                "HealthRecords (HRID) ON DELETE CASCADE ON UPDATE CASCADE NOT DEFERRABLE INITIALLY IMMEDIATE)"
        ));
    }
}
