/*
 * $RCSfile: CreateTableHealthRecords.java,v $
 *
 * Copyright (c) 1999-2002. Christian Heller. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */
package org.resmedicinae.application.healthcare.reform.sqlstatement.create;

import org.resmedicinae.application.healthcare.reform.sqlstatement.*;

/**
 * This class represents a SQL statement.
 * @version $Revision: 1.2 $ $Date: 2002/12/04 22:42:01 $ $Author: zone3 $
 * @author Torsten Kunze <zone3@gmx.de>
 */
public class CreateTableHealthRecords extends CreateTable {

    public void initialize() throws Exception {
        super.initialize();
        setTableName(new org.resmedicinae.resmedlib.term.String("healthrecords"));
        setStatement(new org.resmedicinae.resmedlib.term.String(
                "CREATE TABLE HealthRecords ( HRID VARCHAR(50) NOT NULL, "+
                "Surname VARCHAR(32), Firstname VARCHAR(32), Birthday VARCHAR(10), "+
                "Street VARCHAR(32), ZIP VARCHAR(32), Town VARCHAR(32), Country VARCHAR(32), "+
                "PhoneNo VARCHAR(32), Insurance VARCHAR(32), InsuranceNumber VARCHAR(32), "+
                "BloodType VARCHAR(32), Height VARCHAR(32), Weight VARCHAR(32), Timestamp VARCHAR(32), PRIMARY KEY (HRID))"
        ));
    }

}