/*
 * $RCSfile: CreateTable.java,v $
 *
 * Copyright (c) 1999-2002. Christian Heller. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.application.healthcare.reform.sqlstatement.create;

import org.resmedicinae.application.healthcare.reform.sqlstatement.*;

import java.sql.*;
import java.util.*;

/**
 * This class represents a SQL statement.
 * @version $Revision: 1.2 $ $Date: 2002/12/17 22:14:40 $ $Author: zone3 $
 * @author Torsten Kunze <zone3@gmx.de>
 */
public class CreateTable extends SQLCreate {

    private org.resmedicinae.resmedlib.term.String tableName;

    public org.resmedicinae.resmedlib.term.String getTableName() {
        return tableName;
    }

    public void setTableName(org.resmedicinae.resmedlib.term.String tableName) {
        this.tableName = tableName;
    }

    public void initialize() throws Exception {
        super.initialize();
    }

    /**
     * Checks if there are all tables exist in the data base,
     * else it returns an ArrayList that includes all absent tables.
     * The table names are conform to the values of the member variable tableNames.
     * @return ArrayList all absent table names as Strings
     */

    public ArrayList existTableStructure(org.resmedicinae.resmedlib.term.String[] tableNames) throws Exception {
        ArrayList result = new ArrayList();
        PreparedStatement s;
        ResultSet rs;
        if (getConnection() != null) {
            try {
                DatabaseMetaData dmd = getConnection().getMetaData();
                for (int i = 0; i < tableNames.length; i++) {
                    result.add(tableNames[i].getValue());
                }
                rs = dmd.getTables(null, "%", "%", null);
                if (rs != null) {
                    ResultSetMetaData rsmd = rs.getMetaData();
                    int numberOfColumns = rsmd.getColumnCount();
                    int index = -1;
                    while (rs.next()) {
                        for (int i = 1; i <= numberOfColumns; i++) {
                            if ((index = result.indexOf(rs.getString(i))) > -1) {
                                result.remove(index);
                            }
                        }
                    }
                } else {
                    throw new Exception("Couldn't get databas information.");
                }
                rs.close();
                return result;
            } catch (Exception e) {
                throw new Exception(e);
            }
        } else {
            throw new NullPointerException("The connection object is null.");
        }
    }

    public boolean existTable() throws Exception {
        if (getConnection() != null) {
            try {
                DatabaseMetaData dmd = getConnection().getMetaData();
                ResultSet rs = dmd.getTables(null, "%", "%", null);
                boolean result = false;
                if (rs != null) {
                    rs.first();
                    while ((!result) && (rs.next())) {
                        if (getTableName().getValue().equals(rs.getString("TABLE_NAME")))
                            result = true;
                    }
                } else {
                    throw new Exception("Couldn't get databas information.\n");
                }
                rs.close();
                return result;
            } catch (Exception e) {
                throw new Exception(e);
            }
        } else {
            throw new NullPointerException("The connection object is null.");
        }
    }

    /**
     * Creates a table.
     * @param arrayList includes an array of table names to create tables from
     */
    public void createTable() throws Exception {
        if ((getTableName() != null) && (getTableName().getValue().length() > 0)) {
            System.out.println("creating table "+getTableName().getValue()+"...");
            String sqlStatement;
            PreparedStatement s;
            if (getConnection() != null) {
                s = getConnection().prepareStatement(getStatement().getValue());
                try {
                    s.executeUpdate();
                } catch (Throwable t) {
                    t.printStackTrace();
                    throw new Exception("Table couldn't be created !");
                }
            } else {
                throw new NullPointerException("The connection object is null.");
            }
        } else {
            throw new Exception("Couldn't create table. Wrong table name or table name is null!");
        }
    }
}
