/*
 * $RCSfile: RemoteMethodInvocationModel.java,v $
 *
 * Copyright (c) 1999-2002. Christian Heller. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.application.healthcare.reform.region.model;

import org.resmedicinae.application.healthcare.reform.application.common.basic.AdvancedBasicApplication;
import org.resmedicinae.resmedlib.region.model.DataTransferModel;

/**
 * This class represents a data transfer model.
 *
 * A data transfer model is a special, simplified model to be used for
 * data transfer between remote machines. It has a reduced number of
 * attributes/methods to ease and speed up communication.
 *
 * @version $Revision: 1.2 $ $Date: 2002/12/17 22:14:40 $ $Author: zone3 $
 * @author Christian Heller <christian.heller@tuxtax.de>
 */
public class  RemoteMethodInvocationModel extends DataTransferModel
{

    public static final String MODEL_KEY = "REMOTE_METHOD_INVOCATION_MODEL_KEY";
    private AdvancedBasicApplication controller = null;

    public void setController(AdvancedBasicApplication controller)
    {
        this.controller = controller;
    }

    public AdvancedBasicApplication getController()
    {
        return this.controller;
    }

    public void initialize() throws Exception
    {
        try
        {
            super.initialize();
        }
        catch (Exception e)
        {
            throw new Exception(e);
        }
    }

}

