/*
 * $RCSfile: EntityRelationshipModel.java,v $
 *
 * Copyright (c) 1999-2002. The Res Medicinae developers. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.application.healthcare.reform.region.model;

import org.resmedicinae.resmedlib.region.model.*;

import java.sql.*;

/**
 * This class represents an entity relationship model.
 *
 * An entity relationship model represents the data structure as found
 * in relational databases. It is also commonly called a "mapping layer".
 *
 * @version $Revision: 1.4 $ $Date: 2002/12/17 22:14:40 $ $Author: zone3 $
 * @author Christian Heller <christian.heller@tuxtax.de>
 */
public class EntityRelationshipModel extends PersistenceModel {

    private Connection connection;

    /** ?? */
    public static final String MODEL_KEY = "ER_MODEL_KEY";

    public Connection createConnection(org.resmedicinae.resmedlib.term.String name, org.resmedicinae.resmedlib.term.String pwd) throws Exception {
        try {
            Connection connection;
            Class.forName("org.postgresql.Driver");
            connection = DriverManager.getConnection("jdbc:postgresql://zone3/resmedicinae", name.getValue(), pwd.getValue());
           // connection = DriverManager.getConnection("jdbc:postgresql://zone3/resmedicinae", "zonie", "");
           // connection = DriverManager.getConnection("jdbc:postgresql://localhost/resmedicinae", "zonie", "");
            return connection;
        } catch (Exception e) {
            throw new Exception(e);
        }
    }

    public  void setConnection(Connection connection) {
        this.connection = connection;
    }

    public  Connection getConnection() {
        return this.connection;
    }

    public  void destroyConnection() throws Exception {
        if (this.connection != null)
            this.connection.close();
    }

    public void initialize() throws Exception {
        try {
            super.initialize();
        } catch (Exception e) {
            throw new Exception(e);
        }
    }
}

