/*
 * $RCSfile: HealthRecordViewAssembler.java,v $
 *
 * Copyright (c) 1999-2002. Christian Heller. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.application.healthcare.reform.region.assembler;

import org.resmedicinae.application.healthcare.reform.application.common.basic.*;
import org.resmedicinae.resmedlib.region.assembler.*;

/**
 * This class represents a view model assembler. It can be used to assemble/disassemble a view model from/to a domain model.
 * @version $Revision: 1.2 $ $Date: 2002/12/17 22:14:39 $ $Author: zone3 $
 * @author Torsten Kunze <zone3@gmx.de>
 * @author Christian Heller <christian.heller@tuxtax.de>
 */
public class HealthRecordViewAssembler extends ViewAssembler {
    private static final String ASSEMBLER_KEY = "HEALTH_RECORD_VIEW_MODEL_ASSEMBLER_KEY";
    private AdvancedBasicApplication controller = null;

    public void setController(AdvancedBasicApplication controller) {
        this.controller = controller;
    }

    public AdvancedBasicApplication getController() {
        return this.controller;
    }

    public void initialize() throws Exception {
        try {
            super.initialize();
        } catch (Exception e) {
            throw new Exception(e);
        }
    }
}
