/*
 * $RCSfile: ObjectID.java,v $
 *
 * Copyright (c) 1999-2002. Christian Heller. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */
package org.resmedicinae.application.healthcare.reform.region;

import java.net.*;
import java.sql.*;

/**
 * This class represents the ObjectID used as primary key for data bases, and also used as file name for XML-files.
 * @version $Revision: 1.2 $ $Date: 2003/01/16 10:43:08 $ $Author: tristan24 $
 * @author Torsten Kunze <zone3@gmx.de>
 */
public class ObjectID {

    public static long getNanos(long time) {
        return new Timestamp(time).getNanos();
    }

    /**
      * Returns a not used or new ID
      * @return not used or new ID
      */
     public static org.resmedicinae.resmedlib.term.String getNewOId() throws Exception {
         String idString = InetAddress.getLocalHost().toString();

         idString = idString.substring(idString.indexOf("/") + 1);
         idString = idString.replace('.', '_');
         long time = System.currentTimeMillis();
         idString = idString + "_" + time + Math.round(getNanos(time)/100000);
         System.out.println(idString);
         return new org.resmedicinae.resmedlib.term.String(idString);
     }
}
