/*
 * $RCSfile: DBLogin.java,v $
 *
 * Copyright (c) 1999-2002. Christian Heller. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */
package org.resmedicinae.application.healthcare.reform.region;

import org.resmedicinae.resmedlib.component.view.swing.*;
import org.resmedicinae.application.healthcare.reform.application.common.basic.*;

import javax.swing.*;
import java.awt.*;
import java.util.*;

/**
 * @version $Revision: 1.1 $ $Date: 2002/12/06 12:59:13 $ $Author: zone3 $
 * @author Torsten Kunze <zone3@gmx.de>
 */
public class DBLogin extends SwingView{

    AdvancedBasicApplication controller;

    public void initialize() throws Exception {
        try {
            super.initialize();

            //setDisplayMode(DisplayFactory.MODELESS_DIALOG_DISPLAY);
            setDisplayMode(DisplayFactory.MODAL_DIALOG_DISPLAY);
            //?? Temporary! The dialog bounds of this about dialog are read from the configuration of the application!
            setDialogBounds(createDialogBounds());
            // Set parameters.
            setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            // Set panel properties and add child components.
            this.setSize(300, 265);
           // this.setLocation(0, 565);

            createLoginDialog();

            this.setResizable(true);

        } catch (Exception e) {
            throw new Exception(e);
        }
    }

    public void setController(AdvancedBasicApplication controller) {
        this.controller = controller;
    }
/*
    public AdvancedBasicApplication getController() {
        return this.controller;
    }
*/
    public void createLoginDialog() {
        this.setTitle("Data base login");

        this.setLayout(new BorderLayout());

        ResPanel main = new ResPanel();
        main.setLayout(new GridLayout(6,1));

        ResPanel textfieldPanel1 = new ResPanel();
        textfieldPanel1.setLayout(new GridLayout(1,2));

        ResPanel textfieldPanel2 = new ResPanel();
        textfieldPanel2.setLayout(new GridLayout(1,2));

        ResPanel buttonPanel = new ResPanel();
        buttonPanel.setLayout(new GridLayout(1,2));

        ResLabel nameLabel = new ResLabel();
        nameLabel.setText("Name");

        ResLabel pwdLabel = new ResLabel();
        pwdLabel.setText("Password");

        ResTextField nameField = new ResTextField();

        ResTextField pwdField = new ResTextField();

        JButton okButton = new JButton("OK");
        //okButton.setControlId("OK");
        okButton.addActionListener((AdvancedBasicApplication)getController());

        JButton cancelButton = new JButton("Cancel");
        //cancelButton.setControlId("Cancel");
        cancelButton.addActionListener((AdvancedBasicApplication)getController());

        textfieldPanel1.add(nameLabel);
        textfieldPanel1.add(nameField);
        textfieldPanel2.add(pwdLabel);
        textfieldPanel2.add(pwdField);

        buttonPanel.add(okButton);
        buttonPanel.add(cancelButton);

        main.add(new JLabel(""));
        main.add(textfieldPanel1);
        main.add(textfieldPanel2);
        main.add(new JLabel(""));
        main.add(buttonPanel);

        main.setBorder(BorderFactory.createTitledBorder("Please login to data base"));

        this.add(main,BorderLayout.CENTER);

    }

    public boolean askForAnotherTry() {

        return false;

    }

    public Hashtable getLogin() {
        Hashtable login = new Hashtable();

        return login;
    }

    /**
     * Creates a rectangle storing the dialog bounds.
     * @return the rectangle storing the dialog bounds
     */
    public Rectangle createDialogBounds() {
        // Determine width.
        int screenWidth = (int) Math.floor(Toolkit.getDefaultToolkit().getScreenSize().getWidth());
        int w = 300;
        if (w > screenWidth) {
            w = screenWidth;
        }
        // Use centered x position by default.
        int x = (screenWidth - w) / 2;
        // Determine height.
        int screenHeight = (int) Math.floor(Toolkit.getDefaultToolkit().getScreenSize().getHeight());
        int h = 220;
        if (h > screenHeight) {
            h = screenHeight;
        }
        // Use centered y position by default.
        int y = (screenHeight - h) / 2;
        return new Rectangle(x, y, w, h);
    }
    //
    // Display mode.
    //

    /**
     * Creates a display mode.
     * @return the display mode
     */
    public int createDisplayMode() {
        return DisplayFactory.MODELESS_DIALOG_DISPLAY;
    }
    //
    // Close control.
    //


}
