/*
 * $RCSfile: TLabel.java,v $
 *
 * Copyright (c) 1999-2002. Torsten Kunze. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.application.healthcare.reform.gui;

import org.resmedicinae.application.healthcare.reform.formular.script.*;

import javax.swing.*;
import java.awt.*;

public class TLabel extends JLabel {
    private String id = null;
    private boolean labelDisabled = false;
    private LabelIcon labelIcon = null;
    private ScriptConfiguration scriptConfiguration;

    public TLabel(String label) {
        labelIcon = new LabelIcon();
        labelIcon.setTextLabelAbove(label);
        setIcon(labelIcon);
        scriptConfiguration = ScriptConfiguration.getScriptConfiguration();
        setPreferredSize(new Dimension(20, 15));
    }

    public TLabel(String labelAbove, String labelBelow) {
        labelIcon = new LabelIcon();
        labelIcon.setTextLabelAbove(labelAbove);
        labelIcon.setTextLabelBelow(labelBelow);
        setIcon(labelIcon);
        scriptConfiguration = ScriptConfiguration.getScriptConfiguration();
        setPreferredSize(new Dimension(20, 30));
    }

    public void setSize(Dimension d) {
        super.setSize(d);
    }

    public void setSize(int w, int h) {
        super.setSize(w, h);
    }

    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
    }

    public void setBounds(Rectangle r) {
        super.setBounds(r);
    }
}
