/*
 * $RCSfile: RadioButtonIcon.java,v $
 *
 * Copyright (c) 1999-2002. Torsten Kunze. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.application.healthcare.reform.gui;

import javax.swing.*;
import java.awt.*;

class RadioButtonIcon implements Icon {
    private boolean isSelected;
    private boolean focused;
    private boolean disabled;
    private boolean test;
    private PicturesCheckBox picturesCheckBox = null;
    private int iconheight = 15;
    private int iconwidth = 30;
    private int outerradius = 7;
    private int innerradius = 6;
    private int pointradius = 3;
    private int xposition = 8;
    private int yposition = 12;

    //private ConfigurationManager configMan;
    public RadioButtonIcon(boolean selected, boolean focused, boolean disabled) {
        //    configMan = ConfigurationManager.getConfigurationManager();
        this.isSelected = selected;
        this.disabled = disabled;
        this.focused = focused;
    }

    public RadioButtonIcon(PicturesCheckBox picturesCheckBox, boolean selected, boolean focused) {
        this.isSelected = selected;
        this.focused = focused;
        this.picturesCheckBox = picturesCheckBox;
    }

    public int getIconHeight() {
        return iconheight;
    }

    public int getIconWidth() {
        return iconwidth;
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        Color color1 = new Color(95, 155, 127);
        Color color2 = new Color(220, 220, 220);
        Color color3 = new Color(198, 8, 8);
        Color color4 = new Color(245, 167, 0);
        if (focused == false) {
            g.setColor(color1);

            /*if (this.disabled) {
			g.setColor(configMan.getColorTable().getBorderColorDisabledRadioButton());
			}*/

            for (int e = outerradius; e > -1; e--) {
                for (double i = 0; i < 2 * Math.PI; i = i + Math.PI / 32) {
                    Double x1 = new Double(Math.sin(i) * e);
                    int xx1 = xposition + Math.round(x1.floatValue());
                    Double y1 = new Double(Math.cos(i) * e);
                    int yy1 = yposition + Math.round(y1.floatValue());
                    if (e < innerradius) {
                        g.setColor(color2);

                        /*if (this.disabled) {
						g.setColor(configMan.getColorTable().getInnerColorDisabledRadioButton());
						}*/
                    }
                    g.drawLine(xx1, yy1, xx1, yy1);
                }
            }
        }
        if (focused == true) {
            g.setColor(color3);
            for (int e = outerradius; e > -1; e--) {
                for (double i = 0; i < 2 * Math.PI; i = i + Math.PI / 32) {
                    Double x1 = new Double(Math.sin(i) * e);
                    int xx1 = xposition + Math.round(x1.floatValue());
                    Double y1 = new Double(Math.cos(i) * e);
                    int yy1 = yposition + Math.round(y1.floatValue());
                    if (e < innerradius) {
                        g.setColor(color4);
                    }
                    g.drawLine(xx1, yy1, xx1, yy1);
                }
            }
        }
        if (isSelected == true) {
            g.setColor(Color.black);
            for (int e = pointradius; e > -1; e--) {
                for (double i = 0; i < 2 * Math.PI; i = i + Math.PI / 32) {
                    Double x1 = new Double(Math.sin(i) * e);
                    int xx1 = xposition + Math.round(x1.floatValue());
                    Double y1 = new Double(Math.cos(i) * e);
                    int yy1 = yposition + Math.round(y1.floatValue());
                    g.drawLine(xx1, yy1, xx1, yy1);
                }
            }
        }
    }
}
