/*
 * $RCSfile: CellIcon.java,v $
 *
 * Copyright (c) 1999-2002. Torsten Kunze. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.application.healthcare.reform.gui;

import javax.swing.*;
import java.awt.*;

public class CellIcon implements Icon {
    private boolean isSelected;
    private boolean focused;
    private PicturesCheckBox picturesCheckBox = null;
    //private ConfigurationManager configMan;
    private int outerRectangleHeight = 20;
    private int outerRectangleWidth = 40;
    private int innerRectangleHeight = 19;
    private int innerRectangleWidth = 107;
    private int cellIconHeight = 20;
    private int cellIconWidth = 20;

    public CellIcon(boolean focused) {
        this.focused = focused;
    }

    public int getIconHeight() {
        return cellIconHeight;
    }

    public int getIconWidth() {
        return cellIconHeight;
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        //  configMan = ConfigurationManager.getConfigurationManager();
        if (focused) {
            outerRectangleHeight = c.getSize().height;
            outerRectangleWidth = c.getSize().width;
            Color color4 = new Color(245, 167, 0);
            g.setColor(Color.white);
            g.drawRect(x, y, outerRectangleWidth, outerRectangleHeight);
            g.fillRect(x, y, outerRectangleWidth, outerRectangleHeight);
            g.setColor(color4);
            g.drawRect(x + 1, y + 1, outerRectangleWidth, outerRectangleHeight - 3);
            g.fillRect(x + 1, y + 1, outerRectangleWidth, outerRectangleHeight - 3);
        } else {
            outerRectangleHeight = c.getSize().height;
            outerRectangleWidth = c.getSize().width;
            Color color3 = new Color(176, 182, 189);
            g.setColor(Color.white);
            g.drawRect(x, y, outerRectangleWidth, outerRectangleHeight);
            g.fillRect(x, y, outerRectangleWidth, outerRectangleHeight);
            Color color2 = new Color(255, 0, 0); //configMan.getColorTable().getBackgroundColorEditField();
            g.setColor(color2);
            g.drawRect(x + 1, y + 1, outerRectangleWidth, outerRectangleHeight - 3);
            g.fillRect(x + 1, y + 1, outerRectangleWidth, outerRectangleHeight - 3);
        }
    }
}
