/*
 * $RCSfile: BorderPanel.java,v $
 *
 * Copyright (c) 1999-2002. Torsten Kunze. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.application.healthcare.reform.gui;

import javax.swing.*;
import java.awt.*;

/** The class creates a JPanel with user defined Insets. */
public class BorderPanel extends JPanel {
    private int a, b, c, d;

    /** All Insets get the same value, that is 8. */
    public BorderPanel() {
        a = b = c = d = 8;
    }

    /**
     * All Insets get the same value, that is border.
     * @param  border  Gre der Insets
     */
    public BorderPanel(int border) {
        a = b = c = d = border;
    }

    /**
     * Sets the Insets.
     * @return   die Insets
     */
    public Insets getInsets() {
        return new Insets(a, b, c, d);
    }
}
