/*
 * $RCSfile: ScriptModel.java,v $
 *
 * Copyright (c) 1999-2002. Torsten Kunze. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.application.healthcare.reform.formular.script;

import org.resmedicinae.application.healthcare.reform.formular.*;
import org.resmedicinae.application.healthcare.reform.gui.*;
import org.resmedicinae.domain.healthcare.*;

/**
 * This class represents the data model.
 * @version $Revision: 1.3 $ $Date: 2002/12/17 22:14:37 $ $Author: zone3 $
 * @author Torsten Kunze <zone3@gmx.de>
 */
public class ScriptModel extends FormularModel {
    /**  */

    /** Decleration / Initialization ***************************************** */

    /**  */
    private org.resmedicinae.resmedlib.term.String tf1Insurance = null;
    private org.resmedicinae.resmedlib.term.String name = null;
    private org.resmedicinae.resmedlib.term.String birth = null;
    private org.resmedicinae.resmedlib.term.String insurance1 = null;
    private org.resmedicinae.resmedlib.term.String insurance2 = null;
    private org.resmedicinae.resmedlib.term.String insurance3 = null;
    private org.resmedicinae.resmedlib.term.String date1 = null;
    private org.resmedicinae.resmedlib.term.String date2 = null;
    private org.resmedicinae.resmedlib.term.String date3 = null;
    private org.resmedicinae.resmedlib.term.String actualInsurance = null;
    private org.resmedicinae.resmedlib.term.String healthFund = null;
    private org.resmedicinae.resmedlib.term.String cbGebuehr = null;
    private org.resmedicinae.resmedlib.term.String cbNoctu = null;
    private org.resmedicinae.resmedlib.term.String cbSonstige = null;
    private org.resmedicinae.resmedlib.term.String cbUnfall = null;
    private org.resmedicinae.resmedlib.term.String cbBVG = null;
    private org.resmedicinae.resmedlib.term.String cbHiflsmittel = null;
    private org.resmedicinae.resmedlib.term.String cbImpfstoff = null;
    private org.resmedicinae.resmedlib.term.String cbBedarf = null;
    private int cbAutIdem = 0;
    private org.resmedicinae.resmedlib.term.String dayOfAccident = null;
    private org.resmedicinae.resmedlib.term.String employerNumber = null;
    private org.resmedicinae.resmedlib.term.String rezept = null;
    private HealthRecord healthRecord;

    public void initialize() {
        this.healthRecord = new HealthRecord();
        setView((ScriptView) ((Script) getController()).getView());
    }

    /**  */

    /** Get / Set / Create / Destroy ***************************************** */

    /**  */

    /** Sets the variable healthRecord */

/*
	public void setHealthRecord(HealthRecord inHealthRecord)
	{
		if (inHealthRecord==null)
		{
			this.healthRecord = new HealthRecord();
			clearAllTextFields();
		}
		else
		{
			this.healthRecord = inHealthRecord;
			fillTextFields();
		}
	}
*/

    /** Returns the variable healthRecord */

/*	public HealthRecord getHealthRecord()
	{
	    return this.healthRecord;
	}
*/

    /** Sets the variable to the content of the textfield tf1Insurance */
    public void setTf1Insurance(org.resmedicinae.resmedlib.term.String inTf1Insurance) {
        this.tf1Insurance = inTf1Insurance;
    }

    /**
     * Returns the content of textfield tf1Insurance
     * @return the content of textfield tf1Insurance
     */
    public org.resmedicinae.resmedlib.term.String getTf1Insurance() {
        return this.tf1Insurance;
    }

    /** Sets the variable to the content of the textfield name */
    public void setHealthRecordName(org.resmedicinae.resmedlib.term.String inName) {
        this.name = inName;
    }

    /** Returns the variable to the content of the textfield name */
    public org.resmedicinae.resmedlib.term.String getHealthRecordName() {
        return this.name;
    }

    /**
     * Returns the content of textfield name
     * @return the content of textfield name
     */
    public org.resmedicinae.resmedlib.term.String getDate1getHealthRecordName() {
        return this.name;
    }

    /** Sets the variable to the content of the textfield birth */
    public void setBirthday(org.resmedicinae.resmedlib.term.String inBirthday) {
        this.birth = inBirthday;
    }

    /**
     * Returns the content of textfield birth
     * @return the content of textfield birth
     */
    public org.resmedicinae.resmedlib.term.String getBirthdayday() {
        return this.birth;
    }

    /** Sets the variable to the content of the textfield ensurance1 */
    public void setInsurance1(org.resmedicinae.resmedlib.term.String inInsurance1) {
        this.insurance1 = inInsurance1;
        healthRecord.setHealthFundNumber(inInsurance1);
    }

    /**
     * Returns the content of textfield ensurance1
     * @return the content of textfield ensurance1
     */
    public org.resmedicinae.resmedlib.term.String getInsurance1() {
        return this.insurance1;
    }

    /** Sets the variable to the content of the textfield ensurance2 */
    public void setInsurance2(org.resmedicinae.resmedlib.term.String inInsurance2) {
        this.insurance2 = inInsurance2;
        healthRecord.setInsurantNumber(inInsurance2);
    }

    /**
     * Returns the content of textfield ensurance2
     * @return the content of textfield ensurance2
     */
    public org.resmedicinae.resmedlib.term.String getInsurance2() {
        return this.insurance2;
    }

    /** Sets the variable to the content of the textfield ensurance3 */
    public void setInsurance3(org.resmedicinae.resmedlib.term.String inInsurance3) {
        this.insurance3 = inInsurance3;
        healthRecord.setStatusOfInsurant(inInsurance3);
    }

    /**
     * Returns the content of textfield ensurance3
     * @return the content of textfield ensurance3
     */
    public org.resmedicinae.resmedlib.term.String getInsurance3() {
        return this.insurance3;
    }

    /** Sets the variable to the content of the textfield date1 */
    public void setDate1(org.resmedicinae.resmedlib.term.String inDate1) {
        this.date1 = inDate1;
        healthRecord.setDoctorsNumber(inDate1);
    }

    /**
     * Returns the content of textfield date1
     * @return the content of textfield date1
     */
    public org.resmedicinae.resmedlib.term.String getDate1() {
        return this.date1;
    }

    /** Sets the variable to the content of the textfield date2 */
    public void setDate2(org.resmedicinae.resmedlib.term.String inDate2) {
        this.date2 = inDate2;
        healthRecord.setVKValidy(inDate2);
    }

    /**
     * Returns the content of textfield date2
     * @return the content of textfield date2
     */
    public org.resmedicinae.resmedlib.term.String getDate2() {
        return this.date2;
    }

    /** Sets the variable to the content of the textfield date3 */
    public void setDate3(org.resmedicinae.resmedlib.term.String inDate3) {
        this.date3 = inDate3;
        healthRecord.setDateOfScript(inDate3);
    }

    /**
     * Returns the content of textfield date3
     * @return the content of textfield date3
     */
    public org.resmedicinae.resmedlib.term.String getDate3() {
        return this.date3;
    }

    /**
     * Returns the actual insurance
     * @return the actual insurance
     */
    public org.resmedicinae.resmedlib.term.String getActualInsurance() {
        return this.actualInsurance;
    }

    /** Sets the actual health fund */
    public void setHealthFund(org.resmedicinae.resmedlib.term.String inHealthFund) {
        this.healthFund = inHealthFund;
        healthRecord.setHealthFund(inHealthFund);
    }

    /**
     * Returns the actual health fund
     * @return the actual health fund
     */
    public org.resmedicinae.resmedlib.term.String getHealthFund() {
        return this.healthFund;
    }

    /** Sets the actual ensurance of the checkboxes on the top */
    public void setCbGebuehr(org.resmedicinae.resmedlib.term.String cbGebuehr) {
        this.cbGebuehr = cbGebuehr;
        healthRecord.setAdjustment(cbGebuehr);
    }

    /**
     * Returns the actual ensurance of the checkboxes on the top
     * @return the actual ensurance of the checkboxes on the top
     */
    public org.resmedicinae.resmedlib.term.String getCbNoctu() {
        return this.cbGebuehr;
    }

    /** Sets the actual ensurance of the checkboxes on the top */
    public void setCbNoctu(org.resmedicinae.resmedlib.term.String cbNoctu) {
        this.cbNoctu = cbNoctu;
        healthRecord.setNoctu(cbNoctu);
    }

    /**
     * Returns the actual ensurance of the checkboxes on the top
     * @return the actual ensurance of the checkboxes on the top
     */
    public org.resmedicinae.resmedlib.term.String getCbGebuehr() {
        return this.cbGebuehr;
    }

    /** Sets the actual ensurance of the checkboxes on the top */
    public void setCbSonstige(org.resmedicinae.resmedlib.term.String cbSonstige) {
        System.out.println("in setCbSonstige: " + cbSonstige);
        this.cbSonstige = cbSonstige;
        healthRecord.setSomeOthers(cbSonstige);
    }

    /**
     * Returns the actual ensurance of the checkboxes on the top
     * @return the actual ensurance of the checkboxes on the top
     */
    public org.resmedicinae.resmedlib.term.String getCbSonstige() {
        return this.cbSonstige;
    }

    /** Sets the actual ensurance of the checkboxes on the top */
    public void setCbUnfall(org.resmedicinae.resmedlib.term.String cbUnfall) {
        System.out.println("in setCbUnfall: " + cbUnfall);
        this.cbUnfall = cbUnfall;
        healthRecord.setAccident(cbUnfall);
    }

    /**
     * Returns the actual ensurance of the checkboxes on the top
     * @return the actual ensurance of the checkboxes on the top
     */
    public org.resmedicinae.resmedlib.term.String getCbUnfall() {
        return this.cbUnfall;
    }

    /** Sets the actual ensurance of the checkboxes on the top */
    public void setCbBVG(org.resmedicinae.resmedlib.term.String cbBVG) {
        this.cbBVG = cbBVG;
        healthRecord.setBVG(cbBVG);
    }

    /**
     * Returns the actual ensurance of the checkboxes on the top
     * @return the actual ensurance of the checkboxes on the top
     */
    public org.resmedicinae.resmedlib.term.String getCbBVG() {
        return this.cbBVG;
    }

    /** Sets the actual ensurance of the checkboxes on the top */
    public void setCbHiflsmittel(org.resmedicinae.resmedlib.term.String cbHiflsmittel) {
        this.cbHiflsmittel = cbHiflsmittel;
        healthRecord.setResources(cbHiflsmittel);
    }

    /**
     * Returns the actual ensurance of the checkboxes on the top
     * @return the actual ensurance of the checkboxes on the top
     */
    public org.resmedicinae.resmedlib.term.String getCbHiflsmittel() {
        return this.cbHiflsmittel;
    }

    /** Sets the actual ensurance of the checkboxes on the top */
    public void setCbImpfstoff(org.resmedicinae.resmedlib.term.String cbImpfstoff) {
        this.cbImpfstoff = cbImpfstoff;
        healthRecord.setSerum(cbImpfstoff);
    }

    /**
     * Returns the actual ensurance of the checkboxes on the top
     * @return the actual ensurance of the checkboxes on the top
     */
    public org.resmedicinae.resmedlib.term.String getCbImpfstoff() {
        return this.cbImpfstoff;
    }

    /** Sets the actual ensurance of the checkboxes on the top */
    public void setCbBedarf(org.resmedicinae.resmedlib.term.String cbBedarf) {
        this.cbBedarf = cbBedarf;
        healthRecord.setRequirement(cbBedarf);
    }

    /**
     * Returns the actual ensurance of the checkboxes on the top
     * @return the actual ensurance of the checkboxes on the top
     */
    public org.resmedicinae.resmedlib.term.String getCbBedarf() {
        return this.cbBedarf;
    }

    /** Sets the actual AutIdem check box */
    public void setCbAutIdem(int cbAutIdem) {
        this.cbAutIdem = cbAutIdem;
    }

    /**
     * Returns the actual AutIdem check box
     * @return the actual AutIdem check box
     */
    public int getCbAutIdem() {
        return this.cbAutIdem;
    }

    /** Sets the actual DayOfAccident text field */
    public void setDayOfAccident(org.resmedicinae.resmedlib.term.String dayOfAccident) {
        this.dayOfAccident = dayOfAccident;
    }

    /**
     * Returns the actual DayOfAccident text field
     * @return the actual DayOfAccident text field
     */
    public org.resmedicinae.resmedlib.term.String getDayOfAccident() {
        return this.dayOfAccident;
    }

    /** Sets the actual EmployerNumber text field */
    public void setEmployerNumber(org.resmedicinae.resmedlib.term.String employerNumber) {
        this.employerNumber = employerNumber;
    }

    /**
     * Returns the actual EmployerNumber text field
     * @return the actual EmployerNumber text field
     */
    public org.resmedicinae.resmedlib.term.String getEmployerNumber() {
        return this.employerNumber;
    }

    /** Sets the actual Rezept text area */
    public void setRezept(org.resmedicinae.resmedlib.term.String rezept) {
        this.rezept = rezept;
        healthRecord.setScriptMedicine(rezept);
    }

    /**
     * Returns the actual Rezept text area
     * @return the actual Rezept text area
     */
    public org.resmedicinae.resmedlib.term.String getRezept() {
        return this.rezept;
    }

    /**  */

    /** Methods For ScriptView *********************************************** */

    /**  */
    public void clearAllTextFields() {
        ScriptView view = (ScriptView) getView();
        org.resmedicinae.resmedlib.term.String nullString = new org.resmedicinae.resmedlib.term.String("");
        view.setTf1Insurance(nullString);
        view.setTfName(nullString);
        view.setTfBirthday(nullString);
        view.setTfInsurance1(nullString);
        view.setTfInsurance2(nullString);
        view.setTfInsurance3(nullString);
        view.setTfDate1(nullString);
        view.setTfDate2(nullString);
        view.setTfDate3(nullString);
        view.setTfDayOfAccident(nullString);
        view.setTfEmployerNumber(nullString);
        view.setTaRezept(nullString);
    }

    public void fillTextFields() {
        HealthRecord healthRecord = getCurrentHealthRecord();
        if (healthRecord != null) {
            ScriptView view = (ScriptView) getView();
            String name = "";
            if (healthRecord.getName() != null)
                name = healthRecord.getName().getValue() + ", ";
            if (healthRecord.getFirstName() != null)
                name += healthRecord.getFirstName().getValue();
            view.setTfName(new org.resmedicinae.resmedlib.term.String(name));
            if (healthRecord.getBirthday() != null)
                view.setTfBirthday(healthRecord.getBirthday());
            if (healthRecord.getInsurance() != null)
                view.setTf1Insurance(healthRecord.getInsurance());
        }
    }

    /**
     * Evaluates the PicturesCheckBox event
     * @param event an event of a PicturesCheckBox
     */
    public void evaluatePicturesCheckBoxEvents(Object object) {
        org.resmedicinae.resmedlib.term.String item =
                new org.resmedicinae.resmedlib.term.String(((PicturesCheckBox) object).getLabelString());
        System.out.println("item: " + item);
        ScriptView view = (ScriptView) getView();
        if ((item.equals("Gebhrfrei")) || (item.equals("Geb.-pfl.")))
            if ((!view.getCbGebuehr1().getState()) && (!view.getCbGebuehr2().getState()))
                setCbGebuehr(null);
            else
                setCbGebuehr(item);
        else if (item.equals("noctu"))
            if (!view.getCbNoctu().getState())
                setCbNoctu(null);
            else
                setCbNoctu(item);
        else if (item.equals("Sonstige"))
            if (!view.getCbSonstige().getState())
                setCbSonstige(null);
            else
                setCbSonstige(item);
        else if ((item.equals("Unfall")) || (item.equals("Arbeits-unfall")))
            if ((!view.getCbUnfall().getState()) && (!view.getCbAUnfall().getState()))
                setCbUnfall(null);
            else
                setCbUnfall(item);
        else if (item.equals("6"))
            if (!view.getCbBVG().getState())
                setCbBVG(null);
            else
                setCbBVG(item);
        else if (item.equals("7"))
            if (!view.getCbHiflsmittel().getState())
                setCbHiflsmittel(null);
            else
                setCbHiflsmittel(item);
        else if (item.equals("8"))
            if (!view.getCbImpfstoff().getState())
                setCbImpfstoff(null);
            else
                setCbImpfstoff(item);
        else if (item.equals("9"))
            if (!view.getCbBedarf().getState())
                setCbBedarf(null);
            else
                setCbBedarf(item);
        else if (item.equals("autidem"))
            if (view.getCbAutIdem1().getState())
                setCbAutIdem(1);
            else if (view.getCbAutIdem2().getState())
                setCbAutIdem(2);
            else if (view.getCbAutIdem3().getState())
                setCbAutIdem(3);
            else
                setCbAutIdem(0);
    }

    /**
     * Evaluates the TextField event
     * @param event an event of a TextField
     */
    public void saveAllTextFields(Object object) {
        //		String action = object.toString();
        //		System.out.println("action: "+action);
        ScriptView view = (ScriptView) getView();
        setTf1Insurance(view.getTf1Insurance());
        setHealthRecordName(view.getHealthRecordName());
        setBirthday(view.getBirthdayday());
        setInsurance1(view.getInsurance1());
        setInsurance2(view.getInsurance2());
        setInsurance3(view.getInsurance3());
        setDate1(view.getDate1());
        setDate2(view.getDate2());
        setDate3(view.getDate3());
        setDayOfAccident(view.getDayOfAccident());
        setEmployerNumber(view.getEmployerNumber());
        setRezept(((ScriptView) getView()).getRezept());
    }
}
