/*
 * $RCSfile: ScriptConfiguration.java,v $
 *
 * Copyright (c) 1999-2002. Torsten Kunze. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.application.healthcare.reform.formular.script;

import org.resmedicinae.resmedlib.component.configuration.*;

import java.awt.*;

/**
 * This class represents the configuration.
 * @version $Revision: 1.2 $ $Date: 2002/10/17 15:43:03 $ $Author: zone3 $
 * @author Torsten Kunze <zone3@gmx.de>
 */
public class ScriptConfiguration extends Configuration {
    private static final Color scriptBackGroundColorRed = new Color(255, 180, 190);
    private static final Color scriptBackGroundColorWhite = new Color(255, 255, 255);
    private static final Color scriptBackGroundColorHelp = new Color(0, 160, 190);
    private static final Color borderColor = new Color(255, 40, 100);
    private static final Color fontColor = new Color(255, 40, 100);
    private static final Color innerColorFocusedCheckBox = new Color(255, 255, 255);
    private static final Color borderColorFocusedCheckBox = new Color(255, 40, 100);
    private static final Color innerColorCheckBox = new Color(255, 255, 255);
    private static final Color borderColorCheckBox = new Color(255, 40, 100);
    private static final Font scriptFont = new Font("Times New Roman", Font.PLAIN, 10);
    private static ScriptConfiguration scriptConfiguration = null;

    /**
     * Returns a red color for the script background
     * @return the script background color red
     */
    public Color getScriptBackGroundColorRed() {
        return this.scriptBackGroundColorRed;
    }

    /**
     * Returns a white color for the script background
     * @return the script background color white
     */
    public Color getScriptBackGroundColorWhite() {
        return this.scriptBackGroundColorWhite;
    }

    /**
     * Returns a help color for the script background
     * @return the script background help color
     */
    public Color getScriptBackGroundColorHelp() {
        return this.scriptBackGroundColorWhite;
    }

    /**
     * Returns color for the script borders
     * @return the script border color
     */
    public Color getBorderColor() {
        return this.borderColor;
    }

    /**
     * Returns color for the script fonts
     * @return the script background color
     */
    public Color getFontColor() {
        return this.fontColor;
    }

    /**
     * Returns inner color for a check box if it is focused
     * @return the inner check box color
     */
    public Color getInnerColorFocusedCheckBox() {
        return this.innerColorFocusedCheckBox;
    }

    /**
     * Returns border color for a check box if it is focused
     * @return the check box border color color
     */
    public Color getBorderColorFocusedCheckBox() {
        return this.borderColorFocusedCheckBox;
    }

    /**
     * Returns inner color for a check box
     * @return the inner check box color
     */
    public Color getInnerColorCheckBox() {
        return this.innerColorCheckBox;
    }

    /**
     * Returns border color for a check box
     * @return the check box border color color
     */
    public Color getBorderColorCheckBox() {
        return this.borderColorCheckBox;
    }

    /**
     * Returns font for the script
     * @return the script font
     */
    public Font getScriptFont() {
        return this.scriptFont;
    }

    /**
     * Returns the instance of ScriptConfiguration
     * @return the instance of ScriptConfiguration
     */
    public static ScriptConfiguration getScriptConfiguration() {
        if (scriptConfiguration == null) scriptConfiguration = new ScriptConfiguration();
        return scriptConfiguration;
    }
}
