/*
 * $RCSfile: FormularView.java,v $
 *
 * Copyright (c) 1999-2002. Torsten Kunze. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.application.healthcare.reform.formular;

import org.resmedicinae.resmedlib.component.control.*;
import org.resmedicinae.resmedlib.component.view.swing.*;

import javax.swing.*;
import javax.swing.event.*;
import java.awt.*;
import java.awt.event.*;

/**
 * This class represents the Formular view.
 * @version $Revision: 1.5 $ $Date: 2002/10/17 15:43:03 $ $Author: zone3 $
 * @author Torsten Kunze <zone3@gmx.de>
 */
public class FormularView extends SwingView {
    public void initialize() {
        try {
            super.initialize();
            //			setModel(model);
            //?? Temporary! The display mode of this about dialog is read from the configuration of the application (and such is FRAME_DISPLAY)!
            setDisplayMode(DisplayFactory.MODELESS_DIALOG_DISPLAY);
            //?? Temporary! The dialog bounds of this about dialog are read from the configuration of the application!
            setDialogBounds(createDialogBounds());
            // Set parameters.
            setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        } catch (Exception e) {
            //?? getLogger().log("");
            System.out.println("Fehler: " + e);
        }
    }

    /**
     * Creates the formular
     * @return the ResPanel with the new added Button
     */
    protected ResPanel drawFormular() throws Exception {
        return new ResPanel();
    }

    public ActionListener getActionListener() {
        return (ActionListener) getController();
    }

    public ItemListener getItemListener() {
        return (ItemListener) getController();
    }

    public DocumentListener getDocumentListener() {
        return (DocumentListener) getController();
    }

    /**
     * Creates a title.
     * @return the title
     */
    public String createTitle() {
        return "Formular";
    }

    /**
     * Creates an icon.
     * @return the icon
     */
    public String createIcon() {
        return "Icon";
    }

    /**
     * Creates a border layout.
     * @return the border layout
     */
    public BorderLayout createBorderLayout() {
        return new BorderLayout();
    }

    /**
     * Creates a rectangle storing the dialog bounds.
     * @return the rectangle storing the dialog bounds
     */
    public Rectangle createDialogBounds() {
        // Determine width.
        int screenWidth = (int) Math.floor(Toolkit.getDefaultToolkit().getScreenSize().getWidth());
        int w = 640;
        if (w > screenWidth) {
            w = screenWidth;
        }
        // Use centered x position by default.
        int x = (screenWidth - w) / 2;
        // Determine height.
        int screenHeight = (int) Math.floor(Toolkit.getDefaultToolkit().getScreenSize().getHeight());
        int h = 480;
        if (h > screenHeight) {
            h = screenHeight;
        }
        // Use centered y position by default.
        int y = (screenHeight - h) / 2;
        return new Rectangle(x, y, w, h);
    }
    //
    // Display mode.
    //

    /**
     * Creates a display mode.
     * @return the display mode
     */
    public int createDisplayMode() {
        return DisplayFactory.MODELESS_DIALOG_DISPLAY;
    }
    //
    // Close control.
    //

    /**
     * Creates a control issued when the window containing this view is closed.
     * @return the control issued when the window containing this view is closed
     * @exception NullPointerException if the control is null
     */
    public Control createCloseControl() throws NullPointerException {
        Control c = new Control();
        if (c != null) {
            c.setId(FormularController.DESTROY_FORMULAR_DIALOG_CONTROL_ID);
            c.setSender((Controller) getController());
        } else {
            throw new NullPointerException("Could not create close control. The control is null.");
        }
        return c;
    }

    public void getPrintMask(Graphics2D graphics, Rectangle printArea, FontMetrics fontMetrics) {
        FormularModel model = (FormularModel) getModel();
        float relPosX = 0;
        float relPosY = 0;
        float absPosX = (float) (printArea.getX() + relPosX);
        float absPosY = (float) (printArea.getY() + relPosY);
        graphics.drawString("Formular was printed!", absPosX, absPosY);
    }
}
