/*
 * $RCSfile: FormularModel.java,v $
 *
 * Copyright (c) 1999-2002. Torsten Kunze. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.application.healthcare.reform.formular;

//import java.util.logging.*;

import org.resmedicinae.application.healthcare.reform.region.model.*;
import org.resmedicinae.domain.healthcare.*;

/**
 * This class represents the data model.
 * @version $Revision: 1.7 $ $Date: 2002/12/17 22:14:37 $ $Author: zone3 $
 * @author Torsten Kunze <zone3@gmx.de>
 */
public class FormularModel extends HealthRecordViewModel {
    /**  */

    /** Decleration / Initialization ***************************************** */

    /**  */
    private FormularController controller;
    private FormularView view = null;

    public void initialize() {
        setView((FormularView) ((FormularController) getController()).getView());
    }

    /**  */

    /** Get / Set / Create / Destroy ***************************************** */

    /**  */

    /** Sets the variable view */
    public void setView(FormularView view) {
        this.view = view;
    }

    /** Returns the variable view */
    public FormularView getView() {
        return this.view;
    }

    /** Sets the variable healthRecord */
    public void setCurrentHealthRecord(HealthRecord inHealthRecord) {
        clearAllTextFields();
        if (inHealthRecord == null) {
            super.setCurrentHealthRecord(new HealthRecord());
        } else {
            super.setCurrentHealthRecord(inHealthRecord);
            fillTextFields();
        }
    }

    /** Sets the variable controller */
    public FormularController getController() {
        return this.controller;
    }

    /** Returns the variable controller */
    public void setController(FormularController controller) {
        this.controller = controller;
    }

    /**  */

    /** Methods For FormularView *********************************************** */

    /**  */
    public void clearAllTextFields() {
    }

    public void fillTextFields() {
    }
}
