/*
 * $RCSfile: FormularController.java,v $
 *
 * Copyright (c) 1999-2002. Torsten Kunze. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.application.healthcare.reform.formular;

//import java.util.logging.*;

import org.resmedicinae.application.controller.basic.*;
import org.resmedicinae.domain.healthcare.*;
import org.resmedicinae.resmedlib.component.view.*;

/**
 * This class represents the formular controller.
 * @version $Revision: 1.5 $ $Date: 2002/12/17 22:14:36 $ $Author: zone3 $
 * @author Torsten Kunze <zone3@gmx.de>
 */
public class FormularController extends BasicController {
    public static final String DESTROY_FORMULAR_DIALOG_CONTROL_ID = "close formular";
    //
    // Name.
    //

    /**
     * Returns the name.
     * @return the name
     */
    public String getName() {
        return "Formular";
    }
    //
    // Version.
    //

    /**
     * Returns the version. (major).(minor).(<99 = preX, 99 = final).(bug fix)
     * @return the version
     */
    public String getVersion() {
        return "Unspecified Version";
    }
    //
    // Date.
    //

    /**
     * Returns the release date.
     * @return the release date
     */
    public String getDate() {
        return "Unspecified Date";
    }
    //
    // Logo.
    //

    /**
     * Returns the logo.
     * @return the logo
     */
    public String getLogo() {
        return "Unspecified logo";
    }
    //
    // Copyright.
    //

    /**
     * Returns the copyright.
     * @return the copyright
     */
    public String getCopyright() {
        return "Copyright (c) 1999-2002. The Res Medicinae Developers. All rights reserved.";
    }
    //
    // Contact.
    //

    /**
     * Returns the contact.
     * @return the contact
     */
    public String getContact() {
        return "http://www.resmedicinae.org";
    }
    //
    // Authors.
    //

    /**
     * Returns the authors.
     * @return the authors
     */
    public String getAuthors() {
        return "Torsten Kunze\n<zone3@gmx.net>";
    }
    //
    // Helpers.
    //

    /**
     * Returns the helpers.
     * @return the helpers
     */
    public String getHelpers() {
        return "Unspecified Helpers.\n" + "Try to contact these project administrators:\n\n" +
                "Christian Heller\n<christian.heller@tuxtax.de>\n\n" + "Karsten Hilbert\n<karsten.hilbert@gmx.net>";
    }
    //
    // Inspirations.
    //

    /**
     * Returns the inspirations.
     * @return the inspirations
     */
    public String getInspirations() {
        return "Unspecified Inspirations";
    }
    //
    // License.
    //

    /**
     * Returns the license.
     * @return the license
     */
    public String getLicense() {
        return "This software is published under the GPL GNU General Public License.\n" +
                "This program is free software; you can redistribute it and/or\n" +
                "modify it under the terms of the GNU General Public License\n" +
                "as published by the Free Software Foundation; either version 2\n" +
                "of the License, or (at your option) any later version.\n\n" +
                "This program is distributed in the hope that it will be useful,\n" +
                "but WITHOUT ANY WARRANTY; without even the implied warranty of\n" +
                "MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the\n" +
                "GNU General Public License for more details.\n\n" + "You should have received a copy of the GNU General Public License\n" +
                "along with this program; if not, write to the Free Software\n" +
                "Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.\n\n" +
                "Find the GPL license and more information at: http://www.gnu.org";
    }

    /** instance of HealthRecord */
    private HealthRecord healthRecord = null;

    /** Constructs the Printer application controller and its corresponding model and view. */
    public FormularController() {
        super();
        try {
            // Set model and view.
            System.out.println("FormularController");
        } catch (Exception e) {
            System.out.println("Construction failed:\n" + e);
            e.printStackTrace();
        }
    }

    /**
     * Creates the model.
     * @return the model
     */
    public Object createModel() throws Exception {
        System.out.println("FormularController createModel ANFANG");
        FormularModel m = new FormularModel();
        if (m != null) {
            // m.configure(getConfigurationManager());
            m.setController(this);
            m.initialize();
        } else {
            System.out.println("Could not create model. The view is null.");
            throw new NullPointerException("Could not create model. The model is null.");
        }
        System.out.println("FormularController createModel ENDE");
        return (Object) m;
    }

    /**
     * Creates a view.
     * @return the view
     * @exception NullPointerException if the view is null
     */
    public View createView() throws Exception {
        System.out.println("FormularController createView ANFANG");
        FormularView v = new FormularView();
        if (v != null) {
            //?? Only temporary! Remove this line later, when Controller does not need to be set
            //?? and when assigning ControlId to GUI components is enough.
            v.setController(this);
            v.configure(getConfigurationManager());
            v.initialize();
        } else {
            System.out.println("Could not create view. The view is null.");
            throw new NullPointerException("Could not create view. The view is null.");
        }
        System.out.println("FormularController createView ENDE");
        return v;
    }

    /** Initializes this application controller. */
    public void initialize() throws Exception {
        System.out.println("FormularController initialize ANFANG");
        super.initialize();
        createAllDialogs();
        createAllMembers();
        System.out.println("FormularController initialize ENDE");
    }

    /** Finalizes this application controller. */
    public void finalize() throws Exception {
        try {
            super.finalize();
        } catch (Throwable t) {
            throw new Exception(t.toString());
        }
    }

    public void createAllDialogs() {
        try {
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void createAllMembers() {
        try {
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /** creates the member variable healthRecord. */

/*	public void createHealthRecord()
	{
		this.healthRecord = new HealthRecord();
	}
*/

    /**
     * Sets the member variable healthRecord.
     * @param healthRecord the new value for the member variable healthRecord
     */

/*	public void setHealthRecord(HealthRecord healthRecord)
	{
		this.healthRecord = healthRecord;
	}
*/

    /**
     * Returns the member variable healthRecord.
     * @return healthRecord
     */

/*	public HealthRecord getHealthRecord()
	{
		return this.healthRecord;
	}
*/
}
