/*
 * $RCSfile: AdvancedBasicApplication.java,v $
 *
 * Copyright (c) 1999-2002. Christian Heller. All Rights Reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.application.healthcare.reform.application.common.basic;

import org.resmedicinae.application.common.basic.*;
import org.resmedicinae.application.healthcare.record.topology.*;
import org.resmedicinae.application.healthcare.reform.gui.*;
import org.resmedicinae.application.healthcare.reform.region.*;
import org.resmedicinae.application.healthcare.reform.region.assembler.*;
import org.resmedicinae.application.healthcare.reform.region.model.*;
import org.resmedicinae.application.healthcare.reform.squirrel.*;
import org.resmedicinae.application.healthcare.reform.xml.*;
import org.resmedicinae.application.healthcare.reform.system.server.rmi.*;
import org.resmedicinae.application.healthcare.reform.system.*;
import org.resmedicinae.domain.healthcare.*;
import org.resmedicinae.resmedlib.component.control.*;
import org.resmedicinae.resmedlib.region.*;

import javax.swing.*;
import javax.swing.event.*;
import java.awt.event.*;
import java.util.*;
import java.rmi.*;
import java.net.*;

/**
 * This class represents a basic application. Classes inheriting from this class can be run standalone or
 * belonging to a main (parent) application. Design patterns: - Controller in Model View Controller
 * @version $Revision: 1.12 $ $Date: 2003/01/20 10:14:26 $ $Author: tristan24 $
 * @author Torsten Kunze <zone3@gmx.de>
 * @author Christian Heller <christian.heller@tuxtax.de>
 */
public class AdvancedBasicApplication extends BasicApplication {

    /** includes all assemblers */
    private Hashtable assemblerList;
    /** includes all models */
    private Hashtable modelList;
    /** the identification key of the actual working persistance model */
    private String persistanceModelKey;
    /** the identification key of the actual working data transfer model */
    private String dataTransferModelKey;
    /** the identification key of the actual working persistance assembler */
    private String persistanceAssemblerKey;
    /** the identification key of the actual working data transfer assembler */
    private String dataTransferAssemblerKey;
    /** reference of the squirrel launcher */
    private SquirrelLauncher squirrelLauncher;
    /** the model for this model view controller */
//    private HealthRecordViewModel healthRecordViewModel;
    /** instance of CommunicationSelector */
    private CommunicationSelectorPanel communicationSelectorPanel = null;

    /** The load patient dialog. */
    private LoadPatientDialog loadPatientDialog;

    /** instance of ChangeHealthRecordData */
    private ChangeHealthRecordData changeHealthRecordData = null;

    /** instance of NewHealthRecord */
    private NewHealthRecord newHealthRecord = null;

    /** indexes vector that inculdes vectors of health record (only name, firstname, id) */
    private Vector vectorHealthRecords;

    /** indexes vector that inculdes a subset of vectors of health record (only name, firstname, id) */
    private Vector subSetVectorHealthRecords;

    /** String that inculdes ID of the actual selected healthRecord */
    private org.resmedicinae.resmedlib.term.String selectedHealthRecordId;

    /** instance of JFrame */
    private JFrame generalHintDialogFrame = null;

    /** instance of GeneralHintDialog */
    private GeneralHintDialog generalHintDialog = null;

    /** instance of RMIServerLauncher */
    private RMIServerLauncher rmiServerLauncher;

    /** instance of RMIGeneralServices */
    private RMIGeneralServices rmiGeneralServices;

    /** instance of RMIPartnerNameListDialog */
    private RMIPartnerNameListDialog rmiPartnerNameList;

    private static String rmiHost = "";

    /* Contorl IDs for menu File */

    /** For saving the whole workspace */
    public static final String SAVE_ALL_CONTROL_ID = "Save all";
    /** For selecting data transfer protocol and persistance protocol */
    public static final String COMMUNICATION_SELECTOR_CONTROL_ID = "Communication Selector";
    /** For Starting Sqirell, a data base obeservation tool */
    public static final String SQUIRREL_START_CONTROL_ID = "Start Squirrel";
    /** For exiting the application */
    public static final String EXIT_ID = "Exit";

    /*  Contorl IDs for menu Card Index */

    /** To create a new index file (only for local saving in files) */
    public static final String NEW_INDEX_CONTROL_ID = "New index";
    /** To open an index */
    public static final String OPEN_INDEX_CONTROL_ID = "Open index";
    /** To save an index**/
    public static final String SAVE_INDEX_CONTROL_ID = "Save index";
    /** To save an index by new name (only for local saving in files) */
    public static final String SAVE_INDEX_AS_CONTROL_ID = "Save index as...";

    /*  Contorl IDs for  menu HealthRecord */

    /** Opens a dialog to create a new health record */
    public static final String NEW_HEALTHRECORD_CONTROL_ID = "New health record";
    /** Opens a dialog to change data of a health record */
    public static final String CHANGE_HEALTHRECORD_DATA_CONTROL_ID = "Change health record data";
    /** Opens a dialog to select a health record to work with */
    public static final String CHOOSE_HEALTHRECORD_CONTROL_ID = "Choose health record";
    /** To save the actual selested health record */
    public static final String SAVE_HEALTHRECORD_CONTROL_ID = "Save health record";
    /** To import health records from files */
    public static final String IMPORT_HEALTHRECORD_CONTROL_ID = "Import health record";
    /**  To import health records from directories  */
    public static final String IMPORT_HEALTHRECORD_DIRECTORY_CONTROL_ID = "Import health record directory";


    public static final String SELECT_RMI_COMMUNICATION_PARTNER_DIALOG_CONTROL_ID = "SELECT_RMI_COMMUNICATION_PARTNER_DIALOG_CONTROL_ID";

    public static final String DESTROY_RMI_COMMUNICATION_PARTNER_DIALOG_CONTROL_ID = "DESTROY_RMI_COMMUNICATION_PARTNER_DIALOG_CONTROL_ID";

    public static final String UPDATE_RMI_COMMUNICATION_PARTNER_DIALOG_CONTROL_ID = "UPDATE_RMI_COMMUNICATION_PARTNER_DIALOG_CONTROL_ID";

    public static final String OPEN_RMI_COMMUNICATION_PARTNER_DIALOG_CONTROL_ID = "Availlable RMI Partners";

    /*
    /* Get / Set / Create / Destroy ***************************************** */
    /*

    /**
     *
     * @return
     */
    public RMIServerLauncher getRMIServerLauncher() {
        return rmiServerLauncher;
    }

    /**
     *
     * @param rmiServerLauncher
     */
    public void setRMIServerLauncher(RMIServerLauncher rmiServerLauncher) {
        this.rmiServerLauncher = rmiServerLauncher;
    }

    /**
     *
     * @param modulName
     * @return
     */
    public RMIServerLauncher createRMIServerLauncher(String modulName) {
        String idString = "";
        try {
            idString = InetAddress.getLocalHost().toString();
            idString = idString.substring(0, idString.indexOf("/"));
        } catch(Exception e) {
            e.printStackTrace();
        }
        idString = "rmi://" + idString + "/" + modulName;
        this.rmiHost = idString;
        return new RMIServerLauncher(idString);
    }

    /**
     *
     * @return
     */
    public void destroyRMIServerLauncher() {


    }


    /**
     *
     * @return
     */
    public RMIGeneralServices getRMIGeneralServices() {
        return rmiGeneralServices;
    }

    /**
     *
     * @param rmiGeneralServices
     */
    public void setRMIGeneralServices(RMIGeneralServices rmiGeneralServices) {
        this.rmiGeneralServices = rmiGeneralServices;
    }

    /**
     *
     * @return
     */
    public RMIGeneralServices createRMIGeneralServices() {
        if (System.getSecurityManager() == null) {
            System.setSecurityManager(new RMISecurityManager());
        }
        try {
            RMIGeneralServices rmiGeneralServices = (RMIGeneralServices)
                    Naming.lookup(this.rmiHost);
            System.out.println("RMI name service found...");
            return rmiGeneralServices;
        } catch(MalformedURLException murle) {
            System.out.println();
            System.out.println(
                    "MalformedURLException");
            System.out.println(murle);
        } catch(RemoteException re) {
            System.out.println();
            System.out.println(
                    "RemoteException");
            System.out.println(re);
        } catch(NotBoundException nbe) {
            System.out.println();
            System.out.println(
                    "NotBoundException");
            System.out.println(nbe);
        }
        return null;
    }


    /**
     *
     */
    public void createRMIPartnerNameList() {
        RMIPartnerNameListDialog rmiPartnerNameListDialog = new RMIPartnerNameListDialog();
        rmiPartnerNameListDialog.setController(this);
        rmiPartnerNameListDialog.initialize();
        this.rmiPartnerNameList = rmiPartnerNameListDialog;
    }

    /**
     * Returns the RMIPartnerNameListDialog.
     * @return the rmiPartnerNameList
     */
    public RMIPartnerNameListDialog getRMIPartnerNameList() {
        return this.rmiPartnerNameList;
    }

    /**
     * Sets the LoadPatientDialog.
     * @param rmiPartnerNameListDialog the dialog that includes all avallable rmi communication partners
     */
    public void setRMIPartnerNameList(RMIPartnerNameListDialog rmiPartnerNameListDialog) {
        this.rmiPartnerNameList = rmiPartnerNameListDialog;
    }

    /**
     * Destroys the RMIPartnerNameListDialog.
     * @param rmiPartnerNameListDialog the RMIPartnerNameListDialog
     */
    private void destroyRMIPartnerNameList(RMIPartnerNameListDialog rmiPartnerNameListDialog) throws Exception {
        if (rmiPartnerNameListDialog != null) {
            rmiPartnerNameListDialog.finalizz();
            rmiPartnerNameListDialog.deconfigure(getConfigurationManager());
            rmiPartnerNameListDialog.setController(null);
            rmiPartnerNameListDialog.setModel(null);
        } else {
            throw new NullPointerException("Could not destroy rmi partner name list dialog. The dialog is null.");
        }
    }

    /**
     *
     * @return
     */
    public Vector updateRMICommunicationPartnerList() throws Exception {
        try {
            String[] stArray = Naming.list(rmiHost);
            String st = "";
            Vector unsorted = new Vector();
            Vector sorted = new Vector();
            for (int i = 0; i < stArray.length; i++) {
                unsorted.add(stArray[i]);
            }
            SortedSet sortedSet = Collections.synchronizedSortedSet(new TreeSet(unsorted));
            Iterator iterator = sortedSet.iterator();
            while (iterator.hasNext()) {
                st = iterator.next().toString();
                st = st.substring(st.indexOf("//") + 2);
                st = st.substring(0, st.indexOf(":") + 1) + st.substring(st.indexOf("/") + 1, st.lastIndexOf("////"));
                //st = st.substring(0,st.lastIndexOf("////"));
                sorted.add(st);
            }
            return sorted;
        } catch(Exception e) {
            throw new Exception(e);
        }
    }

    /**
     * Returns the squirrel launcher
     */
    public SquirrelLauncher getSquirrelLauncher() {
        return squirrelLauncher;
    }

    /**
     * Sets the squirrel launcher
     */
    public void setSquirrelLauncher(SquirrelLauncher squirrelLauncher) {
        this.squirrelLauncher = squirrelLauncher;
    }

    /**
     * Creates the member variable assemblerList
     */
    public Hashtable createAssemblerList() {
        return new Hashtable();
    }

    /**
     * Adds a new assembler to the member variable asssemblerList
     */
    public void addSpecialAssemblerToList(Assembler newAssembler, String key) {
        getAssemblerList().put(key, newAssembler);
    }

    /**
     * Returns a specified assembler from the member variable assemblerList.
     * If  key doesn't match any of the stored keys, then it returns null.
     */
    public Assembler getSpecialAssemblerFromList(String key) {
        if (getAssemblerList().containsKey(key))
            return (Assembler) getAssemblerList().get(key);
        else
            return null;
    }

    /**
     * Sets the member variable assemblerList
     */
    public void setAssemblerList(Hashtable assemblerList) {
        this.assemblerList = assemblerList;
    }

    /**
     * Returns the member variable assemblerList
     */
    public Hashtable getAssemblerList() {
        if (this.assemblerList == null)
            setAssemblerList(createAssemblerList());
        return assemblerList;
    }

    /**
     * Destroys the member variable assemblerList
     */
    public void destroyAssemblerList() {
        assemblerList = null;
    }

    /*
     * ModelList
     */

    /**
     * Creates the member variable modelList
     */
    public Hashtable createModelList() {
        return new Hashtable();
    }

    /**
     *  Adds a new model to the member variable modelList
     */
    public void addSpecialModelToList(Model newModel, String key) {
        getModelList().put(key, newModel);
    }

    /**
     * Returns a specified model from the member variable modelList.
     * If  key doesn't match any of the stored keys, then it returns null.
     */
    public Model getSpecialModelFromList(String key) {
        if (getModelList().containsKey(key))
            return (Model) getModelList().get(key);
        else
            return null;
    }

    /**
     * Sets the member variable modelList
     */
    public void setModelList(Hashtable modelList) {
        this.modelList = modelList;
    }

    /**
     * Returns the member variable modelList
     */
    public Hashtable getModelList() {
        if (this.modelList == null)
            setModelList(createModelList());
        return modelList;
    }

    /**
     * Destroys the member variable modelList
     */
    public void destroyModelList() {
        modelList = null;
    }


    /**
     * Creates a new ExtensibleMarkupLanguageAssembler
     */
    public ExtensibleMarkupLanguageAssembler createExtensibleMarkupLanguageAssembler() {
        return new ExtensibleMarkupLanguageAssembler();
    }

    /**
     * Creates a new EntityRelationshipModelAssembler
     */
    public EntityRelationshipAssembler createEntityRelationshipAssembler() {
        return new EntityRelationshipAssembler();
    }

    /**
     * Creates a new CommonObjectRequestBrokerArchitectureAssembler
     */
    public CommonObjectRequestBrokerArchitectureAssembler createCommonObjectRequestBrokerArchitectureAssembler() {
        return new CommonObjectRequestBrokerArchitectureAssembler();
    }

    /**
     * Creates a new JavaMessageServiceAssembler
     */
    public JavaMessageServiceAssembler createJavaMessageServiceAssembler() {
        return new JavaMessageServiceAssembler();
    }

    /**
     * Creates a new emoteMethodInvocationAssembler
     */
    public RemoteMethodInvocationAssembler createRemoteMethodInvocationAssembler() {
        return new RemoteMethodInvocationAssembler();
    }

    /**
     * Creates a new ExtensibleMarkupLanguageModel
     */
    public ExtensibleMarkupLanguageModel createExtensibleMarkupLanguageModel() {
        return new ExtensibleMarkupLanguageModel();
    }

    /**
     * Creates a new EntityRelationshipModel
     */
    public EntityRelationshipModel createEntityRelationshipModel() {
        return new EntityRelationshipModel();
    }

    /**
     * Creates a new CommonObjectRequestBrokerArchitectureModel
     */
    public CommonObjectRequestBrokerArchitectureModel createCommonObjectRequestBrokerArchitectureModel() {
        return new CommonObjectRequestBrokerArchitectureModel();
    }


    /**
     * Creates a new RemoteMethodInvocationModel
     */
    public RemoteMethodInvocationModel createRemoteMethodInvocationModel() {
        return new RemoteMethodInvocationModel();
    }

    /**
     * Creates a new JavaMessageServiceModel
     */
    public JavaMessageServiceModel createJavaMessageServiceModel() {
        return new JavaMessageServiceModel();
    }


    /**
     *  Sets the member variable dataTransferModelKey
     */
    public void setDataTransferModelKey(String key) {
        this.dataTransferModelKey = key;
    }

    /**
     *  Returns the member variable dataTransferModelKey
     */
    public String getDataTransferModelKey() {
        return this.dataTransferModelKey;
    }

    /**
     *  Sets the member variable persistanceModelKey
     */
    public void setPersistanceModelKey(String key) {
        this.persistanceModelKey = key;
    }

    /**
     *  Returns the member variable persistanceModelKey
     */
    public String getPersistanceModelKey() {
        return this.persistanceModelKey;
    }

    /*
     * Sets the member variable dataTransferAssemblerKey
     */
    public void setDataTransferAssemblerKey(String key) {
        this.dataTransferAssemblerKey = key;
    }

    /**
     *  Returns the member variable dataTransferAssemblerKey
     */
    public String getDataTransferAssemblerKey() {
        return this.dataTransferAssemblerKey;
    }

    /**
     *  Sets the member variable persistanceAssemblerKey
     */
    public void setPersistanceAssemblerKey(String key) {
        this.persistanceAssemblerKey = key;
    }

    /**
     *  Returns the member variable persistanceAssemblerKey
     */
    public String getPersistanceAssemblerKey() {
        return this.persistanceAssemblerKey;
    }

    /**
     *  Returns the member variable subSetVectorHealthRecords
     */
    public Vector getSubSetVectorHealthRecords() {
        return this.subSetVectorHealthRecords;
    }

    /**
     *  Returns the member variable subSetVectorHealthRecords
     */
    public void setSubSetVectorHealthRecords(Vector subSetVectorHealthRecords) {
        this.subSetVectorHealthRecords = subSetVectorHealthRecords;
    }

    /**
     *  Returns the member variable vectorHealthRecords
     */
    public Vector getVectorHealthRecords() {
        return this.vectorHealthRecords;
    }

    /**
     *  Returns the member variable vectorHealthRecords
     */
    public void setVectorHealthRecords(Vector vectorHealthRecords) {
        this.vectorHealthRecords = vectorHealthRecords;
    }

    /** creates the member variable generalHintDialogFrame. */
    public void createGeneralHintDialogFrame() {
        this.generalHintDialogFrame = new JFrame();
    }

    /**
     * Sets the member variable generalHintDialogFrame.
     * @param generalHintDialogFrame the new value for the member variable generalHintDialogFrame
     */
    public void setGeneralHintDialogFrame(JFrame generalHintDialogFrame) {
        this.generalHintDialogFrame = generalHintDialogFrame;
    }

    /**
     * Returns the member variable generalHintDialogFrame.
     * @return generalHintDialogFrame
     */
    public JFrame getGeneralHintDialogFrame() {
        return this.generalHintDialogFrame;
    }

    /** creates the member variable generalHintDialog. */
    public void createGeneralHintDialog() {
    }

    /**
     * Sets the member variable generalHintDialog.
     * @param generalHintDialog the new value for the member variable generalHintDialog
     */
    public void setGeneralHintDialog(GeneralHintDialog generalHintDialog) {
        this.generalHintDialog = generalHintDialog;
    }

    /**
     * Returns the member variable generalHintDialog.
     * @return generalHintDialog
     */
    public GeneralHintDialog getGeneralHintDialog() {
        return this.generalHintDialog;
    }

    /**
     *
     * @return
     */
//    public HealthRecordViewModel getHealthRecordViewModel() {
//        return healthRecordViewModel;
//    }

    /**
     *
     * @param healthRecordViewModel
     */
//    public void setHealthRecordViewModel(HealthRecordViewModel healthRecordViewModel) {
//        this.healthRecordViewModel = healthRecordViewModel;
//    }

    public HealthRecordViewModel createHealthRecordViewModel() throws Exception {
        try {
            HealthRecordViewModel healthRecordViewModel = new HealthRecordViewModel();
            healthRecordViewModel.initialize();
            return healthRecordViewModel;
        } catch(Exception e) {
            throw new Exception(e);
        }
    }

    //
    // LoadPatientDialog lifecycle
    //

    /**
     * Creates the LoadPatientDialog.
     * @return the LoadPatientDialog
     * @exception NullPointerException if the context is null
     */
    private LoadPatientDialog createLoadPatientDialog() throws Exception, NullPointerException {
        LoadPatientDialog d = new LoadPatientDialog();
        if (d != null) {
            d.setModel(getModel());
            d.setController(this);
            d.configure(getConfigurationManager());
            d.initialize();
            setVectorHealthRecords(new Vector());
            setSubSetVectorHealthRecords(new Vector());
        } else {
            throw new NullPointerException("Could not create load patient dialog. The dialog is null.");
        }
        return d;
    }

    /**
     * Returns the LoadPatientDialog.
     * @return the LoadPatientDialog
     */
    public LoadPatientDialog getLoadPatientDialog() {
        return this.loadPatientDialog;
    }

    /**
     * Sets the LoadPatientDialog.
     * @param loadPatientDialog the load patient dialog
     */
    public void setLoadPatientDialog(LoadPatientDialog loadPatientDialog) {
        this.loadPatientDialog = loadPatientDialog;
    }

    /**
     * Destroys the LoadPatientDialog.
     * @param d the LoadPatientDialog
     */
    private void destroyLoadPatientDialog(LoadPatientDialog d) throws Exception {
        if (d != null) {
            d.finalizz();
            d.deconfigure(getConfigurationManager());
            d.setController(null);
            d.setModel(null);
        } else {
            throw new NullPointerException("Could not destroy load patient dialog. The dialog is null.");
        }
    }

    /**
     * creates the member variable newHealthRecord.
     * @exception NullPointerException if the context is null
     */
    public void createNewHealthRecord() throws Exception, NullPointerException {
        this.newHealthRecord = new NewHealthRecord();
        if (this.newHealthRecord != null) {
            this.newHealthRecord.setController(this);
            this.newHealthRecord.setModel(getModel());
            this.newHealthRecord.configure(getConfigurationManager());
            this.newHealthRecord.initialize();
            System.out.println("createNewHealthRecord()");
        } else {
            throw new NullPointerException("Could not create load healthRecord dialog. The dialog is null.");
        }
    }

    /**
     * Sets the member variable newHealthRecord.
     * @param newHealthRecord the new value for the member variable newHealthRecord
     */
    public void setNewHealthRecord(NewHealthRecord newHealthRecord) {
        this.newHealthRecord = newHealthRecord;
    }

    /**
     * Returns the member variable newHealthRecord.
     * @return newHealthRecord
     */
    public NewHealthRecord getNewHealthRecord() {
        System.out.println("getNewHealthRecord()");
        return this.newHealthRecord;
    }

    /*
	* Destroys the member variable newHealthRecord.
	* @param newHealthRecord the new value for the member variable newHealthRecord
	*/
    public void destroyNewHealthRecord(NewHealthRecord newHealthRecord) {
    }

    /**
     * Creates the member variable changeHealthRecordData.
     * @exception NullPointerException if the context is null
     */
    public void createChangeHealthRecordData() throws Exception, NullPointerException {
        this.changeHealthRecordData = new ChangeHealthRecordData();
        if (this.changeHealthRecordData != null) {
            this.changeHealthRecordData.setController(this);
            this.changeHealthRecordData.setModel(getModel());
            this.changeHealthRecordData.configure(getConfigurationManager());
            this.changeHealthRecordData.initialize();
        } else {
            throw new NullPointerException("Could not create load healthRecord dialog. The dialog is null.");
        }
    }

    /**
     * Sets the member variable changeHealthRecordData.
     * @param changeHealthRecordData the new value for the member variable changeHealthRecordData
     */
    public void setChangeHealthRecordData(ChangeHealthRecordData changeHealthRecordData) {
        this.changeHealthRecordData = changeHealthRecordData;
    }

    /**
     * Returns the member variable changeHealthRecordData.
     * @return changeHealthRecordData
     */
    public ChangeHealthRecordData getChangeHealthRecordData() {
        return this.changeHealthRecordData;
    }

    /**
     * Creates the member variable communicationSelectorPanel.
     */
    public void createCommunicationSelectorPanel() throws Exception, NullPointerException {
        this.communicationSelectorPanel = new CommunicationSelectorPanel();
        if (this.communicationSelectorPanel != null) {
            this.communicationSelectorPanel.setController(this);
            this.communicationSelectorPanel.configure(getConfigurationManager());
            this.communicationSelectorPanel.initialize();
        } else {
            throw new NullPointerException("Could not create load CommunicationSelectorPanel dialog. The dialog is null.");
        }
    }

    /**
     * Sets the member variable communicationSelectorPanel.
     * @param communicationSelectorPanel the new value for the member variable communicationSelectorPanel
     */
    public void setCommunicationSelectorPanel(CommunicationSelectorPanel communicationSelectorPanel) {
        this.communicationSelectorPanel = communicationSelectorPanel;
    }

    /**
     * Returns the member variable communicationSelectorPanel.
     * @return communicationSelectorPanel
     */
    public CommunicationSelectorPanel getCommunicationSelector() {
        return this.communicationSelectorPanel;
    }

    /**
     ************************************************* Domain handling
     * **********************************************************************
     */

    /** Methods For All  ***************************************************** */

    /**
     * Initializes the model view controler, all necessary dialogs, assemblers and models.
     */
    public void initialize(String modulName) throws Exception {
        try {
            super.initialize();


// ************************* RMI-Server starten *******************************
      //      setRMIServerLauncher(createRMIServerLauncher(modulName));


            if (getModel() == null)
                setModel(createHealthRecordViewModel());

            createAllDialogs();

            ExtensibleMarkupLanguageModel extensibleMarkupLanguageModel = createExtensibleMarkupLanguageModel();
            extensibleMarkupLanguageModel.initialize();
            addSpecialModelToList(extensibleMarkupLanguageModel, ExtensibleMarkupLanguageModel.MODEL_KEY);
            setPersistanceModelKey(ExtensibleMarkupLanguageModel.MODEL_KEY);

            ExtensibleMarkupLanguageAssembler extensibleMarkupLanguageAssembler =
                    createExtensibleMarkupLanguageAssembler();
            extensibleMarkupLanguageAssembler.setModel((HealthRecordViewModel) getModel());
            extensibleMarkupLanguageAssembler.initialize();
            addSpecialAssemblerToList(extensibleMarkupLanguageAssembler,
                    ExtensibleMarkupLanguageAssembler.ASSEMBLER_KEY);
            setPersistanceAssemblerKey(ExtensibleMarkupLanguageAssembler.ASSEMBLER_KEY);

// ************************* RMI-Client starten *******************************

       //     setRMIGeneralServices(createRMIGeneralServices());


        } catch(Exception e) {
            throw new Exception(e);
        }
    }

    /**
     * Creates all needed dialogs
     */
    public void createAllDialogs() throws Exception {
        try {
            this.createNewHealthRecord();
            //            this.createHealthRecordManager();
            setLoadPatientDialog(createLoadPatientDialog());
            this.createChangeHealthRecordData();
            this.createCommunicationSelectorPanel();
            this.createRMIPartnerNameList();
        } catch(Exception e) {
            throw new Exception(e);
        }
    }

    /**
     * Correct strings for storing in xml-format Characters like "","","","","","" are not supported by xml
     * So they will be transformed in "Ae", "Oe", "Ue", "ae", "oe", "ue"
     * @param st string to correct
     * @return the transformed string
     */
    public org.resmedicinae.resmedlib.term.String correctString(String st) {
        st = st.replaceAll("", "Ae");
        st = st.replaceAll("", "Ue");
        st = st.replaceAll("", "Oe");
        st = st.replaceAll("", "ae");
        st = st.replaceAll("", "oe");
        st = st.replaceAll("", "ue");
        return new org.resmedicinae.resmedlib.term.String(st);
    }

    /**
     * Imports new health records from files, depending on the underlaying persistance protocol.
     */
    public void importHealthRecord() throws Exception {
        if (getPersistanceAssemblerKey().equals(ExtensibleMarkupLanguageAssembler.ASSEMBLER_KEY)) {
            ((ExtensibleMarkupLanguageAssembler)
                    getSpecialAssemblerFromList(getPersistanceAssemblerKey())).importHealthRecord();
        }

        /* else if ...*/
    }

    /**
     * Imports new health records from direcotries, depending on the underlaying persistance protocol.
     */
    public void importHealthRecordDirectory() throws Exception {
        if (getPersistanceAssemblerKey().equals(ExtensibleMarkupLanguageAssembler.ASSEMBLER_KEY)) {
            ((ExtensibleMarkupLanguageAssembler)
                    getSpecialAssemblerFromList(getPersistanceAssemblerKey())).importHealthRecordDirectory();
        }

        /* else if ...*/
    }

    /**
     * Saves health record by a specified name, depending on the underlaying persistance protocol.
     */
    public void saveDataAs() {
        if (getPersistanceAssemblerKey().equals(ExtensibleMarkupLanguageAssembler.ASSEMBLER_KEY)) {
            ((ExtensibleMarkupLanguageAssembler)
                    getSpecialAssemblerFromList(getPersistanceAssemblerKey())).saveDataAs(((HealthRecordViewModel) getModel()).getHealthRecordIndex(),
                            ((HealthRecordViewModel) getModel()).getLoadedHealthRecords());
        }

        /* else if ...*/

        ((HealthRecordViewModel) getModel()).getLoadedHealthRecords().setDataModified(false);
    }

    /**
     * Loads a health record, depending on the underlaying persistance protocol.
     */
    public void loadHealthRecordIndex() throws Exception {
        System.out.println("getPersistanceAssemblerKey(): "+getPersistanceAssemblerKey());
        System.out.println("getSpecialAssemblerFromList(getPersistanceAssemblerKey()): "+getSpecialAssemblerFromList(getPersistanceAssemblerKey()));
       // System.out.println(": "+);
        if (getPersistanceAssemblerKey().equals(ExtensibleMarkupLanguageAssembler.ASSEMBLER_KEY)) {

            ((ExtensibleMarkupLanguageAssembler)
                    getSpecialAssemblerFromList(getPersistanceAssemblerKey())).loadHealthRecordIndex();
        } else if (getPersistanceAssemblerKey().equals(EntityRelationshipAssembler.ASSEMBLER_KEY)) {
            ((EntityRelationshipAssembler)
                    getSpecialAssemblerFromList(getPersistanceAssemblerKey())).loadHealthRecordIndex();
        }
        setUpdateAfterChangingHealthRecordData();
    }

    /**
     * Saves the index of the health records, depending on the underlaying persistance protocol.
     * For data base it isn't necessary to save the index seperately, becaus it's generated of it's data at runtime
     * and not stored in a special table.
     */
    public void saveHealthRecordIndex() {
        if (getPersistanceAssemblerKey().equals(ExtensibleMarkupLanguageAssembler.ASSEMBLER_KEY)) {
            ((ExtensibleMarkupLanguageAssembler)
                    getSpecialAssemblerFromList(getPersistanceAssemblerKey())).saveHealthRecordIndex(((HealthRecordViewModel)
                    getModel()).getHealthRecordIndex());
        }

        /* else if ...*/
    }

    /**
     * Saves the actual health record, depending on the underlaying persistance protocol.
     */
    public void saveHealthRecord(HealthRecord healthRecord) throws Exception {
        System.out.println("Save.getPersistanceAssemblerKey(): " + getPersistanceAssemblerKey());
        if (getPersistanceAssemblerKey().equals(ExtensibleMarkupLanguageAssembler.ASSEMBLER_KEY)) {
            System.out.println("SaveToXML");
            ((ExtensibleMarkupLanguageAssembler)
                    getSpecialAssemblerFromList(getPersistanceAssemblerKey())).saveHealthRecord(healthRecord);
            System.out.println("SaveToXML");
            saveHealthRecordIndex();
        } else if (getPersistanceAssemblerKey().equals(EntityRelationshipAssembler.ASSEMBLER_KEY)) {
            System.out.println("SaveToDB");
            ((EntityRelationshipAssembler)
                    getSpecialAssemblerFromList(getPersistanceAssemblerKey())).saveHealthRecord(healthRecord);
        }
    }

    /**
     * Saves all unsaved health record, depending on the underlaying persistance protocol.
     */
    public void saveAllHealthRecords() {
        if (getPersistanceAssemblerKey().equals(ExtensibleMarkupLanguageAssembler.ASSEMBLER_KEY)) {
            ((ExtensibleMarkupLanguageAssembler)
                    getSpecialAssemblerFromList(getPersistanceAssemblerKey())).saveAllHealthRecords(((HealthRecordViewModel)
                    getModel()).getLoadedHealthRecords());
        }

        /* else if ...*/

        ((HealthRecordViewModel) getModel()).getLoadedHealthRecords().setDataModified(false);
    }

    /**
     * Rmoves a health record.
     */
    public void removeHealthRecord(org.resmedicinae.resmedlib.term.String healthRecordId) throws Exception {
        try {
            if (getPersistanceAssemblerKey().equals(ExtensibleMarkupLanguageAssembler.ASSEMBLER_KEY)) {
                ((ExtensibleMarkupLanguageAssembler)
                        getSpecialAssemblerFromList(getPersistanceAssemblerKey())).removeHealthRecord(healthRecordId);
            } else if (getPersistanceAssemblerKey().equals(EntityRelationshipAssembler.ASSEMBLER_KEY))
                ((EntityRelationshipAssembler)
                        getSpecialAssemblerFromList(getPersistanceAssemblerKey())).removeHealthRecord(healthRecordId);
            setUpdateAfterRemovingHealthRecord(healthRecordId);
            int vectorId = 0;
            while ((vectorId < getVectorHealthRecords().size()) &&
                    !(((Vector) getVectorHealthRecords().elementAt(vectorId)).elementAt(0).equals(getSelectedHealthRecordId().getValue())))
                vectorId++;
            if (!((Vector) getVectorHealthRecords().elementAt(vectorId)).elementAt(0).equals(getSelectedHealthRecordId().getValue()))
                throw new Exception("Couldn't delete healthrecord or health record does not exist.");
            int subSetVectorId = getLoadPatientDialog().getPossibleNamesTable().getSelectedRow();
            //            ((HealthRecordViewModel) getModel()).getHealthRecordIndex().addNotUsedId(getHealthRecordIds().elementAt(vectorId).toString());
            Hashtable healthRecordData = new Hashtable();
            int i = -1;
            healthRecordData.put(HealthRecordIndex.ID, new org.resmedicinae.resmedlib.term.String("-1"));
            if (((HealthRecordViewModel) getModel()).getHealthRecordIndex().size() > 0) {
                String searchID = ((Vector) getVectorHealthRecords().elementAt(vectorId)).elementAt(0).toString();
                while ((i < ((HealthRecordViewModel) getModel()).getHealthRecordIndex().size()) &&
                        (((org.resmedicinae.resmedlib.term.String)
                        healthRecordData.get(HealthRecordIndex.ID)).getValue().compareTo(searchID) != 0)) {
                    i++;
                    healthRecordData = (Hashtable) ((HealthRecordViewModel) getModel()).getHealthRecordIndex().elementAt(i);
                }
            }
            ((HealthRecordViewModel) getModel()).getHealthRecordIndex().removeElementAt(i);
            ((HealthRecordViewModel) getModel()).getLoadedHealthRecords().removeHealthRecord(healthRecordId);
            getVectorHealthRecords().removeElementAt(vectorId);
            if (subSetVectorId > -1)
                getSubSetVectorHealthRecords().removeElementAt(subSetVectorId);
            //            ((HealthRecordViewModel) getModel()).setAfterChange(true);
            //            getLoadPatientDialog().getTableModel().fillTableWithEHRIndex(updateSubSetHealthRecords(getHealthRecordNameFragment()));
            getLoadPatientDialog().getTableModel().removeLine(subSetVectorId);
            //            getLoadPatientDialog().getBSelect().setEnabled(true);
            //            healthRecordManager.getBRemove().setEnabled(false);
            if (getPersistanceAssemblerKey().equals(ExtensibleMarkupLanguageAssembler.ASSEMBLER_KEY))
                saveHealthRecordIndex();
        } catch(Exception e) {
            throw new Exception("Health record couldn't be removed!\n" + e);
        }
    }

    /**
     * Rmoves a problem.
     */
    public void removeProblem(org.resmedicinae.resmedlib.term.String problemId) throws Exception {
        try {
            if (getPersistanceAssemblerKey().equals(ExtensibleMarkupLanguageAssembler.ASSEMBLER_KEY)) {
                ((ExtensibleMarkupLanguageAssembler)
                        getSpecialAssemblerFromList(getPersistanceAssemblerKey())).saveHealthRecord(((HealthRecordViewModel) getModel()).getCurrentHealthRecord());
            } else if (getPersistanceAssemblerKey().equals(EntityRelationshipAssembler.ASSEMBLER_KEY)) {
                ((EntityRelationshipAssembler)
                        getSpecialAssemblerFromList(getPersistanceAssemblerKey())).removeProblem(problemId);
            }
        } catch(Exception e) {
            throw new Exception("Problem couldn't be removed!\n" + e);
        }
    }

    /**
     * Rmoves an episode.
     */
    public void removeEpisode(org.resmedicinae.resmedlib.term.String episodeId) throws Exception {
        try {
            if (getPersistanceAssemblerKey().equals(ExtensibleMarkupLanguageAssembler.ASSEMBLER_KEY)) {
                ((ExtensibleMarkupLanguageAssembler)
                        getSpecialAssemblerFromList(getPersistanceAssemblerKey())).saveHealthRecord(((HealthRecordViewModel) getModel()).getCurrentHealthRecord());
            } else if (getPersistanceAssemblerKey().equals(EntityRelationshipAssembler.ASSEMBLER_KEY))
                ((EntityRelationshipAssembler)
                        getSpecialAssemblerFromList(getPersistanceAssemblerKey())).removeEpisode(episodeId);
        } catch(Exception e) {
            throw new Exception("Episode couldn't be removed!\n" + e);
        }
    }

    /**
     * Rmoves a parital contact.
     */
    public void removePartialContact(org.resmedicinae.resmedlib.term.String partialContactId) throws Exception {
        try {
            if (getPersistanceAssemblerKey().equals(ExtensibleMarkupLanguageAssembler.ASSEMBLER_KEY)) {
                ((ExtensibleMarkupLanguageAssembler)
                        getSpecialAssemblerFromList(getPersistanceAssemblerKey())).saveHealthRecord(((HealthRecordViewModel) getModel()).getCurrentHealthRecord());
            } else if (getPersistanceAssemblerKey().equals(EntityRelationshipAssembler.ASSEMBLER_KEY))
                ((EntityRelationshipAssembler)
                        getSpecialAssemblerFromList(getPersistanceAssemblerKey())).removePartialContact(partialContactId);
        } catch(Exception e) {
            throw new Exception("PartialContact couldn't be removed!\n" + e);
        }
    }

    /**
     * Rmoves an objective.
     */
    public void removeObjective(org.resmedicinae.resmedlib.term.String objectiveId) throws Exception {
        try {
            if (getPersistanceAssemblerKey().equals(ExtensibleMarkupLanguageAssembler.ASSEMBLER_KEY)) {
                ((ExtensibleMarkupLanguageAssembler)
                        getSpecialAssemblerFromList(getPersistanceAssemblerKey())).saveHealthRecord(((HealthRecordViewModel) getModel()).getCurrentHealthRecord());
            } else if (getPersistanceAssemblerKey().equals(EntityRelationshipAssembler.ASSEMBLER_KEY))
                ((EntityRelationshipAssembler)
                        getSpecialAssemblerFromList(getPersistanceAssemblerKey())).removeObjective(objectiveId);
        } catch(Exception e) {
            throw new Exception("Objective couldn't be removed!\n" + e);
        }
    }

    /**
     * Rmoves a cave.
     */
    public void removeCave(org.resmedicinae.resmedlib.term.String caveId) throws Exception {
        try {
            if (getPersistanceAssemblerKey().equals(ExtensibleMarkupLanguageAssembler.ASSEMBLER_KEY)) {
                ((ExtensibleMarkupLanguageAssembler)
                        getSpecialAssemblerFromList(getPersistanceAssemblerKey())).saveHealthRecord(((HealthRecordViewModel) getModel()).getCurrentHealthRecord());
            } else if (getPersistanceAssemblerKey().equals(EntityRelationshipAssembler.ASSEMBLER_KEY))
                ((EntityRelationshipAssembler)
                        getSpecialAssemblerFromList(getPersistanceAssemblerKey())).removeCave(caveId);
        } catch(Exception e) {
            throw new Exception("Cave couldn't be removed!\n" + e);
        }
    }

    /** NewHealthRecord  ********************************************************** */

    /**
     * creates a new HealthRecord object and fills it with the data form the JTextFields,
     * adds the HealthRecord object to the project and save it as an xml-file
     */
    public void addHealthRecord() throws Exception {
        NewHealthRecord newHealthRecord = getNewHealthRecord();
        HealthRecord healthRecord = new HealthRecord();
        healthRecord.setIdentifier(ObjectID.getNewOId());
        healthRecord.setName(correctString(newHealthRecord.getTfName().getText()));
        healthRecord.setFirstName(correctString(newHealthRecord.getTfFirstname().getText()));
        healthRecord.setBirthday(new org.resmedicinae.resmedlib.term.String(newHealthRecord.getTfBirthday().getText()));
        healthRecord.setStreet(correctString(newHealthRecord.getTfStreet().getText()));
        healthRecord.setZipCode(new org.resmedicinae.resmedlib.term.String(newHealthRecord.getTfZipCode().getText()));
        healthRecord.setTown(correctString(newHealthRecord.getTfTown().getText()));
        healthRecord.setCountry(correctString(newHealthRecord.getTfCountry().getText()));
        healthRecord.setPhoneNumber(correctString(newHealthRecord.getTfPhoneNumber().getText()));
        healthRecord.setInsurance(correctString(newHealthRecord.getTfInsurance().getText()));
        healthRecord.setInsuranceNumber(correctString(newHealthRecord.getTfInsuranceNumber().getText()));
        healthRecord.setBloodType(correctString(newHealthRecord.getTfBloodType().getText()));
        healthRecord.setHeight(correctString(newHealthRecord.getTfHeight().getText()));
        healthRecord.setWeight(correctString(newHealthRecord.getTfWeight().getText()));
        Hashtable healthRecordData = new Hashtable();
        healthRecordData.put(HealthRecordIndex.ID, healthRecord.getIdentifier());
        healthRecordData.put(HealthRecordIndex.NAME, healthRecord.getName());
        healthRecordData.put(HealthRecordIndex.FIRSTNAME, healthRecord.getFirstName());
        ((HealthRecordViewModel) getModel()).getHealthRecordIndex().addHealthRecord(healthRecordData);
        try {
            setUpdateHealthRecordData(healthRecord);
            saveHealthRecord(healthRecord);
            ((HealthRecordViewModel) getModel()).setCurrentHealthRecord(healthRecord);
      //      if (getRMIGeneralServices() == null)
    //            setRMIGeneralServices(createRMIGeneralServices());
  //          getRMIGeneralServices().setCurrentHealthRecord(healthRecord);

//            System.out.println(getRMIGeneralServices().getCurrentHealthRecord().getName().getValue());
        } catch(Exception e) {
            e.printStackTrace();
            throw new Exception(e);
        }
    }

    /** ChangeHealthRecordData  *************************************************** */

    /**
     * Fills the JTextFields of ChangeHealthRecordData if data are availlable
     */
    public void fillTextFieldsOfChangeHealthRecordDataDialog() {
        if (((HealthRecordViewModel) getModel()).getCurrentHealthRecord() != null) {
            ChangeHealthRecordData changeHealthRecordData = getChangeHealthRecordData();
            if (((HealthRecordViewModel) getModel()).getCurrentHealthRecord().getName() != null)
                changeHealthRecordData.getTfName().setText(((HealthRecordViewModel)
                        getModel()).getCurrentHealthRecord().getName().getValue());
            if (((HealthRecordViewModel) getModel()).getCurrentHealthRecord().getFirstName() != null)
                changeHealthRecordData.getTfFirstname().setText(((HealthRecordViewModel)
                        getModel()).getCurrentHealthRecord().getFirstName().getValue());
            if (((HealthRecordViewModel) getModel()).getCurrentHealthRecord().getBirthday() != null)
                changeHealthRecordData.getTfBirthday().setText(((HealthRecordViewModel)
                        getModel()).getCurrentHealthRecord().getBirthday().getValue());
            if (((HealthRecordViewModel) getModel()).getCurrentHealthRecord().getStreet() != null)
                changeHealthRecordData.getTfStreet().setText(((HealthRecordViewModel)
                        getModel()).getCurrentHealthRecord().getStreet().getValue());
            if (((HealthRecordViewModel) getModel()).getCurrentHealthRecord().getZipCode() != null)
                changeHealthRecordData.getTfZipCode().setText(((HealthRecordViewModel)
                        getModel()).getCurrentHealthRecord().getZipCode().getValue());
            if (((HealthRecordViewModel) getModel()).getCurrentHealthRecord().getTown() != null)
                changeHealthRecordData.getTfTown().setText(((HealthRecordViewModel)
                        getModel()).getCurrentHealthRecord().getTown().getValue());
            if (((HealthRecordViewModel) getModel()).getCurrentHealthRecord().getCountry() != null)
                changeHealthRecordData.getTfCountry().setText(((HealthRecordViewModel)
                        getModel()).getCurrentHealthRecord().getCountry().getValue());
            if (((HealthRecordViewModel) getModel()).getCurrentHealthRecord().getPhoneNumber() != null)
                changeHealthRecordData.getTfPhoneNumber().setText(((HealthRecordViewModel)
                        getModel()).getCurrentHealthRecord().getPhoneNumber().getValue());
            if (((HealthRecordViewModel) getModel()).getCurrentHealthRecord().getInsurance() != null)
                changeHealthRecordData.getTfInsurance().setText(((HealthRecordViewModel)
                        getModel()).getCurrentHealthRecord().getInsurance().getValue());
            if (((HealthRecordViewModel) getModel()).getCurrentHealthRecord().getInsuranceNumber() != null)
                changeHealthRecordData.getTfInsuranceNumber().setText(((HealthRecordViewModel)
                        getModel()).getCurrentHealthRecord().getInsuranceNumber().getValue());
            if (((HealthRecordViewModel) getModel()).getCurrentHealthRecord().getBloodType() != null)
                changeHealthRecordData.getTfBloodType().setText(((HealthRecordViewModel)
                        getModel()).getCurrentHealthRecord().getBloodType().getValue());
            if (((HealthRecordViewModel) getModel()).getCurrentHealthRecord().getHeight() != null)
                changeHealthRecordData.getTfHeight().setText(((HealthRecordViewModel)
                        getModel()).getCurrentHealthRecord().getHeight().getValue());
            if (((HealthRecordViewModel) getModel()).getCurrentHealthRecord().getWeight() != null)
                changeHealthRecordData.getTfWeight().setText(((HealthRecordViewModel)
                        getModel()).getCurrentHealthRecord().getWeight().getValue());
        }
    }

    /**
     * Gets the data from the JTextFields and put then in the actual HealthRecord object, updates the HealthRecordIndex
     * and advises the controller object that something was changed
     */
    public void renewHealthRecordData() throws Exception {
        try {
            HealthRecordViewModel model = (HealthRecordViewModel) getModel();
            if (model.getCurrentHealthRecord() != null) {
                ChangeHealthRecordData changeHealthRecordData = getChangeHealthRecordData();
                if (changeHealthRecordData.getTfName().getText().trim().length() > 0)
                    model.getCurrentHealthRecord().setName(correctString(changeHealthRecordData.getTfName().getText()));
                else {
//    new GeneralHintDialog(getGeneralHintDialogFrame(), "The \"name\" -field may not be empty!");
                }
                if (changeHealthRecordData.getTfFirstname().getText().trim().length() > 0)
                    model.getCurrentHealthRecord().setFirstName(correctString(changeHealthRecordData.getTfFirstname().getText()));
                else {
//    new GeneralHintDialog(getGeneralHintDialogFrame(), "The \"first name\" -field may not be empty!");
                }
                model.getCurrentHealthRecord().setBirthday(
                        new org.resmedicinae.resmedlib.term.String(changeHealthRecordData.getTfBirthday().getText()));
                model.getCurrentHealthRecord().setStreet(correctString(changeHealthRecordData.getTfStreet().getText()));
                model.getCurrentHealthRecord().setZipCode(
                        new org.resmedicinae.resmedlib.term.String(changeHealthRecordData.getTfZipCode().getText()));
                model.getCurrentHealthRecord().setTown(correctString(changeHealthRecordData.getTfTown().getText()));
                model.getCurrentHealthRecord().setCountry(correctString(changeHealthRecordData.getTfCountry().getText()));
                model.getCurrentHealthRecord().setPhoneNumber(correctString(changeHealthRecordData.getTfPhoneNumber().getText()));
                model.getCurrentHealthRecord().setInsurance(correctString(changeHealthRecordData.getTfInsurance().getText()));
                model.getCurrentHealthRecord().setInsuranceNumber(correctString(changeHealthRecordData.getTfInsuranceNumber().getText()));
                model.getCurrentHealthRecord().setBloodType(correctString(changeHealthRecordData.getTfBloodType().getText()));
                model.getCurrentHealthRecord().setHeight(correctString(changeHealthRecordData.getTfHeight().getText()));
                model.getCurrentHealthRecord().setWeight(correctString(changeHealthRecordData.getTfWeight().getText()));
                Hashtable healthRecordData = new Hashtable();
                int i = -1;
                healthRecordData.put(HealthRecordIndex.ID, new org.resmedicinae.resmedlib.term.String("-1"));
                if (model.getHealthRecordIndex().size() > 0) {
                    while ((i < model.getHealthRecordIndex().size()) && (((org.resmedicinae.resmedlib.term.String)
                            healthRecordData.get(HealthRecordIndex.ID)).getValue().compareTo(model.getCurrentHealthRecord().getIdentifier().getValue()) != 0)) {
                        i++;
                        healthRecordData = (Hashtable) model.getHealthRecordIndex().elementAt(i);
                    }
                }
                healthRecordData = new Hashtable();
                healthRecordData.put(HealthRecordIndex.ID, model.getCurrentHealthRecord().getIdentifier());
                healthRecordData.put(HealthRecordIndex.NAME, model.getCurrentHealthRecord().getName());
                healthRecordData.put(HealthRecordIndex.FIRSTNAME, model.getCurrentHealthRecord().getFirstName());
                model.getHealthRecordIndex().setElementAt(healthRecordData, i);

                setUpdateHealthRecordData(model.getCurrentHealthRecord());
                saveHealthRecord(model.getCurrentHealthRecord());
            } else {
//   new GeneralHintDialog(getGeneralHintDialogFrame(), "Please, select a healthRecord first from the \"Choose healthRecord\"-window!");
            }
        } catch(Exception e) {
            throw new Exception(e);
        }
    }

    /**
     * Called when another healthRecord was selected. Displays the data of the new healthRecord.
     */
    public void setUpdateAfterSelectingOtherHealthRecord() {
        getChangeHealthRecordData().clearAllTextFields();
        fillTextFieldsOfChangeHealthRecordDataDialog();
    }

    /**
     * Called when a healthRecord was removeed.
     */
    public void setUpdateAfterRemovingAHealthRecord(org.resmedicinae.resmedlib.term.String healthRecordId) {
        if (((HealthRecordViewModel) getModel()).getCurrentHealthRecord().getIdentifier() != null)
            if (healthRecordId.equals(((HealthRecordViewModel) getModel()).getCurrentHealthRecord().getIdentifier())) {
                getChangeHealthRecordData().clearAllTextFields();
                getNewHealthRecord().clearAllTextFields();
            }
    }

    /** HealthRecordManager  ************************************************** */

    /**
     * Updates the vectors of healthRecord names and healthRecord IDs after changing the value of thr JTextField
     * tfHealthRecordName. This method is called by the HealthRecordFileDocumentListener.
     * @param healthRecordNameFragment a String that includes the fragment of the wanted healthRecord name
     * @return a Vector of all possible variations of healthRecord names
     */
    public Vector updateSubSetHealthRecords(String healthRecordNameFragment) {
        if ((healthRecordNameFragment != null) && (healthRecordNameFragment.trim().compareTo("") != 0)) {
            Vector subSetHR = new Vector();
            String st;
            for (int i = 0; i < getSubSetVectorHealthRecords().size(); i++) {
                st = ((Vector) getSubSetVectorHealthRecords().elementAt(i)).elementAt(2).toString();
                if (st.startsWith(healthRecordNameFragment)) {
                    subSetHR.add(this.subSetVectorHealthRecords.elementAt(i));
                }
            }
            setSubSetVectorHealthRecords(new Vector(subSetHR));
        } else {
            setSubSetVectorHealthRecords(new Vector(getVectorHealthRecords()));
        }
        return getSubSetVectorHealthRecords();
    }

    /**
     * Updates the vectors of healthRecord names and healthRecord IDs after changing the value of the JTextField
     * tfHealthRecordName. This method is called by the HealthRecordFileDocumentListener if something was
     * inserted into the JTextField.
     * @param healthRecordNameFragment a String that includes the fragment of the wanted healthRecord name
     * @return a Vector of all possible variations of healthRecord names
     */
    public Vector insertSubSetHealthRecords(String healthRecordNameFragment) {
//        HealthRecordManager healthRecordManager = getHealthRecordManager();
//        getLoadPatientDialog().getBSelect().setEnabled(false);
//        healthRecordManager.getBRemove().setEnabled(false);
        if ((healthRecordNameFragment != null) && (healthRecordNameFragment.trim().compareTo("") != 0)) {
            Vector subSetHR = new Vector();
            String st;
            for (int i = 0; i < getVectorHealthRecords().size(); i++) {
                st = ((Vector) getVectorHealthRecords().elementAt(i)).elementAt(2).toString();
                if (st.startsWith(healthRecordNameFragment)) {
                    subSetHR.add(getVectorHealthRecords().elementAt(i));
                }
            }
            setSubSetVectorHealthRecords(new Vector(subSetHR));
        } else {
            setSubSetVectorHealthRecords(new Vector(getVectorHealthRecords()));
        }
        return getSubSetVectorHealthRecords();
    }

    /**
     * Updates the vectors of healthRecord names and healthRecord IDs after changing the value of thr JTextField
     * tfHealthRecordName. This method is called by the HealthRecordFileDocumentListener if something was
     * deleted from the JTextField.
     * @param healthRecordNameFragment a String that includes the fragment of the wanted healthRecord name
     * @return a Vector of all possible variations of healthRecord names
     */
    public Vector removeSubSetHealthRecords(String healthRecordNameFragment) {
//        HealthRecordManager healthRecordManager = getHealthRecordManager();
//        getLoadPatientDialog().getBSelect().setEnabled(false);
//        healthRecordManager.getBRemove().setEnabled(false);
        if ((healthRecordNameFragment != null) && (healthRecordNameFragment.trim().compareTo("") != 0)) {
            Vector subSetHR = new Vector();
            String st;
            for (int i = 0; i < getVectorHealthRecords().size(); i++) {
                st = ((Vector) getVectorHealthRecords().elementAt(i)).elementAt(2).toString();
                if (st.startsWith(healthRecordNameFragment)) {
                    subSetHR.add(getVectorHealthRecords().elementAt(i));
                }
            }
            setSubSetVectorHealthRecords(new Vector(subSetHR));
        } else {
            setSubSetVectorHealthRecords(new Vector(getVectorHealthRecords()));
        }
        return getSubSetVectorHealthRecords();
    }

    /**
     * Updates the list of healthRecords after adding, deleting or changing something
     */
    public void setUpdateAfterChangingHealthRecordData() throws Exception {
        System.out.println("setUpdateAfterChangingHealthRecordData");
        setAllHealthRecords();
        try {
            getLoadPatientDialog().getTableModel().fillTableWithEHRIndex(insertSubSetHealthRecords(getHealthRecordNameFragment()));
        } catch(Exception e) {
            throw new Exception(e);
        }
    }

    /**
     * This method is called if something is changed in the HealthRecordIndex but nothing else.
     */
    public void setUpdateHealthRecordList() throws Exception {
        try {
            setUpdateAfterChangingHealthRecordData();
        } catch(Exception e) {
            throw new Exception(e);
        }
    }

    /**
     * This method is called if something is changed in the HealthRecordIndex and
     * healthRecord data have been modifyed (changed, removed, inserted)
     */
    public void setUpdateHealthRecordData(HealthRecord healthRecord) throws Exception {
        ((HealthRecordViewModel) getModel()).getLoadedHealthRecords().updateHealthRecord(healthRecord);
        try {
            setUpdateHealthRecordList();
        } catch(Exception e) {
            throw new Exception(e);
        }
    }

    /**
     * This method is called if an other healthRecord was selected in the "Chose healthRecord"-menu of HealthRecordManager.
     * It udates der already loaded HealthRecords LoadedHealthRecords and advises the @see ChangeHealthRecordData object
     * that another healthRecord was selected.
     */
    public void setUpdateChangeHealthRecord() {
        ((HealthRecordViewModel) getModel()).getLoadedHealthRecords().updateHealthRecord(((HealthRecordViewModel)
                getModel()).getCurrentHealthRecord());
        if (getChangeHealthRecordData() != null) {
            setUpdateAfterSelectingOtherHealthRecord();
        }
    }

    /**
     * This method is called if a healthRecord has been removed from the HealthRecordIndex
     */
    public void setUpdateAfterRemovingHealthRecord(org.resmedicinae.resmedlib.term.String healthRecordId) {
        if (getChangeHealthRecordData() != null) {
            setUpdateAfterRemovingAHealthRecord(healthRecordId);
            ((HealthRecordViewModel) getModel()).getLoadedHealthRecords().removeHealthRecord(healthRecordId);
            if (((HealthRecordViewModel) getModel()).getCurrentHealthRecord().getIdentifier() != null) {
                if (healthRecordId.getValue().compareTo(((HealthRecordViewModel) getModel()).getCurrentHealthRecord().getIdentifier().getValue()) == 0) {
                    ((HealthRecordViewModel) getModel()).setCurrentHealthRecord(null);
                }
            }
        }
    }

    /**
     * gets the healthRecord data from the HealthRecordIndex object of the actual controller,
     * sorts this data and stores the healthRecord names and healthRecord IDs in vectors
     */
    public void setAllHealthRecords() {
//        HealthRecordManager healthRecordManager = getHealthRecordManager();
//        System.out.println(">>>>>>>>>>>>: " + (getLoadPatientDialog() == null));
//        System.out.println(">>>>>>>>>>>>: " + (getLoadPatientDialog().getBSelect() == null));
//        getLoadPatientDialog().getBSelect().setEnabled(false);
//        healthRecordManager.getBRemove().setEnabled(false);
        Vector allHealthRecords = ((HealthRecordViewModel) getModel()).getHealthRecordIndex().getAllHealthRecords();
        Vector singleHealthRecord = new Vector();
        Hashtable ht;
        setVectorHealthRecords(new Vector());
        Vector healthRecordNameId = new Vector();
        String st;
        for (int i = 0; i < allHealthRecords.size(); i++) {
            ht = (Hashtable) (allHealthRecords.elementAt(i));
            healthRecordNameId.add(((org.resmedicinae.resmedlib.term.String) ht.get(HealthRecordIndex.NAME)).getValue() +
                    "###" + ((org.resmedicinae.resmedlib.term.String) ht.get(HealthRecordIndex.FIRSTNAME)).getValue() + "###" +
                    ((org.resmedicinae.resmedlib.term.String) ht.get(HealthRecordIndex.ID)).getValue());
        }
        SortedSet sortedSet = Collections.synchronizedSortedSet(new TreeSet(healthRecordNameId));
        Iterator iterator = sortedSet.iterator();
        while (iterator.hasNext()) {
            st = iterator.next().toString();
            singleHealthRecord = new Vector();
            String st1 = st.substring(0, st.indexOf("###"));
            st = st.substring(st.indexOf("###") + 3);
            String st2 = st.substring(0, st.indexOf("###"));
            st = st.substring(st.indexOf("###") + 3);
            singleHealthRecord.add(st);
            singleHealthRecord.add(st2);
            singleHealthRecord.add(st1);
            getVectorHealthRecords().add(singleHealthRecord);
        }
        setSubSetVectorHealthRecords(new Vector(getVectorHealthRecords()));
        if (getSubSetVectorHealthRecords().size() > 0) {
            getLoadPatientDialog().getPossibleNamesTable().setEnabled(true);
//            showInformationMessage(RecordMessages.POSSIBLE_NAMES_MESSAGE);
        } else {
            getLoadPatientDialog().getPossibleNamesTable().setEnabled(false);
//            showWarningMessage(RecordMessages.NO_SUGGESTIONS_MESSAGE);
        }
    }


    /**
     * Sets the healthRecord ID of the actual selected healthRecord if the value of the JTextField
     * tfHealthRecordName has changed.
     * @param id number of the actual focused data set in the Vector subSetHealthRecordIds
     */
    public void setSelectedHealthRecordId(org.resmedicinae.resmedlib.term.String id) {
        this.selectedHealthRecordId = id;
    }

    /**
     * Sets the identifier of the health record of the actual selected row to the member variable selectedHealthRecordId.
     */
    public void setSelectedHealthRecordId() {
        LoadPatientDialog loadPatientDialog = getLoadPatientDialog();
        this.selectedHealthRecordId = new org.resmedicinae.resmedlib.term.String(((Vector) getSubSetVectorHealthRecords().elementAt(loadPatientDialog.getPossibleNamesTable().getSelectedRow())).elementAt(0).toString());
//        getLoadPatientDialog().getBSelect().setEnabled(true);  // loadPatientDialog
//        healthRecordManager.getBRemove().setEnabled(true);  // loadPatientDialog
    }

    /**
     * Returns the actual selected healthRecord ID.
     * @return the value of the member variable selectedHealthRecordId
     */
    public org.resmedicinae.resmedlib.term.String getSelectedHealthRecordId() {
        return this.selectedHealthRecordId;
    }

    /**
     * Returns the content of the JTextField tfHealthRecordName.
     * @return value of tfHealthRecordName as a String
     */
    public String getHealthRecordNameFragment() {
        return getLoadPatientDialog().getNameTextField().getText();
    }

    /**
     * Sets the actual HealthRecord object and advises the controller that another healthRecord was selected.
     * @param healthRecord the new HealthRecord object
     */
    public void updateHealthRecord(HealthRecord healthRecord) {
        ((HealthRecordViewModel) getModel()).setCurrentHealthRecord(healthRecord);
        setUpdateChangeHealthRecord();
    }

    /**
     * If another health record is selected from list, it's data will be loaded, depending on the underlaying persistance mechanism.
     */
    public void selectAnotherHealthRecord() throws Exception {
        if (getSelectedHealthRecordId() != null) {
            String assemblerKey = getPersistanceAssemblerKey();
            if (assemblerKey.equals(ExtensibleMarkupLanguageAssembler.ASSEMBLER_KEY)) {
                if (((HealthRecordViewModel) getModel()).getLoadedHealthRecords().isLoadedHealthRecord(getSelectedHealthRecordId())) {
                    updateHealthRecord(((HealthRecordViewModel)
                            getModel()).getLoadedHealthRecords().getHealthRecord(getSelectedHealthRecordId()));
                } else {
                    try {
                        updateHealthRecord(((ExtensibleMarkupLanguageAssembler) getSpecialAssemblerFromList(assemblerKey)).loadHealthRecord(getSelectedHealthRecordId()));
                    } catch(Exception e) {
                        e.printStackTrace();
                    }
                    updateHealthRecord(((ExtensibleMarkupLanguageAssembler) getSpecialAssemblerFromList(assemblerKey)).loadHealthRecord(getSelectedHealthRecordId()));
                }
            } else if (assemblerKey.equals(EntityRelationshipAssembler.ASSEMBLER_KEY)) {
                updateHealthRecord(((EntityRelationshipAssembler) getSpecialAssemblerFromList(assemblerKey)).loadHealthRecord(getSelectedHealthRecordId()));
            }
        } else {
            System.out.println("No health record was chosen!");
//   new GeneralHintDialog(getGeneralHintDialogFrame(), "No health record  was chosen!");
        }
    }

    /**
     * Exits the application and stops all of it's running processes.
     */
    protected void exit() {
        if (getSquirrelLauncher() != null)
            getSquirrelLauncher().killProcess();

        if (getRMIServerLauncher() != null) {
            try {
                getRMIGeneralServices().unbindServer();
            } catch(Exception e) {
                e.printStackTrace();
            }
            getRMIServerLauncher().killProcess();
        }

        try {
            if (getSpecialAssemblerFromList(EntityRelationshipAssembler.ASSEMBLER_KEY) != null)
                ((EntityRelationshipAssembler) getSpecialAssemblerFromList(EntityRelationshipAssembler.ASSEMBLER_KEY)).finishCurrentAssemblerActions();
        } catch(Exception e) {
            e.printStackTrace();
        }
        if (((HealthRecordViewModel) getModel()).getLoadedHealthRecords().dataModified()) {
//   new GeneralHintDialog(getGeneralHintDialogFrame(), "Don't forget to save your changes!");
        } else
            System.exit(0);
        System.exit(0);
    }

    /** Event handling ********************************************* */

    /**
     * Handles control events and calls the corresponding methods.
     * @param c the control
     * @exception NullPointerException if the control is null
     */
    protected void handle(Control c) throws Exception, NullPointerException {
        super.handle(c);
        if (c != null) {
            /** NewHealthRecord ************************************* */

            /** Menu File ************************************** */
            if (c.matches(AdvancedBasicApplication.SAVE_ALL_CONTROL_ID)) {
                try {
                    System.out.println("save healthRecords...");
//    getHealthRecordManager().setHealthRecordDataToDocument(healthRecord);
                    saveAllHealthRecords();
                    //saveHealthRecordIndex();
                    System.out.println("healthRecords saved");
                    System.out.println("index saved");
                } catch(Exception e) {
                    e.printStackTrace();
                }
            } else if (c.matches(AdvancedBasicApplication.COMMUNICATION_SELECTOR_CONTROL_ID)) {
                try {
                    show(getCommunicationSelector());
                } catch(Exception e) {
                    e.printStackTrace();
                }
            } else if (c.matches(AdvancedBasicApplication.SQUIRREL_START_CONTROL_ID)) {
                try {
                    if (getSquirrelLauncher() == null) {
                        setSquirrelLauncher(new SquirrelLauncher());
                    }
                } catch(Exception e) {
                    System.out.println("Could not launch application. Undiscovered exception:\n");
                    e.printStackTrace();
                }
            } else if (c.matches(AdvancedBasicApplication.EXIT_ID)) {
                exit();
            }

            /** Menu Card Index ************************************* */

/*
			else if (c.matches(AdvancedBasicApplication.NEW_INDEX_FILE_CONTROL_ID))
			{

                if (!getLoadedHealthRecords().dataModified())
                {
                    try
                    {
                        JFileChooser chooser = new JFileChooser();
                        ExampleFileFilter filterXml = new ExampleFileFilter();
                        filterXml.addExtension("xml");
                        filterXml.setDescription("XML");
                        chooser.setFileFilter(filterXml);
                        int returnVal = chooser.showSaveDialog(new JFrame());
                        if(returnVal == JFileChooser.APPROVE_OPTION)
                        {
                            setIndexFile(chooser.getSelectedFile().getName());
                            System.out.println("You chose to save this file: " + getIndexFile());
                        }
                    }
                    catch (Exception e)
                    {

                        //                    getLogger().log(Level.SEVERE, "Could not dispose application.", e);
                    }
                }
                else
                    new GeneralHintDialog(getGeneralHintDialogFrame(),"Don't forget to save your changes!");
			}
*/

            else if (c.matches(AdvancedBasicApplication.OPEN_INDEX_CONTROL_ID)) {
                try {
                    if (!((HealthRecordViewModel) getModel()).getLoadedHealthRecords().dataModified()) {
                        loadHealthRecordIndex();
                        show(getLoadPatientDialog());
                    }
//  else
//    new GeneralHintDialog(getGeneralHintDialogFrame(), "Don't forget to save your changes!");
                } catch(Exception e) {
                    e.printStackTrace();
                }
            } else if (c.matches(AdvancedBasicApplication.SAVE_INDEX_CONTROL_ID)) {
                try {
                    System.out.println("save index...");
                    saveHealthRecordIndex();
                    System.out.println("healthRecord index saved");
                } catch(Exception e) {
                }
            } else if (c.matches(AdvancedBasicApplication.SAVE_INDEX_AS_CONTROL_ID)) {
                try {
                    saveDataAs();
                } catch(Exception e) {
                }
            }

            /** Menu HealthRecord ****************************************** */
            else if (c.matches(AdvancedBasicApplication.NEW_HEALTHRECORD_CONTROL_ID)) {
                try {
                    show(getNewHealthRecord());
                } catch(Exception e) {
                }
            } else if (c.matches(AdvancedBasicApplication.CHANGE_HEALTHRECORD_DATA_CONTROL_ID)) {
                try {
                    show(getChangeHealthRecordData());
                } catch(Exception e) {
                }
            } else if (c.matches(AdvancedBasicApplication.CHOOSE_HEALTHRECORD_CONTROL_ID)) {
                try {
//	new GeneralHintDialog(getGeneralHintDialogFrame(),"CHOOSE_HEALTHRECORD_FILE");
                    show(getLoadPatientDialog());
                } catch(Exception e) {
                }
            } else if (c.matches(AdvancedBasicApplication.SAVE_HEALTHRECORD_CONTROL_ID)) {
                try {
                    saveHealthRecord(((HealthRecordViewModel) getModel()).getCurrentHealthRecord());
                    //saveHealthRecordIndex();
                } catch(Exception e) {
                }
            } else if (c.matches(AdvancedBasicApplication.IMPORT_HEALTHRECORD_CONTROL_ID)) {
                try {
                    importHealthRecord();
                    setUpdateHealthRecordList();
                } catch(Exception e) {
                }
            } else if (c.matches(AdvancedBasicApplication.IMPORT_HEALTHRECORD_DIRECTORY_CONTROL_ID)) {
                try {
                    importHealthRecordDirectory();
                    System.out.println("in Import vor update2");
                    setUpdateHealthRecordList();
                } catch(Exception e) {
                }
            }

            /** NewHealthRecord **************************************** */
            else if (c.matches(NewHealthRecord.ADD_NEW_HEALTHRECORD_DIALOG_CONTROL_ID)) {
                try {
                    if ((getNewHealthRecord().getTfName().getText().trim().length() > 0) &&
                            (getNewHealthRecord().getTfFirstname().getText()).trim().length() > 0) {
                        addHealthRecord();
                    } else {
//   new GeneralHintDialog(getGeneralHintDialogFrame(), "Please, fill in at least \"Name\" and \"FirstName\"!");
                    }
                } catch(Exception e) {
                }
            } else if (c.matches(NewHealthRecord.NEW_NEW_HEALTHRECORD_DIALOG_CONTROL_ID)) {
                try {
                    getNewHealthRecord().clearAllTextFields();
                } catch(Exception e) {
                }
            } else if (c.matches(NewHealthRecord.DESTROY_NEW_HEALTHRECORD_DIALOG_CONTROL_ID)) {
                try {
                    hide(getNewHealthRecord());
                } catch(Exception e) {
                }
            }

            /** ChangeHealthRecordData ************************************* */
            else if (c.matches(ChangeHealthRecordData.CHANGE_CHANGE_HEALTHRECORD_DATA_DIALOG_CONTROL_ID)) {
                try {
                    renewHealthRecordData();
                } catch(Exception e) {
                }
            } else if (c.matches(ChangeHealthRecordData.CLEAR_CHANGE_HEALTHRECORD_DATA_DIALOG_CONTROL_ID)) {
                try {
                    getChangeHealthRecordData().clearAllTextFields();
                } catch(Exception e) {
                }
            } else if (c.matches(ChangeHealthRecordData.DESTROY_CHANGE_HEALTHRECORD_DATA_DIALOG_CONTROL_ID)) {
                try {
                    hide(getChangeHealthRecordData());
                } catch(Exception e) {
                }
            }

            /** HealthRecordManager ************************************* */
            else if (c.matches(LoadPatientDialog.SELECT_HEALTHRECORD_LOAD_PATIENT_DIALOG_CONTROL_ID)) {
                try {
                    System.out.println(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>Jens: Haelth record load ausgefhrt!");
                    setSelectedHealthRecordId();
                    System.out.println(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>AAA");
                    selectAnotherHealthRecord();
                    System.out.println("!!!!!!!!!!!!!!!!!!!!!currentHealtrecord: " + ((HealthRecordViewModel) getModel()).getCurrentHealthRecord().getName());
                } catch(Exception e) {
                }
            } else if (c.matches(LoadPatientDialog.REMOVE_HEALTHRECORD_LOAD_PATIENT_DIALOG_CONTROL_ID)) {
                System.out.println("AdvancedBasicApplication.REMOVE_HEALTHRECORD_FILE_MANAGER_DIALOG_CONTROL_ID");
                try {
//   if (getSelectedHealthRecordId() != null) {

                    setSelectedHealthRecordId();

                    removeHealthRecord(getSelectedHealthRecordId());
//   } else {
                    System.out.println("No patien was chosen!");
//  new GeneralHintDialog(getGeneralHintDialogFrame(), "No patien was chosen!");
//   }
                } catch(Exception e) {
//                    getLogger().log(Level.SEVERE, "Could not dispose application.", e);
                }
            } else if (c.matches(LoadPatientDialog.DESTROY_HEALTHRECORD_LOAD_PATIENT_DIALOG_CONTROL_ID)) {
                try {
//	new GeneralHintDialog(getGeneralHintDialogFrame(),"CHOOSE_HEALTHRECORD_FILE");
                    hide(getLoadPatientDialog());
                } catch(Exception e) {
                }
            }

            /**  */

            /** Events from CommunicationSelectorPanel ******************************** */
            else if (c.matches(CommunicationSelectorPanel.XML_RADIOBUTTON_KEY)) {
                try {
                    if (getPersistanceAssemblerKey().compareTo(EntityRelationshipAssembler.ASSEMBLER_KEY) == 0)
                        ((EntityRelationshipAssembler) getSpecialAssemblerFromList(getPersistanceAssemblerKey())).finishCurrentAssemblerActions();

                    if (getSpecialModelFromList(ExtensibleMarkupLanguageModel.MODEL_KEY) == null) {
                        ExtensibleMarkupLanguageModel extensibleMarkupLanguageModel = createExtensibleMarkupLanguageModel();
                        extensibleMarkupLanguageModel.initialize();
                        addSpecialModelToList(extensibleMarkupLanguageModel, ExtensibleMarkupLanguageModel.MODEL_KEY);
                    }
                    setPersistanceModelKey(ExtensibleMarkupLanguageModel.MODEL_KEY);


                    if (getSpecialAssemblerFromList(ExtensibleMarkupLanguageAssembler.ASSEMBLER_KEY) == null) {
                        ExtensibleMarkupLanguageAssembler extendedMarkupLanguageModelAssembler =
                                createExtensibleMarkupLanguageAssembler();
                        extendedMarkupLanguageModelAssembler.setModel((HealthRecordViewModel) getModel());
                        extendedMarkupLanguageModelAssembler.initialize();
                        addSpecialAssemblerToList(extendedMarkupLanguageModelAssembler,
                                ExtensibleMarkupLanguageAssembler.ASSEMBLER_KEY);
                    }
                    setPersistanceAssemblerKey(ExtensibleMarkupLanguageAssembler.ASSEMBLER_KEY);
                } catch(Exception ex) {
                    ex.printStackTrace();
                }
            } else if (c.matches(CommunicationSelectorPanel.DB_RADIOBUTTON_KEY)) {
                try {
                    EntityRelationshipModel entityRelationshipModel = (EntityRelationshipModel) getSpecialModelFromList(EntityRelationshipModel.MODEL_KEY);
                    if (entityRelationshipModel == null) {
                        entityRelationshipModel = createEntityRelationshipModel();
                        entityRelationshipModel.initialize();
                        addSpecialModelToList(entityRelationshipModel, EntityRelationshipModel.MODEL_KEY);
                    }

                    EntityRelationshipAssembler entityRelationshipAssembler = (EntityRelationshipAssembler) getSpecialAssemblerFromList(EntityRelationshipAssembler.ASSEMBLER_KEY);
                    if (entityRelationshipAssembler == null) {
                        entityRelationshipAssembler = createEntityRelationshipAssembler();
                        entityRelationshipAssembler.setModel((HealthRecordViewModel) getModel());
                        entityRelationshipAssembler.setERModel(entityRelationshipModel);
                        entityRelationshipAssembler.initialize();
                        addSpecialAssemblerToList(entityRelationshipAssembler, EntityRelationshipAssembler.ASSEMBLER_KEY);
                    }
/*
 DBLogin dbLogin = null;
 if ((dbLogin == null) || (entityRelationshipModel.getConnection() == null)) {
     dbLogin = new DBLogin();
     dbLogin.initialize();
     Hashtable login = new Hashtable();
     login.put("false", "ok");
     login.put("false", "finish");
     show(dbLogin);
     boolean tryAgain = true;
 */

/*
   while ((login.get(new String("finish")).equals("false")) && (tryAgain)) {
       login = dbLogin.getLogin();
*/
                    try {
// entityRelationshipAssembler.openConnection((org.resmedicinae.resmedlib.term.String) login.get("name"), (org.resmedicinae.resmedlib.term.String) login.get("pwd"));
                        entityRelationshipAssembler.openConnection(new org.resmedicinae.resmedlib.term.String("zonie"), new org.resmedicinae.resmedlib.term.String(""));
                    } catch(Exception e) {
                        throw new Exception("Opening data base connection failt.\n" + e);
//          tryAgain = dbLogin.askForAnotherTry();
                    }
// }
/*
    System.out.println("E");

    hide(dbLogin);
    if ((login.get(new String("ok")).equals("true")) && (entityRelationshipModel.getConnection() != null)) {
*/
                    setPersistanceModelKey(EntityRelationshipModel.MODEL_KEY);
                    setPersistanceAssemblerKey(EntityRelationshipAssembler.ASSEMBLER_KEY);
/*    }
}
 */
                    System.out.println("Data base connection successfuly opened");
                } catch(Exception ex) {

                    throw new Exception("Couldn't open database conectivity.\n" + ex);
                }
            } else if (c.matches(CommunicationSelectorPanel.JMS_RADIOBUTTON_KEY)) {
                try {
/*
if (getSpecialAssemblerFromList(JavaMessageServiceModel.MODEL_KEY) == null) {
    JavaMessageServiceModel dataTransferModel = createJavaMessageServiceModel();
    dataTransferModel.initialize();
    addSpecialModelToList(dataTransferModel, JavaMessageServiceModel.MODEL_KEY);
}
setSpecialModelKey(JavaMessageServiceModel.MODEL_KEY);
*/

                    if (getSpecialAssemblerFromList(JavaMessageServiceAssembler.ASSEMBLER_KEY) == null) {
                        JavaMessageServiceAssembler javaMessageServiceAssembler = createJavaMessageServiceAssembler();
                        javaMessageServiceAssembler.setModel((HealthRecordViewModel) getModel());
                        javaMessageServiceAssembler.initialize();
                        addSpecialAssemblerToList(javaMessageServiceAssembler, JavaMessageServiceAssembler.ASSEMBLER_KEY);
                    }
                    setDataTransferAssemblerKey(JavaMessageServiceAssembler.ASSEMBLER_KEY);
                } catch(Exception ex) {
                    ex.printStackTrace();
                }
            }

            /** nur vorbereitet * */

            else if (c.matches(CommunicationSelectorPanel.RMI_RADIOBUTTON_KEY)) {
                try {
                    if (getSpecialAssemblerFromList(RemoteMethodInvocationModel.MODEL_KEY) == null) {
// anpassen
                        RemoteMethodInvocationModel remoteMethodInvocationModel = createRemoteMethodInvocationModel();
                        remoteMethodInvocationModel.initialize();
                        addSpecialModelToList(remoteMethodInvocationModel, RemoteMethodInvocationModel.MODEL_KEY);
                    }
                    setDataTransferModelKey(RemoteMethodInvocationModel.MODEL_KEY);

                    if (getSpecialAssemblerFromList(RemoteMethodInvocationAssembler.ASSEMBLER_KEY) == null) {
// anpassen
                        RemoteMethodInvocationAssembler remoteMethodInvocationAssembler = createRemoteMethodInvocationAssembler();
                        remoteMethodInvocationAssembler.setModel((HealthRecordViewModel) getModel());
                        remoteMethodInvocationAssembler.initialize();
                        addSpecialAssemblerToList(remoteMethodInvocationAssembler, RemoteMethodInvocationAssembler.ASSEMBLER_KEY);
                    }
                    setDataTransferAssemblerKey(RemoteMethodInvocationAssembler.ASSEMBLER_KEY);
                } catch(Exception ex) {
                    ex.printStackTrace();
                }
            } else if (c.matches(CommunicationSelectorPanel.CORBA_RADIOBUTTON_KEY)) {
                try {
                    if (getSpecialAssemblerFromList(CommonObjectRequestBrokerArchitectureModel.MODEL_KEY) == null) {
// anpassen
                        CommonObjectRequestBrokerArchitectureModel commonObjectRequestBrokerArchitectureModel = createCommonObjectRequestBrokerArchitectureModel();
                        commonObjectRequestBrokerArchitectureModel.initialize();
                        addSpecialModelToList(commonObjectRequestBrokerArchitectureModel, CommonObjectRequestBrokerArchitectureModel.MODEL_KEY);
                    }
                    setDataTransferModelKey(CommonObjectRequestBrokerArchitectureModel.MODEL_KEY);
                    if (getSpecialAssemblerFromList(CommonObjectRequestBrokerArchitectureAssembler.ASSEMBLER_KEY) == null) {
// anpassen
                        CommonObjectRequestBrokerArchitectureAssembler commonObjectRequestBrokerArchitectureAssembler = createCommonObjectRequestBrokerArchitectureAssembler();
                        commonObjectRequestBrokerArchitectureAssembler.setModel((HealthRecordViewModel) getModel());
                        commonObjectRequestBrokerArchitectureAssembler.initialize();
                        addSpecialAssemblerToList(commonObjectRequestBrokerArchitectureAssembler, CommonObjectRequestBrokerArchitectureAssembler.ASSEMBLER_KEY);
                    }
                    setDataTransferAssemblerKey(CommonObjectRequestBrokerArchitectureAssembler.ASSEMBLER_KEY);
                } catch(Exception ex) {
                    ex.printStackTrace();
                }
            } else if (c.matches(OPEN_RMI_COMMUNICATION_PARTNER_DIALOG_CONTROL_ID)) {
                try {
                    getRMIPartnerNameList().getChooseList().setListData(updateRMICommunicationPartnerList());
                    show(getRMIPartnerNameList());

                } catch(Exception ex) {
                    ex.printStackTrace();
                }
            } else if (c.matches(SELECT_RMI_COMMUNICATION_PARTNER_DIALOG_CONTROL_ID)) {
                try {


                } catch(Exception ex) {
                    ex.printStackTrace();
                }
            } else if (c.matches(DESTROY_RMI_COMMUNICATION_PARTNER_DIALOG_CONTROL_ID)) {
                try {
                    hide(getRMIPartnerNameList());
                } catch(Exception ex) {
                    ex.printStackTrace();
                }
            } else if (c.matches(UPDATE_RMI_COMMUNICATION_PARTNER_DIALOG_CONTROL_ID)) {
                try {
                    getRMIPartnerNameList().getChooseList().setListData(updateRMICommunicationPartnerList());

                } catch(Exception ex) {
                    ex.printStackTrace();
                }
            }
            /**  */
        } else {
            throw new NullPointerException("Could not handle control. Control is null.");
        }
    }

    /**
     * Handles all action events of the whole application.
     * @param e the action event
     */
    public void actionPerformed
            (ActionEvent
            e) {
        if (e != null) {
            Control c = new Control();
            c.setId(e.getActionCommand());
            try {
                this.handle(c);
            } catch(Exception ex) {
                ex.printStackTrace();
            }
        } else {
            throw new NullPointerException("Could not handle action event. Action event is null.");
        }
    }

    /**
     * Here are all valueChanged events of the whole application handled. These are events from tables, or lists.
     * Actual healthRecord ID changes, HealthRecordManager.setSelectedHealthRecordId() is called.
     */
    public void valueChanged
            (ListSelectionEvent
            event) {
//    setSelectedHealthRecordId();
        if (event.getSource() instanceof JList) {
//            if (!((HealthRecordViewModel)getModel()).getAfterChange())
//            else
//                ((HealthRecordViewModel)getModel()).setAfterChange(false);
        }
    }

    /**
     * Listener for HealthRecordManager<br> Manages the actions of JTextFields.
     * @see HealthRecordManager
     * @see DocumentListener
     * @param event DocumentEvent
     */
    public void changedUpdate
            (DocumentEvent
            event) {
        super.changedUpdate(event);
        try {
            Vector v = updateSubSetHealthRecords(getHealthRecordNameFragment());
            getLoadPatientDialog().getTableModel().fillTableWithEHRIndex(v);
            if (v.size() > 0)
                setSelectedHealthRecordId(
                        new org.resmedicinae.resmedlib.term.String(((Vector) v.elementAt(0)).elementAt(0).toString()));
        } catch(Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * Evaluates the event if something was inserted into the text area
     * @param event DocumentEvent
     */
    public void insertUpdate
            (DocumentEvent
            event) {
        super.insertUpdate(event);
        try {
            Vector v = updateSubSetHealthRecords(getHealthRecordNameFragment());
            getLoadPatientDialog().getTableModel().fillTableWithEHRIndex(insertSubSetHealthRecords(getHealthRecordNameFragment()));
            if (v.size() > 0)
                setSelectedHealthRecordId(
                        new org.resmedicinae.resmedlib.term.String(((Vector) v.elementAt(0)).elementAt(0).toString()));
        } catch(Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * Evaluates the event if something was removed from the text area
     * @param event DocumentEvent
     */
    public void removeUpdate
            (DocumentEvent
            event) {
        super.removeUpdate(event);
        try {
            Vector v = updateSubSetHealthRecords(getHealthRecordNameFragment());
            getLoadPatientDialog().getTableModel().fillTableWithEHRIndex(removeSubSetHealthRecords(getHealthRecordNameFragment()));
            if (v.size() > 0)
                setSelectedHealthRecordId(
                        new org.resmedicinae.resmedlib.term.String(((Vector) v.elementAt(0)).elementAt(0).toString()));
        } catch(Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * Handles all mouseClicked events of the whole application.
     * @param event the mouse clicked event
     */
    public void mouseClicked
            (MouseEvent
            event) {
        System.out.println("Clicked");
        if (event.getClickCount() == 2) {
            try {
                setSelectedHealthRecordId();
                selectAnotherHealthRecord();
//                setSelectedHealthRecordId();
            } catch(Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public String generateModuleID() throws Exception {
        try {
            return getName() + "////" + ObjectID.getNewOId().getValue();
        } catch(Exception e) {
            throw new Exception(e);
        }

    }
}
