/*
 * $RCSfile: ReForm.java,v $
 *
 * Copyright (c) 1999-2002. Christian Heller. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.application.healthcare.reform;

import org.resmedicinae.application.healthcare.reform.application.common.basic.*;
import org.resmedicinae.application.healthcare.reform.formular.*;
import org.resmedicinae.application.healthcare.reform.formular.script.*;
import org.resmedicinae.application.healthcare.reform.gui.*;
import org.resmedicinae.application.healthcare.reform.printer.*;
import org.resmedicinae.application.healthcare.reform.system.server.rmi.*;
import org.resmedicinae.application.healthcare.reform.region.*;
import org.resmedicinae.domain.healthcare.*;
import org.resmedicinae.resmedlib.component.control.*;
import org.resmedicinae.resmedlib.component.view.*;
import org.resmedicinae.resmedlib.component.view.swing.*;

import javax.swing.*;
import javax.swing.event.*;
import java.awt.event.*;
import java.rmi.*;
import java.net.*;
import java.util.*;

/**
 * This class represents the reform controller.
 * @version $Revision: 1.22 $ $Date: 2003/01/16 10:42:41 $ $Author: tristan24 $
 * @author Torsten Kunze <zone3@gmx.de>
 */
public class ReForm extends AdvancedBasicApplication {
    /* Menu File */

    static final String PRINT_CONTROL_ID = "Print";
    static final String PRINT_SETUP_CONTROL_ID = "Print Setup...";
    static final String EXIT_ID = "Exit";

    /* Menu Formular */

    static final String SCRIPT_FORMULAR_CONTROL_ID = "Script";

    /* Menu Help */

    static final String ABOUT_CONTROL_ID = "About";
    static final String HELP_CONTROL_ID = "Help   F1";
    //
    // Name.
    //


    /**
     * Returns the name.
     * @return the name
     */
    public String getName() {
        return "ReForm";
    }
    //
    // Version.
    //

    /**
     * Returns the version. (major).(minor).(<99 = preX, 99 = final).(bug fix)
     * @return the version
     */
    public String getVersion() {
        return "Unspecified Version";
    }
    //
    // Date.
    //

    /**
     * Returns the release date.
     * @return the release date
     */
    public String getDate() {
        return "Unspecified Date";
    }
    //
    // Logo.
    //

    /**
     * Returns the logo.
     * @return the logo
     */
    public String getLogo() {
        return "Unspecified logo";
    }
    //
    // Copyright.
    //

    /**
     * Returns the copyright.
     * @return the copyright
     */
    public String getCopyright() {
        return "Copyright (c) 1999-2002. The Res Medicinae Developers. All rights reserved.";
    }
    //
    // Contact.
    //

    /**
     * Returns the contact.
     * @return the contact
     */
    public String getContact() {
        return "http://www.resmedicinae.org";
    }
    //
    // Authors.
    //

    /**
     * Returns the authors.
     * @return the authors
     */
    public String getAuthors() {
        return "Torsten Kunze\n<zone3@gmx.net>";
    }
    //
    // Helpers.
    //

    /**
     * Returns the helpers.
     * @return the helpers
     */
    public String getHelpers() {
        return "Unspecified Helpers.\n" + "Try to contact these project administrators:\n\n" +
                "Christian Heller\n<christian.heller@tuxtax.de>\n\n" + "Karsten Hilbert\n<karsten.hilbert@gmx.net>";
    }
    //
    // Inspirations.
    //

    /**
     * Returns the inspirations.
     * @return the inspirations
     */
    public String getInspirations() {
        return "Unspecified Inspirations";
    }
    //
    // License.
    //

    /**
     * Returns the license.
     * @return the license
     */
    public String getLicense() {
        return "This software is published under the GPL GNU General Public License.\n" +
                "This program is free software; you can redistribute it and/or\n" +
                "modify it under the terms of the GNU General Public License\n" +
                "as published by the Free Software Foundation; either version 2\n" +
                "of the License, or (at your option) any later version.\n\n" +
                "This program is distributed in the hope that it will be useful,\n" +
                "but WITHOUT ANY WARRANTY; without even the implied warranty of\n" +
                "MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the\n" +
                "GNU General Public License for more details.\n\n" + "You should have received a copy of the GNU General Public License\n" +
                "along with this program; if not, write to the Free Software\n" +
                "Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.\n\n" +
                "Find the GPL license and more information at: http://www.gnu.org";
    }

    /** Constructs the Printer application controller and its corresponding model and view. */
    public ReForm() {
        super();
        try {
            // Set model and view.
            System.out.println("Caution! Commented out line 'setModelAndView()' -------------------------------");
            //??            setModelAndView(m, v);
            //    generalHintDialog = new GeneralHintDialog(getGeneralHintDialogFrame(),"Hello@all!");
        } catch (Exception e) {
            new GeneralHintDialog(new JFrame(), "Construction failed:\n" + e);
            System.out.println("Construction failed:\n" + e);
            e.printStackTrace();
        }
    }

    /**
     * Creates the model.
     * @return the model
     */
    public Object createModel() throws Exception {
        ReFormModel m = new ReFormModel();
        if (m != null) {
            // m.setController(this);
            //  m.configure(new Configuration());      // nur fr den Logger ntig
            m.initialize();

            setModel(m);
        } else {
            throw new NullPointerException("Could not create model. The model is null.");
        }
        return m;
    }

    /**
     * Creates a view.
     * @return the view
     * @exception NullPointerException if the view is null
     */
    public View createView() throws Exception {
        ReFormView v = new ReFormView();
        if (v != null) {
            v.setController(this);
            v.configure(getConfigurationManager());
            v.initialize();
        } else {
            throw new NullPointerException("Could not create view. The view is null.");
        }
        return v;
    }

    /** Initializes this application controller. */
    public void initialize() throws Exception {
        super.initialize(generateModuleID());


/*
           ExtensibleMarkupLanguageAssembler extendedMarkupLanguageModelAssembler = createExtendedMarkupLanguageModelAssembler();
           extendedMarkupLanguageModelAssembler.setModel((ReFormModel)getModel());
           extendedMarkupLanguageModelAssembler.initialize();
           addSpecialAssemblerToList(extendedMarkupLanguageModelAssembler, ExtensibleMarkupLanguageAssembler.ASSEMBLER_KEY);
           setSpecialAssemblerKey(ExtensibleMarkupLanguageAssembler.ASSEMBLER_KEY);
        */
    }

    /** Finalizes this application controller. */
    public void finalize() throws Exception {
        try {
            super.finalize();

        } catch (Throwable t) {
            throw new Exception(t.toString());
        }
    }

    /**
     * This method is called if an other healthRecord was selected in the "Chose healthRecord"-menu of HealthRecordManager.
     * It udates der already loaded HealthRecords LoadedHealthRecords and advises the @see ChangeHealthRecordData object
     * that another healthRecord was selected.
     */
    public void setUpdateChangeHealthRecord() {
        super.setUpdateChangeHealthRecord();
        if (((ReFormModel) getModel()).getActualFormularController() != null)
            ((FormularModel) ((ReFormModel) getModel()).getActualFormularController().getModel()).setCurrentHealthRecord(((ReFormModel)
                    getModel()).getCurrentHealthRecord());
    }

    public void setUpdateAfterRemovingHealthRecord(org.resmedicinae.resmedlib.term.String healthRecordId) {
        super.setUpdateAfterRemovingHealthRecord(healthRecordId);
        if (((ReFormModel) getModel()).getActualFormularController() != null) {
            if (getChangeHealthRecordData() != null) {
                if (((ReFormModel) getModel()).getCurrentHealthRecord() != null) {
                    if (healthRecordId.getValue().compareTo(((ReFormModel)
                            getModel()).getCurrentHealthRecord().getIdentifier().getValue()) == 0) {
                        ((FormularModel) ((ReFormModel) getModel()).getActualFormularController().getModel()).setCurrentHealthRecord(((ReFormModel)
                                getModel()).getCurrentHealthRecord());
                    }
                } else
                    ((FormularModel) ((ReFormModel) getModel()).getActualFormularController().getModel()).setCurrentHealthRecord(((ReFormModel)
                            getModel()).getCurrentHealthRecord());
            }
        }
    }

    /**
     * Handles control events and calls the corresponding methods.
     * @param c the control
     * @exception NullPointerException if the control is null
     */
    protected void handle(Control c) throws Exception, NullPointerException {
        super.handle(c);
        if (c != null) {
            ReFormModel model = (ReFormModel) getModel();

            /** Menu File ************************************** */
            if (c.matches(ReForm.PRINT_CONTROL_ID)) {
                //        new PrinterTest();
                //    AbstractApplicationController ac = model.getFormularController();
                String jobName = "Empty Script";
                if ((model.getCurrentHealthRecord().getFirstName() != null) ||
                        (model.getCurrentHealthRecord().getName() != null)) {
                    jobName = "Script for ";
                    if (model.getCurrentHealthRecord().getFirstName() != null)
                        jobName += model.getCurrentHealthRecord().getFirstName() + " ";
                    if (model.getCurrentHealthRecord().getName() != null)
                        jobName += model.getCurrentHealthRecord().getName();
                }
                PrintSuit.printComponent((SwingView) model.getActualFormularController().getView(), jobName, false);
                //    PrintSuit.printComponent(model.getGraphicToPrint(),ac.getName());
            } else if (c.matches(ReForm.PRINT_SETUP_CONTROL_ID)) {
                try {
                    // Get a PrinterJob
                    //    AbstractApplicationController ac = model.getFormularController();
                    String jobName = "Empty Script";
                    if ((model.getCurrentHealthRecord().getFirstName() != null) ||
                            (model.getCurrentHealthRecord().getName() != null)) {
                        jobName = "Script for ";
                        if (model.getCurrentHealthRecord().getFirstName() != null)
                            jobName += model.getCurrentHealthRecord().getFirstName() + " ";
                        if (model.getCurrentHealthRecord().getName() != null)
                            jobName += model.getCurrentHealthRecord().getName();
                    }
                    PrintSuit.askBeforePrintComponent((SwingView) model.getActualFormularController().getView(),
                            "Script for " + jobName, false);
                    //    PrintSuit.askBeforePrintComponent(model.getGraphicToPrint(),ac.getName());
                } catch (Exception e) {
                    //                    getLogger().log(Level.SEVERE, "Could not dispose application.", e);
                }
            } else if (c.matches(ReForm.EXIT_ID)) {
                /* *something to close or shut down* */

                super.exit();
            }

            /** Menu Formular ********************************* */
            else if (c.matches(ReForm.SCRIPT_FORMULAR_CONTROL_ID)) {
                try {
                    System.out.println("Script should be shown now!");
                    Script sc = new Script();
                    sc.setConfigurationManager(getConfigurationManager());
                    sc.initialize();
                    if (model.getCurrentHealthRecord() == null)
                        model.setCurrentHealthRecord(new HealthRecord());
                    ((ScriptModel) sc.getModel()).setCurrentHealthRecord(model.getCurrentHealthRecord());
                    model.setActualFormularController(sc);
                    show(sc.getView());
                } catch (Exception e) {
                    //                  getLogger().log(Level.SEVERE, "Could not create an application.", e);
                }
            } else if (c.matches(Script.DESTROY_SCRIPT_FORMULAR_CONTROL_ID)) {
                try {
                    Script sc = (Script) ((ReFormModel) getModel()).getActualFormularController();
                    hide(sc.getView());
                } catch (Exception e) {
                    //                  getLogger().log(Level.SEVERE, "Could not create an application.", e);
                }
            }

            /** Menu Help ************************************* */
            else if (c.matches(ReForm.ABOUT_CONTROL_ID)) {
                try {
                } catch (Exception e) {
                    //                    getLogger().log(Level.SEVERE, "Could not dispose application.", e);
                }
            } else if (c.matches(ReForm.HELP_CONTROL_ID)) {
                try {
                } catch (Exception e) {
                    //                    getLogger().log(Level.SEVERE, "Could not dispose application.", e);
                }
            }
        } else {
            throw new NullPointerException("Could not handle control. Control is null.");
        }
    }

    /**
     * Handles all action events of the whole application.
     * @param e the action event
     */
    public void actionPerformed(ActionEvent e) {
        if (e != null) {
            Control c = new Control();
            c.setId(e.getActionCommand());
            try {
                handle(c);
            } catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            throw new NullPointerException("Could not handle action event. Action event is null.");
        }
    }

    /**
     * Handles all item events of the whole application.
     * @param e the item event
     */
    public void itemStateChanged(ItemEvent e) {
    }

    /**
     * Handles all keyPressed events of the whole application.
     * @param k the key pressed event
     */
    public void keyPressed(KeyEvent k) {
    }

    /**
     * Handles all keyTyped events of the whole application.
     * @param k the key typed event
     */
    public void keyTyped(KeyEvent k) {
    }

    /**
     * Handles all keyReleased events of the whole application.
     * @param k the key released event
     */
    public void keyReleased(KeyEvent k) {
    }

    /**
     * Handles all mouseClicked events of the whole application.
     * @param event the mouse clicked event
     */
    public void mouseClicked(MouseEvent event) {
        super.mouseClicked(event);
    }

    /** Not implemented */
    public void mouseEntered(MouseEvent e) {
    }

    /** Not implemented */
    public void mouseExited(MouseEvent e) {
    }

    /** Not implemented */
    public void mouseReleased(MouseEvent e) {
    }

    /** Not implemented */
    public void mousePressed(MouseEvent e) {
    }

    /** Not implemented */
    public void mouseDragged(MouseEvent e) {
    }

    /** Not implemented */
    public void mouseMoved(MouseEvent e) {
    }

    /**
     * Here are all valueChanged events of the whole application handled. These are events from tables, or lists.
     * Actual healthRecord ID changes, HealthRecordManager.setSelectedHealthRecordId() is called.
     */
    public void valueChanged(ListSelectionEvent event) {
        super.valueChanged(event);
    }

    /** Here are all windowClosing events of the whole application handled. */
    public void windowClosing(WindowEvent event) {
    }

    /**
     * Listener for HealthRecordManager<br> Manages the actions of JTextFields.
     * @see DocumentListener
     * @param event DocumentEvent
     */
    public void changedUpdate(DocumentEvent event) {
        super.changedUpdate(event);
    }

    /**
     * Evaluates the event if something was inserted into the text area
     * @param event DocumentEvent
     */
    public void insertUpdate(DocumentEvent event) {
        super.insertUpdate(event);
    }

    /**
     * Evaluates the event if something was removed from the text area
     * @param event DocumentEvent
     */
    public void removeUpdate(DocumentEvent event) {
        super.removeUpdate(event);
    }
}
