/*
 * $RCSfile: TreeTableModel.java,v $
 *
 * Copyright (c) 1999-2002. Jens Bohl. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.application.healthcare.record.treetable;

import javax.swing.tree.*;

/**
 * This interface defines a TreeTable model based on a TreeModel
 * @author Jens Bohl <info@jens-bohl-professional.de>
 */
public interface TreeTableModel extends TreeModel {
    /** Returns the number ofs availible column. */
    public int getColumnCount();

    /** Returns the name for column number <code>column</code>. */
    public String getColumnName(int column);

    /** Returns the type for column number <code>column</code>. */
    public Class getColumnClass(int column);

    /** Returns the value to be displayed for node <code>node</code>, at column number <code>column</code>. */
    public Object getValueAt(Object node, int column);

    /** Indicates whether the the value for node <code>node</code>, at column number <code>column</code> is editable. */
    public boolean isCellEditable(Object node, int column);

    /** Sets the value for node <code>node</code>, at column number <code>column</code>. */
    public void setValueAt(Object aValue, Object node, int column);
}
