/*
 * $RCSfile: TreeIconCellRenderer.java,v $
 *
 * Copyright (c) 1999-2002. Jens Bohl. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.application.healthcare.record.treetable;

import org.resmedicinae.application.healthcare.record.*;
import org.resmedicinae.application.healthcare.record.topology.Disease;
import org.resmedicinae.application.healthcare.record.topology.Overlay;
import org.resmedicinae.domain.healthcare.*;
import org.resmedicinae.domain.healthcare.heading.problem.*;
import org.resmedicinae.domain.healthcare.unit.*;

import javax.swing.*;
import javax.swing.tree.*;
import java.awt.*;

/** This class represents a cell renderer for tree icons. Tree icons replace standard swing icons.
 * @author Jens Bohl <info@jens-bohl-professional.de>
 *
 */
public class TreeIconCellRenderer extends DefaultTreeCellRenderer {
    /**Default constructor*/
    public TreeIconCellRenderer() {
    }

    /**Gets the Cell tree renderer. Has to overriden.
     * @param tree the tree
     * @param value the node value
     * @param sel indicates whether the node is selected
     * @param expanded indicates whether the tree is expanded
     * @param leaf indicates whether the node is a leaf
     * @param row the row of the node
     * @param hasFocus indicates whether the node has the focus
     *
     * @return the renderer component
     * */
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf,
                                                  int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        if (value.getClass() == Overlay.class) {
            Overlay overlay = (Overlay)value;
            ImageIcon icon;
            if(overlay.isAlternative()){
                icon = new ImageIcon(RecordModel.RelativeIconDirectoryName + "altTreeIcon.gif");
                setForeground(Color.GRAY);
            }else{
                icon = new ImageIcon(RecordModel.RelativeIconDirectoryName + "regionTreeIcon.gif");
                setForeground(Color.BLACK);
            }
            setIcon(icon);
        }else if (value.getClass() == Disease.class) {
            ImageIcon objIcon = new ImageIcon(RecordModel.RelativeIconDirectoryName + "objectiveTreeIcon.gif");
            setIcon(objIcon);
            setForeground(Color.RED);
        }
        return (Component) this;
    }
}
