/*
 * $RCSfile: XMLFileNameFilter.java,v $
 *
 * Copyright (c) 1999-2002. Jens Bohl. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.application.healthcare.record.topology;

import java.io.*;

/**
 * This class represents a file filter. Only files with extension .xml are accepted.
 * @author Jens Bohl <info@jens-bohl-professional.de>
 **/

public class XMLFileNameFilter implements FilenameFilter {
    /**
     *Method for accepting XML files
     * @param dir the directory the file is in
     * @param fileName the file name
     * @return true if the file is a xml file, false if not
     */
    public boolean accept(File dir, String fileName) {
        if (fileName.endsWith(".xml")) {
            return true;
        }
        return false;
    }
}
