/*
 * $RCSfile: TopologyTextArea.java,v $
 *
 * Copyright (c) 1999-2002. Jens Bohl. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.application.healthcare.record.topology;

import org.resmedicinae.application.healthcare.record.*;

import javax.swing.*;
import java.awt.*;

/** This class represents a special Text Area. Basically, the font and color properties are changed.
 * @author Jens Bohl <info@jens-bohl-professional.de>
 * */
public class TopologyTextArea extends JTextArea {
    /**
     *The constructor
     * @param preferredSize the preferred size of the text area
     */
    public TopologyTextArea(Dimension preferredSize) {
        super();
        setPreferredSize(preferredSize);
        initialize();
    }

    /** Initialization of the text area */
    public void initialize() {
        setFont(new Font("title", Font.BOLD, 12));
        setEditable(true);
        setEnabled(true);
        setLineWrap(true);
        setWrapStyleWord(true);
        setBackground(RecordModel.BackgroundColor);
    }
}
