/*
 * $RCSfile: PreviewPanel.java,v $
 *
 * Copyright (c) 1999-2002. Jens Bohl. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.application.healthcare.record.topology;

import org.resmedicinae.application.healthcare.record.*;

import javax.swing.*;
import java.awt.*;

/** View component. This panel shows a preview of the target image.
 * @author Jens Bohl <info@jens-bohl-professional.de>
 * */
public class PreviewPanel extends RecordPanel {
    /** Preview of the target image */
    private Image image;
    /** The toolkit needed */
    private Toolkit kit;
    /** Default Constructor. */
    public PreviewPanel() {
        super();
        //default size
        setPreferredSize(new Dimension(150, 150));
    }

    /**Constructor. */
    public PreviewPanel(Dimension preferredSize) {
        super();

        setPreferredSize(preferredSize);
    }

    /** Initialization of components. */
    public void initialize() {
        setBorder(BorderFactory.createTitledBorder("Preview"));
        setToolTipText("Target Image");
        kit = Toolkit.getDefaultToolkit();
        setImage(kit.getImage("bilder/empty.jpg"));
    }

    /**
     *Overriden method to paint the preview image
     * @param g the graphics context
     */
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D) g;

        /*needed because getPreferredSize returns double....needed is int*/

        Double height = new Double(getPreferredSize().getHeight());
        Double width = new Double(getPreferredSize().getHeight());
        if (getImage() != null) {
            /*Drawing the image aligned to the containing panel*/

            g2d.drawImage(getImage(), 7, 15, width.intValue() - 15, height.intValue() - 20, this);
        }
    }

    /** Method for updating the panel */
    public void updateGraphics() {
        update(getGraphics());
    }

    /**
     *Sets the preview image
     * @param image the preview image
     */
    public void setImage(Image image) {
        this.image = image;
    }

    /**
     *Gets the preview image
     * @return the preview image
     */
    public Image getImage() {
        return this.image;
    }

    /**
     *Get the toolKit
     * @return the tool kit
     */
    public Toolkit getKit() {
        return kit;
    }

    /**
     *Sets the toolKit
     * @param kit the tool kit
     */
    public void setKit(Toolkit kit) {
        this.kit = kit;
    }
}
