/*
 * $RCSfile: OverlayRegion.java,v $
 *
 * Copyright (c) 1999-2002. Jens Bohl. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.application.healthcare.record.topology;

import org.resmedicinae.application.healthcare.record.*;

import java.awt.*;

/** This class represents a sensible region of an image. Overlays constist of overlay regions. By clicking on those
 * regions a new overlay (corresponding overlay!!!)shows up and will be loaded.
 * @author Jens Bohl <info@jens-bohl-professional.de>
 * */
public class OverlayRegion extends Polygon {
    /** Indicates whether the overlayRegion is already painted */
    private boolean painted;
    /** The name of overlayRegion */
    private String name;
    /** The target of overlayRegion. The name of the overlay.*/
    private String target;
    /** The numberc of this overlayRegion within the overlay */
    private String number = null;
    /** The top neighbour */
    private String topNeighbour;
    /** The bottom neighbour */
    private String bottomNeighbour;
    /** The right neighbour */
    private String rightNeighbour;
    /** The left neighbour */
    private String leftNeighbour;
    /** The model of MVC */
    private RecordModel model;

    /** Default constructor */
    public OverlayRegion() {
    }

    /** The constructor. Initializes a overlayRegion with the specific values.
     * @param x array of x coordinates of the regiom
     * @param y array of y coordinates of the regiom
     * @param size number of points
     * */
    public OverlayRegion(int[] x, int[] y, int size) {
        super(x, y, size);
    }

    /** Sets the model
     * @param recordModel the model of the MVC
     * */
    public void setModel(RecordModel recordModel) {
        this.model = recordModel;
    }

    /** Gets the model
     * @returnthe model of the MVC
     * */
    public RecordModel getModel() {
        return this.model;
    }

    /** Sets the overlayRegion as painted - or not painted
     * @param painted indicates whether the overlayRegion is painted or not
     * */
    public void setPainted(boolean painted) {
        this.painted = painted;
    }

    /** Tests whether the overlayRegion is painted or not.
     * @return true if painted, false if not
     * */
    public boolean isPainted() {
        return this.painted;
    }

    /** Sets the name of the overlayRegion.
     * @param name the name of the region
     * */
    public void setName(String name) {
        this.name = name;
    }

    /** Gets the name of the overlayRegion.
     * @return the name of the region
     * */
    public String getName() {
        return this.name;
    }

    /** Sets the name of the target of the overlayRegion.
     * @param target the name arget of the region
     * */
    public void setTarget(String target) {
        this.target = target;
    }

    /** Gets the name of the target of the overlayRegion.
     * @return the name of the target
     *  */
    public String getTarget() {
        return this.target;
    }

    /**
     *Gets the number of the overlayRegion.
     * @return the number of the overlayRegion
     */
    public String getNumber() {
        return this.number;
    }

    /**
     *Sets the number of the overlayRegion.
     * @param number the number of the overlayRegion
     */
    public void setNumber(String number) {
        this.number = number;
    }

    /**
     *Gets the top neighbour of the overlayRegion.
     * @return the topNeighbour of the overlayRegion
     */
    public String getTopNeighbour() {
        return topNeighbour;
    }

    /**
     *Sets the top neighbour of the overlayRegion.
     * @param topNeighbour the top neighbour of the overlayRegion
     */
    public void setTopNeighbour(String topNeighbour) {
        this.topNeighbour = topNeighbour;
    }

    /**
     *Gets the bottom neighbour of the overlayRegion.
     * @return bottomNeighbour the bottom neighbour of the overlayRegion
     */
    public String getBottomNeighbour() {
        return bottomNeighbour;
    }

    /**
     *Sets the bottom neighbour of the overlayRegion.
     * @param bottomNeighbour the bottom neighbour of the overlayRegion
     */
    public void setBottomNeighbour(String bottomNeighbour) {
        this.bottomNeighbour = bottomNeighbour;
    }

    /**
     *Gets the right neighbour of the overlayRegion.
     * @return rightNeighbour the right neighbour of the overlayRegion
     */
    public String getRightNeighbour() {
        return rightNeighbour;
    }

    /**
     *Sets the right neighbour of the overlayRegion.
     * @param rightNeighbour the right neighbour of the overlayRegion
     */
    public void setRightNeighbour(String rightNeighbour) {
        this.rightNeighbour = rightNeighbour;
    }

    /**
     *Gets the left neighbour of the overlayRegion.
     * @return the left neighbour of the overlayRegion
     */
    public String getLeftNeighbour() {
        return leftNeighbour;
    }

    /**
     *Sets the left neighbour of the overlayRegion.
     * @param leftNeighbour the left neighbour of the overlayRegion
     */
    public void setLeftNeighbour(String leftNeighbour) {
        this.leftNeighbour = leftNeighbour;
    }
}
