/*
 * $RCSfile: MakeReportOnOverlayDialog.java,v $
 *
 * Copyright (c) 1999-2002. Jens Bohl. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.application.healthcare.record.topology;

import org.resmedicinae.application.healthcare.record.*;
import org.resmedicinae.resmedlib.component.view.swing.*;

import javax.swing.*;
import java.awt.*;

/**
 *This dialog is for creating a report with the help of topological reporting. After pressing F4 this dialog shows up
 * and the user can make e report on the current region.
 * @author Jens Bohl <info@jens-bohl-professional.de>
 */
public class MakeReportOnOverlayDialog extends SwingView {
    /** Layout Manager of this dialog */
    private GridBagLayout gridbag;
    /** Textarea for report */
    private TopologyTextArea reportTextArea;
    /** ScrollPane for the report text area */
    private TopologyScrollPane reportTextAreaScrollPane;
    /** Ok button */
    private JButton okButton;
    /** Cancel button */
    private JButton cancelButton;

    /**
     * Creates a rectangle storing the dialog bounds.
     * @return the rectangle storing the dialog bounds
     */
    public Rectangle createDialogBounds() {
        // Determine width.
        int screenWidth = (int) Math.floor(Toolkit.getDefaultToolkit().getScreenSize().getWidth());
        int w = 350;
        if (w > screenWidth) {
            w = screenWidth;
        }
        // Use centered x position by default.
        int x = (screenWidth - w) / 2;
        // Determine height.
        int screenHeight = (int) Math.floor(Toolkit.getDefaultToolkit().getScreenSize().getHeight());
        int h = 400;
        if (h > screenHeight) {
            h = screenHeight;
        }
        // Use centered y position by default.
        int y = (screenHeight - h) / 2;
        return new Rectangle(x, y, w, h);
    }
    //
    // Display mode.
    //

    /**
     * Creates a display mode.
     * @return the display mode
     */
    public int createDisplayMode() {
        return DisplayFactory.MODELESS_DIALOG_DISPLAY;
    }

    /** Initialization of components */
    public void initialize() {
        gridbag = new GridBagLayout();
        setLayout(gridbag);
        GridBagConstraints c = new GridBagConstraints();
        setDisplayMode(DisplayFactory.MODELESS_DIALOG_DISPLAY);
        setDialogBounds(createDialogBounds());
        setTitle("New objective...");

        setReportTextArea(createReportTextArea());
        setReportTextAreaScrollPane(createReportTextAreaScrollPane());
        setOkButton(createOkButton());
        setCancelButton(createCancelButton());

        c.anchor = GridBagConstraints.EAST;
        c.insets = new Insets(10, 10, 2, 10);
        c.gridwidth = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.fill = GridBagConstraints.HORIZONTAL;
        gridbag.setConstraints(getReportTextAreaScrollPane(), c);
        add(getReportTextAreaScrollPane());

        c.anchor = GridBagConstraints.EAST;
        c.insets = new Insets(10, 10, 2, 10);
        c.gridwidth = 1;
        c.gridx = 1;
        c.gridy = 1;
        gridbag.setConstraints(getCancelButton(), c);
        add(getCancelButton());

        c.anchor = GridBagConstraints.WEST;
        c.insets = new Insets(10, 10, 2, 10);
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 1;
        gridbag.setConstraints(getOkButton(), c);
        add(getOkButton());
    }

    /**Gets the layoutManager
     * @return the layoutManager
     */
    public GridBagLayout getGridbag() {
        return gridbag;
    }

    /**Sets the layoutManager
     * @param layoutManager the layoutManager
     */
    public void setGridbag(GridBagLayout gridbag) {
        this.gridbag = gridbag;
    }

    /**Creates the reportTextArea
     * @return the reportTextArea
     */
    public TopologyTextArea createReportTextArea() {
        return new TopologyTextArea(new Dimension(300, 300));
    }

    /**Gets the reportTextArea
     * @return the reportTextArea
     */
    public TopologyTextArea getReportTextArea() {
        return reportTextArea;
    }

    /**Sets the reportTextArea
     * @param reportTextArea the reportTextArea
     */
    public void setReportTextArea(TopologyTextArea reportTextArea) {
        this.reportTextArea = reportTextArea;
    }

    /**Creates the reportTextAreaScrollPane
     * @return the reportTextAreaScrollPane
     */
    public TopologyScrollPane createReportTextAreaScrollPane(){
        return new TopologyScrollPane(getReportTextArea(), "Objective");
    }

    /**Gets the reportTextAreaScrollPane
     * @return the reportTextAreaScrollPane
     */
    public TopologyScrollPane getReportTextAreaScrollPane() {
        return reportTextAreaScrollPane;
    }

    /**Sets the reportTextAreaScrollPane
     * @param reportTextAreaScrollPane the reportTextAreaScrollPane
     */
    public void setReportTextAreaScrollPane(TopologyScrollPane reportTextAreaScrollPane) {
        this.reportTextAreaScrollPane = reportTextAreaScrollPane;
    }

    /**Creates the okButton
     * @return the okButton
     */
    public JButton createOkButton(){
        JButton b = new JButton("Ok");
        b.setToolTipText("Create new objective");
        b.addActionListener((Record) getController());
        b.setActionCommand(Record.MAKE_REPORT_ON_OVERLAY_OK_ID);
        return b;
    }

    /**Gets the okButton
     * @return the okButton
     */
    public JButton getOkButton() {
        return okButton;
    }

    /**Sets the okButton
     * @param okButton the okButton
     */
    public void setOkButton(JButton okButton) {
        this.okButton = okButton;
    }

    /**Creates the cancelButton
     * @return the cancelButton
     */
    public JButton createCancelButton(){
        JButton b = new JButton("Cancel");
        b.setToolTipText("Cancel");
        b.addActionListener((Record) getController());
        b.setActionCommand(Record.MAKE_REPORT_ON_OVERLAY_CANCEL_ID);
        return b;
    }

    /**Gets the cancelButton
     * @return the cancelButton
     */
    public JButton getCancelButton() {
        return cancelButton;
    }

    /**Sets the cancelButton
     * @param cancelButton the cancelButton
     */
    public void setCancelButton(JButton cancelButton) {
        this.cancelButton = cancelButton;
    }
}
