/*
 * $RCSfile: MakeProblemDialog.java,v $
 *
 * Copyright (c) 1999-2002. Jens Bohl. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.application.healthcare.record.topology;

import org.resmedicinae.application.healthcare.record.*;
import org.resmedicinae.resmedlib.component.control.*;
import org.resmedicinae.resmedlib.component.view.swing.*;

import javax.swing.ImageIcon;
import javax.swing.*;
import java.awt.*;

/** View Component. This dialog is for creating a new problem. Here the problemName and problemDescription can be defined.
 * @author Jens Bohl <info@jens-bohl-professional.de>
 * */
public class MakeProblemDialog extends SwingView {
    /** The Layout Manager */
    private GridBagLayout gridbag;
    /** Name textField of problem */
    private JTextField nameTextField;
    /**Name label*/
    private TopologyLabel nameLabel;
    /** Anamnese textField of problem */
    private TopologyTextArea anamneseTextArea;
    /** ScrollPane for anamenseTextArea*/
    private TopologyScrollPane anamneseTextAreaScrollPane;
    /**The okButton*/
    private JButton okButton;
    /**The clearButton*/
    private JButton clearButton;
    /**The cancelButton*/
    private JButton cancelButton;
    /**The model of MVC*/
    private RecordModel model;

    /**Default constructor*/
    public MakeProblemDialog() {
    }

    /** Initialization of components */
    public void initialize() {
        setTitle("Create Problem...");
        gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        setLayout(gridbag);
        c = new GridBagConstraints();
        setDisplayMode(DisplayFactory.MODELESS_DIALOG_DISPLAY);
        setDialogBounds(createDialogBounds());

        setNameLabel(createNameLabel());
        setNameTextField(createNameTextField());
        setAnamneseTextArea(createAnamneseTextArea());
        setAnamneseTextAreaScrollPane(createAnamneseTextAreaScrollPane());
        setOkButton(createOkButton());
        setCancelButton(createCancelButton());
        setClearButton(createClearButton());

        c.fill = GridBagConstraints.HORIZONTAL;
        c.anchor = GridBagConstraints.EAST;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(0, 7, 0, 0);
        gridbag.setConstraints(getNameLabel(), c);
        add(getNameLabel());

        c.anchor = GridBagConstraints.EAST;
        c.insets = new Insets(0, 0, 0, 0);
        c.gridx = 1;
        c.gridy = 0;
        gridbag.setConstraints(getNameTextField(), c);
        add(getNameTextField());

        c.anchor = GridBagConstraints.EAST;
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 3;
        gridbag.setConstraints(getAnamneseTextAreaScrollPane(), c);
        add(getAnamneseTextAreaScrollPane());

        c.anchor = GridBagConstraints.EAST;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 2;
        gridbag.setConstraints(getOkButton(), c);
        add(getOkButton());

        c.anchor = GridBagConstraints.CENTER;
        c.gridx = 1;
        c.gridy = 2;
        gridbag.setConstraints(getClearButton(), c);
        add(getClearButton());

        c.anchor = GridBagConstraints.EAST;
        c.gridx = 2;
        c.gridy = 2;
        gridbag.setConstraints(getCancelButton(), c);
        add(getCancelButton());
    }


    /**
     * Creates a rectangle storing the dialog bounds.
     * @return the rectangle storing the dialog bounds
     */
    public Rectangle createDialogBounds() {
        // Determine width.
        int screenWidth = (int) Math.floor(Toolkit.getDefaultToolkit().getScreenSize().getWidth());
        int w = 300;
        if (w > screenWidth) {
            w = screenWidth;
        }
        // Use centered x position by default.
        int x = (screenWidth - w) / 2;
        // Determine height.
        int screenHeight = (int) Math.floor(Toolkit.getDefaultToolkit().getScreenSize().getHeight());
        int h = 320;
        if (h > screenHeight) {
            h = screenHeight;
        }
        // Use centered y position by default.
        int y = (screenHeight - h) / 2;
        return new Rectangle(x, y, w, h);
    }

    /**
     * Creates a display mode.
     * @return the display mode
     */
    public int createDisplayMode() {
        return DisplayFactory.MODELESS_DIALOG_DISPLAY;
    }

    /**
     * Creates a control issued when the window containing this view is closed.
     * @return the control issued when the window containing this view is closed
     * @exception NullPointerException if the control is null
     */
    public Control createCloseControl() throws NullPointerException {
        Control c = new Control();
        if (c != null) {
            c.setId(Record.DESTROY_LOAD_PATIENT_DIALOG_CONTROL_ID);
            c.setSender((Controller) getController());
        } else {
            throw new NullPointerException("Could not create close control. The control is null.");
        }
        return c;
    }

    /** Finalizes this component. */
    public void finalizz() throws Exception {
        try {
            // Set parameters.
            setBorder(null);
        } finally {
            super.finalizz();
        }
    }

    /** Clears all text fields in the frame. Sets an empty string. */
    public void clearAllTextFields() {
        nameTextField.setText("");
        anamneseTextArea.setText("");
    }

    /**Gets the layoutManager
     * @return the layoutManager
     * */
    public GridBagLayout getGridbag() {
        return gridbag;
    }

    /**Sets the layoutManager
     * @param gridbag the layoutManager
     * */
    public void setGridbag(GridBagLayout gridbag) {
        this.gridbag = gridbag;
    }

    /**Creates the nameTextField
     * @return the nameTextField
     * */
    public JTextField createNameTextField(){
        JTextField nameTextField = new JTextField(15);
        nameTextField.setEditable(true);
        nameTextField.setEnabled(true);
        nameTextField.addActionListener((Record) getController());
        nameTextField.setActionCommand(Record.MAKE_PROBLEM_DIALOG_OK_ID);
        return nameTextField;
    }

    /**Gets the nameTextField
     * @return the nameTextField
     * */
    public JTextField getNameTextField() {
        return nameTextField;
    }

    /**Sets the nameTextField
     * @param nameTextField the nameTextField
     * */
    public void setNameTextField(JTextField nameTextField) {
        this.nameTextField = nameTextField;
    }

    /**Creates the anamneseTextArea
     * @return the anamneseTextArea
     * */
    public TopologyTextArea createAnamneseTextArea(){
        return new TopologyTextArea(new Dimension(240, 240));
    }

    /**Gets the anamneseTextArea
     * @return the anamneseTextArea
     * */
    public TopologyTextArea getAnamneseTextArea() {
        return anamneseTextArea;
    }

    /**Sets the anamneseTextArea
     * @param anamneseTextArea the anamneseTextArea
     * */
    public void setAnamneseTextArea(TopologyTextArea anamneseTextArea) {
        this.anamneseTextArea = anamneseTextArea;
    }

    /**Creates the nameLabel
     * @return the nameLabel
     * */
    public TopologyLabel createNameLabel(){
        TopologyLabel nameLabel = new TopologyLabel(false);
        nameLabel.setText("Name");
        return nameLabel;
    }

    /**Gets the nameLabel
     * @return the nameLabel
     * */
    public TopologyLabel getNameLabel() {
        return nameLabel;
    }

    /**Sets the nameLabel
     * @param nameLabel the nameLabel
     * */
    public void setNameLabel(TopologyLabel nameLabel) {
        this.nameLabel = nameLabel;
    }

    /**Creates the anamneseTextAreaScrollPane
     * @return the anamneseTextAreaScrollPane
     * */
    public TopologyScrollPane createAnamneseTextAreaScrollPane(){
        return new TopologyScrollPane(getAnamneseTextArea(), "Description");
    }

    /**Gets the anamneseTextAreaScrollPane
     * @return the anamneseTextAreaScrollPane
     * */
    public TopologyScrollPane getAnamneseTextAreaScrollPane() {
        return anamneseTextAreaScrollPane;
    }

    /**Sets the anamneseTextAreaScrollPane
     * @param anamneseTextAreaScrollPane the anamneseTextAreaScrollPane
     * */
    public void setAnamneseTextAreaScrollPane(TopologyScrollPane anamneseTextAreaScrollPane) {
        this.anamneseTextAreaScrollPane = anamneseTextAreaScrollPane;
    }

    /**Creates the okButton
     * @return the okButton
     * */
    public JButton createOkButton(){
        JButton okBtn = new JButton("Ok");
        okBtn.addActionListener((Record) getController());
        okBtn.setActionCommand(Record.MAKE_PROBLEM_DIALOG_OK_ID);
        return okBtn;
    }

    /**Gets the okButton
     * @return the okButton
     * */
    public JButton getOkButton() {
        return this.okButton;
    }

    /**Sets the okButton
     * @param okButton the okButton
     * */
    public void setOkButton(JButton okButton) {
        this.okButton = okButton;
    }

    /**Creates the clearButton
     * @return the clearButton
     * */
    public JButton createClearButton(){
        JButton clearBtn = new JButton("Clear");
        clearBtn.addActionListener((Record) getController());
        clearBtn.setActionCommand(Record.MAKE_PROBLEM_DIALOG_CLEAR_ID);
        return clearBtn;
    }

    /**Gets the clearButton
     * @return the clearButton
     * */
    public JButton getClearButton() {
        return clearButton;
    }

    /**Sets the clearButton
     * @param clearButton the clearButton
     * */
    public void setClearButton(JButton clearButton) {
        this.clearButton = clearButton;
    }

    /**Creates the cancelBtn
     * @return the cancelBtn
     * */
    public JButton createCancelButton(){
        JButton cancelBtn = new JButton("Cancel");
        cancelBtn.addActionListener((Record) getController());
        cancelBtn.setActionCommand(Record.MAKE_PROBLEM_DIALOG_CANCEL_ID);
        return cancelBtn;
    }

    /**Gets the cancelBtn
     * @return the cancelBtn
     * */
    public JButton getCancelButton() {
        return cancelButton;
    }

    /**Sets the cancelBtn
     * @param cancelButton the cancelBtn
     * */
    public void setCancelButton(JButton cancelButton) {
        this.cancelButton = cancelButton;
    }
}
