/*
 * $RCSfile: MakeOverlayDialog.java,v $
 *
 * Copyright (c) 1999-2002. Jens Bohl. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.application.healthcare.record.topology;

import org.resmedicinae.application.healthcare.record.*;
import org.resmedicinae.resmedlib.component.control.*;
import org.resmedicinae.resmedlib.component.view.swing.*;

import javax.swing.ImageIcon;
import javax.swing.*;
import java.awt.*;

/**
 *View Component. Dialog for creating a new overlay. The user can choose an image file such as JPG or GIF
 * and give a name and decription to the overlay.
 * @author Jens Bohl <info@jens-bohl-professional.de>
 */
public class MakeOverlayDialog extends SwingView {
    /** Layout Manager of this dialog */
    private GridBagLayout gridbag;
    /** Name label of this overlay */
    private TopologyLabel nameLabel;
    /** Name textField of this overlay */
    private JTextField nameTextField;
    /** Name label of picture (JPG or GIF) to choose */
    private TopologyLabel pictureNameLabel;
    /** Name text field showing the name of choosed picture */
    private JTextField pictureNameTextField;
    /** Ok button for commitment */
    private JButton okButton;
    /** Cancel button for cancelation */
    private JButton cancelButton;
    /** Button for choosing files. A file chooser appears after clicking this button.*/
    private JButton chooseFileButton;
    /** Textarea to give a description to the image. */
    private TopologyTextArea descriptionTextArea;
    /** The model of MVC */
    private RecordModel model;
    /** Directory where icons are at */
    private String iconDirectoryName = new String("icons");
    /** Icon for chooseFileButton */
    private ImageIcon openIcon;
    /**Scrollpane for description textArea*/
    private TopologyScrollPane descriptionTextAreaScrollPane;

    /**Default Constructor */
    public MakeOverlayDialog() {
    }

    /** Initialization of components */
    public void initialize() {
        setTitle("Create overlay...");
        gridbag = new GridBagLayout();
        setLayout(gridbag);
        GridBagConstraints c = new GridBagConstraints();
        setDisplayMode(DisplayFactory.MODELESS_DIALOG_DISPLAY);
        setDialogBounds(createDialogBounds());
        setLocation(500, 350);

        setNameLabel(createNameLabel());
        setNameTextField(createNameTextField());
        setPictureNameLabel(createPictureNameLabel());
        setPictureNameTextField(createPictureNameTextField());
        setDescriptionTextArea(createDescriptionTextArea());
        setDescriptionTextAreaScrollPane(createDescriptionTextAreaScrollPane());
        setOkButton(createOkButton());
        setCancelButton(createCancelButton());
        setChooseFileButton(createChooseFileButton());


        c.anchor = GridBagConstraints.EAST;
        c.insets = new Insets(5, 10, 0, 10);
        c.gridx = 0;
        c.gridy = 0;
        c.fill = GridBagConstraints.HORIZONTAL;
        gridbag.setConstraints(getNameLabel(), c);
        add(getNameLabel());

        c.anchor = GridBagConstraints.WEST;
        c.gridwidth = 3;
        c.gridx = 1;
        c.gridy = 0;
        gridbag.setConstraints(nameTextField, c);
        add(getNameTextField());

        c.anchor = GridBagConstraints.EAST;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 1;
        gridbag.setConstraints(getPictureNameLabel(), c);
        add(getPictureNameLabel());

        c.anchor = GridBagConstraints.WEST;
        c.gridx = 1;
        c.gridy = 1;
        gridbag.setConstraints(getPictureNameTextField(), c);
        add(getPictureNameTextField());

        c.gridx = 2;
        c.gridy = 1;
        c.anchor = GridBagConstraints.EAST;
        gridbag.setConstraints(getChooseFileButton(), c);
        add(getChooseFileButton());

        c.insets = new Insets(5, 10, 5, 10);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 3;
        c.anchor = GridBagConstraints.WEST;
        gridbag.setConstraints(getDescriptionTextAreaScrollPane(), c);
        add(getDescriptionTextAreaScrollPane());

        c.insets = new Insets(5, 10, 5, 10);
        c.gridx = 0;
        c.gridwidth = 1;
        c.gridy = 3;
        c.anchor = GridBagConstraints.EAST;
        gridbag.setConstraints(getOkButton(), c);
        add(getOkButton());

        c.insets = new Insets(5, 10, 5, 10);
        c.gridx = 1;
        c.gridwidth = 2;
        c.gridy = 3;
        c.anchor = GridBagConstraints.EAST;
        gridbag.setConstraints(getCancelButton(), c);
        add(getCancelButton());


    }

    /**
     * Creates a rectangle storing the dialog bounds.
     * @return the rectangle storing the dialog bounds
     */
    public Rectangle createDialogBounds() {
        // Determine width.
        int screenWidth = (int) Math.floor(Toolkit.getDefaultToolkit().getScreenSize().getWidth());
        int w = 360;
        if (w > screenWidth) {
            w = screenWidth;
        }
        // Use centered x position by default.
        int x = (screenWidth - w) / 2;
        // Determine height.
        int screenHeight = (int) Math.floor(Toolkit.getDefaultToolkit().getScreenSize().getHeight());
        int h = 300;
        if (h > screenHeight) {
            h = screenHeight;
        }
        // Use centered y position by default.
        int y = (screenHeight - h) / 2;
        return new Rectangle(x, y, w, h);
    }

    /**
     * Creates a display mode.
     * @return the display mode
     */
    public int createDisplayMode() {
        return DisplayFactory.MODELESS_DIALOG_DISPLAY;
    }

    /**
     * Creates a control issued when the window containing this view is closed.
     * @return the control issued when the window containing this view is closed
     * @exception NullPointerException if the control is null
     */
    public Control createCloseControl() throws NullPointerException {
        Control c = new Control();
        if (c != null) {
            c.setId(Record.DESTROY_LOAD_PATIENT_DIALOG_CONTROL_ID);
            c.setSender((Controller) getController());
        } else {
            throw new NullPointerException("Could not create close control. The control is null.");
        }
        return c;
    }

    /** Finalizes this component. */
    public void finalizz() throws Exception {
        try {
            // Set parameters.
            setBorder(null);
        } finally {
            super.finalizz();
        }
    }

    /**Gets the layout manager
     * @return the layout manager
     * */
    public GridBagLayout getGridbag() {
        return gridbag;
    }

    /**Sets the layout manager
     * @param gridbag the layout manager
     * */
    public void setGridbag(GridBagLayout gridbag) {
        this.gridbag = gridbag;
    }

    /**Creates the name label
     * @return the name label
     * */
    public TopologyLabel createNameLabel(){
        TopologyLabel nameLabel = new TopologyLabel(false);
        nameLabel.setText("Name");
        return nameLabel;
    }

    /**Gets the label
     * @return the name label
     * */
    public TopologyLabel getNameLabel() {
        return nameLabel;
    }

    /**Sets the label
     * @param nameLabel the name label
     * */
    public void setNameLabel(TopologyLabel nameLabel) {
        this.nameLabel = nameLabel;
    }

    /**Creates the textField
     * @return the textField
     * */
    public JTextField createNameTextField(){
        JTextField nameTextField = new JTextField(15);
        nameTextField.setEditable(true);
        nameTextField.setEnabled(true);
        return nameTextField;
    }

    /**Gets the textField
     * @return the textField
     * */
    public JTextField getNameTextField() {
        return nameTextField;
    }

    /**Sets the nameTextField
     * @param nameTextField the nameTextField
     * */
    public void setNameTextField(JTextField nameTextField) {
        this.nameTextField = nameTextField;
    }

    /**Creates the pictureNameLabel
     * @return the pictureNameLabel
     * */
    public TopologyLabel createPictureNameLabel(){
        TopologyLabel pictureNameLabel = new TopologyLabel(false);
        pictureNameLabel.setText("Dateiname");
        return pictureNameLabel;
    }

    /**Gets the pictureNameLabel
     * @return the pictureNameLabel
     * */
    public TopologyLabel getPictureNameLabel() {
        return pictureNameLabel;
    }

    /**Sets the pictureNameLabel
     * @param pictureNameLabel the pictureNameLabel
     * */
    public void setPictureNameLabel(TopologyLabel pictureNameLabel) {
        this.pictureNameLabel = pictureNameLabel;
    }

    /**Creates the pictureNameTextField
     * @return the pictureNameTextField
     * */
    public JTextField createPictureNameTextField(){
        JTextField pictureNameTextField = new JTextField(15);
        pictureNameTextField.setEditable(false);
        return pictureNameTextField;
    }

    /**Gets the pictureNameTextField
     * @return the pictureNameTextField
     * */
    public JTextField getPictureNameTextField() {
        return pictureNameTextField;
    }

    /**Sets the pictureNameTextField
     * @param pictureNameTextField the pictureNameTextField
     * */
    public void setPictureNameTextField(JTextField pictureNameTextField) {
        this.pictureNameTextField = pictureNameTextField;
    }

    /**Creates the okButton
     * @return the okButton
     * */
    public JButton createOkButton(){
        JButton okButton = new JButton("Ok");
        okButton.addActionListener((Record) getController());
        okButton.setActionCommand(Record.MAKE_OVERLAY_DIALOG_OK_ID);
        okButton.setToolTipText("Create new overlay");
        return okButton;
    }

    /**Gets the okButton
     * @return the okButton
     * */
    public JButton getOkButton() {
        return okButton;
    }

    /**Sets the okButton
     * @param okButton the okButton
     * */
    public void setOkButton(JButton okButton) {
        this.okButton = okButton;
    }

    /**Creates the cancelButton
     * @return the cancelButton
     * */
    public JButton createCancelButton(){
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener((Record) getController());
        cancelButton.setActionCommand(Record.MAKE_OVERLAY_DIALOG_CANCEL_ID);
        cancelButton.setToolTipText("Cancel");
        return cancelButton;
    }

    /**Gets the cancelButton
     * @return the cancelButton
     * */
    public JButton getCancelButton() {
        return cancelButton;
    }

    /**Sets the cancelButton
     * @param cancelButton the cancelButton
     * */
    public void setCancelButton(JButton cancelButton) {
        this.cancelButton = cancelButton;
    }

    /**Creates the chooseFileButton
     * @return the chooseFileButton
     * */
    public JButton createChooseFileButton(){
        ImageIcon openIcon = new ImageIcon(RecordModel.RelativeIconDirectoryName + "open.gif");
        JButton chooseFileButton = new JButton(openIcon);
        chooseFileButton.addActionListener((Record) getController());
        chooseFileButton.setActionCommand(Record.MAKE_OVERLAY_DIALOG_CHOOSE_FILE_ID);
        chooseFileButton.setToolTipText("Choose image");
        return chooseFileButton;
    }

    /**Gets the chooseFileButton
     * @return the chooseFileButton
     * */
    public JButton getChooseFileButton() {
        return chooseFileButton;
    }

    /**Sets the chooseFileButton
     * @param chooseFileButton the chooseFileButton
     * */
    public void setChooseFileButton(JButton chooseFileButton) {
        this.chooseFileButton = chooseFileButton;
    }

    /**Creates the descriptionTextArea
     * @return the descriptionTextArea
     * */
    public TopologyTextArea createDescriptionTextArea(){
        return new TopologyTextArea(new Dimension(280, 150));
    }

    /**Gets the descriptionTextArea
     * @return the descriptionTextArea
     * */
    public TopologyTextArea getDescriptionTextArea() {
        return descriptionTextArea;
    }

    /**Sets the descriptionTextArea
     * @param descriptionTextArea the descriptionTextArea
     * */
    public void setDescriptionTextArea(TopologyTextArea descriptionTextArea) {
        this.descriptionTextArea = descriptionTextArea;
    }

    /**Creates the descriptionTextAreaScrollPane
     * @return the descriptionTextAreaScrollPane
     * */
    public TopologyScrollPane createDescriptionTextAreaScrollPane(){
        return new TopologyScrollPane(getDescriptionTextArea(), "Description");
    }

    /**Gets the descriptionTextAreaScrollPane
     * @return the descriptionTextAreaScrollPane
     * */
    public TopologyScrollPane getDescriptionTextAreaScrollPane() {
        return descriptionTextAreaScrollPane;
    }

    /**Sets the descriptionTextAreaScrollPane
     * @param descriptionTextAreaScrollPane the descriptionTextAreaScrollPane
     * */
    public void setDescriptionTextAreaScrollPane(TopologyScrollPane descriptionTextAreaScrollPane) {
        this.descriptionTextAreaScrollPane = descriptionTextAreaScrollPane;
    }
}
