/*
 * Created by IntelliJ IDEA.
 * User: Jens Bohl
 * Date: 03.12.2002
 * Time: 20:50:42
 * To change template for new class use 
 * Code Style | Class Templates options (Tools | IDE Options).
 */
package org.resmedicinae.application.healthcare.record.topology;

import org.resmedicinae.resmedlib.component.view.swing.SwingView;
import org.resmedicinae.resmedlib.component.view.swing.DisplayFactory;
import org.resmedicinae.resmedlib.component.control.Control;
import org.resmedicinae.resmedlib.component.control.Controller;
import org.resmedicinae.application.healthcare.record.RecordModel;
import org.resmedicinae.application.healthcare.record.Record;

import javax.swing.*;
import javax.swing.event.TreeSelectionListener;
import java.awt.*;

/**
 * This class represents dialog that can be used for creating new diseases as well as for editing and removing
 * diseases and overlays.
 * @author Jens Bohl <info@jens-bohl-professional.de>
 */
public class MakeDiseaseDialog extends SwingView {
    /** The Layout Manager */
    private GridBagLayout gridbag;
    /** GridBagConstraints that are used */
    private GridBagConstraints c;
    /**Name label of diseaseNameTextField*/
    private JLabel nameLabel;
    /**TextField for the name of the disease*/
    private JTextField diseaseNameTextField;
    /** TextArea for the description of the disease*/
    private TopologyTextArea dieseaseDescriptionTextArea;
    /**The Model of the MVC*/
    private RecordModel model;
    /**A treeview for displaying overlays and correspoding diseases*/
    private OverlayTree overlayTree;
    /**Ok Button. Clicking this button creates a new disease and hides the dialog.*/
    private JButton okButton;
    /**Cancel Button. Clicking this button hides the dialog.*/
    private JButton cancelButton;
    /**Remove Button. Clicking this button removes a diesease or an overlay.*/
    private JButton removeButton;
    /**Commit Button. Clicking this button saves modified properties such as names and description of overlays an
     * diseases.*/
    private JButton commitButton;
    /**Clear Button. Clears the textArea and textField of the dialog.*/
    private JButton clearButton;
    /**ScrollPane for diseaseTextArea*/
    private TopologyScrollPane diseaseScrollPane;
    /**ScrollPane for overlayTree*/
    private JScrollPane overlayTreeScrollPane;


    /**Default constructor*/
    public MakeDiseaseDialog() {
    }

    /** Initialization of components */
    public void initialize() {
        setTitle("Create/Edit disease...");
        gridbag = new GridBagLayout();
        setLayout(gridbag);
        c = new GridBagConstraints();
        setDisplayMode(DisplayFactory.MODELESS_DIALOG_DISPLAY);
        setDialogBounds(createDialogBounds());

        setNameLabel(createNameLabel());
        setDiseaseNameTextField(createDiseaseNameTextField());
        setOkButton(createOkButton());
        setDiseaseScrollPane(createDiseaseScrollPane());
        setOverlayTreeScrollPane(createOverlayTreeScrollPane());

        c.anchor = GridBagConstraints.WEST;
        c.gridx = 0;
        c.gridy = 0;
        gridbag.setConstraints(getNameLabel(), c);
        add(getNameLabel());

        c.anchor = GridBagConstraints.CENTER;
        c.fill = GridBagConstraints.HORIZONTAL;
        c.gridwidth = 5;
        c.gridx = 1;
        c.gridy = 0;
        gridbag.setConstraints(diseaseNameTextField, c);
        add(getDiseaseNameTextField());

        c.anchor = GridBagConstraints.EAST;
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 6;
        c.ipady = 150;
        c.ipady = 150;
        c.ipadx = 100;
        gridbag.setConstraints(getDiseaseScrollPane(), c);
        add(getDiseaseScrollPane());

        c.anchor = GridBagConstraints.WEST;
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 6;
        c.ipady = 150;
        c.ipadx = 100;
        gridbag.setConstraints(getOverlayTreeScrollPane(), c);
        add(getOverlayTreeScrollPane());

        c.anchor = GridBagConstraints.WEST;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 3;
        c.ipady = 5;
        c.ipadx = 5;
        gridbag.setConstraints(getOkButton(), c);
        add(getOkButton());

        setClearButton(createClearButton());
        c.anchor = GridBagConstraints.CENTER;
        c.gridx = 4;
        c.gridy = 3;
        gridbag.setConstraints(getClearButton(), c);
        add(getClearButton());

        setCancelButton(createCancelButton());
        c.anchor = GridBagConstraints.EAST;
        c.gridx = 5;
        c.gridy = 3;
        gridbag.setConstraints(getCancelButton(), c);
        add(getCancelButton());

        setRemoveButton(createRemoveButton());
        c.anchor = GridBagConstraints.EAST;
        c.gridx = 3;
        c.gridy = 3;
        gridbag.setConstraints(getRemoveButton(), c);
        add(getRemoveButton());

        setCommitButton(createCommitButton());
        c.anchor = GridBagConstraints.EAST;
        c.gridx = 1;
        c.gridy = 3;
        gridbag.setConstraints(getCommitButton(), c);
        add(getCommitButton());
    }

    /**
     * Creates a rectangle storing the dialog bounds.
     * @return the rectangle storing the dialog bounds
     */
    public Rectangle createDialogBounds() {
        // Determine width.
        int screenWidth = (int) Math.floor(Toolkit.getDefaultToolkit().getScreenSize().getWidth());
        int w = 390;
        if (w > screenWidth) {
            w = screenWidth;
        }
        // Use centered x position by default.
        int x = (screenWidth - w) / 2;
        // Determine height.
        int screenHeight = (int) Math.floor(Toolkit.getDefaultToolkit().getScreenSize().getHeight());
        int h = 480;
        if (h > screenHeight) {
            h = screenHeight;
        }
        // Use centered y position by default.
        int y = (screenHeight - h) / 2;
        return new Rectangle(x, y, w, h);
    }

    /**
     * Creates a display mode.
     * @return the display mode
     */
    public int createDisplayMode() {
        return DisplayFactory.MODELESS_DIALOG_DISPLAY;
    }

    /**
     * Creates a control issued when the window containing this view is closed.
     * @return the control issued when the window containing this view is closed
     * @exception NullPointerException if the control is null
     */
    public Control createCloseControl() throws NullPointerException {
        Control c = new Control();
        if (c != null) {
            c.setId(Record.DESTROY_LOAD_PATIENT_DIALOG_CONTROL_ID);
            c.setSender((Controller) getController());
        } else {
            throw new NullPointerException("Could not create close control. The control is null.");
        }
        return c;
    }

    /** Finalizes this component. */
    public void finalizz() throws Exception {
        try {
            // Set parameters.
            setBorder(null);
        } finally {
            super.finalizz();
        }
    }

    /**Gets the layoutManager
     * @return the layout manager
     */
    public GridBagLayout getGridbag() {
        return gridbag;
    }

    /**Sets the layoutManager
     * @param gridbag the layout manager
     */
    public void setGridbag(GridBagLayout gridbag) {
        this.gridbag = gridbag;
    }

    /**Creates the diseaseTextField
     * @return the diseaseTextField
     */
    public JTextField createDiseaseNameTextField(){
        JTextField diseaseNameTextField = new JTextField(100);
        //diseaseNameTextField.setEditable(false);
        //diseaseNameTextField.setEnabled(false);
        diseaseNameTextField.addActionListener((Record) getController());
        return diseaseNameTextField;
    }

    /**Gets the diseaseTextField
     * @return the diseaseTextField
     */
    public JTextField getDiseaseNameTextField() {
        return diseaseNameTextField;
    }

    /**Sets the diseaseTextField
     * @param diseaseTextField the diseaseTextField
     */
    public void setDiseaseNameTextField(JTextField nameTextField) {
        this.diseaseNameTextField = nameTextField;
    }

    /**Creates the nameLabel
     * @return the nameLabeld
     */
    public JLabel createNameLabel(){
        TopologyLabel nameLabel = new TopologyLabel(false);
        nameLabel.setText("Name");
        return nameLabel;
    }

    /**Gets the nameLabel
     * @return the nameLabeld
     */
    public JLabel getNameLabel() {
        return nameLabel;
    }

    /**Sets the nameLabel
     * @return nameLabel the nameLabel
     */
    public void setNameLabel(JLabel nameLabel) {
        this.nameLabel = nameLabel;
    }

    /**Creates the diseaseDescriptionTextArea
     * @return the diseaseDescriptionTextArea
     */
    public TopologyTextArea createDiseaseDescriptionTextArea(){
        TopologyTextArea dieseaseDescriptionTextArea = new TopologyTextArea(new Dimension(380, 200));
        //dieseaseDescriptionTextArea.setEnabled(false);
        //dieseaseDescriptionTextArea.setEditable(false);
        return dieseaseDescriptionTextArea;
    }

    /**Gets the diseaseDescriptionTextArea
     * @return the diseaseDescriptionTextArea
     */
    public TopologyTextArea getDiseaseDescriptionTextArea() {
        return dieseaseDescriptionTextArea;
    }

    /**Sets the anamneseTextArea
     * @return nameLabel the anamneseTextArea
     */
    public void setDiseaseDescriptionTextArea(TopologyTextArea anamneseTextArea) {
        this.dieseaseDescriptionTextArea = anamneseTextArea;
    }

    /**Creates the overlayTree
     * @return the overlayTree
     */
    public OverlayTree createOverlayTree(){
        RecordModel model = (RecordModel)getModel();
        OverlayTree overlayTree = new OverlayTree();
        overlayTree.addTreeSelectionListener((TreeSelectionListener)getController());
        return overlayTree;
    }

    /**Gets the overlayTree
     * @return the overlayTree
     */
    public OverlayTree getOverlayTree() {
        System.out.println("Getting the overlay tree of the makeDiseaseDialog========================================");
        return overlayTree;
    }

    /**Sets the overlayTree
     * @return nameLabel the overlayTree
     */
    public void setOverlayTree(OverlayTree overlayTree) {
        this.overlayTree = overlayTree;
    }

    /**Creates the okButton
     * @return the okButton
     */
    public JButton createOkButton(){
        JButton okBtn = new JButton("New");
        okBtn.addActionListener((Record) getController());
        okBtn.setActionCommand(Record.MAKE_DISEASE_DIALOG_OK_ID);
        return okBtn;
    }

    /**Gets the okButton
     * @return the okButton
     */
    public JButton getOkButton() {
        return okButton;
    }

    /**Sets the okButton
     * @return okButton the okButton
     */
    public void setOkButton(JButton okButton) {
        this.okButton = okButton;
    }

    /**Creates the cancelButton
     * @return the cancelButton
     */
    public JButton createCancelButton(){
        JButton cancelBtn = new JButton("Cancel");
        cancelBtn.setToolTipText("Cancel");
        cancelBtn.addActionListener((Record) getController());
        cancelBtn.setActionCommand(Record.MAKE_DISEASE_DIALOG_CANCEL_ID);
        return cancelBtn;
    }

    /**Gets the cancelButton
     * @return the cancelButton
     */
    public JButton getCancelButton() {
        return cancelButton;
    }

    /**Sets the cancelButton
     * @return cancelButton the cancelButton
     */
    public void setCancelButton(JButton cancelButton) {
        this.cancelButton = cancelButton;
    }

    /**Creates the removeButton
     * @return the removeButton
     */
    public JButton createRemoveButton(){
        JButton removeBtn = new JButton("Remove");
        removeBtn.setEnabled(false);
        removeBtn.setToolTipText("Remove disease");
        removeBtn.addActionListener((Record) getController());
        removeBtn.setActionCommand(Record.MAKE_DISEASE_DIALOG_REMOVE_DISEASE_ID);
        return removeBtn;
    }

    /**Gets the removeButton
     * @return the removeButton
     */
    public JButton getRemoveButton() {
        return removeButton;
    }

    /**Sets the removeButton
     * @return removeButton the removeButton
     */
    public void setRemoveButton(JButton removeButton) {
        this.removeButton = removeButton;
    }

    /**Creates the commitButton
     * @return the commitButton
     */
    public JButton createCommitButton(){
        JButton commitBtn = new JButton("Commit");
        commitBtn.setEnabled(false);
        commitBtn.setToolTipText("Commit changes");
        commitBtn.addActionListener((Record) getController());
        commitBtn.setActionCommand(Record.MAKE_DISEASE_DIALOG_COMMIT_CHANGES_IN_DISEASE_ID);
        return commitBtn;
    }

    /**Gets the commitButton
     * @return the commitButton
     */
    public JButton getCommitButton() {
        return commitButton;
    }

    /**Sets the commitButton
     * @return commitButton the commitButton
     */
    public void setCommitButton(JButton commitButton) {
        this.commitButton = commitButton;
    }

    /**Creates the clearButton
     * @return the clearButton
     */
    public JButton createClearButton(){
        JButton clearBtn = new JButton("Clear");
        clearBtn.setToolTipText("Clear textfields");
        clearBtn.addActionListener((Record) getController());
        clearBtn.setActionCommand(Record.MAKE_DISEASE_DIALOG_CLEAR_ID);
        return clearBtn;
    }

    /**Gets the clearButton
     * @return the clearButton
     */
    public JButton getClearButton() {
        return clearButton;
    }

    /**Sets the clearButton
     * @return clearButton the clearButton
     */
    public void setClearButton(JButton clearButton) {
        this.clearButton = clearButton;
    }

    public TopologyScrollPane createDiseaseScrollPane(){
        setDiseaseDescriptionTextArea(createDiseaseDescriptionTextArea());
        return new TopologyScrollPane(getDiseaseDescriptionTextArea(), "Description");
    }


    /**Gets the diseaseScrollpane
     * @return the diseaseScrollpane
     * */
    public TopologyScrollPane getDiseaseScrollPane() {
        return diseaseScrollPane;
    }

    /**Sets the diseaseScrollpane
     * @return diseaseScrollpane the diseaseScrollpane
     * */
    public void setDiseaseScrollPane(TopologyScrollPane diseaseScrollPane) {
        this.diseaseScrollPane = diseaseScrollPane;
    }

    /**Creates the overlayTreeScrollPane
     * @return the overlayTreeScrollPane
     */
    public JScrollPane createOverlayTreeScrollPane(){
        setOverlayTree(createOverlayTree());
        JScrollPane overlayTreeScrollPane = new JScrollPane(getOverlayTree());
        overlayTreeScrollPane.setPreferredSize(new Dimension(380,180));
        overlayTreeScrollPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
        overlayTreeScrollPane.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED);
        return overlayTreeScrollPane;
    }

    /**Gets the overlayTreeScrollPane
     * @return the overlayTreeScrollPane
     */
    public JScrollPane getOverlayTreeScrollPane() {
        return overlayTreeScrollPane;
    }

    /**Sets the overlayTreeScrollPane
     * @return overlayTreeScrollPane the overlayTreeScrollPane
     */
    public void setOverlayTreeScrollPane(JScrollPane overlayTreeScrollPane) {
        this.overlayTreeScrollPane = overlayTreeScrollPane;
    }
}
