/*
 * $RCSfile: MakeCAVEDialog.java,v $
 *
 * Copyright (c) 1999-2002. Jens Bohl. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.application.healthcare.record.topology;

import org.resmedicinae.application.healthcare.record.*;
import org.resmedicinae.resmedlib.component.control.*;
import org.resmedicinae.resmedlib.component.view.swing.*;

import javax.swing.*;
import java.awt.*;

/** View Component. This frame is for creating a new CAVE entry. A mask appears where all properties can be filled in.
 * @author Jens Bohl <info@jens-bohl-professional.de>
 *  */
public class MakeCAVEDialog extends SwingView {
    /**The cave name label.*/
    private TopologyLabel caveNameLabel;
    /**The cave name tectfield.*/
    private JTextField caveNameTextField;
    /**The cave description label.*/
    private TopologyLabel caveDescriptionLabel;
    /**The cave description textarea.*/
    private TopologyTextArea caveDescriptionTextArea;
    /**The cancel button.*/
    private JButton cancelButton;
    /**The ok button.*/
    private JButton okButton;
     /**The clear button.*/
    private JButton clearButton;

    /**Default constructor.*/
    public MakeCAVEDialog() {
    }

    /**Initializes the component.*/
    public void initialize() {
        setTitle("New CAVE! entry...");
        setDisplayMode(DisplayFactory.MODELESS_DIALOG_DISPLAY);
        setDialogBounds(createDialogBounds());
        GridBagLayout gridBag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        setLayout(gridBag);

        setCaveNameLabel(createNameLabel());
        setCaveNameTextField(createCaveNameTextField());

        setCaveDescriptionTextArea(createCaveDescriptionTextArea());
        TopologyScrollPane caveDescriptionScrollPane = new TopologyScrollPane(getCaveDescriptionTextArea(), "Description");

        setOkButton(createOkButton());
        setCancelButton(createCancelButton());
        setClearButton(createClearButton());

        c.anchor = GridBagConstraints.WEST;
        c.fill = GridBagConstraints.HORIZONTAL;
        c.insets = new Insets(0,7,0,0);
        c.gridx = 0;
        c.gridy = 0;
        gridBag.setConstraints(getCaveNameLabel(), c);
        add(getCaveNameLabel());

        c.anchor = GridBagConstraints.WEST;
        c.insets = new Insets(0,0,0,0);
        c.gridx = 1;
        c.gridy = 0;
        gridBag.setConstraints(caveNameTextField, c);
        add(getCaveNameTextField());

        c.anchor = GridBagConstraints.WEST;
        c.gridwidth = 3;
        c.gridx = 0;
        c.gridy = 2;
        gridBag.setConstraints(caveDescriptionScrollPane, c);
        add(caveDescriptionScrollPane);

        c.anchor = GridBagConstraints.WEST;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 3;
        gridBag.setConstraints(getOkButton(), c);
        add(getOkButton());

        c.anchor = GridBagConstraints.CENTER;
        c.gridx = 1;
        c.gridy = 3;
        gridBag.setConstraints(getClearButton(), c);
        add(getClearButton());

        c.anchor = GridBagConstraints.EAST;
        c.gridx = 2;
        c.gridy = 3;
        gridBag.setConstraints(getCancelButton(), c);
        add(getCancelButton());
    }

    /**
     * Creates a rectangle storing the dialog bounds.
     * @return the rectangle storing the dialog bounds
     */
    public Rectangle createDialogBounds() {
        // Determine width.
        int screenWidth = (int) Math.floor(Toolkit.getDefaultToolkit().getScreenSize().getWidth());
        int w = 300;
        if (w > screenWidth) {
            w = screenWidth;
        }
        // Use centered x position by default.
        int x = (screenWidth - w) / 2;
        // Determine height.
        int screenHeight = (int) Math.floor(Toolkit.getDefaultToolkit().getScreenSize().getHeight());
        int h = 320;
        if (h > screenHeight) {
            h = screenHeight;
        }
        // Use centered y position by default.
        int y = (screenHeight - h) / 2;
        return new Rectangle(x, y, w, h);
    }

    /**
     * Creates a display mode.
     * @return the display mode
     */
    public int createDisplayMode() {
        return DisplayFactory.MODELESS_DIALOG_DISPLAY;
    }

    /**
     * Creates a control issued when the window containing this view is closed.
     * @return the control issued when the window containing this view is closed
     * @exception NullPointerException if the control is null
     */
    public Control createCloseControl() throws NullPointerException {
        Control c = new Control();
        if (c != null) {
            c.setId(Record.DESTROY_LOAD_PATIENT_DIALOG_CONTROL_ID);
            c.setSender((Controller) getController());
        } else {
            throw new NullPointerException("Could not create close control. The control is null.");
        }
        return c;
    }

    /** Finalizes this component. */
    public void finalizz() throws Exception {
        try {
            // Set parameters.
            setBorder(null);
        } finally {
            super.finalizz();
        }
    }

    /**Creates the caveDescriptionTextArea
     * @return the caveDescriptionTextArea
     */
    public TopologyTextArea createCaveDescriptionTextArea(){
        TopologyTextArea caveDescriptionTextArea = new TopologyTextArea(new Dimension(250, 240));
        return caveDescriptionTextArea;
    }

    /**Gets the caveDescriptionTextArea
     * @return the caveDescriptionTextArea
     */
    public TopologyTextArea getCaveDescriptionTextArea() {
        return caveDescriptionTextArea;
    }

    /**Sets the caveDescriptionTextArea
     * @param caveDescriptionTextArea the caveDescriptionTextArea
     */
    public void setCaveDescriptionTextArea(TopologyTextArea caveDescriptionTextArea) {
        this.caveDescriptionTextArea = caveDescriptionTextArea;
    }

    /**Creates the caveNameLabel
     * @return the caveNameLabel
     */
    public TopologyLabel createNameLabel(){
        TopologyLabel caveNameLabel = new TopologyLabel(false);
        caveNameLabel.setText("Cave!");
        return caveNameLabel;
    }

    /**Gets the caveNameLabel
     * @return the caveNameLabel
     */
    public TopologyLabel getCaveNameLabel() {
        return caveNameLabel;
    }

    /**Sets the caveNameLabel
     * @param caveNameLabel the caveNameLabel
     */
    public void setCaveNameLabel(TopologyLabel caveNameLabel) {
        this.caveNameLabel = caveNameLabel;
    }

    /**Creates the caveNameTextField
     * @return the caveNameTextField
     */
    public JTextField createCaveNameTextField(){
        JTextField caveNameTextField = new JTextField(15);
        return caveNameTextField;
    }

    /**Gets the caveNameTextField
     * @return the caveNameTextField
     */
    public JTextField getCaveNameTextField() {
        return caveNameTextField;
    }

    /**Sets the caveNameTextField
     * @param caveNameTextField the caveNameTextField
     */
    public void setCaveNameTextField(JTextField caveNameTextField) {
        this.caveNameTextField = caveNameTextField;
    }

    /**Creates the cancelButton
     * @return the cancelButton
     */
    public JButton createCancelButton(){
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener((Record) getController());
        cancelButton.setActionCommand(Record.MAKE_CAVE_DIALOG_CANCEL_ID);
        return cancelButton;
    }

    /**Gets the cancelButton
     * @return the cancelButton
     */
    public JButton getCancelButton() {
        return cancelButton;
    }

    /**Sets the cancelButton
     * @param cancelButton the cancelButton
     */
    public void setCancelButton(JButton cancelButton) {
        this.cancelButton = cancelButton;
    }

    /**Creates the okButton
     * @return the okButton
     */
    public JButton createOkButton(){
        JButton okButton = new JButton("Ok");
        okButton.setActionCommand(Record.MAKE_CAVE_DIALOG_OK_ID);
        okButton.addActionListener((Record) getController());
        return okButton;
    }

    /**Gets the okButton
     * @return the okButton
     */
    public JButton getOkButton() {
        return okButton;
    }

    /**Sets the okButton
     * @param okButton the okButton
     */
    public void setOkButton(JButton okButton) {
        this.okButton = okButton;
    }

    /**Creates the clearButton
     * @return the clearButton
     * */
    public JButton createClearButton(){
        JButton clearBtn = new JButton("Clear");
        clearBtn.addActionListener((Record) getController());
        clearBtn.setActionCommand(Record.MAKE_CAVE_DIALOG_CLEAR_ID);
        return clearBtn;
    }

    /**Gets the clearButton
     * @return the clearButton
     * */
    public JButton getClearButton() {
        return clearButton;
    }

    /**Sets the clearButton
     * @param clearButton the clearButton
     * */
    public void setClearButton(JButton clearButton) {
        this.clearButton = clearButton;
    }
}
