/*
 * $RCSfile: LoadPatientDialog.java,v $
 *
 * Copyright (c) 1999-2002. The Res Medicinae Developers. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.application.healthcare.record.topology;

import org.resmedicinae.application.healthcare.record.*;
import org.resmedicinae.application.healthcare.reform.application.common.basic.*;
import org.resmedicinae.resmedlib.component.control.*;
import org.resmedicinae.resmedlib.component.view.swing.*;

import javax.swing.*;
import java.awt.*;
import java.util.*;

/**
 * This class represents a load patient dialog.
 * @version $Revision: 1.15 $ $Date: 2002/12/11 15:28:03 $ $Author: tristan24 $
 * @author Jens Bohl <info@jens-bohl-professional.de>
 * @author Christian Heller <christian.heller@tuxtax.de>
 */
public class LoadPatientDialog extends SwingView {

    /**Action command. Normally all action commands are described be Record. But this dialog is also used be Reform and
     * that why the action commands have to be declared here.
     */
    public static final String SELECT_HEALTHRECORD_LOAD_PATIENT_DIALOG_CONTROL_ID = "Select";
    /**Action command. Normally all action commands are described be Record. But this dialog is also used be Reform and
     * that why the action commands have to be declared here.
     */
    public static final String REMOVE_HEALTHRECORD_LOAD_PATIENT_DIALOG_CONTROL_ID = "Remove";
    /**Action command. Normally all action commands are described be Record. But this dialog is also used be Reform and
     * that why the action commands have to be declared here.
     */
    public static final String DESTROY_HEALTHRECORD_LOAD_PATIENT_DIALOG_CONTROL_ID = "Close";

    /** Layout Manager of this dialog.*/
    private GridBagLayout gridbag;
    /** Name label of patient */
    private TopologyLabel nameLabel;
    /** Name textField of patient */
    public JTextField nameTextField;
    /** Caption suggested name */
    private TopologyLabel suggestedLabel;
    /** Select button for commitment */
    private JButton selectButton;
    /** Close button for removining a health record */
    private JButton removeButton;
    /** Close button for hiding the dialog */
    private JButton closeButton;
    /** Possible names table */
    public JTable possibleNamesTable;
    /** The model of the possible names table */
    public LoadPatientFrameTableModel tableModel;
    /** The listSelectionmodel of the possible names table */
    public ListSelectionModel listSelectionModel;
    /** Vector containing table column names */
    private Vector columNames;

    /**
     * Creates a rectangle storing the dialog bounds.
     * @return the rectangle storing the dialog bounds
     */
    public Rectangle createDialogBounds() {
        // Determine width.
        int screenWidth = (int) Math.floor(Toolkit.getDefaultToolkit().getScreenSize().getWidth());
        int w = 300;
        if (w > screenWidth) {
            w = screenWidth;
        }
        // Use centered x position by default.
        int x = (screenWidth - w) / 2;
        // Determine height.
        int screenHeight = (int) Math.floor(Toolkit.getDefaultToolkit().getScreenSize().getHeight());
        int h = 320;
        if (h > screenHeight) {
            h = screenHeight;
        }
        // Use centered y position by default.
        int y = (screenHeight - h) / 2;
        return new Rectangle(x, y, w, h);
    }
    //
    // Display mode.
    //

    /**
     * Creates a display mode.
     * @return the display mode
     */
    public int createDisplayMode() {
        return DisplayFactory.MODELESS_DIALOG_DISPLAY;
    }
    //
    // Close control.
    //

    /**
     * Creates a control issued when the window containing this view is closed.
     * @return the control issued when the window containing this view is closed
     * @exception NullPointerException if the control is null
     */
    public Control createCloseControl() throws NullPointerException {
        Control c = new Control();
        if (c != null) {
            c.setId(Record.DESTROY_LOAD_PATIENT_DIALOG_CONTROL_ID);
            c.setSender((Controller) getController());
        } else {
            throw new NullPointerException("Could not create close control. The control is null.");
        }
        return c;
    }

    /** Initializes this component. */
    public void initialize() throws Exception {
        super.initialize();
        setTitle("Load patient...");
        //?? Temporary! The display mode of this about dialog is read from the configuration of the application (and such is FRAME_DISPLAY)!
        setDisplayMode(DisplayFactory.MODELESS_DIALOG_DISPLAY);
        //?? Temporary! The dialog bounds of this about dialog are read from the configuration of the application!
        setDialogBounds(createDialogBounds());

        //setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));

        gridbag = new GridBagLayout();
        setLayout(gridbag);
        GridBagConstraints c = new GridBagConstraints();
        setColumNames(createColumNames());
        setTableModel(createTableModel());
        setNameLabel(createNameLabel());
        setNameTextField(createNameTextField());
        setSuggestedLabel(createSuggestedLabel());

        setPossibleNamesTable(createPossibleNamesTable());
        TopologyScrollPane scrollPane = new TopologyScrollPane(getPossibleNamesTable(), "Suggestions");
        setSelectButton(createSelectButton());
        setRemoveButton(createRemoveButton());
        setCloseButton(createCloseButton());


        c.anchor = GridBagConstraints.WEST;
        c.insets = new Insets(0,7,0,0);
        c.fill = GridBagConstraints.HORIZONTAL;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        gridbag.setConstraints(getSuggestedLabel(), c);
        add(getSuggestedLabel());

        c.anchor = GridBagConstraints.WEST;
        c.insets = new Insets(0,0,0,0);
        c.gridwidth = 1;
        c.gridx = 1;
        c.gridy = 0;
        gridbag.setConstraints(getNameTextField(), c);
        add(getNameTextField());

        c.anchor = GridBagConstraints.CENTER;
        c.ipady = 190;
        c.ipadx = 20;
        c.gridwidth = 3;
        c.gridx = 0;
        c.gridy = 2;
        gridbag.setConstraints(scrollPane, c);
        add(scrollPane);

        c.gridwidth = 1;
        c.ipady = 0;

        c.gridx = 0;
        c.gridy = 3;
        c.anchor = GridBagConstraints.EAST;
        gridbag.setConstraints(selectButton, c);
        add(selectButton);

        c.gridx = 1;
        c.gridy = 3;
        c.anchor = GridBagConstraints.CENTER;
        gridbag.setConstraints(removeButton, c);
        add(removeButton);

        c.gridx = 2;
        c.gridy = 3;
        c.anchor = GridBagConstraints.EAST;
        gridbag.setConstraints(closeButton, c);
        add(closeButton);
    }

    /** Finalizes this component. */
    public void finalizz() throws Exception {
        try {
            // Set parameters.
            setBorder(null);
        } finally {
            super.finalizz();
        }
    }

    /**Creates the name label.
     * @return the nameLabel
     * */
    public TopologyLabel createNameLabel(){
        TopologyLabel nameLabel = new TopologyLabel(false);
        nameLabel.setText("Name");
        return nameLabel;
    }

    /**Gets the name label.
     * @return the nameLabel
     * */
    public TopologyLabel getNameLabel() {
        return nameLabel;
    }

    /**Sets the name label.
     * @param nameLabel the nameLabel
     * */
    public void setNameLabel(TopologyLabel nameLabel) {
        this.nameLabel = nameLabel;
    }

    /**Creates the name textfield.
     * @return the nameTextField
     * */
    public JTextField createNameTextField(){
        JTextField nameTextField = new JTextField(15);
        nameTextField.setEditable(true);
        nameTextField.setEnabled(true);
        nameTextField.getDocument().addDocumentListener((AdvancedBasicApplication) getController());
        nameTextField.addActionListener((AdvancedBasicApplication) getController());
        nameTextField.setActionCommand(LoadPatientDialog.SELECT_HEALTHRECORD_LOAD_PATIENT_DIALOG_CONTROL_ID);
        return nameTextField;
    }

    /**Gets the name textfield.
     * @return the nametextfield
     * */
    public JTextField getNameTextField() {
        return nameTextField;
    }

    /**Sets the name textfield.
     * @param the nametextfield
     * */
    public void setNameTextField(JTextField nameTextField) {
        this.nameTextField = nameTextField;
    }


    /**Creates the suggested label.
     * @return the suggestedLabel
     * */
    public TopologyLabel createSuggestedLabel(){
        TopologyLabel l = new TopologyLabel(false);
        l.setText("Name:");
        return l;
    }

    /**Gets the suggested label.
     * @return the suggestedLabel
     * */
    public TopologyLabel getSuggestedLabel() {
        return suggestedLabel;
    }


    /**Sets the name suggestedLabel
     * @param suggestedLabel the suggestedLabel
     * */
    public void setSuggestedLabel(TopologyLabel suggestedLabel) {
        this.suggestedLabel = suggestedLabel;
    }


    /**Creates the possibleNamesTable.
     * @return the possibleNamesTable
     * */
    public JTable createPossibleNamesTable(){
        JTable possibleNamesTable = new JTable(tableModel);
        possibleNamesTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        possibleNamesTable.setPreferredSize(new Dimension(295, 250));
        possibleNamesTable.addMouseListener((AdvancedBasicApplication) getController());
        possibleNamesTable.getColumnModel().getSelectionModel().addListSelectionListener((AdvancedBasicApplication) getController());
        possibleNamesTable.setEnabled(false);
        return possibleNamesTable;
    }

    /**Gets the possibleNamesTable.
     * @return the possibleNamesTable
     * */
    public JTable getPossibleNamesTable() {
        return possibleNamesTable;
    }

    /**Sets the possibleNamesTable.
     * @param possibleNamesTable the possibleNamesTable
     * */
    public void setPossibleNamesTable(JTable possibleNamesTable) {
        this.possibleNamesTable = possibleNamesTable;
    }

    /**Creates the loadPatientFrameTableModel
     * @return the loadPatientFrameTableModel
     * */
    public LoadPatientFrameTableModel createTableModel(){
        LoadPatientFrameTableModel l = new LoadPatientFrameTableModel();
        return l;
    }

    /**Gets the loadPatientFrameTableModel
     * @return the loadPatientFrameTableModel
     * */
    public LoadPatientFrameTableModel getTableModel() {
        return tableModel;
    }

    /**Sets the loadPatientFrameTableModel
     * @param loadPatientFrameTableModel the loadPatientFrameTableModel
     * */
    public void setTableModel(LoadPatientFrameTableModel tableModel) {
        this.tableModel = tableModel;
    }

    /**Creates the listSelectionModel
     * @return the listSelectionModel
     * */
    public ListSelectionModel createListSelectionModel(){
        return new DefaultListSelectionModel();
    }

    /**Gets the listSelectionModel
     * @return the listSelectionModel
     * */
    public ListSelectionModel getListSelectionModel() {
        return listSelectionModel;
    }

    /**Sets the listSelectionModel
     * @param listSelectionModel the listSelectionModel
     * */
    public void setListSelectionModel(ListSelectionModel listSelectionModel) {
        this.listSelectionModel = listSelectionModel;
    }

    /**Creates the column Names
     * @return the column Names
     * */
    public Vector createColumNames(){
        Vector columNames = new Vector();
        columNames.add("Id");
        columNames.add("Vorname");
        columNames.add("Name");
        return columNames;
    }

    /**Gets the column Names
     * @return the column Names
     * */
    public Vector getColumNames() {
        return columNames;
    }

    /**Sets the columNames
     * @param columNames the columNames
     * */
    public void setColumNames(Vector columNames) {
        this.columNames = columNames;
    }

    /**Creates the selectButton
     * @return the selectButton
     * */
    public JButton createSelectButton(){
        JButton selectButton = new JButton("Load");
        selectButton.addActionListener((AdvancedBasicApplication) getController());
        selectButton.setActionCommand(LoadPatientDialog.SELECT_HEALTHRECORD_LOAD_PATIENT_DIALOG_CONTROL_ID);
        selectButton.setToolTipText("Select focused health record globaly");
        return selectButton;
    }

    /**Gets the selectButton
     * @return the selectButton
     * */
    public JButton getSelectButton() {
        return selectButton;
    }

    /**Sets the selectButton
     * @param selectButton the selectButton
     * */
    public void setSelectButton(JButton selectButton) {
        this.selectButton = selectButton;
    }

    /**Creates the removeButton
     * @return the removeButton
     * */
    public JButton createRemoveButton(){
        JButton removeButton = new JButton("Remove");
        removeButton.addActionListener((AdvancedBasicApplication) getController());
        removeButton.setActionCommand(LoadPatientDialog.REMOVE_HEALTHRECORD_LOAD_PATIENT_DIALOG_CONTROL_ID);
        removeButton.setToolTipText("Remove focused health record");
        return removeButton;
    }

    /**Gets the removeButton
     * @return the removeButton
     * */
    public JButton getRemoveButton() {
        return removeButton;
    }

    /**Sets the removeButton
     * @param removeButton the removeButton
     * */
    public void setRemoveButton(JButton removeButton) {
        this.removeButton = removeButton;
    }

    /**Creates the closeButton
     * @return the closeButton
     * */
    public JButton createCloseButton(){
        JButton closeButton = new JButton("Cancel");
        closeButton.addActionListener((AdvancedBasicApplication) getController());
        closeButton.setActionCommand(LoadPatientDialog.DESTROY_HEALTHRECORD_LOAD_PATIENT_DIALOG_CONTROL_ID);
        closeButton.setToolTipText("Close this dialog");
        return closeButton;
    }

    /**Gets the closeButton
     * @return the closeButton
     * */
    public JButton getCloseButton() {
        return closeButton;
    }

    /**Sets the closeButton
     * @param closeButton the closeButton
     * */
    public void setCloseButton(JButton closeButton) {
        this.closeButton = closeButton;
    }
}
