/*
 * $RCSfile: EditOverlayDialog.java,v $
 *
 * Copyright (c) 1999-2002. Jens Bohl. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.application.healthcare.record.topology;

import org.resmedicinae.application.healthcare.record.*;
import org.resmedicinae.resmedlib.component.control.*;
import org.resmedicinae.resmedlib.component.view.swing.*;

import javax.swing.*;
import java.awt.*;

/** View Component. This dialog is for editing overlays. This means e.g. drawing new polygons in these overlays.
 * From this dialog the state of working can be managed. The system can be in working mode (normally) or in
 * overlayRegion drawing mode or in overlayRegion editing mode.
 * @author Jens Bohl <info@jens-bohl-professional.de>
 *  */
public class EditOverlayDialog extends SwingView {
    /** Button for showing a painted polygon */
    private JButton showOverlayRegionButton;
    /** Button for deleting a polygon that is only showed on the image */
    private JButton deleteOverlayRegionButton;
    /** Button for saving a new polygon, the createOverlayRegionFrame is showed */
    private JButton saveOverlayRegionButton;
    /** Button for deleting the last point drawn on the image panel */
    private JButton deleteLastPointButton;
    /** Radiobutton for changing into the polygon edit modus */
    private JRadioButton editOverlayRegionRadioButton;
    /** Radiobutton for changing into the point painting modus */
    private JRadioButton paintPointsRadioButton;
    /** Radiobutton for changing into the working modus */
    private JRadioButton workingRadioButton;
    /** Panel consisting of buttons */
    private JPanel buttonPanel;
    /** The model of MVC */
    private RecordModel model;
    /** CombobBox for switching between images */
    private JComboBox fileChooseCombobox;
    /** If this CheckBox is selected all existing polygons for the current image are shown */
    private JCheckBox showOverlayRegionsCheckBox;
    /** The x position of dialog */
    private int dialogXPosition;
    /** The y position of dialog */
    private int dialogYPosition;
    /** Default Constructor */
    public EditOverlayDialog() {
    }

    public Rectangle createDialogBounds() {
        // Determine width.
        int screenWidth = (int) Math.floor(Toolkit.getDefaultToolkit().getScreenSize().getWidth());
        int w = 180;
        if (w > screenWidth) {
            w = screenWidth;
        }
        int x = getDialogXPosition();
        // Determine height.
        int screenHeight = (int) Math.floor(Toolkit.getDefaultToolkit().getScreenSize().getHeight());
        int h = 250;
        if (h > screenHeight) {
            h = screenHeight;
        }
        int y = getDialogXPosition();
        return new Rectangle(x, y, w, h);
    }

    /**
     * Creates a display mode.
     * @return the display mode
     */
    public int createDisplayMode() {
        return DisplayFactory.MODELESS_DIALOG_DISPLAY;
    }

    /**
     * Creates a control issued when the window containing this view is closed.
     * @return the control issued when the window containing this view is closed
     * @exception NullPointerException if the control is null
     */
    public Control createCloseControl() throws NullPointerException {
        Control c = new Control();
        if (c != null) {
            c.setId(Record.DESTROY_LOAD_PATIENT_DIALOG_CONTROL_ID);
            c.setSender((Controller) getController());
        } else {
            throw new NullPointerException("Could not create close control. The control is null.");
        }
        return c;
    }

    /** Finalizes this component. */
    public void finalizz() throws Exception {
        try {
            // Set parameters.
            setBorder(null);
        } finally {
            super.finalizz();
        }
    }

    /** Initialization of components */
    public void initialize() {
        //initialize the button panel, containing buttons, one checkbox and one combobox
        setLayout(new BorderLayout());
        buttonPanel = new JPanel();
        setDialogXPosition(100);
        setDialogYPosition(400);
        GridLayout gridLayout = new GridLayout(4, 1);
        buttonPanel.setLayout(gridLayout);
        gridLayout.setVgap(10);
        setDisplayMode(DisplayFactory.MODELESS_DIALOG_DISPLAY);
        setDialogBounds(createDialogBounds());
        //initialize all buttons in the button panel
        showOverlayRegionButton = new JButton("Preview");
        showOverlayRegionButton.addActionListener((Record) getController());
        showOverlayRegionButton.setActionCommand(Record.EDIT_OVERLAY_NEW_POLYGON_ID);
        showOverlayRegionButton.setEnabled(false);
        showOverlayRegionButton.setToolTipText("Shows preview of the overlay region");
        deleteOverlayRegionButton = new JButton("Remove");
        deleteOverlayRegionButton.addActionListener((Record) getController());
        deleteOverlayRegionButton.setActionCommand(Record.EDIT_OVERLAY_DELETE_POLYGON_ID);
        deleteOverlayRegionButton.setEnabled(false);
        deleteOverlayRegionButton.setToolTipText("Remove overlay region preview");
        saveOverlayRegionButton = new JButton("Save");
        saveOverlayRegionButton.addActionListener((Record) getController());
        saveOverlayRegionButton.setActionCommand(Record.EDIT_OVERLAY_SAVE_POLYGON_ID);
        saveOverlayRegionButton.setEnabled(false);
        saveOverlayRegionButton.setToolTipText("Save overlay region");
        deleteLastPointButton = new JButton("Remove last point");
        deleteLastPointButton.addActionListener((Record) getController());
        deleteLastPointButton.setActionCommand(Record.EDIT_OVERLAY_DELETE_LAST_POINT_ID);
        deleteLastPointButton.setEnabled(false);
        deleteLastPointButton.setToolTipText("remove last point of overlay region");
        editOverlayRegionRadioButton = new JRadioButton("Edit");
        editOverlayRegionRadioButton.setEnabled(true);
        editOverlayRegionRadioButton.setToolTipText("edit overlay region");
        paintPointsRadioButton = new JRadioButton("Points");
        paintPointsRadioButton.setEnabled(true);
        paintPointsRadioButton.setToolTipText("draw points");
        workingRadioButton = new JRadioButton("Work");
        workingRadioButton.setEnabled(true);
        workingRadioButton.setToolTipText("sets working mode");
        workingRadioButton.setSelected(true);
        if (((RecordModel) getModel()).getFileNames() != null) {
            fileChooseCombobox = new JComboBox(((RecordModel) getModel()).getFileNames());
        } else
            fileChooseCombobox = new JComboBox();
        fileChooseCombobox.addActionListener((Record) getController());
        fileChooseCombobox.setActionCommand(Record.EDIT_OVERLAY_CHOOSE_FILE_ID);
        fileChooseCombobox.setToolTipText("Image Auswahl");
        showOverlayRegionsCheckBox = new JCheckBox("Show all overlay regions");
        showOverlayRegionsCheckBox.addItemListener((Record) getController());
        ButtonGroup buttongroup = new ButtonGroup();
        buttongroup.add(editOverlayRegionRadioButton);
        buttongroup.add(paintPointsRadioButton);
        buttongroup.add(workingRadioButton);

        buttonPanel.add(showOverlayRegionButton);
        buttonPanel.add(deleteOverlayRegionButton);
        buttonPanel.add(saveOverlayRegionButton);
        buttonPanel.add(deleteLastPointButton);
        //buttonPanel.add(fileChooseCombobox);
        buttonPanel.add(editOverlayRegionRadioButton);
        buttonPanel.add(paintPointsRadioButton);
        buttonPanel.add(workingRadioButton);
        buttonPanel.setBorder(BorderFactory.createTitledBorder("Overlay Regions"));

        GridLayout radioButtonLayout = new GridLayout(1,4);
        radioButtonLayout.setVgap(2);
        JPanel radioButtonPanel = new JPanel(radioButtonLayout);
        radioButtonPanel.add(editOverlayRegionRadioButton);
        radioButtonPanel.add(paintPointsRadioButton);
        radioButtonPanel.add(workingRadioButton);
        radioButtonPanel.setBorder(BorderFactory.createTitledBorder("Mode"));
        add(buttonPanel,BorderLayout.NORTH);
        add(radioButtonPanel,BorderLayout.CENTER);
        add(showOverlayRegionsCheckBox,BorderLayout.SOUTH);
        //		pack();
    }
    /**Gets the showShowOverlayRegionButton
     * @return  the showShowOverlayRegionButton
     */
    public JButton getShowOverlayRegionButton() {
        return showOverlayRegionButton;
    }
    /**Sets the showShowOverlayRegionButton
     * @param  the showShowOverlayRegionButton
     */
    public void setShowOverlayRegionButton(JButton showOverlayRegionButton) {
        this.showOverlayRegionButton = showOverlayRegionButton;
    }
    /**Gets the deleteOverlayRegionButton
     * @return  the deleteOverlayRegionButton
     */
    public JButton getDeleteOverlayRegionButton() {
        return deleteOverlayRegionButton;
    }
    /**Sets the deleteOverlayRegionButton
     * @param  the deleteOverlayRegionButton
     */
    public void setDeleteOverlayRegionButton(JButton deleteOverlayRegionButton) {
        this.deleteOverlayRegionButton = deleteOverlayRegionButton;
    }
    /**Gets the saveOverlayRegionButton
     * @return  the saveOverlayRegionButton
     */
    public JButton getSaveOverlayRegionButton() {
        return saveOverlayRegionButton;
    }
    /**Sets the saveOverlayRegionButton
     * @param the saveOverlayRegionButton
     */
    public void setSaveOverlayRegionButton(JButton saveOverlayRegionButton) {
        this.saveOverlayRegionButton = saveOverlayRegionButton;
    }
    /**Gets the deleteLastPointButton
     * @return  the deleteLastPointButton
     */
    public JButton getDeleteLastPointButton() {
        return deleteLastPointButton;
    }
    /**Sets the deleteLastPointButton
     * @param deleteLastPointButton the deleteLastPointButton
     */
    public void setDeleteLastPointButton(JButton deleteLastPointButton) {
        this.deleteLastPointButton = deleteLastPointButton;
    }
    /**Gets the editOverlayRegionRadioButton
     * @return  ditOverlayRegionRadioButton the ditOverlayRegionRadioButton
     */
    public JRadioButton getEditOverlayRegionRadioButton() {
        return editOverlayRegionRadioButton;
    }
    /**Sets the ditOverlayRegionRadioButton
     * @return  the ditOverlayRegionRadioButton
     */
    public void setEditOverlayRegionRadioButton(JRadioButton editOverlayRegionRadioButton) {
        this.editOverlayRegionRadioButton = editOverlayRegionRadioButton;
    }
    /**Gets the paintPointsRadioButton
     * @return  the paintPointsRadioButton
     */
    public JRadioButton getPaintPointsRadioButton() {
        return paintPointsRadioButton;
    }
    /**Sets the paintPointsRadioButton
     * @param paintPointsRadioButton the paintPointsRadioButton
     */
    public void setPaintPointsRadioButton(JRadioButton paintPointsRadioButton) {
        this.paintPointsRadioButton = paintPointsRadioButton;
    }
    /**Gets the workingRadioButton
     * @return the workingRadioButton
     */
    public JRadioButton getWorkingRadioButton() {
        return workingRadioButton;
    }
    /**Sets the workingRadioButton
     * @param workingRadioButton the workingRadioButton
     */
    public void setWorkingRadioButton(JRadioButton workingRadioButton) {
        this.workingRadioButton = workingRadioButton;
    }
    /**Gets the buttonPanel
     * @return  the buttonPanel
     */
    public JPanel getButtonPanel() {
        return buttonPanel;
    }
    /**Sets the buttonPanel
     * @param buttonPanel  the buttonPanel
     */
    public void setButtonPanel(JPanel buttonPanel) {
        this.buttonPanel = buttonPanel;
    }

    /**Gets the fileChooseCombobox
     * @return the fileChooseCombobox
     */
    public JComboBox getFileChooseCombobox() {
        return fileChooseCombobox;
    }

    /**Sets the showOverlayRegionsCheckBox
     * @param fileChooseCombobox the fileChooseCombobox
     */
    public void setFileChooseCombobox(JComboBox fileChooseCombobox) {
        this.fileChooseCombobox = fileChooseCombobox;
    }

    /**Gets the showOverlayRegionsCheckBox
     * @return  the showOverlayRegionsCheckBox
     */
    public JCheckBox getShowOverlayRegionsCheckBox() {
        return showOverlayRegionsCheckBox;
    }

    /**Sets the showOverlayRegionsCheckBox
     * @param showOverlayRegionsCheckBox the showOverlayRegionsCheckBox
     */
    public void setShowOverlayRegionsCheckBox(JCheckBox showOverlayRegionsCheckBox) {
        this.showOverlayRegionsCheckBox = showOverlayRegionsCheckBox;
    }

    /**Gets the x position of the dialog
     * @return the x position
     */
    public int getDialogXPosition() {
        return dialogXPosition;
    }

    /**Sets the x position of the dialog
     * @param the x position
     */
    public void setDialogXPosition(int dialogXPosition) {
        this.dialogXPosition = dialogXPosition;
    }

    /**Gets the y position of the dialog
     * @return the y position
     */
    public int getDialogYPosition() {
        return dialogYPosition;
    }

    /**Sets the y position of the dialog
     * @param the y position
     */
    public void setDialogYPosition(int dialogYPosition) {
        this.dialogYPosition = dialogYPosition;
    }
}
