/*
 * $RCSfile: EditAlternativeOverlayDialog.java,v $
 *
 * Copyright (c) 1999-2002. Jens Bohl. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.application.healthcare.record.topology;

import org.resmedicinae.application.healthcare.record.*;
import org.resmedicinae.resmedlib.component.control.*;
import org.resmedicinae.resmedlib.component.view.swing.*;

import javax.swing.*;
import javax.swing.tree.DefaultTreeModel;
import java.awt.*;

/**View component. With the help of this dialog editing of alternative overlays can be done.
 * @author Jens Bohl <info@jens-bohl-professional.de>
 */
public class EditAlternativeOverlayDialog extends SwingView {
    /** List containing all overlays */
    private JList allOverlaysList;

    /** Listmodel for allOverlaysList */
    private DefaultListModel allOverlaysListModel;

    /** List containing all alternative overlays */
    private JList alternativeOverlaysList;

    /** Listmodel for alternativeOverlaysList */
    private DefaultListModel alternativeOverlaysListModel;

    /** Add button */
    private JButton addButton;

    /** Ok button */
    private JButton okButton;

    /** Cancel button */
    private JButton cancelButton;

    /** Remove button */
    private JButton removeButton;

    /** The layout manager */
    private GridBagLayout gridBag;

    /** The constraints of the dialog */
    private GridBagConstraints c;



    /**The scrollPane of the alternative overlays list
     *
     */
    private JScrollPane allOverlaysTreeScrollPane;

    public EditAlternativeOverlayDialog() {
    }

    public void initialize() {
        gridBag = new GridBagLayout();
        c = new GridBagConstraints();
        setLayout(gridBag);
        setTitle("Edit alternative overlays...");
        addKeyListener((Record) getController());
        //?? Temporary! The display mode of this about dialog is read from the configuration of the application (and such is FRAME_DISPLAY)!
        setDisplayMode(DisplayFactory.MODELESS_DIALOG_DISPLAY);
        //?? Temporary! The dialog bounds of this about dialog are read from the configuration of the application!
        setDialogBounds(createDialogBounds());
        setAllOverlaysList(createAllOverlaysList());
        setAlternativeOverlaysList(createAternativeOverlaysList());
        setOkButton(createOkButton());
        setAddButton(createAddButton());
        setRemoveButton(createRemoveButton());
        setCancelButton(createCancelButton());

        JScrollPane allOverlaysTreeScrollPane = new JScrollPane(getAllOverlaysList());
        setAllOverlaysTreeScrollPane(allOverlaysTreeScrollPane);
        allOverlaysTreeScrollPane.setBorder(BorderFactory.createTitledBorder("All Overlays"));
        JScrollPane altOverlaysTreeScrollPane = new JScrollPane(getAlternativeOverlaysList());
        altOverlaysTreeScrollPane.setBorder(BorderFactory.createTitledBorder("Alternative Overlays"));
        allOverlaysTreeScrollPane.setPreferredSize(new Dimension(250, 200));
        altOverlaysTreeScrollPane.setPreferredSize(new Dimension(250, 200));
        allOverlaysTreeScrollPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
        allOverlaysTreeScrollPane.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED);
        altOverlaysTreeScrollPane.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED);
        altOverlaysTreeScrollPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);

        c.anchor = GridBagConstraints.EAST;
        c.insets = new Insets(5, 10, 0, 10);
        c.gridheight = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.fill = GridBagConstraints.HORIZONTAL;
        gridBag.setConstraints(getAllOverlaysList(), c);
        add(allOverlaysTreeScrollPane);

        c.anchor = GridBagConstraints.CENTER;
        c.insets = new Insets(5, 10, 0, 10);
        c.gridheight = 1;
        c.gridx = 1;
        c.gridy = 0;
        gridBag.setConstraints(getAddButton(), c);
        add(getAddButton());

        c.anchor = GridBagConstraints.EAST;
        c.insets = new Insets(5, 10, 0, 10);
        c.gridheight = 2;
        c.gridx = 2;
        c.gridy = 0;
        gridBag.setConstraints(getAlternativeOverlaysList(), c);
        add(altOverlaysTreeScrollPane);

        c.anchor = GridBagConstraints.EAST;
        c.insets = new Insets(5, 10, 0, 10);
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 2;
        gridBag.setConstraints(getOkButton(), c);
        add(getOkButton());

        c.anchor = GridBagConstraints.CENTER;
        c.insets = new Insets(5, 10, 0, 10);
        c.gridheight = 1;
        c.gridx = 1;
        c.gridy = 2;
        gridBag.setConstraints(getRemoveButton(), c);
        add(getRemoveButton());

        c.anchor = GridBagConstraints.EAST;
        c.insets = new Insets(5, 10, 0, 10);
        c.gridheight = 1;
        c.gridx = 2;
        c.gridy = 2;
        gridBag.setConstraints(getCancelButton(), c);
        add(getCancelButton());

    }

    /**
     * Creates a rectangle storing the dialog bounds.
     * @return the rectangle storing the dialog bounds
     */
    public Rectangle createDialogBounds() {
        // Determine width.
        int screenWidth = (int) Math.floor(Toolkit.getDefaultToolkit().getScreenSize().getWidth());
        int w = 650;
        if (w > screenWidth) {
            w = screenWidth;
        }
        // Use centered x position by default.
        int x = (screenWidth - w) / 2;
        // Determine height.
        int screenHeight = (int) Math.floor(Toolkit.getDefaultToolkit().getScreenSize().getHeight());
        int h = 300;
        if (h > screenHeight) {
            h = screenHeight;
        }
        // Use centered y position by default.
        int y = (screenHeight - h) / 2;
        return new Rectangle(x, y, w, h);
    }
    //
    // Display mode.
    //

    /**
     * Creates a display mode.
     * @return the display mode
     */
    public int createDisplayMode() {
        return DisplayFactory.MODELESS_DIALOG_DISPLAY;
    }
    //
    // Close control.
    //

    /**
     * Creates a control issued when the window containing this view is closed.
     * @return the control issued when the window containing this view is closed
     * @exception NullPointerException if the control is null
     */
    public Control createCloseControl() throws NullPointerException {
        Control c = new Control();
        if (c != null) {
            c.setId(Record.DESTROY_LOAD_PATIENT_DIALOG_CONTROL_ID);
            c.setSender((Controller) getController());
        } else {
            throw new NullPointerException("Could not create close control. The control is null.");
        }
        return c;
    }

    /** Finalizes this component. */
    public void finalizz() throws Exception {
        try {
            // Set parameters.
            setBorder(null);
        } finally {
            super.finalizz();
        }
    }

    public JList createAllOverlaysList() {
        RecordModel model = (RecordModel) getModel();
        JList l = new JList();
        if (l != null) {
            //l.setVisibleRowCount(500);
            setAllOverlaysListModel(new DefaultListModel());
            //getAllOverlaysListModel().ensureCapacity(50);
            l.setModel(getAllOverlaysListModel());
            //l.setPreferredSize(new Dimension(250, 200));
        } else {
            throw new NullPointerException("Could not create all overlays list. The list is null.");
        }
        return l;
    }

    public JList getAllOverlaysList() {
        return this.allOverlaysList;
    }

    public void setAllOverlaysList(JList allOverlaysList) {
        this.allOverlaysList = allOverlaysList;
    }

    public JList createAternativeOverlaysList() {
        JList l = new JList();
        if (l != null) {
            setAlternativeOverlaysListModel(new DefaultListModel());
            l.setModel(getAlternativeOverlaysListModel());
            l.setPreferredSize(new Dimension(250, 200));
        } else {
            throw new NullPointerException("Could not create alternative overlays list. The list is null.");
        }
        return l;
    }

    public JList getAlternativeOverlaysList() {
        return alternativeOverlaysList;
    }

    public void setAlternativeOverlaysList(JList alternativeOverlaysList) {
        this.alternativeOverlaysList = alternativeOverlaysList;
    }

    public JButton createAddButton() {
        JButton b = new JButton();
        if (b != null) {
            b.setText(">>");
            b.addActionListener((Record) getController());
            b.setActionCommand(Record.EDIT_ALTERNATIVE_OVERLAY_DIALOG_ADD_ID);
        } else {
            throw new NullPointerException("Could not create cancel button. The button is null.");
        }
        return b;
    }

    public JButton getAddButton() {
        return addButton;
    }

    public void setAddButton(JButton addButton) {
        this.addButton = addButton;
    }

    public JButton createOkButton() {
        JButton b = new JButton();
        if (b != null) {
            b.setText("Ok");
            b.addActionListener((Record) getController());
            b.setActionCommand(Record.EDIT_ALTERNATIVE_OVERLAY_DIALOG_OK_ID);
        } else {
            throw new NullPointerException("Could not create ok button. The button is null.");
        }
        return b;
    }

    public JButton getOkButton() {
        return okButton;
    }

    public void setOkButton(JButton okButton) {
        this.okButton = okButton;
    }

    public JButton createCancelButton() {
        JButton b = new JButton();
        if (b != null) {
            b.setText("Cancel");
            b.addActionListener((Record) getController());
            b.setActionCommand(Record.EDIT_ALTERNATIVE_OVERLAY_DIALOG_CANCEL_ID);
        } else {
            throw new NullPointerException("Could not create cancel button. The button is null.");
        }
        return b;
    }

    public JButton getCancelButton() {
        return cancelButton;
    }

    public void setCancelButton(JButton cancelButton) {
        this.cancelButton = cancelButton;
    }

    public JButton createRemoveButton() {
        JButton b = new JButton();
        if (b != null) {
            b.setText("Remove");
            b.addActionListener((Record) getController());
            b.setActionCommand(Record.EDIT_ALTERNATIVE_OVERLAY_DIALOG_REMOVE_ID);
        } else {
            throw new NullPointerException("Could not create remove button. The button is null.");
        }
        return b;
    }

    public JButton getRemoveButton() {
        return removeButton;
    }

    public void setRemoveButton(JButton removeButton) {
        this.removeButton = removeButton;
    }

    public GridBagConstraints getC() {
        return c;
    }

    public void setC(GridBagConstraints c) {
        this.c = c;
    }

    public GridBagLayout getGridBag() {
        return gridBag;
    }

    public void setGridBag(GridBagLayout gridBag) {
        this.gridBag = gridBag;
    }

    public DefaultListModel getAllOverlaysListModel() {
        return allOverlaysListModel;
    }

    public void setAllOverlaysListModel(DefaultListModel allOverlaysListModel) {
        this.allOverlaysListModel = allOverlaysListModel;
    }

    public DefaultListModel getAlternativeOverlaysListModel() {
        return alternativeOverlaysListModel;
    }

    public void setAlternativeOverlaysListModel(DefaultListModel alternativeOverlaysListModel) {
        this.alternativeOverlaysListModel = alternativeOverlaysListModel;
    }

    public JScrollPane getAllOverlaysTreeScrollPane() {
        return allOverlaysTreeScrollPane;
    }

    public void setAllOverlaysTreeScrollPane(JScrollPane allOverlaysTreeScrollPane) {
        this.allOverlaysTreeScrollPane = allOverlaysTreeScrollPane;
    }
}
