/*
 * Created by IntelliJ IDEA.
 * User: Jens Bohl
 * Date: 04.12.2002
 * Time: 10:15:43
 * To change template for new class use 
 * Code Style | Class Templates options (Tools | IDE Options).
 */
package org.resmedicinae.application.healthcare.record.topology;

import org.resmedicinae.domain.healthcare.Heading;

/**This class represents a disease. A disease can be use for documentation of objectives with the help of the
 * topological part of Record.
 * @author Jens Bohl <info@jens-bohl-professional.de>
 */
public class Disease extends Heading{

    /**The Name of the disease. Has to be unique because no primary key is used. */
    private String diseaseName;
    /**The description of the disease. Further information about the disease.*/
    private String diseaseDescription;

    /**Gets the name of the disease
     * @return the name of the disease
     * */
    public String getDiseaseName() {
        return diseaseName;
    }

    /**Sets the name of the disease
     * @param diseaseName the name of the disease
     * */
    public void setDiseaseName(String diseaseName) {
        this.diseaseName = diseaseName;
    }
    /**Gets the description of the disease
     * @return the description of the disease
     * */
    public String getDiseaseDescription() {
        return diseaseDescription;
    }

    /**Sets the name of the disease
     * @param diseaseDescription the description of the disease
     * */
    public void setDiseaseDescription(String diseaseDescription) {
        this.diseaseDescription = diseaseDescription;
    }

    /**String representation of the disease: the disease name (is needed for presentation of the disease in the
     * overlay treeTable.
     * @return the name of the disease
     */
    public String toString(){
        return getDiseaseName();
    }
}
