/*

 * $RCSfile: RecordViewConfiguration.java,v $

 *

 * Copyright (c) 1999-2002. Christian Heller. All rights reserved.

 *

 * This software is published under the GPL GNU General Public License.

 * This program is free software; you can redistribute it and/or

 * modify it under the terms of the GNU General Public License

 * as published by the Free Software Foundation; either version 2

 * of the License, or (at your option) any later version.

 *

 * This program is distributed in the hope that it will be useful,

 * but WITHOUT ANY WARRANTY; without even the implied warranty of

 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the

 * GNU General Public License for more details.

 *

 * You should have received a copy of the GNU General Public License

 * along with this program; if not, write to the Free Software

 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

 *

 * http://www.resmedicinae.org

 * - Information in Medicine -

 */

package org.resmedicinae.application.healthcare.record;

import org.resmedicinae.resmedlib.component.configuration.*;

import javax.swing.tree.*;
import java.util.*;

/**
 * This class represents the record view configuration.
 * @version $Revision: 1.9 $ $Date: 2002/10/17 15:44:00 $ $Author: zone3 $
 * @author Christian Heller <christian.heller@tuxtax.de>
 */
public class RecordViewConfiguration extends Configuration {
    //
    // Preference keys.
    //

    /** The info panels count. */
    static final String INFO_PANELS_COUNT = "info_panels_count";

    /** The info panels. */
    static final String INFO_PANELS = "info_panels";

    /**
     * Returns the overview tree.
     * @return the overview tree
     * @exception NullPointerException if the tree node is null
     */
    public TreeNode getOverviewTree() {
        MutableTreeNode t = new DefaultMutableTreeNode("root");

/*??

        int c = getAvailableApplicationsCount();

        int i;

        String s;

        boolean enabled;

        String name;

*/

        //?? --- Dirty temporary solution. Start. ---
        MutableTreeNode parent = null;
        MutableTreeNode n = null;
        parent = new DefaultMutableTreeNode("Photo");
        n = new DefaultMutableTreeNode("image.jpeg");
        parent.insert(n, parent.getChildCount());
        t.insert(parent, t.getChildCount());

/*??

Stammdaten

Name,

Geschlecht

Adresse

Kontaktmglichkeiten

*/

        parent = new DefaultMutableTreeNode("Stammdaten");
        n = new DefaultMutableTreeNode("Max Mustermann");
        parent.insert(n, parent.getChildCount());
        n = new DefaultMutableTreeNode("M");
        parent.insert(n, parent.getChildCount());
        n = new DefaultMutableTreeNode("Strae 1, 12345 Stadt");
        parent.insert(n, parent.getChildCount());
        n = new DefaultMutableTreeNode("Was als Kontakt??");
        parent.insert(n, parent.getChildCount());
        t.insert(parent, t.getChildCount());

/*??

Versicherungsdaten

- Art der Kasse (privat/gesetzlich)

- Name der Kasse (...)

- existiert ein offener BG-Fall ?

*/

        parent = new DefaultMutableTreeNode("Versicherungsdaten");
        n = new DefaultMutableTreeNode("gesetzlich");
        parent.insert(n, parent.getChildCount());
        n = new DefaultMutableTreeNode("AOK");
        parent.insert(n, parent.getChildCount());
        n = new DefaultMutableTreeNode("offener BG Fall");
        parent.insert(n, parent.getChildCount());
        t.insert(parent, t.getChildCount());

/*??

Cave-Eintrge

- Allergien

- eigene Hinweise/Kurznotizen

- zu beachtende Medikation

- Schwangerschaft

{ "PM", "Schrittmacher", "test", new Integer(5), new Boolean(false) },

{ "Falithrom", "Marcumar-", "Prophylaxe", new Integer(20), new Boolean(true) },

{ "Allergie", "test", "test", new Integer(4), new Boolean(false) }

String[] columnNames = { "Warning", "Allergy", "Description" };

*/

        parent = new DefaultMutableTreeNode("Cave-Eintrge");
        n = new DefaultMutableTreeNode("Allergien");
        parent.insert(n, parent.getChildCount());
        n = new DefaultMutableTreeNode("eigene Hinweise/Kurznotizen");
        parent.insert(n, parent.getChildCount());
        n = new DefaultMutableTreeNode("zu beachtende Medikation");
        parent.insert(n, parent.getChildCount());
        n = new DefaultMutableTreeNode("Schwangerschaft");
        parent.insert(n, parent.getChildCount());
        t.insert(parent, t.getChildCount());

/*??

medizinische Problemliste/Letzter Kontakt

- Diagnosen/Episoden

- wann zuletzt deswegen

- ggf. hierarchisch geordnet (von mir zugeordnet)

*/

        parent = new DefaultMutableTreeNode("medizinische Problemliste/Letzter Kontakt");
        n = new DefaultMutableTreeNode("Diagnosen/Episoden");
        parent.insert(n, parent.getChildCount());
        n = new DefaultMutableTreeNode("wann zuletzt deswegen");
        parent.insert(n, parent.getChildCount());
        t.insert(parent, t.getChildCount());

/*??

Medikation = Prescriptions

- zuletzt verschriebene oben bzw. markiert

- warum verschrieben (ein/zwei Worte, mssen von mir zugeordnet worden sein)

- wann verschrieben

- ob lt. Packungsgre/Einnahmefrequenz alle oder nicht

*/

        parent = new DefaultMutableTreeNode("Medikation");
        n = new DefaultMutableTreeNode("zuletzt verschrieben");
        parent.insert(n, parent.getChildCount());
        n = new DefaultMutableTreeNode("warum verschrieben");
        parent.insert(n, parent.getChildCount());
        n = new DefaultMutableTreeNode("wann verschrieben");
        parent.insert(n, parent.getChildCount());
        n = new DefaultMutableTreeNode("lt. Packungsgre/Einnahmefrequenz alle?");
        parent.insert(n, parent.getChildCount());
        t.insert(parent, t.getChildCount());

/*??

ausstehende Dinge

- Impfungen

- sonstige Dinge, die zu tun sind

- wenn Termin vorhanden: wie lange berschritten/wie lange noch bis hin

- Wiedervorlage von Diagnosen (Frequenz mu von mir zugeordnet werden)

*/

        parent = new DefaultMutableTreeNode("Recall");
        n = new DefaultMutableTreeNode("Impfungen");
        parent.insert(n, parent.getChildCount());
        n = new DefaultMutableTreeNode("Sonstiges");
        parent.insert(n, parent.getChildCount());
        n = new DefaultMutableTreeNode("Termin wie lange berschritten?");
        parent.insert(n, parent.getChildCount());
        n = new DefaultMutableTreeNode("Wiedervorlage von Diagnosen");
        parent.insert(n, parent.getChildCount());
        t.insert(parent, t.getChildCount());
        //??            fireModelChange(VALUE_CHANGED, Selector.fromString("overviewTree"));
        //?? --- end ---

/*??

        if (c > 0) {



            for (i = 0; i < c; i++) {



                s = getPreferences().get(ResMedicinaeConfiguration.INFO_PANELS + "_" + Integer.toString(i), "");

                category = determineApplicationCategory(s);

                external = determineExternalApplication(s);

                location = determineApplicationLocation(s);



                createApplicationTreeBranch(category, external, location, n);

            }



        } else {



            for (i = 0; i < 10; i++) {



                s = getDefaultAvailableApplication(i);

                category = determineApplicationCategory(s);

                external = determineExternalApplication(s);

                location = determineApplicationLocation(s);



                createApplicationTreeBranch(category, external, location, n);

            }

        }

*/

        return t;
    }

    /**
     * Sets the overview tree.
     * @param n the overview tree
     */
    public void setOverviewTree(TreeNode n) {
        if (n != null) {
            Enumeration enum = ((DefaultMutableTreeNode) n).depthFirstEnumeration();
            if (enum != null) {
                Object o;
                int i = -1;
                while (enum.hasMoreElements() == true) {
                    o = enum.nextElement();
                    i = i + 1;
                    if (o != null) {
                        getPreferences().put(RecordViewConfiguration.INFO_PANELS + "_" + Integer.toString(i), o.toString());
                    }
                }
            }
        }
    }
}
