/*
 * $RCSfile: RecordView.java,v $
 *
 * Copyright (c) 1999-2002. Christian Heller. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.application.healthcare.record;

import com.jrefinery.chart.*;
import com.jrefinery.data.*;
import org.resmedicinae.application.healthcare.record.topology.*;
import org.resmedicinae.application.healthcare.record.treetable.*;
import org.resmedicinae.application.healthcare.reform.application.common.basic.*;
import org.resmedicinae.resmedlib.component.control.*;
import org.resmedicinae.resmedlib.component.view.swing.*;

import javax.swing.*;
import javax.swing.event.TreeSelectionListener;
import javax.swing.border.*;
import javax.swing.tree.*;
import java.awt.*;
import java.awt.event.*;

/**
 * This class represents the Record view.
 * @version $Revision: 1.54 $ $Date: 2003/01/13 20:36:16 $ $Author: tristan24 $
 * @author Christian Heller <christian.heller@tuxtax.de>
 * @author Jens Bohl <info@jens-bohl-professional.de>
 */
public class RecordView extends SwingView {
    //
    // Attributes.
    //

    /** The split pane. */
    private ResSplitPane splitPane;

    /** Button for moving one step back to the last image */
    private JButton historyBackButton;

    /** Label showing the status */
    private TopologyLabel statusLabel;

    /** name label, static */
    private TopologyLabel overlayRegionNameLabel;

    /** Label showing dynmamically the name of the overlayRegion the mouse is over */
    private TopologyLabel overlayRegionNameEntryLabel;

    /** target label, static */
    private TopologyLabel overlayRegionTargetLabel;

    /** Label showing dynmamically the target of the overlayRegion the mouse is over */
    private TopologyLabel overlayRegionTargetEntryLabel;

    /** Panel showing the topology chart */
    private JPanel topologyChart;

    /** Panel displaying the currentImage */
    private ImagePanel imagePanel;
    private PatientInfoPanel patientInfoPanel;
    private JPanel regionInfoPanel;
    private JCheckBox grabFocusCheckBox;
    private TopologyTextArea reportTextArea;
    private JPanel overlayRegionInfoPanel;
    private PreviewPanel previewPanel;
    private TreeTablePanel treeTablePanel;

    /** The menu bar */
    private JMenuBar menubar;

    /** Menu for system operations */
    private JMenu systemMenu;

    /** Menu item for exit */
    private JMenuItem exit;

    /** Menu for dealing with patients */
    private JMenu patientMenu;

    /** Menu item for creating an new patient. */
    private JMenuItem newPatient;

    /** Menu item for loading an existing patient */
    private JMenuItem loadPatient;

    /** Menu item for saving the current ehr */
    private JMenuItem savePatient;

    /** Menu item for creating a new CAVE entry */
    private JMenuItem newCAVEEntry;

    /** Menu item for removing a new CAVE entry */
    private JMenuItem removeCAVEEntry;

    /** Menu for handling image action e.g. creating or deleting an image */
    private JMenu imageMenu;

    /** Menu item for creating a new image. */
    private JMenuItem newImage;

    /** Menu item for deleting an image. */
    private JMenuItem delImage;

    /** Menu item for editing an image. */
    private JMenuItem editImage;

    /** Menu item for editing alternative overlays. */
    private JMenuItem editAlternativeOverlay;

    /** Menu item for showing alternative overlays. */
    private JMenuItem showAlternativeOverlay;

    /**Menu for managing diseases*/
    private JMenu diseaseMenu;

    /** Menu item for creating an new disease */
    private JMenuItem newDisease;

    /** Menu for markers */
    private JMenu markerMenu;

    /** Menu item for saving markers. */
    private JMenuItem saveMarkers;

    /** Menu for dealing with settings */
    private JMenu settingsMenu;

    /** Menu item for changing overlayRegion settings. */
    private JMenuItem overlayRegionSettings;

    /** Menu item for changing into not filled overlayRegion drawing. */
    private JRadioButtonMenuItem drawOverlayRegion;

    /** Menu item for changing into red filled overlayRegion drawing. */
    private JRadioButtonMenuItem fillOverlayRegion;

    /** Menu item for changing into alpha red filled overlayRegion drawing. */
    private JRadioButtonMenuItem fillOverlayRegionAlpha;

    /** Menu item for changing communication. */
    private ResMenuItem communicationSelectorMenuItem;

    /** Menu item for changing patientInfoPanel settings. */
    private JMenuItem patientInfoPanelSettings;

    /** Menu item for changing into not filled overlayRegion drawing. */
    private JCheckBoxMenuItem showCaveList;

    /** Menu item for changing into red filled overlayRegion drawing. */
    private JCheckBoxMenuItem showMedicamentList;

    /** Menu item for changing into alpha red filled overlayRegion drawing. */
    private JCheckBoxMenuItem showProblemList;

    /** Menu for dealing with episodes */
    private JMenu episodesMenu;

    /** Menu item for creating a new episode. */
    private JMenuItem newEpisode;

    /** Menu item for deleting an episode. */
    private JMenuItem delEpisode;

    /** Menu for dealing with problems */
    private JMenu problemsMenu;

    /** Menu item for creating a new problem. */
    private JMenuItem newProblem;

    /** Menu item for deleting a problem. */
    private JMenuItem delProblem;

    /** Menu for dealing with windows */
    private JMenu windowsMenu;

    /** Menu item for creating a new episode. */
    private JMenuItem closeActiveWindow;

    /** Menu for help */
    private JMenu helpMenu;

    /** Menu item for monitoring and changing the keyboard configuration.. */
    private JMenuItem keyBoardConfiguration;

    /** Menu item for showing the manual. */
    private JMenuItem helpManual;

    /** A toolbar. */
    private ResToolBar toolBar;

    /** Problem list */
    private JComboBox problemComboBox;

    /** Problem list model */
    private DefaultListModel listModel = new DefaultListModel();

    /*Text area with information about the current image. This means
    *for example the latin description of the region shown in the image.
    */

    private TopologyTextArea imageInfoTextArea;
    private ObjectModel objectModel;

    /** Panel containing a textArea for showing status and hints */
    private ResPanel statusAndInformationPanel;

    /*TextArea for presenting status and hints*/

    private JLabel statusAndInformationLabel;

    /** Panel for containing the report */
    private JPanel monitorReportPanel;

    /** Checkbox for showing markers or not */
    private JCheckBox showMarkersCheckBox;

    /** Panel containing buttons for managing overlays */
    private JPanel managePanel;

    /** Button for changing to start overlay */
    private JButton backToStartOverlayButton;

    /** Button for changing to alternative overlays */
    private JButton alternativeOverlayButton;

    /** Button for saving markers */
    private JButton saveMarkersButton;

    /** Button for deleting markers */
    private JButton removeAllMarkersButton;

    /** Marker label */
    private TopologyLabel markerLabel;

    /** Overlay label */
    private TopologyLabel overlayLabel;

    /** Control label */
    private TopologyLabel controlLabel;

    /** An ampty label */
    private TopologyLabel emptyLabel;

    /** An object label */
    private TopologyLabel objectLabel;

    /** Button for changing the current object */
    private JButton changeObjectButton;

    /** Button for removing the current object */
    private JButton removeCurrentObjectButton;

    /**Tree for displaying overlays in hierarchical order*/
    private OverlayTree overlayTree;

    /**Tree model for overlay tree*/
    private OverlayTreeModel overlayTreeModel;



    //
    // Menu bar.
    //

    /**
     * Returns the menu bar. ??Todo: Replace return type with ResMenuBar
     * @return the menu bar
     */
    public ResMenuBar createMenuBar() {
        ResMenuBar mb = new ResMenuBar();
        systemMenu = new JMenu("System");
        mb.add(systemMenu);
        communicationSelectorMenuItem = new ResMenuItem();
        communicationSelectorMenuItem.setText(AdvancedBasicApplication.COMMUNICATION_SELECTOR_CONTROL_ID);
        communicationSelectorMenuItem.setMnemonic(KeyEvent.VK_C);
        communicationSelectorMenuItem.setControlId(AdvancedBasicApplication.COMMUNICATION_SELECTOR_CONTROL_ID);
        communicationSelectorMenuItem.setOwner(this);
        communicationSelectorMenuItem.setEnabled(true);
        communicationSelectorMenuItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_J, ActionEvent.CTRL_MASK));
        communicationSelectorMenuItem.addActionListener((Record) getController());
        systemMenu.add(communicationSelectorMenuItem);
        exit = new JMenuItem("Exit");
        exit.addActionListener((Record) getController());
        exit.setActionCommand(Record.SYSTEM_EXIT_ID);
        systemMenu.add(exit);
        //initializing the Patient menu
        patientMenu = new JMenu("Patient");
        mb.add(patientMenu);
        newPatient = new JMenuItem("New Patient...");
        newPatient.addActionListener((Record) getController());
        newPatient.setActionCommand(AdvancedBasicApplication.NEW_HEALTHRECORD_CONTROL_ID);
        newPatient.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_F3, 0));
        loadPatient = new JMenuItem("Load patient...");
        loadPatient.addActionListener((Record) getController());
        loadPatient.setActionCommand(AdvancedBasicApplication.OPEN_INDEX_CONTROL_ID);
        loadPatient.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_F2, 0));
        savePatient = new JMenuItem("Save patient");
        savePatient.addActionListener((Record) getController());
        savePatient.setActionCommand(AdvancedBasicApplication.SAVE_HEALTHRECORD_CONTROL_ID);
        savePatient.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_F6, 0));
        newCAVEEntry = new JMenuItem("New CAVE!-Entry...");
        newCAVEEntry.addActionListener((Record) getController());
        newCAVEEntry.setActionCommand(Record.NEW_CAVE_ENTRY_ID);
        removeCAVEEntry = new JMenuItem("Remove CAVE!-Entry");
        removeCAVEEntry.addActionListener((Record) getController());
        removeCAVEEntry.setActionCommand(Record.REMOVE_CAVE_ENTRY_ID);
        patientMenu.add(newPatient);
        patientMenu.add(loadPatient);
        patientMenu.add(savePatient);
        patientMenu.addSeparator();
        patientMenu.add(newCAVEEntry);
        patientMenu.add(removeCAVEEntry);
        //initializing the Problems menu
        problemsMenu = new JMenu("Problem");
        mb.add(problemsMenu);
        newProblem = new JMenuItem("New problem...");
        newProblem.setEnabled(false);
        newProblem.addActionListener((Record) getController());
        newProblem.setActionCommand(Record.NEW_PROBLEM_ID);
        problemsMenu.add(newProblem);
        delProblem = new JMenuItem("Remove problem");
        setDelProblem(delProblem);
        delProblem.setEnabled(false);
        delProblem.addActionListener((Record) getController());
        delProblem.setActionCommand(Record.REMOVE_PROBLEM_ID);
        problemsMenu.add(delProblem);
        diseaseMenu = new JMenu("Disease");
        newDisease = new JMenuItem("New disease");
        newDisease.addActionListener((Record) getController());
        newDisease.setActionCommand(Record.NEW_DISEASE_ID);
        //mb.add(diseaseMenu);
        //mb.add(windowsMenu);

        diseaseMenu.add(newDisease);
        //initializing the Episodes menu
        episodesMenu = new JMenu("Episode");
        mb.add(episodesMenu);
        newEpisode = new JMenuItem("New Objective...");
        newEpisode.setEnabled(true);
        newEpisode.addActionListener((Record) getController());
        newEpisode.setActionCommand(Record.NEW_REPORT_ID);
        newEpisode.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_F4, 0));
        episodesMenu.add(newEpisode);
        delEpisode = new JMenuItem("Remove episode");
        delEpisode.setEnabled(false);
        delEpisode.addActionListener((Record) getController());
        delEpisode.setActionCommand(Record.REMOVE_EPISODE_ID);
        episodesMenu.add(delEpisode);
        //initializing the Image menu
        imageMenu = new JMenu("Overlay");
        mb.add(imageMenu);
        newImage = new JMenuItem("New overlay...");
        newImage.addActionListener((Record) getController());
        newImage.setActionCommand(Record.NEW_FILE_ID);
        delImage = new JMenuItem("Remove overlay...");
        delImage.addActionListener((Record) getController());
        delImage.setActionCommand(Record.DEL_FILE_ID);
        editImage = new JMenuItem("Edit overlay regions...");
        editImage.addActionListener((Record) getController());
        editImage.setActionCommand(Record.EDIT_FILE_ID);
        editAlternativeOverlay = new JMenuItem("Edit alternative overlays...");
        editAlternativeOverlay.addActionListener((Record) getController());
        editAlternativeOverlay.setActionCommand(Record.EDIT_ALTERNATIVE_OVERLAYS_ID);
        showAlternativeOverlay = new JMenuItem("Show alternative overlays...");
        showAlternativeOverlay.addActionListener((Record) getController());
        showAlternativeOverlay.setActionCommand(Record.SHOW_ALTERNATIVE_OVERLAY_ID);
        showAlternativeOverlay.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_F5, 0));
        newDisease = new JMenuItem("Edit diseases...");
        newDisease.addActionListener((Record) getController());
        newDisease.setActionCommand(Record.NEW_DISEASE_ID);
        //mb.add(diseaseMenu);
        //mb.add(windowsMenu);

        imageMenu.add(newImage);
        imageMenu.addSeparator();
        imageMenu.add(editImage);
        imageMenu.addSeparator();
        imageMenu.add(editAlternativeOverlay);
        imageMenu.add(showAlternativeOverlay);
        imageMenu.addSeparator();
        imageMenu.add(newDisease);
        //initializing the Marker menu
        markerMenu = new JMenu("Marker");
        mb.add(markerMenu);
        saveMarkers = new JMenuItem("Save markers");
        markerMenu.add(saveMarkers);
        saveMarkers.addActionListener((Record) getController());
        saveMarkers.setActionCommand(Record.SAVE_MARKER_ID);
        //initializing the Settings menu
        settingsMenu = new JMenu("Preferences");
        mb.add(settingsMenu);
        overlayRegionSettings = new JMenu("Regions Filling");
        drawOverlayRegion = new JRadioButtonMenuItem("none");
        drawOverlayRegion.setSelected(RecordModel.DRAW_POLYGON);
        fillOverlayRegion = new JRadioButtonMenuItem("solid");
        fillOverlayRegion.setSelected(RecordModel.FILL_POLYGON);
        fillOverlayRegionAlpha = new JRadioButtonMenuItem("solid with alpha blending");
        fillOverlayRegionAlpha.setSelected(RecordModel.FILL_POLYGON_ALPHA);
        ButtonGroup radioButtonGroup = new ButtonGroup();
        radioButtonGroup.add(drawOverlayRegion);
        radioButtonGroup.add(fillOverlayRegion);
        radioButtonGroup.add(fillOverlayRegionAlpha);
        overlayRegionSettings.add(drawOverlayRegion);
        overlayRegionSettings.add(fillOverlayRegion);
        overlayRegionSettings.add(fillOverlayRegionAlpha);
        drawOverlayRegion.addActionListener((Record) getController());
        drawOverlayRegion.setActionCommand(Record.DRAW_POLYGON_SELECTED_ID);
        fillOverlayRegion.addActionListener((Record) getController());
        fillOverlayRegion.setActionCommand(Record.FILL_POLYGON_SELECTED_ID);
        fillOverlayRegionAlpha.addActionListener((Record) getController());
        fillOverlayRegionAlpha.setActionCommand(Record.FILL_POLYGON_ALPHA_SELECTED_ID);
        patientInfoPanelSettings = new JMenuItem("Zeige");
        showMedicamentList = new JCheckBoxMenuItem("Medikamente");
        showMedicamentList.addActionListener((Record) getController());
        showMedicamentList.setActionCommand(Record.SHOW_MEDICAMENT_LIST_ID);
        showProblemList = new JCheckBoxMenuItem("Probleme");
        showProblemList.addActionListener((Record) getController());
        showProblemList.setActionCommand(Record.SHOW_PROBLEM_LIST_ID);
        showCaveList = new JCheckBoxMenuItem("CAVE");
        showCaveList.addActionListener((Record) getController());
        showCaveList.setActionCommand(Record.SHOW_CAVE_LIST_ID);
        settingsMenu.add(overlayRegionSettings);
        //settingsMenu.add(showCaveList);
        //settingsMenu.add(showProblemList);
        //settingsMenu.add(showMedicamentList);
        //initializing the Help menu
        helpMenu = new JMenu("Help");
        mb.add(helpMenu);
        keyBoardConfiguration = new JMenuItem("Keyboard...");
        keyBoardConfiguration.setEnabled(false);
        helpManual = new JMenuItem("Handbuch");
        helpMenu.add(keyBoardConfiguration);
        //helpMenu.add(helpManual);
        return mb;
    }
    //
    // Tool bar.
    //

    /**
     * Creates the tool bar.
     * @return the tool bar
     * @exception NullPointerException if the tool bar is null
     */
    public ResToolBar createToolBar() throws NullPointerException {
        ResToolBar tb = new ResToolBar();
        if (tb != null) {
            tb.add(new JButton("Back"));
        } else {
            throw new NullPointerException("Could not create tool bar. The tool bar is null.");
        }
        return tb;
    }
    //
    // Split pane.
    //

    /**
     * Returns the split pane.
     * @return the split pane
     */
    protected ResSplitPane getSplitPane() {
        return this.splitPane;
    }

    /**
     * Sets the split pane.
     * @param splitPane the split pane
     */
    protected void setSplitPane(ResSplitPane splitPane) {
        this.splitPane = splitPane;
    }

    /**
     * Creates the split pane.
     * @return the split pane
     * @exception NullPointerException if the split pane is null
     */
    protected ResSplitPane createSplitPane() throws NullPointerException {
        ResSplitPane sp = new ResSplitPane();
        if (sp != null) {
            sp.setOrientation(ResSplitPane.VERTICAL_SPLIT);
            sp.setTopComponent(createGeneralInformationPanel());
            sp.setBottomComponent(createContentsPanel());
            sp.setOneTouchExpandable(true);
            sp.setContinuousLayout(true);
            sp.setDividerLocation(200);
        } else {
            throw new NullPointerException("Could not create split pane. The split pane is null.");
        }
        return sp;
    }

    /**
     * Destroys the split pane.
     * @param splitPane the split pane
     */
    protected void destroySplitPane(ResSplitPane splitPane) {
    }
    //
    // Overview panel.
    //

    /**
     * Creates the overview panel.
     * @return the overview panel
     * @exception NullPointerException if the overview panel or the grid bag layout or the grid bag constraints is null
     * @exception NullPointerException if the overview tree is null
     */
    protected ResPanel createOverviewPanel() throws NullPointerException {
        ResPanel p = new ResPanel();
        GridBagLayout l = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        if ((p != null) && (l != null) && (c != null)) {
            // Set panel properties.
            p.setLayout(l);
            // Relative cell width compared to all other cells in this row.
            c.gridwidth = 1;
            c.gridheight = 1;
            // The size of the panel will change when the form is resized.
            c.weighty = 1.0;
            // Expand panels in x- and y-direction for that they all have the same size/are ordered properly in one line.
            c.fill = GridBagConstraints.BOTH;
            TreeNode infoPanelTreeNode = null;
            ResPanel infoPanel = null;
            //?? Temporary dirty solution.
            RecordViewConfiguration conf = new RecordViewConfiguration();
            TreeNode n = conf.getOverviewTree();
            if (n != null) {
                int count = n.getChildCount();
                for (int i = 0; i < count; i++) {
                    // Determine child node and hand over to create panel.
                    infoPanelTreeNode = n.getChildAt(i);
                    if (!((DefaultMutableTreeNode) infoPanelTreeNode).getUserObject().equals("Photo")) {
                        // The size of the panel will change when the form is resized.
                        c.weightx = 1.0;
                        infoPanel = createInfoPanel(infoPanelTreeNode);
                    } else {
                        infoPanel = createPhotoPanel(infoPanelTreeNode);
                    }
                    if ((i + 1) == count) {
                        // Indicates the last component in a row.
                        c.gridwidth = GridBagConstraints.REMAINDER;
                    }
                    try {
                        // Set layout constraints and add panel.
                        l.setConstraints(infoPanel, c);
                        p.add(infoPanel);
                    } catch (NullPointerException e) {
                        // This exception has to be catched here!
                        // Otherwise, no info panel will be created if at least one of the panels is null.
                        // The NullPointerException is thrown from setConstraints which tries to
                        // add infoPanel to a Hashtable.
                        //?? getLogger().log(Level.WARNING, "Could not add info panel. The info panel is null.", e);
                        System.out.println("Could not add info panel. The info panel is null." + e);
                    }
                }
            } else {
                throw new NullPointerException("Could not create overview panel. The overview tree is null.");
            }
        } else {
            throw new NullPointerException("Could not create overview panel. The overview panel or the grid bag layout or the grid bag constraints is null.");
        }
        return p;
    }
    //
    // Photo panel.
    //

    /**
     * Creates the photo panel.
     * @param n the tree node specifying the image resource location
     * @return the photo panel
     * @exception NullPointerException if the photo panel or the configuration tree node is null
     */
    protected ResPanel createPhotoPanel(TreeNode n) throws NullPointerException {
        ResPanel p = new ResPanel();
        if ((p != null) && (n != null)) {
            String resource = (String) ((DefaultMutableTreeNode) ((DefaultMutableTreeNode) n).getFirstChild()).getUserObject();
            //?? Image Resource must be available. For testing, copy into /build (class) directory!!
            //?? java.net.URL url = c.getResource("/org/resmedicinae/application/healthcare/record/image.gif");
            java.net.URL url = getClass().getResource(resource);
            try {
                javax.swing.ImageIcon ii = new javax.swing.ImageIcon(url);
                JLabel l = new JLabel(ii);
                p.setLayout(new BorderLayout());
                p.add(l, BorderLayout.NORTH);
                p.setBorder(new TitledBorder(new EtchedBorder(EtchedBorder.LOWERED), ""));
            } catch (NullPointerException e) {
                // This exception has to be catched here!
                // Otherwise, the whole view will not be created.
                // The NullPointerException is thrown from ImageIcon()
                // which can't use a null parameter.
                //?? log(Level.WARNING, "Could not create image icon. The image icon is null.", e);
                System.out.println("Could not create image icon. The image icon is null." + e);
            }
        } else {
            throw new NullPointerException("Could not create photo panel. The photo panel or the configuration tree node is null.");
        }
        return p;
    }
    //
    // Info panel.
    //

    /**
     * Creates an info panel.
     * @param n the tree node containing the information to be displayed by the panel
     * @return the info panel
     * @exception NullPointerException if the info panel or the configuration tree node is null
     */
    protected ResPanel createInfoPanel(TreeNode n) throws NullPointerException {
        ResPanel p = new ResPanel();
        if ((p != null) && (n != null)) {
            // Set panel properties.
            String title = (String) ((DefaultMutableTreeNode) n).getUserObject();
            p.setLayout(new BorderLayout());
            p.setBorder(new TitledBorder(new EtchedBorder(EtchedBorder.LOWERED), title));
            p.setMinimumSize(new Dimension(80, 60));
            JTree t = new JTree(n);
            ResScrollPane sp = new ResScrollPane();
            if ((t != null) && (sp != null)) {
                t.setRootVisible(false);
                t.setShowsRootHandles(false);
                sp.setViewportView(t);
            }
            p.add(sp, BorderLayout.CENTER);
        } else {
            throw new NullPointerException("Could not create info panel. The info panel or the configuration tree node is null.");
        }
        return p;
    }
    //
    // Contents panel.
    //

    /**
     * Creates the contents panel.
     * @return the contents panel
     * @exception NullPointerException if the contents panel is null
     */
    protected ResPanel createContentsPanel() throws NullPointerException {
        ResPanel p = new ResPanel();
        if (p != null) {
            ResPanel f = createFilterPanel();
            ResTabbedPane d = createDocumentationPanel();
            // Set panel properties and add child components.
            p.setLayout(new BorderLayout());
            //p.add(f, BorderLayout.NORTH);
            p.add(d, BorderLayout.CENTER);
            p.add(getStatusAndInformationPanel(), BorderLayout.SOUTH);
        } else {
            throw new NullPointerException("Could not create contents panel. The contents panel is null.");
        }
        return p;
    }
    //
    // Filter panel.
    //

    /**
     * Creates the filter panel.
     * @return the filter panel
     * @exception NullPointerException if the filter panel is null
     */
    protected ResPanel createFilterPanel() throws NullPointerException {
        ResPanel p = new ResPanel();
        if (p != null) {
            Object[] episodeNames = {"Episode 1", "Episode 2", "Episode 3"};
            Object[] entryNames = {"Diagnose", "Therapie", "Medikamente", "Befunde"};
            ResPanel episodePanel = new ResPanel();
            JLabel episodeLabel = new JLabel("Episode");
            JComboBox episodeComboBox = new JComboBox(episodeNames);
            episodePanel.setLayout(new BorderLayout());
            episodePanel.add(episodeLabel, BorderLayout.NORTH);
            episodePanel.add(episodeComboBox, BorderLayout.SOUTH);
            ResPanel entryPanel = new ResPanel();
            JLabel entryLabel = new JLabel("Entry");
            JComboBox entryComboBox = new JComboBox(entryNames);
            entryPanel.setLayout(new BorderLayout());
            entryPanel.add(entryLabel, BorderLayout.NORTH);
            entryPanel.add(entryComboBox, BorderLayout.SOUTH);
            //?? test
            ResTextField tf = new ResTextField();
            ResButton b = new ResButton();
            ResLabel l = new ResLabel();
            tf.setColumns(20);
            b.setControlId(Record.CREATE_LOAD_PATIENT_DIALOG_CONTROL_ID);
            //??            l.setSelectorString("patient_diagnose");
            // Set panel properties and add child components.
            p.setLayout(new BorderLayout());
            p.add(episodePanel, BorderLayout.WEST);
            p.add(entryPanel, BorderLayout.EAST);
            p.add(tf, BorderLayout.NORTH);
            p.add(b, BorderLayout.CENTER);
            p.add(l, BorderLayout.SOUTH);
            p.setBorder(
                    new CompoundBorder(new TitledBorder(new EtchedBorder(EtchedBorder.LOWERED), "Filter Settings"), new EmptyBorder(5, 5, 5, 5)));
        } else {
            throw new NullPointerException("Could not create filter panel. The filter panel is null.");
        }
        return p;
    }
    //
    // Documentation panel.
    //

    /**
     * Creates the contents panel.
     * @return the contents panel
     * @exception NullPointerException if the tabbed pane is null
     */
    protected ResTabbedPane createDocumentationPanel() throws NullPointerException {
        ResTabbedPane tp = new ResTabbedPane();
        if (tp != null) {
            this.topologyChart = createTopologyChart();
            tp.addTab("TreeTable", null, createTreeTable());
            tp.addTab("TextEditor", null, createTextEditor());
            tp.addTab("GraphChart", null, createGraphChart());
            tp.addTab("Topology", null, this.topologyChart);
            tp.setSelectedIndex(3);
            System.out.println("Assure proper visualization.");
            tp.setTabPlacement(ResTabbedPane.TOP);
        } else {
            throw new NullPointerException("Could not create documentation panel. The tabbed pane is null.");
        }
        return tp;
    }
    //
    // Tree table.
    //

    /**
     * Creates the tree table to display data entries sorted in a table.
     * @return the tree table
     * @exception NullPointerException if the tree table is null
     */
    protected TreeTablePanel createTreeTable() throws NullPointerException {
        setTreeTablePanel(new TreeTablePanel());
        getTreeTablePanel().setController(getController());
        // this.objectModel = new ObjectModel(dummyPatient, (RecordModel)getModel());
        this.objectModel = new ObjectModel((RecordModel) getModel());
        //t.setTreeTableModel(this.objectModel);

        /*this.xmlModel = new XMLModel();
        t.setTreeTableModel(this.xmlModel);*/

        treeTablePanel.initialize();
        //treeTablePanel.add(getStatusAndInformationPanel());
        //??        TreeNode n = ((RecordModel) getModel()).getEntriesTree();
        //??        TreeModel m = new DefaultTreeModel(n);
        //??        FilesystemDataSource d = new FilesystemDataSource(new java.io.File("/home/christian/tmp"), false);
        //??        ITreeModel m = new DynamicTreeModel(d);
        if (treeTablePanel != null) {
            //??            t.setTreeModel(m);
            //??            t.setSelectorString("open_entry");
            //??            t.setControlId(Record.OPEN_ENTRY);
        }
        return treeTablePanel;
    }
    //
    // Text editor.
    //

    /**
     * Creates the text editor to display data textually using markup commands.
     * @return the text editor
     * @exception NullPointerException if the text editor is null
     */
    protected ResTextPane createTextEditor() throws NullPointerException {
        ResTextPane p = new ResTextPane();
        return p;
    }
    //
    // Graph chart.
    //

    /**
     * Creates the graph chart to display episode data along a time axis.
     * @return the graph chart
     * @exception NullPointerException if the graph chart is null
     */
    protected JFreeChartPanel createGraphChart() throws NullPointerException {
        JFreeChartPanel p = null;
        JFreeChart c = null;
        DefaultPieDataset d = new DefaultPieDataset();
        if (d != null) {
            d.setValue("Category 1", new Double(43.2));
            d.setValue("Category 2", new Double(27.9));
            d.setValue("Category 3", new Double(79.5));
            c = ChartFactory.createPieChart("Episode History (will be a horizontal Bar Chart later!)", d, true);
            p = new JFreeChartPanel(c);
        } else {
            throw new NullPointerException("Could not create graph chart. The dataset is null.");
        }
        return p;
    }
    //
    // Topology chart.
    //

    /**
     * Creates the topology chart to help create a diagnose.
     * @return the topology chart
     * @exception NullPointerException if the topology chart is null
     */
    protected JPanel createTopologyChart() throws NullPointerException {
        JPanel p = new JPanel();
        if (p != null) {
            setRegionInfoPanel(createRegionInfoPanel());
            setImagePanel(createImagePanel());
            setMonitorReportPanel(createMonitorReportPanel());
            setStatusAndInformationPanel(createStatusAndInformationPanel());
            setManagePanel(createManagePanel());
            p.setLayout(new FlowLayout());
            p.add(getMonitorReportPanel());
            p.add(getManagePanel());
            p.add(getImagePanel());
            p.add(getRegionInfoPanel());
            p.add(getStatusAndInformationPanel());
        } else {
            throw new NullPointerException("Could not create topology chart. The panel is null.");
        }
        return p;
    }

    /**
     * Creates the region info panel.
     * @return the region info panel
     */
    public JPanel createRegionInfoPanel() throws NullPointerException {
        JPanel p = new JPanel();
        BorderLayout regionInfoPanelLayout = new BorderLayout();
        if (p != null) {
            // Add lifecycle here:
            // constructor, configure, compose, initialize
            //initializing the overlayRegion info panel
            //info panel contains overlayRegionInfoPanel as well as preview panel
            p.setPreferredSize(new Dimension(165, 380));
            p.setBorder(BorderFactory.createBevelBorder(BevelBorder.LOWERED));
            //here are the components of the overlayRegionInfoPanel
            overlayRegionInfoPanel = new JPanel();
            overlayRegionInfoPanel.setLayout(new GridLayout(2, 1));
            overlayRegionNameEntryLabel = new TopologyLabel("Name");
            overlayRegionNameEntryLabel.setPreferredSize(new Dimension(100, 20));
            overlayRegionNameEntryLabel.setFont(new Font("title", Font.BOLD, 10));
            overlayRegionTargetEntryLabel = new TopologyLabel("Target");
            overlayRegionTargetEntryLabel.setFont(new Font("title", Font.BOLD, 10));
            overlayRegionTargetEntryLabel.setVerticalAlignment(SwingConstants.NORTH);
            overlayRegionInfoPanel.add(overlayRegionNameEntryLabel);
            overlayRegionInfoPanel.add(overlayRegionTargetEntryLabel);
            overlayRegionInfoPanel.setBorder(BorderFactory.createTitledBorder("Current Region"));
            overlayRegionInfoPanel.setPreferredSize(new Dimension(145, 100));
            overlayRegionInfoPanel.setToolTipText("Information about current region");
            imageInfoTextArea = new TopologyTextArea(new Dimension(145, 110));
            TopologyScrollPane imageInfoTextAreaScrollPane = new TopologyScrollPane(imageInfoTextArea, "Explanation");
            imageInfoTextAreaScrollPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
            imageInfoTextAreaScrollPane.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_NEVER);
            //here are the components of the previewPanel
            previewPanel = new PreviewPanel();
            previewPanel.setModel((RecordModel) getModel());
            previewPanel.setController(getController());
            previewPanel.initialize();
            //adding grabFocusCheckBox and both panels to infoPanel
            p.add(imageInfoTextAreaScrollPane);
            p.add(overlayRegionInfoPanel);
            p.add(previewPanel);
            //infoPanel.add(editCheckBox);
        } else {
            throw new NullPointerException("Could not create region info panel. The panel is null.");
        }
        return p;
    }

    /**
     * Creates the image info panel.
     * @return the image info panel
     * @exception NullPointerException if the panel is null
     */
    public ImagePanel createImagePanel() throws NullPointerException {
        ImagePanel p = new ImagePanel();
        if (p != null) {
            p.setModel((RecordModel) getModel());
            // Add lifecycle here:
            // constructor, configure, compose, initialize
            //initializing the image panel
            p.setModel((RecordModel) getModel());
            p.setController(getController());
            p.initialize();
            p.setBorder(new LineBorder(Color.BLACK));
        } else {
            throw new NullPointerException("Could not create image panel. The panel is null.");
        }
        return p;
    }
    //
    // Close control.
    //

    /**
     * Returns the close control for closing the window. ??Todo: Replace return type with Control of ResMedLib.
     * @return the close control
     * @exception NullPointerException if the control is null
     */
    public Control getCloseControl() throws NullPointerException {
        Control c = new Control();
        if (c != null) {
            c.setId(Record.DESTROY_APPLICATION_CONTROL_ID);
            c.setSender(getController());
        } else {
            throw new NullPointerException("Could not create close control. The control is null.");
        }
        return c;
    }
    //
    // Initializable.
    //

    /** Initializes this component. */
    public void initialize() throws Exception {
        super.initialize();
        setSplitPane(createSplitPane());
        //?? Put the following methods to an extra lifecycle method "assemble"?
        setFocusable(true);
        add(getSplitPane(), BorderLayout.CENTER);
        addFocusListener((FocusListener) getController());
        setModel(((Record) getController()).getModel());
    }

    /** Finalizes this component. */
    public void finalizz() throws Exception {
        try {
            //?? Put the following methods to an extra lifecycle method "disassemble"?
            remove(getSplitPane());
            destroySplitPane(getSplitPane());
            setSplitPane(null);
        } finally {
            super.finalizz();
        }
    }

    /** Overrides paint from class JComponent */
    public void paint(Graphics g) {
        super.paint(g);
    }

    /** Overrides update from class JComponent */
    public void update(Graphics g) {
        super.update(g);
    }

    /** Adding a new Item to all comboboxes that deal with file names */

    /*public void updateComboBoxes(String imageName) {
        ((Record) getController()).getEditOverlayDialog().fileChooseCombobox.addItem(imageName);
        ((Record) getController()).getRemoveOverlayDialog().nameComboBox.addItem(imageName);
        ((Record) getController()).getEditOverFrame().fileChooseCombobox.update(getGraphics());
        ((Record) getController()).getCreateOverlayRegionFrame().targetImageComboBox.addItem(imageName);
    }*/

    /** /** Loads a patient */

    /*public void updatePatient() {
        Patient patient = ((RecordModel) getModel()).getCurrentPatient();
        this.objectModel = new ObjectModel(patient, (RecordModel) getModel());
//		this.objectModel.initializeRoot(patient);

        t.setTreeTableModel(this.objectModel);
        //this.xmlModel = new XMLModel();
        //t.setTreeTableModel(this.xmlModel);
        //t.initialize();

//        ((RecordModel) getModel()).setCurrentPatient(patient);


        getReportPanel().setEnabled(true);
        this.currentPatient = patient;
        getReportPanel().setCurrentPatient(patient);
        getReportPanel().clearLabels();
        getReportPanel().clearTextAreas();
        this.patientInfoPanel.setCurrentPatient(patient);
        this.patientInfoPanel.clearAllTextAreas();
        ;
        this.patientInfoPanel.changePatient(patient);
        newProblem.setEnabled(true);
        newEpisode.setEnabled(false);
        //newProblem.setEnabled(true);
    }*/

    /*public void changeProblem(Problem p) {
        if (this.currentPatient.hasProblems()) {
            if (p.hasEpisodes()) {
                Episode e = p.getLastEpisode();
                if (e.getPicture() != null) {
                    try {
                        ((RecordModel) getModel()).changeFile(e.getPicture());
                    } catch (Exception ex) {
                        System.out.println("Error in changing file. " + ex);
                    }
                }
                if (e.hasMarkers() == true) {
                    getImagePanel().drawMarkersForEpisode(e);
                }
            }
        }
        this.patientInfoPanel.changeProblem(p);
        this.reportPanel.changeProblem(p);
    } */

    /** Gets the ImagePanel */
    public ImagePanel getImagePanel() {
        return this.imagePanel;
    }

    /** Gets the PreviewPanel */
    public PreviewPanel getPreviewPanel() {
        return this.previewPanel;
    }

    public PatientInfoPanel getPatientInfoPanel() {
        return this.patientInfoPanel;
    }

    public JPanel getTopologyChart() {
        return this.topologyChart;
    }

    public ActionListener getActionListener() {
        return (ActionListener) getController();
    }

    public TopologyTextArea createReportTextArea(Dimension d) {
        TopologyTextArea t = new TopologyTextArea(d);
        if (t != null) {
            t.setBorder(BorderFactory.createTitledBorder("Objective"));
        } else {
            throw new NullPointerException("Could not create report text area. The text area is null.");
        }
        return t;
    }

    public TopologyTextArea getReportTextArea() {
        return this.reportTextArea;
    }

    public void setReportTextArea(TopologyTextArea t) {
        this.reportTextArea = t;
    }

    public ResPanel createGeneralInformationPanel() {
        ResPanel g = new ResPanel();
        g.setLayout(new FlowLayout());
        setPatientInfoPanel(createPatientInfoPanel());
        g.add(getPatientInfoPanel());
        return g;
    }

    public void setPatientInfoPanel(PatientInfoPanel r) {
        this.patientInfoPanel = r;
    }

    /**
     * Creates the patient info panel.
     * @return the patient info panel
     * @exception NullPointerException if the panel is null
     */
    public PatientInfoPanel createPatientInfoPanel() {
        PatientInfoPanel pip = new PatientInfoPanel();
        pip.setController(getController());
        pip.initialize();
        setPatientInfoPanel(pip);
        return pip;
    }

    public TreeTablePanel getTreeTablePanel() {
        return treeTablePanel;
    }

    public void setTreeTablePanel(TreeTablePanel treeTablePanel) {
        this.treeTablePanel = treeTablePanel;
    }

    public void setTopologyChart(JPanel topologyChart) {
        this.topologyChart = topologyChart;
    }

    public void setImagePanel(ImagePanel imagePanel) {
        this.imagePanel = imagePanel;
    }

    public JPanel getRegionInfoPanel() {
        return regionInfoPanel;
    }

    public void setRegionInfoPanel(JPanel regionInfoPanel) {
        this.regionInfoPanel = regionInfoPanel;
    }

    public JPanel getOverlayRegionInfoPanel() {
        return overlayRegionInfoPanel;
    }

    public void setOverlayRegionInfoPanel(JPanel overlayRegionInfoPanel) {
        this.overlayRegionInfoPanel = overlayRegionInfoPanel;
    }

    public void setPreviewPanel(PreviewPanel previewPanel) {
        this.previewPanel = previewPanel;
    }

    public JMenuBar getMenubar() {
        return menubar;
    }

    public void setMenubar(JMenuBar menubar) {
        this.menubar = menubar;
    }

    public JMenu getSystemMenu() {
        return systemMenu;
    }

    public void setSystemMenu(JMenu systemMenu) {
        this.systemMenu = systemMenu;
    }

    public JMenuItem getExit() {
        return exit;
    }

    public void setExit(JMenuItem exit) {
        this.exit = exit;
    }

    public JMenu getPatientMenu() {
        return patientMenu;
    }

    public void setPatientMenu(JMenu patientMenu) {
        this.patientMenu = patientMenu;
    }

    public JMenuItem getNewPatient() {
        return newPatient;
    }

    public void setNewPatient(JMenuItem newPatient) {
        this.newPatient = newPatient;
    }

    public JMenuItem getLoadPatient() {
        return loadPatient;
    }

    public void setLoadPatient(JMenuItem loadPatient) {
        this.loadPatient = loadPatient;
    }

    public JMenu getImageMenu() {
        return imageMenu;
    }

    public void setImageMenu(JMenu imageMenu) {
        this.imageMenu = imageMenu;
    }

    public JMenuItem getNewImage() {
        return newImage;
    }

    public void setNewImage(JMenuItem newImage) {
        this.newImage = newImage;
    }

    public JMenuItem getDelImage() {
        return delImage;
    }

    public void setDelImage(JMenuItem delImage) {
        this.delImage = delImage;
    }

    public JMenuItem getEditImage() {
        return editImage;
    }

    public void setEditImage(JMenuItem editImage) {
        this.editImage = editImage;
    }

    public JMenu getMarkerMenu() {
        return markerMenu;
    }

    public void setMarkerMenu(JMenu markerMenu) {
        this.markerMenu = markerMenu;
    }

    public JMenuItem getSaveMarkers() {
        return saveMarkers;
    }

    public void setSaveMarkers(JMenuItem saveMarkers) {
        this.saveMarkers = saveMarkers;
    }

    public JMenu getSettingsMenu() {
        return settingsMenu;
    }

    public void setSettingsMenu(JMenu settingsMenu) {
        this.settingsMenu = settingsMenu;
    }

    public JMenuItem getOverlayRegionSettings() {
        return overlayRegionSettings;
    }

    public void setOverlayRegionSettings(JMenuItem overlayRegionSettings) {
        this.overlayRegionSettings = overlayRegionSettings;
    }

    public JRadioButtonMenuItem getDrawOverlayRegion() {
        return drawOverlayRegion;
    }

    public void setDrawOverlayRegion(JRadioButtonMenuItem drawOverlayRegion) {
        this.drawOverlayRegion = drawOverlayRegion;
    }

    public JRadioButtonMenuItem getFillOverlayRegion() {
        return fillOverlayRegion;
    }

    public void setFillOverlayRegion(JRadioButtonMenuItem fillOverlayRegion) {
        this.fillOverlayRegion = fillOverlayRegion;
    }

    public JRadioButtonMenuItem getFillOverlayRegionAlpha() {
        return fillOverlayRegionAlpha;
    }

    public void setFillOverlayRegionAlpha(JRadioButtonMenuItem fillOverlayRegionAlpha) {
        this.fillOverlayRegionAlpha = fillOverlayRegionAlpha;
    }

    public JMenu getEpisodesMenu() {
        return episodesMenu;
    }

    public void setEpisodesMenu(JMenu episodesMenu) {
        this.episodesMenu = episodesMenu;
    }

    public JMenu getProblemsMenu() {
        return problemsMenu;
    }

    public void setProblemsMenu(JMenu problemsMenu) {
        this.problemsMenu = problemsMenu;
    }

    public JMenuItem getNewProblem() {
        return newProblem;
    }

    public void setNewProblem(JMenuItem newProblem) {
        this.newProblem = newProblem;
    }

    public JMenuItem getDelProblem() {
        return delProblem;
    }

    public void setDelProblem(JMenuItem delProblem) {
        this.delProblem = delProblem;
    }

    public JMenu getHelpMenu() {
        return helpMenu;
    }

    public void setHelpMenu(JMenu helpMenu) {
        this.helpMenu = helpMenu;
    }

    public JMenuItem getKeyBoardConfiguration() {
        return keyBoardConfiguration;
    }

    public void setKeyBoardConfiguration(JMenuItem keyBoardConfiguration) {
        this.keyBoardConfiguration = keyBoardConfiguration;
    }

    public JMenuItem getHelpManual() {
        return helpManual;
    }

    public void setHelpManual(JMenuItem helpManual) {
        this.helpManual = helpManual;
    }

    public ResToolBar getToolBar() {
        return toolBar;
    }

    public void setToolBar(ResToolBar toolBar) {
        this.toolBar = toolBar;
    }

    public JComboBox getProblemComboBox() {
        return problemComboBox;
    }

    public void setProblemComboBox(JComboBox problemComboBox) {
        this.problemComboBox = problemComboBox;
    }

    public DefaultListModel getListModel() {
        return listModel;
    }

    public void setListModel(DefaultListModel listModel) {
        this.listModel = listModel;
    }

    public TopologyTextArea getImageInfoTextArea() {
        return imageInfoTextArea;
    }

    public void setImageInfoTextArea(TopologyTextArea imageInfoTextArea) {
        this.imageInfoTextArea = imageInfoTextArea;
    }

    public ObjectModel getObjectModel() {
        return objectModel;
    }

    public void setObjectModel(ObjectModel objectModel) {
        this.objectModel = objectModel;
    }

    public JMenuItem getDelEpisode() {
        return delEpisode;
    }

    public void setDelEpisode(JMenuItem delEpisode) {
        this.delEpisode = delEpisode;
    }

    public JMenuItem getNewEpisode() {
        return newEpisode;
    }

    public void setNewEpisode(JMenuItem newEpisode) {
        this.newEpisode = newEpisode;
    }

    public JButton createHistoryBackButton() {
        JButton b = new JButton();
        b.setIcon(new javax.swing.ImageIcon(RecordModel.RelativeIconDirectoryName+"back.gif"));
        b.setRolloverIcon(new javax.swing.ImageIcon(RecordModel.RelativeIconDirectoryName+"backOver.gif"));
        if (b != null) {
            b.addActionListener((Record) getController());
            b.setActionCommand(Record.HISTORY_BACK_ID);
            b.setEnabled(false);
            b.setPreferredSize(new Dimension(35, 35));
            b.setToolTipText("Show previous overlay");
        } else {
            throw new NullPointerException("Could not create history back button. The button is null.");
        }
        return b;
    }

    public JButton getHistoryBackButton() {
        return historyBackButton;
    }

    public void setHistoryBackButton(JButton historyBackButton) {
        this.historyBackButton = historyBackButton;
    }

    public TopologyLabel getStatusLabel() {
        return statusLabel;
    }

    public void setStatusLabel(TopologyLabel statusLabel) {
        this.statusLabel = statusLabel;
    }

    public TopologyLabel getOverlayRegionNameLabel() {
        return overlayRegionNameLabel;
    }

    public void setOverlayRegionNameLabel(TopologyLabel overlayRegionNameLabel) {
        this.overlayRegionNameLabel = overlayRegionNameLabel;
    }

    public TopologyLabel getOverlayRegionNameEntryLabel() {
        return overlayRegionNameEntryLabel;
    }

    public void setOverlayRegionNameEntryLabel(TopologyLabel overlayRegionNameEntryLabel) {
        this.overlayRegionNameEntryLabel = overlayRegionNameEntryLabel;
    }

    public TopologyLabel getOverlayRegionTargetLabel() {
        return overlayRegionTargetLabel;
    }

    public void setOverlayRegionTargetLabel(TopologyLabel overlayRegionTargetLabel) {
        this.overlayRegionTargetLabel = overlayRegionTargetLabel;
    }

    public TopologyLabel getOverlayRegionTargetEntryLabel() {
        return overlayRegionTargetEntryLabel;
    }

    public void setOverlayRegionTargetEntryLabel(TopologyLabel overlayRegionTargetEntryLabel) {
        this.overlayRegionTargetEntryLabel = overlayRegionTargetEntryLabel;
    }

    public ResPanel createStatusAndInformationPanel() {
        ResPanel p = new ResPanel();
        if (p != null) {
            FlowLayout statusAndInformationPanelLayout = new FlowLayout();
            statusAndInformationPanelLayout.setAlignment(FlowLayout.LEFT);
            p.setLayout(statusAndInformationPanelLayout);
            p.setBorder(BorderFactory.createBevelBorder(BevelBorder.LOWERED));
            p.setPreferredSize(new Dimension(1000, 30));
            setStatusAndInformationLabel(createStatusAndInformationLabel());
            p.add(getStatusAndInformationLabel());
        } else {
            throw new NullPointerException("Could not create Status and Information panel. The panel is null.");
        }
        return p;
    }

    public ResPanel getStatusAndInformationPanel() {
        return statusAndInformationPanel;
    }

    public void setStatusAndInformationPanel(ResPanel statusAndInformationPanel) {
        this.statusAndInformationPanel = statusAndInformationPanel;
    }

    public JLabel createStatusAndInformationLabel() {
        JLabel l = new JLabel("Ready.");
        if (l != null) {
            l.setText(RecordMessages.READY_MESSAGE);
        } else {
            throw new NullPointerException("Could not create Status and Information Text area. The text area is null");
        }
        return l;
    }

    public JLabel getStatusAndInformationLabel() {
        return this.statusAndInformationLabel;
    }

    public void setStatusAndInformationLabel(JLabel statusAndInformationLabel) {
        this.statusAndInformationLabel = statusAndInformationLabel;
    }

    public JCheckBox createGrabFocusCheckBox() {
        JCheckBox g = new JCheckBox("Keyboard");
        if (g != null) {
            /*g.setIcon(new CheckBoxIcon("K",false, false));
            g.setSelectedIcon(new CheckBoxIcon("K", false, true));*/

            g.setToolTipText("Keyboardstreuerung");
            g.addItemListener((Record) getController());
        } else {
            throw new NullPointerException("Could not create grab focus checkbox. The checkbox is null.");
        }
        return g;
    }

    public JCheckBox getGrabFocusCheckBox() {
        return grabFocusCheckBox;
    }

    public void setGrabFocusCheckBox(JCheckBox grabFocusCheckBox) {
        this.grabFocusCheckBox = grabFocusCheckBox;
    }

    public ResPanel createMonitorReportPanel() {
        ResPanel p = new ResPanel();
        if (p != null) {
            p.setPreferredSize(new Dimension(390, 380));
            p.setBorder(BorderFactory.createBevelBorder(BevelBorder.LOWERED));
            setReportTextArea(createReportTextArea(new Dimension(385,80)));
            setOverlayTree(createOverlayTree());
            //p.add(getReportTextArea());
            JScrollPane overlayTreeScrollPane = new JScrollPane(getOverlayTree());
            overlayTreeScrollPane.setPreferredSize(new Dimension(380,360));
            overlayTreeScrollPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
            overlayTreeScrollPane.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED);
            p.add(overlayTreeScrollPane);
        } else {
            throw new NullPointerException("Could not create monitor report panel. The panel is null");
        }
        return p;
    }

    public JPanel getMonitorReportPanel() {
        return monitorReportPanel;
    }

    public void setMonitorReportPanel(JPanel monitorReportPanel) {
        this.monitorReportPanel = monitorReportPanel;
    }

    public JCheckBox createShowMarkersCheckBox() {
        JCheckBox c = new JCheckBox();
        c.setSelectedIcon(new javax.swing.ImageIcon(RecordModel.RelativeIconDirectoryName+"showmarker.gif"));
        c.setIcon(new javax.swing.ImageIcon(RecordModel.RelativeIconDirectoryName+"notshowmarker.gif"));
        if (c != null) {
            /*c.setIcon(new CheckBoxIcon("M",false,false));
            c.setSelectedIcon(new CheckBoxIcon("M",false,true));*/

            c.setToolTipText("Show all markers");
            c.addItemListener((Record) getController());
            c.setPreferredSize(new Dimension(35, 35));
            c.setEnabled(false);
        } else {
            throw new NullPointerException("Could not create show markers checkbox. The checkbox is null.");
        }
        return c;
    }

    public JCheckBox getShowMarkersCheckBox() {
        return showMarkersCheckBox;
    }

    public void setShowMarkersCheckBox(JCheckBox showMarkersCheckBox) {
        this.showMarkersCheckBox = showMarkersCheckBox;
    }

    public ResPanel createManagePanel() {
        ResPanel p = new ResPanel();
        if (p != null) {
            GridBagLayout gridBag = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            p.setLayout(gridBag);
            p.setBorder(BorderFactory.createBevelBorder(BevelBorder.LOWERED));
            p.setPreferredSize(new Dimension(44, 380));
            setOverlayLabel(createOverlayLabel());
            setHistoryBackButton(createHistoryBackButton());
            setBackToStartOverlayButton(createBackToStartOverlayButton());
            setAlternativeOverlayButton(createAlternativeOverlayButton());
            setMarkerLabel(createMarkerLabel());
            setSaveMarkersButton(createSaveMarkersButton());
            setRemoveAllMarkersButton(createRemoveAllMarkersButton());
            setShowMarkersCheckBox(createShowMarkersCheckBox());
            setControlLabel(createControlLabel());
            setGrabFocusCheckBox(createGrabFocusCheckBox());
            setEmptyLabel(createEmptyLabel());
            setObjectLabel(createObjectLabel());
            setChangeObjectButton(createChangeObjectButton());
            setRemoveCurrentObjectButton(createRemoveCurrentObjectButton());

            c.anchor = GridBagConstraints.CENTER;
            c.gridx = 0;
            c.gridy = 1;
            c.weighty = 2;
            gridBag.setConstraints(getBackToStartOverlayButton(), c);
            p.add(getBackToStartOverlayButton());

            c.anchor = GridBagConstraints.CENTER;
            c.gridx = 0;
            c.gridy = 2;
            gridBag.setConstraints(getHistoryBackButton(), c);
            p.add(getHistoryBackButton());
            c.anchor = GridBagConstraints.CENTER;
            c.gridx = 0;
            c.gridy = 3;

            gridBag.setConstraints(getAlternativeOverlayButton(), c);
            p.add(getAlternativeOverlayButton());

            c.anchor = GridBagConstraints.CENTER;
            c.gridx = 0;
            c.gridy = 6;
            gridBag.setConstraints(getSaveMarkersButton(), c);
            p.add(getSaveMarkersButton());

            c.anchor = GridBagConstraints.CENTER;
            c.gridx = 0;
            c.gridy = 7;
            gridBag.setConstraints(getRemoveAllMarkersButton(), c);
            p.add(getRemoveAllMarkersButton());

            c.anchor = GridBagConstraints.CENTER;
            c.gridx = 0;
            c.gridy = 8;
            gridBag.setConstraints(getShowMarkersCheckBox(), c);
            p.add(getShowMarkersCheckBox());

            c.anchor = GridBagConstraints.CENTER;
            c.gridx = 0;
            c.gridy = 14;
            gridBag.setConstraints(getChangeObjectButton(), c);
            p.add(getChangeObjectButton());
            c.anchor = GridBagConstraints.CENTER;
            c.gridx = 0;
            c.gridy = 15;
            gridBag.setConstraints(getRemoveCurrentObjectButton(), c);
            p.add(getRemoveCurrentObjectButton());
        }
        return p;
    }

    public JPanel getManagePanel() {
        return managePanel;
    }

    public void setManagePanel(JPanel managePanel) {
        this.managePanel = managePanel;
    }

    public JButton createBackToStartOverlayButton() {
        JButton b = new JButton();
        b.setIcon(new javax.swing.ImageIcon(RecordModel.RelativeIconDirectoryName+"home.gif"));
        b.setRolloverIcon(new javax.swing.ImageIcon(RecordModel.RelativeIconDirectoryName+"homeOver.gif"));
        if (b != null) {
            b.setToolTipText("Back to start");
            b.setActionCommand(Record.BACK_TO_START_OVERLAY_ID);
            b.addActionListener((Record) getController());
            b.setPreferredSize(new Dimension(35, 35));
        } else {
            throw new NullPointerException("Could not create back to start overlay button. The button is null.");
        }
        return b;
    }

    public JButton getBackToStartOverlayButton() {
        return backToStartOverlayButton;
    }

    public void setBackToStartOverlayButton(JButton backToStartOverlayButton) {
        this.backToStartOverlayButton = backToStartOverlayButton;
    }

    public JButton createAlternativeOverlayButton() {
        JButton b = new JButton();
        b.setIcon(new javax.swing.ImageIcon(RecordModel.RelativeIconDirectoryName+"alt.gif"));
        b.setRolloverIcon(new javax.swing.ImageIcon(RecordModel.RelativeIconDirectoryName+"altOver.gif"));
        if (b != null) {
            b.addActionListener((Record) getController());
            b.setActionCommand(Record.SHOW_ALTERNATIVE_OVERLAY_ID);
            b.setPreferredSize(new Dimension(35, 35));
            b.setToolTipText("Show alternative overlays");
        } else {
            throw new NullPointerException("Could not create alternative overlay button. The button is null.");
        }
        return b;
    }

    public JButton getAlternativeOverlayButton() {
        return alternativeOverlayButton;
    }

    public void setAlternativeOverlayButton(JButton alternativeOverlayButton) {
        this.alternativeOverlayButton = alternativeOverlayButton;
    }

    public JButton createRemoveAllMarkersButton() {
        JButton b = new JButton();
        if (b != null) {
            b.setIcon(new javax.swing.ImageIcon(RecordModel.RelativeIconDirectoryName+"delmarker.gif"));
            b.setRolloverIcon(new javax.swing.ImageIcon(RecordModel.RelativeIconDirectoryName+"delmarkerOver.gif"));
            b.addActionListener((Record) getController());
            b.setActionCommand(Record.REMOVE_MARKER_ID);
            b.setPreferredSize(new Dimension(35, 35));
            b.setToolTipText("Remove all markers");
        } else {
            throw new NullPointerException("Could not create remove markers button. The button is null.");
        }
        return b;
    }

    public JButton getRemoveAllMarkersButton() {
        return removeAllMarkersButton;
    }

    public void setRemoveAllMarkersButton(JButton removeAllMarkersButton) {
        this.removeAllMarkersButton = removeAllMarkersButton;
    }

    public JButton createSaveMarkersButton() {
        JButton b = new JButton();
        b.setIcon(new javax.swing.ImageIcon(RecordModel.RelativeIconDirectoryName+"savemarker.gif"));
        b.setRolloverIcon(new javax.swing.ImageIcon(RecordModel.RelativeIconDirectoryName+"savemarkerOver.gif"));
        if (b != null) {
            b.addActionListener((Record) getController());
            b.setActionCommand(Record.SAVE_MARKER_ID);
            b.setPreferredSize(new Dimension(35, 35));
            b.setToolTipText("Save markers");
        } else {
            throw new NullPointerException("Could not create save markers button. The button is null.");
        }
        return b;
    }

    public JButton getSaveMarkersButton() {
        return saveMarkersButton;
    }

    public void setSaveMarkersButton(JButton saveMarkersButton) {
        this.saveMarkersButton = saveMarkersButton;
    }

    public TopologyLabel createMarkerLabel() {
        TopologyLabel l = new TopologyLabel(false);
        if (l != null) {
            l.setText("Marker");
            l.setForeground(Color.BLUE);
        } else {
            throw new NullPointerException("Could not create marker label. The label is null.");
        }
        return l;
    }

    public TopologyLabel getMarkerLabel() {
        return markerLabel;
    }

    public void setMarkerLabel(TopologyLabel markerLabel) {
        this.markerLabel = markerLabel;
    }

    public TopologyLabel createOverlayLabel() {
        TopologyLabel l = new TopologyLabel(false);
        if (l != null) {
            l.setText("Overlay");
            l.setForeground(Color.BLUE);
        } else {
            throw new NullPointerException("Could not create overlay label. The label is null.");
        }
        return l;
    }

    public TopologyLabel getOverlayLabel() {
        return overlayLabel;
    }

    public void setOverlayLabel(TopologyLabel overlayLabel) {
        this.overlayLabel = overlayLabel;
    }

    public TopologyLabel createControlLabel() {
        TopologyLabel l = new TopologyLabel(false);
        if (l != null) {
            l.setText("Kontrolle");
            l.setForeground(Color.BLUE);
        } else {
            throw new NullPointerException("Could not create control label. The label is null.");
        }
        return l;
    }

    public TopologyLabel getControlLabel() {
        return controlLabel;
    }

    public void setControlLabel(TopologyLabel controlLabel) {
        this.controlLabel = controlLabel;
    }

    public TopologyLabel createEmptyLabel() {
        TopologyLabel l = new TopologyLabel(false);
        if (l != null) {
            l.setText("Empty");
            l.setForeground(RecordModel.BackgroundColor);
        } else {
            throw new NullPointerException("Could not create empty label. The label is null.");
        }
        return l;
    }

    public TopologyLabel getEmptyLabel() {
        return emptyLabel;
    }

    public void setEmptyLabel(TopologyLabel emptyLabel) {
        this.emptyLabel = emptyLabel;
    }

    public TopologyLabel createObjectLabel() {
        TopologyLabel l = new TopologyLabel(false);
        if (l != null) {
            l.setText("Befund");
            l.setForeground(Color.BLUE);
        } else {
            throw new NullPointerException("Could not create object label. The label is null.");
        }
        return l;
    }

    public TopologyLabel getObjectLabel() {
        return objectLabel;
    }

    public void setObjectLabel(TopologyLabel objectLabel) {
        this.objectLabel = objectLabel;
    }

    public JButton createChangeObjectButton() {
        JButton b = new JButton();
        if (b != null) {
            b.setIcon(new javax.swing.ImageIcon(RecordModel.RelativeIconDirectoryName+"prevobjective.gif"));
            b.setRolloverIcon(new javax.swing.ImageIcon(RecordModel.RelativeIconDirectoryName+"prevobjectiveOver.gif"));
            b.setToolTipText("Next objective");
            b.addActionListener((Record) getController());
            b.setActionCommand(Record.NEXT_OBJECT_ID);
            b.setPreferredSize(new Dimension(35, 35));
            b.setEnabled(true);
        } else {
            throw new NullPointerException("Could not create change object button. The button is null.");
        }
        return b;
    }

    public JButton getChangeObjectButton() {
        return changeObjectButton;
    }

    public void setChangeObjectButton(JButton changeObjectButton) {
        this.changeObjectButton = changeObjectButton;
    }

    public JButton createRemoveCurrentObjectButton() {
        JButton b = new JButton();
        if (b != null) {
            b.setToolTipText("Remove current objective");
            b.setIcon(new javax.swing.ImageIcon(RecordModel.RelativeIconDirectoryName+"delobjective.gif"));
            b.setRolloverIcon(new javax.swing.ImageIcon(RecordModel.RelativeIconDirectoryName+"delobjectiveOver.gif"));
            b.addActionListener((Record) getController());
            b.setActionCommand(Record.REMOVE_CURRENT_OBJECT_ID);
            b.setPreferredSize(new Dimension(35, 35));
            b.setEnabled(true);
        } else {
            throw new NullPointerException("Could not create remove object button. The button is null.");
        }
        return b;
    }

    public JButton getRemoveCurrentObjectButton() {
        return removeCurrentObjectButton;
    }

    public void setRemoveCurrentObjectButton(JButton removeCurrentObjectButton) {
        this.removeCurrentObjectButton = removeCurrentObjectButton;
    }

    public JMenuItem getSavePatient() {
        return savePatient;
    }

    public void setSavePatient(JMenuItem savePatient) {
        this.savePatient = savePatient;
    }

    public JCheckBoxMenuItem getShowProblemList() {
        return showProblemList;
    }

    public void setShowProblemList(JCheckBoxMenuItem showProblemList) {
        this.showProblemList = showProblemList;
    }

    public JCheckBoxMenuItem getShowMedicamentList() {
        return showMedicamentList;
    }

    public void setShowMedicamentList(JCheckBoxMenuItem showMedicamentList) {
        this.showMedicamentList = showMedicamentList;
    }

    public JCheckBoxMenuItem getShowCaveList() {
        return showCaveList;
    }

    public void setShowCaveList(JCheckBoxMenuItem showCaveList) {
        this.showCaveList = showCaveList;
    }

    public OverlayTree createOverlayTree(){
        RecordModel model = (RecordModel)getModel();
        OverlayTree overlayTree = new OverlayTree();
        overlayTree.addTreeSelectionListener((Record)getController());
        overlayTree.addMouseListener((Record)getController());
        //overlayTree.setPreferredSize(new Dimension(390,200));
        return overlayTree;
    }

    public OverlayTree getOverlayTree() {
        return overlayTree;
    }

    public void setOverlayTree(OverlayTree overlayTree) {
        this.overlayTree = overlayTree;
    }

    public OverlayTreeModel createOverlayTreeModel(RecordModel model){
        //Overlay rootOverlay = (Overlay)model.getOverlayHashtable().get(RecordModel.StartDocumentName);
        OverlayTreeModel overlayTreeModel = new OverlayTreeModel();
        return overlayTreeModel;
    }

    public OverlayTreeModel getOverlayTreeModel() {
        return overlayTreeModel;
    }

    public void setOverlayTreeModel(OverlayTreeModel overlayTreeModel) {
        this.overlayTreeModel = overlayTreeModel;
    }
}
