/*
 * $RCSfile: RecordPanel.java,v $
 *
 * Copyright (c) 1999-2002. Jens Bohl. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.application.healthcare.record;

import org.resmedicinae.resmedlib.component.control.*;
import org.resmedicinae.resmedlib.component.view.swing.*;

import javax.swing.event.*;

/**
 *This panel is super class of all rerord panels. This class basically has methods for setting and
 * getting controller and model.
 * @author Jens Bohl <info@jens-bohl-professional.de>
 */
public class RecordPanel extends ResPanel {
    private RecordModel model;
    private Controller controller;

    /**
     *Sets the model. This is needed because there is no setModel(...) method to overwrite. No inheritance from SwingView.
     * @param model the model.
     */
    public void setModel(RecordModel model) {
        this.model = model;
    }

    /**
     *Sets the model. This is needed because there is no getModel(...) method to overwrite. No inheritance from SwingView.
     * @return the model.
     */
    public RecordModel getModel() {
        return this.model;
    }

    /**
     *Sets the controller. This is needed because there is no setController(...) method to overwrite. No
     * inheritance from SwingView.
     * @return the controller.
     */
    public void setController(Controller controller) {
        this.controller = controller;
    }

    /**
     *Gets the controller. This is needed because there is no getController(...) method to overwrite. No
     * inheritance from SwingView.
     * @return the controller.
     */
    public Controller getController() {
        return this.controller;
    }

    /**
     *Gets the controller as a list selection listener.
     * @return the controller with listSelectionListener interface.
     */
    public ListSelectionListener getListSelectionListener() {
        return (ListSelectionListener) this.controller;
    }
}
