/*
 * $RCSfile: Record.java,v $
 *
 * Copyright (c) 1999-2002. Christian Heller. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.application.healthcare.record;

import org.resmedicinae.application.healthcare.record.topology.*;
import org.resmedicinae.application.healthcare.record.treetable.*;
import org.resmedicinae.application.healthcare.reform.application.common.basic.*;
import org.resmedicinae.application.healthcare.reform.region.ObjectID;
import org.resmedicinae.domain.healthcare.*;
import org.resmedicinae.domain.healthcare.description.*;
import org.resmedicinae.domain.healthcare.heading.problem.*;
import org.resmedicinae.domain.healthcare.unit.*;
import org.resmedicinae.resmedlib.component.configuration.*;
import org.resmedicinae.resmedlib.component.context.*;
import org.resmedicinae.resmedlib.component.control.*;
import org.resmedicinae.resmedlib.component.view.*;
import org.w3c.dom.*;

import javax.swing.*;
import javax.swing.event.*;
import javax.swing.tree.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.util.*;
import java.util.prefs.*;

/**
 * This class represents the record application. This controller handles all events that appear within this application. These
 * are action, item, mouse, key, and listselection events. This means implementing all nessesary interfaces.
 * @version $Revision: 1.70 $ $Date: 2003/01/20 10:12:30 $ $Author: tristan24 $
 * @author Christian Heller <christian.heller@tuxtax.de>
 * @author Jens Bohl <info@jens-bohl-professional.de>
 */
public class Record extends AdvancedBasicApplication {
    //
    // Control id constants.
    //
    /** The create about dialog control id. */
    public static final String CREATE_LOAD_PATIENT_DIALOG_CONTROL_ID = "create_load_patient_dialog";
    /** The destroy about dialog control id. */
    public static final String DESTROY_LOAD_PATIENT_DIALOG_CONTROL_ID = "destroy_load_patient_dialog";
    //Menu Action commands---------------------------------------------------------------------------------
    /*Action command*/
    public static final String SYSTEM_EXIT_ID = "menu exit";
    /*Action command*/
    public static final String NEW_FILE_ID = "menu new_file";
    /*Action command*/
    public static final String DEL_FILE_ID = "menu del_file";
    /*Action command*/
    public static final String EDIT_FILE_ID = "menu edit_file";
    /*Action command*/
    public static final String EDIT_ALTERNATIVE_OVERLAYS_ID = "edit alternative overlays";
    /*Action command*/
    public static final String POLYGON_SETTINGS_ID = "menu overlayRegion_settings";
    /*Action command*/
    public static final String NEW_PATIENT_ID = "menu new_patient";
    /*Action command*/
    public static final String SAVE_PATIENT_ID = "menu save_patient";
    /*Action command*/
    public static final String NEW_CAVE_ENTRY_ID = "menu new cave entry";
    /*Action command*/
    public static final String REMOVE_CAVE_ENTRY_ID = "menu remove cave entry";
    /*Action command*/
    public static final String NEW_EPISODE_ID = "menu new_episode";
    /*Action command*/
    public static final String NEW_PARTIAL_CONTACT_ID = "menu new_partial contact";
    /*Action command*/
    public static final String REMOVE_PARTIAL_CONTACT_ID = "menu remove_partial contact";
    /*Action command*/
    public static final String REMOVE_EPISODE_ID = "menu remove_episode";
    /*Action command*/
    public static final String NEW_PROBLEM_ID = "menu new_problem";
    /*Action command*/
    public static final String REMOVE_PROBLEM_ID = "menu remove_problem";
    /*Action command*/
    public static final String DRAW_POLYGON_SELECTED_ID = "menu draw_overlayRegion_selected";
    /*Action command*/
    public static final String FILL_POLYGON_SELECTED_ID = "menu fill_overlayRegion_selected";
    /*Action command*/
    public static final String FILL_POLYGON_ALPHA_SELECTED_ID = "menu fill_overlayRegion_selected_alpha";
    /*Action command*/
    public static final String HISTORY_BACK_ID = "menu history_back";
    /*Action command*/
    public static final String SAVE_MARKER_ID = "menu save_marker";
    /*Action command*/
    public static final String NEW_REPORT_ID = "new report";
    /*Action command*/
    public static final String CHANGE_FILTER_ID = "change filter";
    /*Action command*/
    public static final String CLOSE_ACTIVE_WINDOW_ID = "close aktive window";
    /*Action command. Not used.*/
    public static final String SHOW_MEDICAMENT_LIST_ID = "show medicament list";
    /*Action command. Not used.*/
    public static final String SHOW_PROBLEM_LIST_ID = "show problem list";
    /*Action command. Not in use.*/
    public static final String SHOW_CAVE_LIST_ID = "show cave list";
    /*Action command*/
    public static final String NEW_MEDICATION_ID = "new medication";
    /*Action command*/
    public static final String NEW_DISEASE_ID = "new disease";
    /*Action command*/
    public static final String REMOVE_MEDICATION_ID = "remove medication";
    //RemoveOverlayDialog Action commands-------------------------------------------------------------------------------
    /*Action command*/
    public static final String REMOVE_OVERLAY_DIALOG_OK_ID = "remove overlay ok";
    /*Action command*/
    public static final String REMOVE_OVERLAY_DIALOG_CANCEL_ID = "remove overlay cancel";
    //MakeOverlayDialog Action commands---------------------------------------------------------------------------------
    /*Action command*/
    public static final String MAKE_OVERLAY_DIALOG_CHOOSE_FILE_ID = "make overlay choose file";
    /*Action command*/
    public static final String MAKE_OVERLAY_DIALOG_OK_ID = "make overlay ok";
    /*Action command*/
    public static final String MAKE_OVERLAY_DIALOG_CANCEL_ID = "make overlay cancel";
    //EditOverlayDialog Action commands---------------------------------------------------------------------------------
    /*Action command*/
    public static final String EDIT_OVERLAY_NEW_POLYGON_ID = "edit overlay new overlayRegion";
    /*Action command*/
    public static final String EDIT_OVERLAY_SAVE_POLYGON_ID = "edit overlay save overlayRegion";
    /*Action command*/
    public static final String EDIT_OVERLAY_DELETE_POLYGON_ID = "edit overlay delete overlayRegion";
    /*Action command*/
    public static final String EDIT_OVERLAY_DELETE_LAST_POINT_ID = "edit overlay delete last point";
    /*Action command*/
    public static final String EDIT_OVERLAY_CHOOSE_FILE_ID = "edit overlay choose file";
    /*Action command*/
    public static final String EDIT_OVERLAY_REGION_DIALOG_DELETE_POLYGON_ID = "edit overlay region delete overlayRegion";
    /*Action command*/
    public static final String EDIT_OVERLAY_REGION_DIALOG_OK_ID = "edit overlay region ok";
    //LoadPatientDialog Action commands---------------------------------------------------------------------------------
    /*Action command*/
    public static final String LOAD_PATIENT_DIALOG_OK_ID = "load patient ok";
    /*Action command*/
    public static final String LOAD_PATIENT_DIALOG_CANCEL_ID = "load patient cancel";
    //ReportPanel Action commands---------------------------------------------------------------------------------------
    /*Action command*/
    public static final String REPORT_PANEL_NEXT_EPISODE_ID = "next episode";
    /*Action command*/
    public static final String REPORT_PANEL_PREV_EPISODE_ID = "prev episode";
    //MakeOverlayRegionDialog Action command----------------------------------------------------------------------------
    /*Action command*/
    public static final String MAKE_OVERLAY_REGION_DIALOG_OK_ID = "make overlay region ok";
    /*Action command*/
    public static final String MAKE_OVERLAY_REGION_DIALOG_CANCEL_ID = "make overlay region cancel";
    /*Action command*/
    public static final String MAKE_OVERLAY_REGION_DIALOG_CHANGE_PREVIEW_ID = "change preview";
    //MakeProblemDialog Action commands---------------------------------------------------------------------------------
    /*Action command*/
    public static final String MAKE_PROBLEM_DIALOG_OK_ID = "make problem ok";
    /*Action command*/
    public static final String MAKE_PROBLEM_DIALOG_CANCEL_ID = "make problem cancel";
    /*Action command*/
    public static final String MAKE_PROBLEM_DIALOG_CLEAR_ID = "make problem clear";
    //MakeEpisodeDialog Action commands---------------------------------------------------------------------------------
    /*Action command*/
    public static final String MAKE_EPISODE_OK_ID = "make episode ok";
    /*Action command*/
    public static final String MAKE_EPISODE_CANCEL_ID = "make episode cancel";
    /*Action command*/
    public static final String MAKE_EPISODE_CLEAR_ID = "make episode clear";
    //Make Report On Overlay Action command-----------------------------------------------------------------------------
    /*Action command*/
    public static final String MAKE_REPORT_ON_OVERLAY_OK_ID = "make report on overlay ok";
    /*Action command*/
    public static final String MAKE_REPORT_ON_OVERLAY_CANCEL_ID = "make report on overlay cancel";
    //Manage Overlay Action command-------------------------------------------------------------------------------------
    /*Action command*/
    public static final String BACK_TO_START_OVERLAY_ID = "back to start overlay";
    /*Action command*/
    public static final String SHOW_ALTERNATIVE_OVERLAY_ID = "show alternative overlay";
    /*Action command*/
    public static final String REMOVE_MARKER_ID = "remove all markers";
    /*Action command*/
    public static final String NEXT_OBJECT_ID = "next object";
    /*Action command*/
    public static final String REMOVE_CURRENT_OBJECT_ID = "remove current object";
    //Edit alterative overlays dialog Action commands-------------------------------------------------------------------
    /*Action command*/
    public static final String EDIT_ALTERNATIVE_OVERLAY_DIALOG_CANCEL_ID = "edit alterantive overlays cancel";
    /*Action command*/
    public static final String EDIT_ALTERNATIVE_OVERLAY_DIALOG_OK_ID = "edit alterantive overlays ok";
    /*Action command*/
    public static final String EDIT_ALTERNATIVE_OVERLAY_DIALOG_ADD_ID = "edit alterantive overlays add";
    /*Action command*/
    public static final String EDIT_ALTERNATIVE_OVERLAY_DIALOG_REMOVE_ID = "edit alterantive overlays remove";
    //AlternativeOverlaysPreviewDialog Action commands------------------------------------------------------------------
    /*Action command*/
    public static final String CHANGE_ALTERNATIVE_OVERLAY_PREVIEW_ID = "change alternative overlay preview";
    //MakeCAVEDialog Action commands------------------------------------------------------------------
    /*Action command*/
    public static final String MAKE_CAVE_DIALOG_OK_ID = "make cave ok";
    /*Action command*/
    public static final String MAKE_CAVE_DIALOG_CANCEL_ID = "make cave cancel";
    /*Action command*/
    public static final String MAKE_CAVE_DIALOG_CLEAR_ID = "make cave clear";
    //MakeDiseaseDialog Action commands------------------------------------------------------------------
    /*Action command*/
    public static final String MAKE_DISEASE_DIALOG_OK_ID = "make disease ok";
    /*Action command*/
    public static final String MAKE_DISEASE_DIALOG_CANCEL_ID = "make disease cancel";
    /*Action command*/
    public static final String MAKE_DISEASE_DIALOG_CLEAR_ID = "make disease clear";
    /*Action command*/
    public static final String MAKE_DISEASE_DIALOG_COMMIT_CHANGES_IN_DISEASE_ID = "commit changes in disease";
    /*Action command*/
    public static final String MAKE_DISEASE_DIALOG_REMOVE_DISEASE_ID = "remove disease";

    // Dialogs.---------------------------------------------------------------------------------------------------------
    /** Dialog for creating overlays*/
    private MakeOverlayDialog makeOverlayDialog;
    /** Dialog for creating overlay regions*/
    private MakeOverlayRegionDialog makeOverlayRegionDialog;
    /** Dialog for editing a overlayRegion */
    private EditOverlayRegionDialog editOverlayRegionDialog;
    /** Dialog for editing overlays */
    public EditOverlayDialog editOverlayDialog;
    /** Dialog for creating problems */
    private MakeProblemDialog makeProblemDialog;
    /** Dialog for creating reports on overlays */
    private MakeReportOnOverlayDialog makeReportOnOverlayDialog;
    /** Dialog for editing alternative overlays */
    private EditAlternativeOverlayDialog editAlternativeOverlaysDialog;
    /** Dialog for selecting alternative overlays */
    private AlternativeOverlaysPreviewDialog alternativeOverlaysPreviewDialog;
    /** Dialog for creating diseases*/
    private MakeDiseaseDialog makeDiseaseDialog;
    /** Dialog for creating a new CAVE entry */
    private MakeCAVEDialog makeNewCAVEEntryDialog;

    /** Java Toolkit */
    private Toolkit kit = Toolkit.getDefaultToolkit();
    // Panels for the topology tab--------------------------------------------------------------------------------------
    /** Panel showing a preview of the target image of the overlayRegion the mouse is over */
    private PreviewPanel previewPanel;
    /** Panel showing information about a overlayRegion e.g. name or destination */
    private JPanel overlayRegionInfoPanel;
    /** Panel containing infopanel and previewPanel */
    private JPanel infoPanel;
    /** Panel showing patient data */
    private PatientInfoPanel patientInfoPanel;
    /** The load patient control id. */
    public static final String LOAD_PATIENT_CONTROL_ID = "load_patient";
    /** The name of the picture that will be used within an the current overlay */
    private String picToUse;
    /**
     * The name of the backup overlay. The name will be backuped if it is not sure whether the alternative
     * overlay will be used or not. If Escape is pressed the backup overlay will be restored.
     */
    private String overlayBackup;
    /** The index of the current object */
    private int objectIndex;
    //
    // Name.
    //

    /**
     * Returns the name.
     * @return the name
     */
    public String getName() {
        return "Record";
    }
    //
    // Version.
    //

    /**
     * Returns the version. (major).(minor).(<99 = preX, 99 = final).(bug fix)
     * @return the version
     */
    public String getVersion() {
        return "0.0.4.0";
    }
    //
    // Date.
    //

    /**
     * Returns the release date.
     * @return the release date
     */
    public String getDate() {
        return "30.09.2002";
    }
    //
    // Authors.
    //

    /**
     * Returns the authors.
     * @return the authors
     */
    public String getAuthors() {
        return super.getAuthors() + "\n\nJens Bohl\n<jens.bohl@stud.tu-ilmenau.de>\nDeveloper";
    }

    //
    // Configuration.
    //

    /*
	* Creates the system configuration.
	*
	* @return the system configuration
	* @exception NullPointerException if the system configuration is null
	* @exception NullPointerException if the context is null
	*/

    protected Configuration createSystemConfiguration() throws Exception, NullPointerException {
        RecordConfiguration c = new RecordConfiguration();
        if (c != null) {
            Context ctxt = getContext();
            if (ctxt != null) {
                ctxt.putEntry("preferences", Preferences.systemNodeForPackage(getClass()));
                ctxt.putEntry("location", ctxt.getEntry("system_configuration_location"));
                c.contextualize(ctxt);
                c.initialize();
            } else {
                throw new NullPointerException("Could not create system configuration. The context is null.");
            }
        } else {
            throw new NullPointerException("Could not create system configuration. The system configuration is null.");
        }
        return c;
    }

    /**
     * Creates the model.
     * @return the model
     */
    public Object createModel() throws Exception {
        RecordView view = (RecordView) getView();
        RecordModel model = new RecordModel(view, this);
        setMakeDiseaseDialog(createMakeDiseaseDialog());
        if (model != null) {
            // m.configure(getConfigurationManager());
            model.initialize();
            ((RecordView) getView()).setModel(model);
        } else {
            throw new NullPointerException("Could not create model. The model is null.");
        }

        return (Object) model;
    }
    //
    // View.
    //

    /**
     * Creates a view.
     * @return the view
     * @exception NullPointerException if the view is null
     */
    public View createView() throws Exception {
        RecordView v = new RecordView();
        if (v != null) {

            //?? Only temporary! Remove this line later, when Controller does not need to be set
            //?? and when assigning ControlId to GUI components is enough.
            v.setController(this);
            v.addKeyListener(this);
            v.configure(getConfigurationManager());
            v.initialize();
        } else {
            throw new NullPointerException("Could not create view. The view is null.");
        }
        setView(v);
        return v;
    }
    //
    // Initializable.
    //

    /** Initializes this component. */
    public void initialize() throws Exception {
        super.initialize(getName());
        RecordModel model = (RecordModel) getModel();
        getView().setModel(model);
        createAllRecordDialogs();
        OverlayTreeModel overlayTreeModel = new OverlayTreeModel(model);
        System.out.println("Vor dem Setzen.");
        getMakeDiseaseDialog().getOverlayTree().setModel(overlayTreeModel);
        System.out.println("Nach dem Setzen.");
        ((RecordView)getView()).getOverlayTree().setModel(overlayTreeModel);
        Document startDocument = model.getDocumentByName(RecordModel.StartDocumentName);
        if (startDocument != null) {
            model.getHistoryVector().add(RecordModel.StartDocumentName);
            model.changeOverlay(RecordModel.StartDocumentName);
            updateAlternativeOverlays();
            ((RecordView) getView()).getHistoryBackButton().setEnabled(false);
        } else {
            System.out.println("Start Dokument nicht vorhanden. Entweder ist der Dateinname falsch geschrieben" +
                    "oder die Datei im Bilder-Verzeichnis nicht vorhanden.");
        }
        setObjectIndex(0);
    }

    /** Finalizes this component. */
    public void finalizz() throws Exception {
        super.finalizz();
    }

    /** Creates all dialogs of Record*/
    public void createAllRecordDialogs() {
        setMakeOverlayDialog(createMakeOverlayDialog());
        setMakeOverlayRegionDialog(createMakeOverlayRegionDialog());
        setMakeProblemDialog(createMakeProblemDialog());
        setMakeDiseaseDialog(createMakeDiseaseDialog());
        setEditOverlayDialog(createEditOverlayDialog());
        setEditOverlayRegionDialog(createEditOverlayRegionDialog());
        setReportOnOverlayDialog(createMakeReportOnOverlayDialog());
        setEditAlternativeOverlaysDialog(createEditAlternativeOverlayDialog());
        setAlternativeOverlaysPreviewDialog(createAlternativeOverlaysPreviewDialog());
        setMakeNewCAVEEntryDialog(createMakeCAVEDialog());
    }
    //
    // Handling of signals.
    //

    /**
     * Handles control events and calls the corresponding methods.
     * @param c the control
     * @exception NullPointerException if the control is null
     */
    protected void handle(Control c) throws Exception, NullPointerException {
        super.handle(c);
        if (c != null) {
            if (c.matches(Record.LOAD_PATIENT_CONTROL_ID)) {
                loadPatient();
            }
        } else {
            throw new NullPointerException("Could not handle control. Control is null.");
        }
    }

    /**
     * Handles all action events of the whole application. This is a very bad solution. The events should be delegated!!!
     * @param evt the action event
     */
    public void actionPerformed(ActionEvent evt) {
        RecordView view = (RecordView) getView();
        RecordModel model = (RecordModel) getModel();
        System.out.println("ACTION PERFORMED IN RECORD MODUL");
        try {
            //Action commands raised by the menu------------------------------------------------------------------------
            if (evt.getActionCommand() == Record.SYSTEM_EXIT_ID) {
                showInformationMessage(RecordMessages.EXIT_MESSAGE);
                //quits application
                super.exit();
            } else if (evt.getActionCommand() == Record.NEW_FILE_ID) {
                show(getMakeOverlayDialog());
                showInformationMessage(RecordMessages.CREATE_NEW_OVERLAY_MESSAGE);
            } else if (evt.getActionCommand() == Record.EDIT_ALTERNATIVE_OVERLAYS_ID) {
                //putting all overlays in a list for presenting in the dialog
                Enumeration e = model.getImageHashtable().keys();
                int counter = 1;
                Vector allOverlaysNameVector = new Vector();
                while (e.hasMoreElements()) {
                    counter++;
                    String overlayName = (String) e.nextElement();
                    allOverlaysNameVector.add(overlayName);
                }
                getEditAlternativeOverlaysDialog().getAllOverlaysTreeScrollPane().setBorder(BorderFactory.createTitledBorder("All Overlays "+"("+allOverlaysNameVector.size()+")"));
                SortedSet sortedSet = Collections.synchronizedSortedSet(new TreeSet(allOverlaysNameVector));
                Iterator iterator = sortedSet.iterator();
                while (iterator.hasNext()) {
                    getEditAlternativeOverlaysDialog().getAllOverlaysListModel().addElement(iterator.next());
                }
                //clear the vector containing alternative overlay before filling it
                getEditAlternativeOverlaysDialog().getAlternativeOverlaysListModel().clear();

                //putting all alternative overlays in a list for presenting in the dialog
                Vector r = model.getAlternativeOverlaysForCurrentOverlay();
                if (r != null) {
                    for (int i = 0; i < r.size(); i++) {
                        String overlayName = (String) r.elementAt(i);
                        String currentOverlayName = model.getNameFromDocument(model.getCurrentDocument());
                        if (!(overlayName == currentOverlayName)) {
                            getEditAlternativeOverlaysDialog().getAlternativeOverlaysListModel().addElement(overlayName);
                        }
                    }
                }
                show(getEditAlternativeOverlaysDialog());
                showInformationMessage(RecordMessages.EDIT_ALTERNATIVE_OVERLAYS_MESSAGE);
            } else if (evt.getActionCommand() == Record.DEL_FILE_ID) {
                showInformationMessage(RecordMessages.REMOVE_OVERLAY_MESSAGE);
            } else if (evt.getActionCommand() == Record.EDIT_FILE_ID) {
                getEditOverlayDialog().setTitle("Edit: "+model.getNameFromDocument(model.getCurrentDocument()));
                show(getEditOverlayDialog());
                showInformationMessage(RecordMessages.EDIT_OVERLAY_MESSAGE);
            } else if (evt.getActionCommand() == Record.DRAW_POLYGON_SELECTED_ID) {
                //setting regions to appear only with border
                RecordModel.DRAW_POLYGON = true;
                RecordModel.FILL_POLYGON = false;
                RecordModel.FILL_POLYGON_ALPHA = false;
                showInformationMessage(RecordMessages.REGION_TRANSPARENT_MESSAGE);
            } else if (evt.getActionCommand() == Record.FILL_POLYGON_SELECTED_ID) {
                //setting regions to appear solid
                RecordModel.DRAW_POLYGON = false;
                RecordModel.FILL_POLYGON = true;
                RecordModel.FILL_POLYGON_ALPHA = false;
                showInformationMessage(RecordMessages.REGION_NOT_TRANSPARENT_MESSAGE);
            } else if (evt.getActionCommand() == Record.FILL_POLYGON_ALPHA_SELECTED_ID) {
                //setting regions to appear with alpha blending
                RecordModel.DRAW_POLYGON = false;
                RecordModel.FILL_POLYGON = false;
                RecordModel.FILL_POLYGON_ALPHA = true;
                showInformationMessage(RecordMessages.REGION_TRANSPARENT_WITH_ALPHA_VALUE_MESSAGE);
            } else if (evt.getActionCommand() == Record.NEW_CAVE_ENTRY_ID) {
                show(getMakeNewCAVEEntryDialog());
            } else if (evt.getActionCommand() == Record.REMOVE_CAVE_ENTRY_ID) {
                Object selectedValue = view.getPatientInfoPanel().getCaveList().getSelectedValue();
                view.getPatientInfoPanel().getCaveListModel().removeElement(selectedValue);
                if (selectedValue != null) {
                    Object[] caves = model.getCaveByName((String) selectedValue);
                    for (int i = 0; i < caves.length; i++) {
                        Cave cave = (Cave) caves[i];
                        if (cave.getIdentifier() != null) {
                            model.getCurrentHealthRecord().remove(cave.getIdentifier());
                            removeCave(cave.getIdentifier());
                        }
                    }
                }
            } else if (evt.getActionCommand() == Record.NEW_PROBLEM_ID) {
                show(getMakeProblemDialog());
                showInformationMessage(RecordMessages.MAKE_NEW_PROBLEM_MESSAGE);
            } else if (evt.getActionCommand().equals(Record.CREATE_LOAD_PATIENT_DIALOG_CONTROL_ID)) {
                show(getLoadPatientDialog());
                showInformationMessage(RecordMessages.LOAD_PATIENT_MESSAGE);
            } else if (evt.getActionCommand() == Record.SAVE_MARKER_ID) {
                if (((RecordModel) getModel()).getCurrentHealthRecord() != null) {
                    saveHealthRecord(model.getCurrentHealthRecord());
                    //the image will be repainted, so the markers have to be drawn on it as well
                    if (view.getShowMarkersCheckBox().isSelected()) {
                        view.getImagePanel().drawMarkersForObject(model.getCurrentObject());
                    }
                    view.getShowMarkersCheckBox().setEnabled(true);
                    showInformationMessage(RecordMessages.MARKER_SUCESSFULLY_SAVED_MESSAGE);
                }
            } else if (evt.getActionCommand() == Record.NEW_PARTIAL_CONTACT_ID) {
                if (model.getCurrentEpisode() != null) {
                    model.createPartialContactTemplateForCurrentEpisode();
                }
                TreePath selectedPath = view.getTreeTablePanel().getTreeTable().getTree().getSelectionPath();
                expandTree();
                view.getTreeTablePanel().getTreeTable().getTree().expandPath(selectedPath);
                showInformationMessage(RecordMessages.NEW_EPISODE_TEMPLATE_CREATED_MESSAGE);
            } else if (evt.getActionCommand() == Record.CHANGE_FILTER_ID) {
                String selectedItem = view.getTreeTablePanel().getFilterComboBox().getSelectedItem().toString();
                if (selectedItem.equals("Plan")) {
                    ObjectModel planModel = new ObjectModel(model.getPlansFromCurrentEHR(), (RecordModel) getModel());
                    view.getTreeTablePanel().setTreeTableModel(planModel);
                }
                if (selectedItem.equals("Subjective")) {
                    ObjectModel planModel = new ObjectModel(model.getSubjectivesFromCurrentEHR(), (RecordModel) getModel());
                    view.getTreeTablePanel().setTreeTableModel(planModel);
                }
                if (selectedItem.equals("Assessment")) {
                    ObjectModel planModel = new ObjectModel(model.getAssessmentsFromCurrentEHR(), (RecordModel) getModel());
                    view.getTreeTablePanel().setTreeTableModel(planModel);
                }
                if (selectedItem.equals("Objective")) {
                    ObjectModel planModel = new ObjectModel(model.getObjectivesFromCurrentEHR(), (RecordModel) getModel());
                    view.getTreeTablePanel().setTreeTableModel(planModel);
                } else if (selectedItem.equals("All")) {
                    ObjectModel objectModel = new ObjectModel(model.getCurrentHealthRecord(), (RecordModel) getModel());
                    view.getTreeTablePanel().setTreeTableModel(objectModel);
                }
            } else if (evt.getActionCommand() == Record.REMOVE_PARTIAL_CONTACT_ID) {
                Object[] options = {"Ja", "Nein"};
                int n = JOptionPane.showOptionDialog((RecordView) getView(),
                        "Diesen Kontakt wirklich lschen?", "Besttigung", JOptionPane.YES_NO_OPTION, JOptionPane.QUESTION_MESSAGE,
                        null, options, options[1]);
                if (n == JOptionPane.YES_OPTION) {
                    removeCurrentPartialContactFromEHR();
                    TreePath selectedPath = view.getTreeTablePanel().getTreeTable().getTree().getSelectionPath();
                    expandTree();
                    removePartialContact(model.getCurrentPartialContact().getIdentifier());
                    view.getTreeTablePanel().resetButtonPanel();
                    showInformationMessage(RecordMessages.PARTIAL_CONTACT_REMOVED_MESSAGE);
                }
                TreePath selectedPath = view.getTreeTablePanel().getTreeTable().getTree().getSelectionPath();
                expandTree();
                view.getTreeTablePanel().getTreeTable().getTree().expandPath(selectedPath);
                //does not work:
            } else if (evt.getActionCommand() == Record.NEW_EPISODE_ID) {
                if (model.getCurrentProblem() != null) {
                    ((RecordModel) getModel()).createEpisodeForCurrentProblem();
                }
                TreePath selectedPath = view.getTreeTablePanel().getTreeTable().getTree().getSelectionPath();
                expandTree();
                view.getTreeTablePanel().getTreeTable().getTree().expandPath(selectedPath);
                showInformationMessage(RecordMessages.NEW_EPISODE_TEMPLATE_CREATED_MESSAGE);
                //does not work:
            } else if (evt.getActionCommand() == Record.NEW_MEDICATION_ID) {
                Medication medicament = new Medication();
                medicament.setName(new org.resmedicinae.resmedlib.term.String());
                Dose dose = new Dose();
                org.resmedicinae.resmedlib.term.String doseId = ObjectID.getNewOId();
                medicament.set(doseId, dose);
                dose.setIdentifier(doseId);
                org.resmedicinae.resmedlib.term.String medicamentId = ObjectID.getNewOId();
                ((Plan) model.getCurrentPartialContact().getPlans()[0]).set(medicamentId, medicament);
                medicament.setIdentifier(medicamentId);
                TreePath selectedPath = view.getTreeTablePanel().getTreeTable().getTree().getSelectionPath();
                expandTree();
                view.getTreeTablePanel().getTreeTable().getTree().expandPath(selectedPath);
                showInformationMessage(RecordMessages.NEW_EPISODE_TEMPLATE_CREATED_MESSAGE);
                //does not work:
            } else if (evt.getActionCommand() == Record.NEW_DISEASE_ID) {
                show(getMakeDiseaseDialog());
                //does not work:
            } else if (evt.getActionCommand() == Record.REMOVE_MEDICATION_ID) {
                if (model.getCurrentMedication() != null) {
                    ((Plan) model.getCurrentPartialContact().getPlans()
                            [0]).remove(model.getCurrentMedication().getIdentifier());
                    TreePath selectedPath = view.getTreeTablePanel().getTreeTable().getTree().getSelectionPath();
                    expandTree();
                    view.getTreeTablePanel().getTreeTable().getTree().expandPath(selectedPath);
                }
            } else if (evt.getActionCommand() == Record.CLOSE_ACTIVE_WINDOW_ID) {
                if (getLoadPatientDialog().isShowing()) {
                    hide(getLoadPatientDialog());
                }else if (getAlternativeOverlaysPreviewDialog().isShowing()) {
                    hide(getAlternativeOverlaysPreviewDialog());
                }
            }
            //Action commands raised by the toolbar---------------------------------------------------------------------
            else if (evt.getActionCommand() == Record.HISTORY_BACK_ID) {
                //?? Remove this try catch block later!
                //?? Couldn't throw Exception upwards cause this method header
                //?? doesn't allow for it.
                try {
                    model.backToPreviousOverlay();
                    synchronizeOverlayTree();
                    showInformationMessage(RecordMessages.BACK_TO_PREVIOUS_OVERLAY_SUCESSFULL_MESSAGE);
                } catch (Exception ex) {
                    System.out.println("Change file exception. Could not change file after history back command." + ex);
                    showErrorMessage(RecordMessages.BACK_TO_PREVIOUS_OVERLAY_NOT_SUCESSFULL_MESSAGE + ": " + ex);
                }
            }
            //Action commands raised by the RemoveOverlayDialog---------------------------------------------------------
            else if (evt.getActionCommand() == Record.REMOVE_OVERLAY_DIALOG_OK_ID) {
                showInformationMessage(RecordMessages.OVERLAY_SUCESSFULLY_REMOVED_MESSAGE);
            } else if (evt.getActionCommand() == Record.REMOVE_OVERLAY_DIALOG_CANCEL_ID) {
                showInformationMessage(RecordMessages.OVERLAY_NOT_SUCESSFULLY_REMOVED_MESSAGE);
            }
            //Action commands raised by the MakeOverlayDialog-----------------------------------------------------------
            else if (evt.getActionCommand() == Record.MAKE_OVERLAY_DIALOG_CHOOSE_FILE_ID) {
                showInformationMessage(RecordMessages.CHOOSE_PICTURE_MESSAGE);
                JFileChooser fc = new JFileChooser();
                fc.setCurrentDirectory(new File(RecordModel.RelativePictureDirectoryName));
                int returnVal = fc.showOpenDialog(getMakeOverlayDialog());
                if (returnVal == JFileChooser.APPROVE_OPTION) {
                    File picFile = fc.getSelectedFile();
                    File directoryFile = picFile;
                    String directoryName = new String();
                    //go through the directory path until it PictureDirectoryName, save the relative path
                    while (!directoryFile.getParentFile().getName().equals(RecordModel.PictureDirectoryName)) {
                        directoryName = directoryFile.getParentFile().getName() + "/" + directoryName;
                        directoryFile = directoryFile.getParentFile();
                    }
                    //save the relative path starting from PictureDirectoryName plus the pic name,
                    //so that it could be used when it is needed
                    //...no good solution, i know
                    setPicToUse(directoryName + picFile.getName());
                    //show only the file name, not the fill relative path
                    getMakeOverlayDialog().getPictureNameTextField().setText(picFile.getName());
                } else {
                }
            } else if (evt.getActionCommand() == Record.MAKE_OVERLAY_DIALOG_OK_ID) {
                String imageName = getMakeOverlayDialog().getNameTextField().getText();
                String pictureName = getMakeOverlayDialog().getPictureNameTextField().getText();
                String pictureDescription = getMakeOverlayDialog().getDescriptionTextArea().getText();
                //all fields have to be filled
                if ((imageName != "") && (getPicToUse() != "") && (pictureDescription != "")) {
                    //save immediatly to disk
                    model.saveOverlayToXMLFile(model.createOverlayDocument(imageName, getPicToUse(), pictureDescription));
                    addNewItemToAllComboBoxes(imageName);
                    hide(getMakeOverlayDialog());
                    view.getImagePanel().deleteCurrentRegionFromOverlay();
                    //Update overlay trees
                    OverlayTreeModel overlayTreeModel = new OverlayTreeModel(model);
                    view.getOverlayTree().setModel(overlayTreeModel);
                    System.out.println("MAKE_DISEASE_DIALOG_REMOVE_DISEASE_ID");
                    getMakeDiseaseDialog().getOverlayTree().setModel(overlayTreeModel);
                    showInformationMessage(RecordMessages.OVERLAY_SUCESSFULLY_CREATED_MESSAGE);
                } else {
                    JOptionPane.showMessageDialog(null, "Bitte alle Felder ausfllen", "Fehler!!!", JOptionPane.ERROR_MESSAGE);
                    showWarningMessage(RecordMessages.FIELD_LEFT_EMPTY_MESSAGE);
                }
            } else if (evt.getActionCommand() == Record.MAKE_OVERLAY_DIALOG_CANCEL_ID) {
                hide(getMakeOverlayDialog());
                showInformationMessage(RecordMessages.READY_MESSAGE);
                getMakeOverlayDialog().getNameTextField().setText("");
            }
            //Action commands raised by the EditOverlayDialog-----------------------------------------------------------
            else if (evt.getActionCommand() == Record.EDIT_OVERLAY_NEW_POLYGON_ID) {
                //preview the currently painted region represented by polyon points (painted by mouse clicks) on overlay
                view.getImagePanel().paintCurrentRegionOnOverlay();
                getEditOverlayDialog().getDeleteOverlayRegionButton().setEnabled(true);
                getEditOverlayDialog().getSaveOverlayRegionButton().setEnabled(true);
                showInformationMessage(RecordMessages.NEW_REGION_DRAWN_MESSAGE);
            } else if (evt.getActionCommand() == Record.EDIT_OVERLAY_DELETE_POLYGON_ID) {
                //remove the currently painted region from overlay and remove the points
                view.getImagePanel().deleteCurrentRegionFromOverlay();
                //no region: no saving
                getEditOverlayDialog().getSaveOverlayRegionButton().setEnabled(false);
                //no region: no last point
                getEditOverlayDialog().getDeleteLastPointButton().setEnabled(false);
                //no region: no deleting
                getEditOverlayDialog().getDeleteOverlayRegionButton().setEnabled(false);
                showInformationMessage(RecordMessages.REGION_REMOVED_MESSAGE);
            } else if (evt.getActionCommand() == Record.EDIT_OVERLAY_SAVE_POLYGON_ID) {
                getMakeOverlayRegionDialog().reInitialize();
                show(getMakeOverlayRegionDialog());
                getEditOverlayDialog().getSaveOverlayRegionButton().setEnabled(false);
                //view.getImagePanel().deleteCurrentRegionFromOverlay();
            } else if (evt.getActionCommand() == Record.EDIT_OVERLAY_DELETE_LAST_POINT_ID) {
                showInformationMessage(RecordMessages.REMOVED_LAST_REGION_POINT_MESSAGE);
                view.getImagePanel().deleteLastPaintedPoint();
                if (view.getImagePanel().getXCoordinates().isEmpty()) {
                    getEditOverlayDialog().getDeleteLastPointButton().setEnabled(false);
                    getEditOverlayDialog().getShowOverlayRegionButton().setEnabled(false);
                }
            } else if (evt.getActionCommand() == Record.EDIT_OVERLAY_CHOOSE_FILE_ID) {
                JComboBox source = (JComboBox) evt.getSource();
                //?? Remove this try catch block later!
                //?? Couldn't throw Exception upwards cause this method header
                //?? doesn't allow for it.
                try {
                    model.changeOverlay((String) source.getSelectedItem());
                    view.getImagePanel().updateImage();
                    updateAlternativeOverlays();
                    //clear the history vector when changing the file
                    model.getHistoryVector().clear();
                    model.getHistoryVector().add((String) source.getSelectedItem());
                    view.getHistoryBackButton().setEnabled(false);
                    getAlternativeOverlaysPreviewDialog().reInitialize();
                    showInformationMessage(RecordMessages.CHANGED_FILE_MESSAGE + (String) source.getSelectedItem());
                } catch (Exception ex) {
                    System.out.println("Change file exception. Could not change file after selecting file in edit overlay dialog." + ex);
                    showWarningMessage(RecordMessages.COULD_NOT_CHANGED_FILE_MESSAGE + (String) source.getSelectedItem());
                }
            }
            //Action command raised by EditOverlayRegionDialog---------------------------------------------------------
            else if (evt.getActionCommand() == Record.EDIT_OVERLAY_REGION_DIALOG_OK_ID) {
                EditOverlayRegionDialog editOverlayRegionFrame = getEditOverlayRegionDialog();
                String oldName = editOverlayRegionFrame.getOldName();
                String newName = editOverlayRegionFrame.getNameTextField().getText();
                String newTarget = (String) editOverlayRegionFrame.getTargetImageComboBox().getSelectedItem();
                //Managing neighbour new relationships---------------------------------------------------
                if (getEditOverlayRegionDialog().getTopNeighbourCheckBox().isSelected()) {
                    String selectedItem = (String) getEditOverlayRegionDialog().getTopNeighbourComboBox().getSelectedItem();
                    //first change the neighbour of the region....the region is called with the old name, that will changed
                    //into new name later into newName by model.editOverlayRegion(...)
                    model.changeTopNeighbourOfRegion(model.getCurrentDocument(), oldName, selectedItem);
                    //then change the region as new neighbour for the neighbour, of course with the new name!!!....
                    //(the other direction, back)
                    model.changeBottomNeighbourOfRegion(model.getCurrentDocument(), selectedItem, newName);
                }
                if (getEditOverlayRegionDialog().getBottomNeighbourCheckBox().isSelected()) {
                    String selectedItem = (String) getEditOverlayRegionDialog().getBottomNeighbourComboBox().getSelectedItem();
                    //first change the neighbour of the region....the region is called with the old name, that will changed
                    //into new name later into newName by model.editOverlayRegion(...)
                    model.changeBottomNeighbourOfRegion(model.getCurrentDocument(), oldName, selectedItem);
                    //then change the region as new neighbour for the neighbour, of course with the new name!!!....
                    //(the other direction, back)
                    model.changeTopNeighbourOfRegion(model.getCurrentDocument(), selectedItem, newName);
                }
                if (getEditOverlayRegionDialog().getLeftNeighbourCheckBox().isSelected()) {
                    String selectedItem = (String) getEditOverlayRegionDialog().getLeftNeighbourComboBox().getSelectedItem();
                    //first change the neighbour of the region....the region is called with the old name, that will changed
                    //into new name later into newName by model.editOverlayRegion(...)
                    model.changeLeftNeighbourOfRegion(model.getCurrentDocument(), oldName, selectedItem);
                    //then change the region as new neighbour for the neighbour, of course with the new name!!!....
                    //(the other direction, back)
                    model.changeRightNeighbourOfRegion(model.getCurrentDocument(), selectedItem, newName);
                }
                if (getEditOverlayRegionDialog().getRightNeighbourCheckBox().isSelected()) {
                    String selectedItem = (String) getEditOverlayRegionDialog().getRightNeighbourComboBox().getSelectedItem();
                    //first change the neighbour of the region....the region is called with the old name, that will changed
                    //into new name later into newName by model.editOverlayRegion(...)
                    model.changeRightNeighbourOfRegion(model.getCurrentDocument(), oldName, selectedItem);
                    //then change the region as new neighbour for the neighbour, of course with the new name!!!....
                    //(the other direction, back)
                    model.changeLeftNeighbourOfRegion(model.getCurrentDocument(), selectedItem, newName);
                }
                //?? Remove this try catch block later!
                //?? Couldn't throw Exception upwards cause this method header
                //?? doesn't allow for it.
                try {
                    TreePath selectedPath = getMakeDiseaseDialog().getOverlayTree().getEditingPath();

                    model.editOverlayRegion(oldName, newName, newTarget);

                    OverlayTreeModel overlayTreeModel = new OverlayTreeModel(model);
                    getMakeDiseaseDialog().getOverlayTree().setModel(overlayTreeModel);
                    getMakeDiseaseDialog().getOverlayTree().setSelectionPath(selectedPath);
                    getMakeDiseaseDialog().getOverlayTree().expandPath(selectedPath);
                    view.getOverlayTree().setModel(overlayTreeModel);
                    showInformationMessage(RecordMessages.NEW_REGION_SUCESSFULLY_CREATED_MESSAGE);
                } catch (Exception ex) {
                    System.out.println("Edit region exception. Could not edit region " + oldName +
                            "with new properties name: " + newName + " and new target: " + newTarget + " :" + ex);
                    showErrorMessage(RecordMessages.NEW_REGION_NOT_SUCESSFULLY_CREATED_MESSAGE + ": " + ex);
                }
                hide(getEditOverlayRegionDialog());
            } else if (evt.getActionCommand() == Record.EDIT_OVERLAY_REGION_DIALOG_DELETE_POLYGON_ID) {
                EditOverlayRegionDialog editOverlayRegionFrame = getEditOverlayRegionDialog();
                String oldName = editOverlayRegionFrame.getOldName();
                //?? Remove this try catch block later!
                //?? Couldn't throw Exception upwards cause this method header
                //?? doesn't allow for it.
                try {
                    model.deleteRegionsFromOverlay(oldName);
                    showInformationMessage(RecordMessages.REGION_SUCESSFULLY_REMOVED_MESSAGE);
                } catch (Exception ex) {
                    System.out.println("Edit region exception. Could not remove region." + ex);
                    showErrorMessage(RecordMessages.REGION_NOT_SUCESSFULLY_REMOVED_MESSAGE + ex);
                }
                hide(getEditOverlayRegionDialog());
            }
            //Action commands raised by LoadPatientDialog---------------------------------------------------------------
            else if (evt.getActionCommand() == Record.LOAD_PATIENT_DIALOG_OK_ID) {
                LoadPatientDialog d = getLoadPatientDialog();
                ListSelectionModel lsm = d.possibleNamesTable.getSelectionModel();
                view.getTreeTablePanel().resetButtonPanel();
                int selectedIndex = lsm.getMinSelectionIndex();
                if (selectedIndex == -1) {
                    if (d.possibleNamesTable.getRowCount() == 1) {
                        //if there is only only row in table, take this patient by pressing return
                        selectedIndex = 0;
                    } else {
                        JOptionPane.showMessageDialog(null, "Bitte einen Patienten selektieren", "Fehler!!!",
                                JOptionPane.ERROR_MESSAGE);
                        showWarningMessage(RecordMessages.NO_PATIENT_SELECTED_MESSAGE);
                    }
                }
                if (selectedIndex != -1) {
                    String selectedId = (String) d.tableModel.getValueAt(selectedIndex, 0);
                    HealthRecord patient = (HealthRecord) model.getPatientHashtable().get(selectedId);
                    if (patient != null) {
                        model.setCurrentHealthRecord(patient);
                        if (model.getCurrentHealthRecord().hasProblems()) {
                            Object[] problems = model.getCurrentHealthRecord().getProblems();
                            Problem problem = (Problem) problems[0];
                            model.setCurrentProblem(problem);
                            if (model.getCurrentProblem().hasEpisodes()) {
                                model.setCurrentEpisode(model.getCurrentProblem().getFirstEpisode());
                                if (model.getCurrentProblem().getFirstEpisode().hasPartialContacts()) {
                                    view.getRemoveCurrentObjectButton().setEnabled(true);
                                    view.getShowMarkersCheckBox().setEnabled(true);
                                } else {
                                    view.getShowMarkersCheckBox().setEnabled(false);
                                }
                                view.getChangeObjectButton().setEnabled(true);
                            } else {
                                model.setCurrentEpisode(null);
                                view.getChangeObjectButton().setEnabled(false);
                                view.getShowMarkersCheckBox().setEnabled(false);
                            }
                        } else {
                            model.setCurrentProblem(null);
                            view.getChangeObjectButton().setEnabled(false);
                        }
                        ObjectModel objectModel = new ObjectModel(patient, (RecordModel) getModel());
                        view.getTreeTablePanel().setTreeTableModel(objectModel);
                        view.getPatientInfoPanel().displayPatient(model.getCurrentHealthRecord());
                        view.getTreeTablePanel().getNewProblemButton().setEnabled(true);
                        showInformationMessage(RecordMessages.PATIENT_SUCESSFULLY_LOADED_MESSAGE);
                    } else {
                        showWarningMessage(RecordMessages.PATIENT_NOT_SUCESSFULLY_LOADED_MESSAGE);
                    }
                    hide(d);
                    d.getNameTextField().setText("");
                    view.getPatientInfoPanel().setEnabled(true);
                }
            } else if (evt.getActionCommand().equals(Record.LOAD_PATIENT_DIALOG_CANCEL_ID)) {
                showInformationMessage(RecordMessages.READY_MESSAGE);
                LoadPatientDialog d = getLoadPatientDialog();
                hide(d);
                d.getNameTextField().setText("");
            }
            //Action commands raised by MakeOverlayRegionDialog---------------------------------------------------------
            else if (evt.getActionCommand() == Record.MAKE_OVERLAY_REGION_DIALOG_OK_ID) {
                MakeOverlayRegionDialog createOverlayRegionFrame = getMakeOverlayRegionDialog();
                if (!(createOverlayRegionFrame.getOverlayRegionNameTextField().getText().equals("")) &&
                        (!((String) createOverlayRegionFrame.getTargetImageComboBox().getSelectedItem()).equals(""))) {
                    String overlayRegionName = createOverlayRegionFrame.getOverlayRegionNameTextField().getText();
                    String overlayRegionTarget = (String)
                            createOverlayRegionFrame.getTargetImageComboBox().getSelectedItem();
                    String overlayRegionNumber = createOverlayRegionFrame.getOverlayRegionNumberTextField().getText();
                    Vector xCoordinates = view.getImagePanel().getOverlayRegionXCoordinates();
                    Vector yCoordinates = view.getImagePanel().getOverlayRegionYCoordinates();
                    String rightNeighbour = new String();
                    String leftNeighbour = new String();
                    String topNeighbour = new String();
                    String bottomNeighbour = new String();
                    if (createOverlayRegionFrame.getRightNeighbourCheckBox().isSelected()) {
                        rightNeighbour = (String) createOverlayRegionFrame.getRightNeighbourComboBox().getSelectedItem();
                        model.changeLeftNeighbourOfRegion(model.getCurrentDocument(), rightNeighbour, overlayRegionName);
                    } else {
                        String rightNeihbour = "Kein rechter Nachbar";
                    }
                    if (createOverlayRegionFrame.getLeftNeighbourCheckBox().isSelected()) {
                        leftNeighbour = (String) createOverlayRegionFrame.getLeftNeighbourComboBox().getSelectedItem();
                        model.changeRightNeighbourOfRegion(model.getCurrentDocument(), leftNeighbour, overlayRegionName);
                    } else {
                        String rightNeihbour = "Kein linker Nachbar";
                    }
                    if (createOverlayRegionFrame.getTopNeighbourCheckBox().isSelected()) {
                        topNeighbour = (String) createOverlayRegionFrame.getTopNeighbourComboBox().getSelectedItem();
                        model.changeBottomNeighbourOfRegion(model.getCurrentDocument(), topNeighbour, overlayRegionName);
                    } else {
                        topNeighbour = "Kein oberer Nachbar";
                    }
                    if (createOverlayRegionFrame.getBottomNeighbourCheckBox().isSelected()) {
                        bottomNeighbour = (String) createOverlayRegionFrame.getBottomNeighbourComboBox().getSelectedItem();
                        model.changeTopNeighbourOfRegion(model.getCurrentDocument(), bottomNeighbour, overlayRegionName);
                    } else {
                        bottomNeighbour = "Kein unterer Nachbar";
                    }
                    model.saveOverlayRegion(overlayRegionName, overlayRegionTarget, overlayRegionNumber, xCoordinates,
                            yCoordinates, topNeighbour, bottomNeighbour, leftNeighbour, rightNeighbour);
                    hide(createOverlayRegionFrame);

                    int[] xarray = new int[xCoordinates.size()];
                    int[] yarray = new int[yCoordinates.size()];
                    for (int p = 0; p < xCoordinates.size(); p++) {
                        try {
                            xarray[p] = Integer.parseInt((String) xCoordinates.elementAt(p));
                            yarray[p] = Integer.parseInt((String) yCoordinates.elementAt(p));
                        } catch (Exception exception) {
                        }
                    }

                    OverlayRegion overlayRegion = new OverlayRegion(xarray,yarray,xCoordinates.size());
                    overlayRegion.setName(overlayRegionName);
                    overlayRegion.setTarget(overlayRegionTarget);
                    overlayRegion.setNumber(overlayRegionNumber);
                    overlayRegion.setRightNeighbour(rightNeighbour);
                    overlayRegion.setLeftNeighbour(leftNeighbour);
                    overlayRegion.setTopNeighbour(topNeighbour);
                    overlayRegion.setBottomNeighbour(bottomNeighbour);

                    /*Removing the polygon points after that...*/

                    view.getImagePanel().deleteCurrentRegionFromOverlay();
                    //no region: no saving
                    getEditOverlayDialog().getSaveOverlayRegionButton().setEnabled(false);
                    //no region: no last point
                    getEditOverlayDialog().getDeleteLastPointButton().setEnabled(false);
                    //no region: no deleting
                    getEditOverlayDialog().getDeleteOverlayRegionButton().setEnabled(false);
                    //view.getImagePanel().deleteCurrentRegionFromOverlay();
                    showInformationMessage(RecordMessages.NEW_REGION_SUCESSFULLY_CREATED_MESSAGE);
                    Overlay overlay = (Overlay)model.getOverlayHashtable().get(model.getNameFromDocument(model.getCurrentDocument()));
                    overlay.getOverlayRegionHashtable().put(overlayRegion.getName(),overlayRegion);

                    //Update overlay trees
                    OverlayTreeModel overlayTreeModel = new OverlayTreeModel(model);
                    view.getOverlayTree().setModel(overlayTreeModel);
                    getMakeDiseaseDialog().getOverlayTree().setModel(overlayTreeModel);
                } else {
                    JOptionPane.showMessageDialog(getMakeOverlayRegionDialog(), "Bitte berprfen Sie Ihre Eingabe !!!");
                }
            } else if (evt.getActionCommand() == Record.MAKE_OVERLAY_REGION_DIALOG_CANCEL_ID) {
                showInformationMessage(RecordMessages.READY_MESSAGE);
                MakeOverlayRegionDialog createOverlayRegionFrame = getMakeOverlayRegionDialog();
                createOverlayRegionFrame.getOverlayRegionNameTextField().setText("");
                hide(getMakeOverlayRegionDialog());
            } else if (evt.getActionCommand() == Record.MAKE_OVERLAY_REGION_DIALOG_CHANGE_PREVIEW_ID) {
                showInformationMessage(RecordMessages.READY_MESSAGE);
                MakeOverlayRegionDialog createOverlayRegionFrame = getMakeOverlayRegionDialog();
                String selectedTarget = (String) createOverlayRegionFrame.getTargetImageComboBox().getSelectedItem();
                Document doc = (Document) model.getImageHashtable().get(selectedTarget);
                if (model.getImageFromDocument(doc) != null) {
                    createOverlayRegionFrame.getTargetPreviewPanel().setImage(model.getImageFromDocument(doc));
                }
                createOverlayRegionFrame.getTargetPreviewPanel().updateGraphics();
            }
            //Action commands raised by MakeProblemDialog---------------------------------------------------------
            else if (evt.getActionCommand() == Record.MAKE_PROBLEM_DIALOG_CANCEL_ID) {
                hide(getMakeProblemDialog());
                getMakeProblemDialog().clearAllTextFields();
                showInformationMessage(RecordMessages.READY_MESSAGE);
            } else if (evt.getActionCommand() == MAKE_PROBLEM_DIALOG_CLEAR_ID) {
                getMakeProblemDialog().clearAllTextFields();
                showInformationMessage(RecordMessages.ALL_FIELDS_CLEARED_MESSAGE);
            } else if (evt.getActionCommand() == MAKE_PROBLEM_DIALOG_OK_ID) {
                System.out.println("MAKE_PROBLEM_DIALOG_OK_ID");
                String problemName = getMakeProblemDialog().getNameTextField().getText();
                String anamnese = getMakeProblemDialog().getAnamneseTextArea().getText();
                try {
                    model.createNewProblem(problemName, anamnese);
                } catch (Exception ex) {
                    System.out.println("Could not create Problem. Exception: " + ex);
                }
                view.getPatientInfoPanel().addProblemToProblemList(problemName);
                int rowCount = view.getTreeTablePanel().getTreeTable().getModel().getRowCount();
                System.out.println("vor expandTree()");
                TreePath selectedPath = view.getTreeTablePanel().getTreeTable().getTree().getSelectionPath();
                expandTree();
                view.getTreeTablePanel().getTreeTable().getTree().expandPath(selectedPath);
                System.out.println("nach expandTree()");
                expandTreeTable(rowCount);
                hide(getMakeProblemDialog());
                getMakeProblemDialog().clearAllTextFields();
                view.getTreeTablePanel().getTreeTable().getTree().expandPath(selectedPath);
                showInformationMessage(RecordMessages.NEW_PROBLEM_SUCESSFULLY_CREATED_MESSAGE);
            }
            //Action commands raised by MakeEpisodeDialog---------------------------------------------------------
            else if (evt.getActionCommand() == Record.NEW_REPORT_ID) {
                if (model.getCurrentDocument() != null) {
                    getMakeReportOnOverlayDialog().setTitle(model.getNameFromDocument(model.getCurrentDocument()));
                    getMakeReportOnOverlayDialog().getReportTextArea().setText("");
                    show(getMakeReportOnOverlayDialog());
                    showInformationMessage(RecordMessages.MAKE_NEW_REPORT_ON_OVERLAY_MESSAGE);
                } else {
                    showWarningMessage(RecordMessages.NO_PATIENT_LOADED_MESSAGE);
                }
                //Action commads raised by MakeReportOnOverlayDialog--------------------------------------------------------
            } else if (evt.getActionCommand() == Record.MAKE_REPORT_ON_OVERLAY_OK_ID) {
                if (model.getCurrentPartialContact() != null) {
                    Objective newObjective = new Objective(getMakeReportOnOverlayDialog().getReportTextArea().getText());
                    newObjective.setOverlayName(model.getNameFromDocument(model.getCurrentDocument()));
                    newObjective.setIdentifier(ObjectID.getNewOId());
                    model.getCurrentPartialContact().set(newObjective.getIdentifier(), newObjective);
                    model.setCurrentObject(newObjective);
                    TreePath selectedPath = view.getTreeTablePanel().getTreeTable().getTree().getSelectionPath();
                    expandTree();
                    view.getTreeTablePanel().getTreeTable().getTree().expandPath(selectedPath);
                    saveHealthRecord(model.getCurrentHealthRecord());
                    //removing markers if there are any from the last overlay
                    view.getImagePanel().updateImage();
                    view.getReportTextArea().setText(model.getCurrentObject().getText().getValue());
                    hide(getMakeReportOnOverlayDialog());
                } else {
                    showWarningMessage(RecordMessages.NO_EPISODE_LOADED_MESSAGE);
                }
            } else if (evt.getActionCommand() == Record.MAKE_REPORT_ON_OVERLAY_CANCEL_ID) {
                hide(getMakeReportOnOverlayDialog());
            } else if (evt.getActionCommand() == Record.REMOVE_PROBLEM_ID) {
                Object[] options = {"Ja", "Nein"};
                int n = JOptionPane.showOptionDialog((RecordView) getView(),
                        "Dieses Problem wirklich lschen?", "Besttigung", JOptionPane.YES_NO_OPTION, JOptionPane.QUESTION_MESSAGE,
                        null, options, options[1]);
                if (n == JOptionPane.YES_OPTION) {
                    removeCurrentProblemFromEHR();
                    removeProblem(model.getCurrentProblem().getIdentifier());
                    view.getPatientInfoPanel().getProblemListModel().removeElement(model.getCurrentProblem().getName());
                    model.setCurrentProblem(null);
                    TreePath selectedPath = view.getTreeTablePanel().getTreeTable().getTree().getSelectionPath();
                    expandTree();
                    view.getTreeTablePanel().getTreeTable().getTree().expandPath(selectedPath);
                    view.getTreeTablePanel().update();
                    view.getTreeTablePanel().resetButtonPanel();
                }
            } else if (evt.getActionCommand() == Record.REMOVE_EPISODE_ID) {
                Object[] options = {"Ja", "Nein"};
                int n = JOptionPane.showOptionDialog((RecordView) getView(),
                        "Diese Episode wirklich lschen?", "Besttigung", JOptionPane.YES_NO_OPTION, JOptionPane.QUESTION_MESSAGE,
                        null, options, options[1]);
                if (n == JOptionPane.YES_OPTION) {
                    removeCurrentEpisodeFromEHR();
                    TreePath selectedPath = view.getTreeTablePanel().getTreeTable().getTree().getSelectionPath();
                    expandTree();
                    view.getTreeTablePanel().getTreeTable().getTree().expandPath(selectedPath);
                    removeEpisode(model.getCurrentEpisode().getIdentifier());
                    view.getTreeTablePanel().resetButtonPanel();
                }

                //Action commads raised by Manage Panel----------------------------------------------------------
            } else if (evt.getActionCommand() == Record.BACK_TO_START_OVERLAY_ID) {
                //setting all prperties concerning patients, markers and so on to initial values
                model.setCurrentObject(null);
                view.getImagePanel().getMarkerXCoordinates().clear();
                view.getImagePanel().getMarkerYCoordinates().clear();
                view.getShowMarkersCheckBox().setSelected(false);
                view.getShowMarkersCheckBox().setEnabled(false);
                model.changeOverlay(RecordModel.StartDocumentName);
                model.getHistoryVector().removeAllElements();
                model.getHistoryVector().add(RecordModel.StartDocumentName);
                view.getOverlayRegionTargetEntryLabel().setText("");
                view.getOverlayRegionNameEntryLabel().setText("");
                view.getPreviewPanel().setImage(kit.getImage("bilder/empty.jpg"));
                view.getPreviewPanel().updateGraphics();
                //view.getImagePanel().updateImage();
                updateAlternativeOverlays();
                getAlternativeOverlaysPreviewDialog().reInitialize();
                view.getHistoryBackButton().setEnabled(false);
                synchronizeOverlayTree();
            } else if (evt.getActionCommand() == Record.SHOW_ALTERNATIVE_OVERLAY_ID) {
                setOverlayBackup(model.getNameFromDocument(model.getCurrentDocument()));
                show(getAlternativeOverlaysPreviewDialog());
                view.getHistoryBackButton().setEnabled(false);
            } else if (evt.getActionCommand() == Record.REMOVE_MARKER_ID) {
                model.removeMarkersFromCurrentObject();
                saveHealthRecord(model.getCurrentHealthRecord());
                view.getImagePanel().updateImage();
                view.getShowMarkersCheckBox().setSelected(false);
                view.getShowMarkersCheckBox().setEnabled(false);
            } else if (evt.getActionCommand() == Record.NEXT_OBJECT_ID) {
                PartialContact currentPartialContact = model.getCurrentPartialContact();
                if (currentPartialContact.hasObjectives()) {
                    Objective object = ((Objective) currentPartialContact.getObjectives()[getObjectIndex()]);
                    int objectCount = currentPartialContact.getObjectives().length;
                    model.setCurrentObject(object);
                    model.changeOverlay(model.getCurrentObject().getOverlayName());
                    view.getReportTextArea().setText(model.getCurrentObject().getText().getValue());
                    updateAlternativeOverlays();
                    if (view.getShowMarkersCheckBox().isSelected()) {
                        view.getImagePanel().updateImage();
                        view.getImagePanel().drawMarkersForObject(model.getCurrentObject());
                    } else {
                        view.getImagePanel().updateImage();
                    }
                    if (model.getCurrentObject().hasMarkers()) {
                        view.getShowMarkersCheckBox().setEnabled(true);
                    } else {
                        view.getShowMarkersCheckBox().setSelected(false);
                        view.getShowMarkersCheckBox().setEnabled(false);
                    }
                    setObjectIndex(getObjectIndex() + 1);
                    if (getObjectIndex() == objectCount) {
                        setObjectIndex(0);
                    }
                }
            } else if (evt.getActionCommand() == Record.REMOVE_CURRENT_OBJECT_ID) {
                if (model.getCurrentEpisode() != null) {
                    if (model.getCurrentPartialContact().hasObjectives()) {
                        model.getCurrentPartialContact().remove(model.getCurrentObject().getIdentifier());
                        removeObjective(model.getCurrentObject().getIdentifier());
                        setObjectIndex(getObjectIndex() - 1);

                    }
                    if (model.getCurrentPartialContact().hasObjectives()) {
                        Objective object = (Objective) (model.getCurrentPartialContact().getObjectives()[0]);
                        model.setCurrentObject(object);
                        try {
                            model.changeOverlay(object.getOverlayName());
                        } catch (Exception ex) {
                            showErrorMessage(RecordMessages.COULD_NOT_CHANGED_FILE_MESSAGE + ex);
                        }
                        view.getImagePanel().updateImage();
                        view.getReportTextArea().setText(object.getText().getValue());
                    } else {
                        try {
                            model.changeOverlay(RecordModel.StartDocumentName);
                        } catch (Exception ex) {
                            showErrorMessage(RecordMessages.COULD_NOT_CHANGED_FILE_MESSAGE + ex);
                        }
                        view.getImagePanel().updateImage();
                        view.getReportTextArea().setText("");
                        showInformationMessage(RecordMessages.NO_OBJECT_LOADED_MESSAGE);
                    }
                }
                ObjectModel objectModel = new ObjectModel(model.getCurrentHealthRecord(), (RecordModel) getModel());
                view.getTreeTablePanel().setTreeTableModel(objectModel);
            }
            //Action commads raised by EditOverlayRegionDialog----------------------------------------------------------
            else if (evt.getActionCommand() == Record.EDIT_ALTERNATIVE_OVERLAY_DIALOG_ADD_ID) {
                String selectedValue = (String) getEditAlternativeOverlaysDialog().getAllOverlaysList().getSelectedValue();
                if (!getEditAlternativeOverlaysDialog().getAlternativeOverlaysListModel().contains(selectedValue)) {
                    getEditAlternativeOverlaysDialog().getAlternativeOverlaysListModel().addElement(selectedValue);
                } else {
                    showWarningMessage(RecordMessages.ALTERNATIVE_OVERLAY_ALREADY_IN_LIST_MESSAGE);
                }
            } else if (evt.getActionCommand() == Record.EDIT_ALTERNATIVE_OVERLAY_DIALOG_REMOVE_ID) {
                String selectedValue = (String) getEditAlternativeOverlaysDialog().getAlternativeOverlaysList().getSelectedValue();
                if (selectedValue != null) {
                    getEditAlternativeOverlaysDialog().getAlternativeOverlaysListModel().removeElement(selectedValue);
                } else {
                    showWarningMessage(RecordMessages.NO_ALTERNATIVE_OVERLAY_SELECTED_MESSAGE);
                }
            } else if (evt.getActionCommand() == Record.EDIT_ALTERNATIVE_OVERLAY_DIALOG_OK_ID) {
                EditAlternativeOverlayDialog e = getEditAlternativeOverlaysDialog();
                Vector alternativeOverlays = new Vector();
                if (e.getAlternativeOverlaysListModel().getSize() > 0) {
                    for (int i = 0; i < e.getAlternativeOverlaysListModel().getSize(); i++) {
                        String alternativeOverlay = (String) e.getAlternativeOverlaysListModel().elementAt(i);
                        alternativeOverlays.addElement(alternativeOverlay);
                    }
                    //alternativeOverlays.add(model.getNameFromDocument(model.getCurrentDocument()));
                }
                //changing the object:
                String currentDocumentName = model.getNameFromDocument(model.getCurrentDocument());
                Overlay currentOverlay = (Overlay)model.getOverlayHashtable().get(currentDocumentName);
                currentOverlay.setAlternativeOverlays(alternativeOverlays);
                //saving to xml:
                model.setAlternativeOverlaysForCurrentOverlay(alternativeOverlays);
                for (int ii = 0; ii < alternativeOverlays.size(); ii++) {
                    Document doc = model.getDocumentByName((String) alternativeOverlays.elementAt(ii));
                    model.saveAlternativeOverlays(doc);
                }
                model.saveAlternativeOverlays(model.getCurrentDocument());
                TreePath selectedPath = getMakeDiseaseDialog().getOverlayTree().getEditingPath();
                OverlayTreeModel overlayTreeModel = new OverlayTreeModel(model);
                getMakeDiseaseDialog().getOverlayTree().setModel(overlayTreeModel);
                getMakeDiseaseDialog().getOverlayTree().setSelectionPath(selectedPath);
                getMakeDiseaseDialog().getOverlayTree().expandPath(selectedPath);
                view.getOverlayTree().setModel(overlayTreeModel);
                getAlternativeOverlaysPreviewDialog().reInitialize();
                hide(getEditAlternativeOverlaysDialog());
            } else if (evt.getActionCommand() == Record.EDIT_ALTERNATIVE_OVERLAY_DIALOG_CANCEL_ID) {
                hide(getEditAlternativeOverlaysDialog());
            } else if (evt.getActionCommand() == Record.CHANGE_ALTERNATIVE_OVERLAY_PREVIEW_ID) {
                Enumeration e = getAlternativeOverlaysPreviewDialog().getGroup().getElements();
                while (e.hasMoreElements()) {
                    JRadioButton rb = (JRadioButton) e.nextElement();
                    if (rb.isSelected()) {
                        String overlayName = rb.getText();
                        model.changeOverlay(overlayName);
                        view.getImagePanel().updateImage();
                    }
                }
            } else if (evt.getActionCommand() == Record.MAKE_CAVE_DIALOG_OK_ID) {
                org.resmedicinae.resmedlib.term.String caveName = new org.resmedicinae.resmedlib.term.String(this.getMakeNewCAVEEntryDialog().getCaveNameTextField().getText());
                org.resmedicinae.resmedlib.term.String caveDescription = new org.resmedicinae.resmedlib.term.String(this.getMakeNewCAVEEntryDialog().getCaveDescriptionTextArea().getText());
                model.createNewCaveEntryForCurrentPatient(caveName, caveDescription);
                view.getPatientInfoPanel().getCaveListModel().addElement(caveName.getValue());
                hide(getMakeNewCAVEEntryDialog());
            } else if (evt.getActionCommand() == Record.MAKE_CAVE_DIALOG_CANCEL_ID) {
                hide(getMakeNewCAVEEntryDialog());
            } else if (evt.getActionCommand() == Record.MAKE_CAVE_DIALOG_CLEAR_ID) {
                getMakeNewCAVEEntryDialog().getCaveDescriptionTextArea().setText("");
                getMakeNewCAVEEntryDialog().getCaveNameTextField().setText("");
            } else if (evt.getActionCommand() == LoadPatientDialog.SELECT_HEALTHRECORD_LOAD_PATIENT_DIALOG_CONTROL_ID) {
                Control c = new Control();
                c.setId(evt.getActionCommand());
                try {
                    System.out.println("Handling c.................:SELECT_HEALTHRECORD_LOAD_PATIENT_DIALOG_CONTROL_ID");
                    handle(c);
                    expandTree();
                    view.getPatientInfoPanel().displayPatient(model.getCurrentHealthRecord());
                } catch (Exception ex) {
                    ex.printStackTrace();
                }
            }else if (evt.getActionCommand() == Record.MAKE_DISEASE_DIALOG_OK_ID) {
                String diseaseName = getMakeDiseaseDialog().getDiseaseNameTextField().getText();
                String diseaseDescription = getMakeDiseaseDialog().getDiseaseDescriptionTextArea().getText();
                System.out.println("MAKE_DISEASE_DIALOG_OK_ID");
                Object node = getMakeDiseaseDialog().getOverlayTree().getLastSelectedPathComponent();
                if(node==null){
                     JOptionPane.showMessageDialog(getMakeDiseaseDialog(), "Please select overlay!!!");
                }else{
                    if(node.getClass()!=Overlay.class){
                        JOptionPane.showMessageDialog(getMakeDiseaseDialog(), "Please select overlay!!!");
                    }else{
                        Overlay overlay = (Overlay)node;
                        if(overlay.hasDisease(diseaseName)){
                            JOptionPane.showMessageDialog(getMakeDiseaseDialog(), "Disease already in overlay!!!");
                        }else if (diseaseName==""){
                            JOptionPane.showMessageDialog(getMakeDiseaseDialog(), "Please fill in name for disease!!!");
                        }else{
                            TreePath selectedPath = getMakeDiseaseDialog().getOverlayTree().getSelectionPath();
                            model.createNewDisease(diseaseName, diseaseDescription, overlay);
                            OverlayTreeModel overlayTreeModel = new OverlayTreeModel(model);
                            getMakeDiseaseDialog().getOverlayTree().setModel(overlayTreeModel);
                            getMakeDiseaseDialog().getOverlayTree().setSelectionPath(selectedPath);
                            getMakeDiseaseDialog().getOverlayTree().expandPath(selectedPath);
                            view.getOverlayTree().setModel(overlayTreeModel);
                        }
                    }
                }
            }else if (evt.getActionCommand() == Record.MAKE_DISEASE_DIALOG_CLEAR_ID) {
                getMakeDiseaseDialog().getDiseaseDescriptionTextArea().setText("");
                getMakeDiseaseDialog().getDiseaseNameTextField().setText("");
            }else if (evt.getActionCommand() == Record.MAKE_DISEASE_DIALOG_CANCEL_ID) {
                try{
                    getMakeDiseaseDialog().getDiseaseDescriptionTextArea().setText("");
                    getMakeDiseaseDialog().getDiseaseNameTextField().setText("");
                    hide(getMakeDiseaseDialog());
                }catch(Exception ex){
                    System.out.println("Could not hide makeDiseaseDialog");
                }
            }else if (evt.getActionCommand() == Record.MAKE_DISEASE_DIALOG_REMOVE_DISEASE_ID) {
                Object node = getMakeDiseaseDialog().getOverlayTree().getLastSelectedPathComponent();
                if(node==null){
                     JOptionPane.showMessageDialog(getMakeDiseaseDialog(), "Please select a disease or overlay to remove!!!");
                }else{
                    /*if((node.getClass()!=Disease.class)||(node.getClass()!=Overlay.class)){
                        JOptionPane.showMessageDialog(getMakeDiseaseDialog(), "Please select a disease or overlay to remove!!!");
                    }else{*/
                        if(node.getClass()==Disease.class){
                            Disease disease = (Disease)node;
                            Overlay overlay = (Overlay)disease.getParent();
                            model.removeDiseaseFromOverlay(disease, overlay);
                            overlay.remove(new org.resmedicinae.resmedlib.term.String(disease.getDiseaseName()));
                            showInformationMessage(RecordMessages.DISEASE_SUCESSFULLY_REMOVED_MESSAGE);
                        }else if (node.getClass()==Overlay.class){
                            Overlay overlay = (Overlay)node;
                            model.deleteOverlayDocument(overlay.getName());
                            //Removing overlay from the overlayRegion objects
                            Enumeration enum = model.getOverlayHashtable().elements();
                            while(enum.hasMoreElements()){
                                Overlay tempOverlay = (Overlay)enum.nextElement();
                                Enumeration regionEnum = tempOverlay.getOverlayRegionHashtable().elements();
                                while(regionEnum.hasMoreElements()){
                                    OverlayRegion region = (OverlayRegion)regionEnum.nextElement();
                                    if(region.getTarget().equals(overlay.getName())){
                                        tempOverlay.getOverlayRegionHashtable().remove(region.getName());
                                    }
                                }
                            }
                            showInformationMessage(RecordMessages.OVERLAY_SUCESSFULLY_REMOVED_MESSAGE);
                        }
                        //Update overlay trees
                        TreePath selectedPath = getMakeDiseaseDialog().getOverlayTree().getSelectionPath();
                        OverlayTreeModel overlayTreeModel = new OverlayTreeModel(model);
                        view.getOverlayTree().setModel(overlayTreeModel);
                        getMakeDiseaseDialog().getOverlayTree().setModel(overlayTreeModel);
                        getMakeDiseaseDialog().getOverlayTree().setSelectionPath(selectedPath);
                        getMakeDiseaseDialog().getOverlayTree().expandPath(selectedPath);
                    //}
                }
            }else if (evt.getActionCommand() == Record.MAKE_DISEASE_DIALOG_COMMIT_CHANGES_IN_DISEASE_ID) {
                Object node = getMakeDiseaseDialog().getOverlayTree().getLastSelectedPathComponent();
                if(node==null){
                     JOptionPane.showMessageDialog(getMakeDiseaseDialog(), "Please select a disease to edit!!!");
                }else{
                    if(node.getClass()!=Disease.class){
                        JOptionPane.showMessageDialog(getMakeDiseaseDialog(), "Please select a disease to edit!!!");
                    }else{
                        if(getMakeDiseaseDialog().getDiseaseNameTextField().getText().equals("")){
                            JOptionPane.showMessageDialog(getMakeDiseaseDialog(), "Name has to be filled in!!!");
                        }else{
                            Disease disease = (Disease)node;
                            String newDiseaseName = getMakeDiseaseDialog().getDiseaseNameTextField().getText();
                            String newDiseaseDescription = getMakeDiseaseDialog().getDiseaseDescriptionTextArea().getText();
                            model.updateDisease(disease, newDiseaseName, newDiseaseDescription);
                            disease.setDiseaseName(getMakeDiseaseDialog().getDiseaseNameTextField().getText());
                            disease.setDiseaseDescription(getMakeDiseaseDialog().getDiseaseDescriptionTextArea().getText());
                            TreePath selectedPath = getMakeDiseaseDialog().getOverlayTree().getSelectionPath();
                            OverlayTreeModel overlayTreeModel = new OverlayTreeModel(model);
                            view.getOverlayTree().setModel(overlayTreeModel);
                            System.out.println("MAKE_DISEASE_DIALOG_COMMIT_CHANGES_IN_DISEASE_ID");
                            getMakeDiseaseDialog().getOverlayTree().setModel(overlayTreeModel);
                            getMakeDiseaseDialog().getOverlayTree().setSelectionPath(selectedPath);
                            getMakeDiseaseDialog().getOverlayTree().expandPath(selectedPath);
                        }
                    }
                }
            }
            else {
                Control c = new Control();
                c.setId(evt.getActionCommand());
                handle(c);
            }
        } catch (Exception e) {
            System.out.println("Exception in Record.actionPerformed(...) :" + e);
        }
    }

    /**
     * Handles all item events of the whole application.
     * @param evt the item event
     */
    public void itemStateChanged(ItemEvent evt) {
        RecordView view = (RecordView) getView();
        RecordModel model = (RecordModel) getModel();
        if (getEditOverlayDialog().getShowOverlayRegionsCheckBox() == (JCheckBox) evt.getItem()) {
            if (getEditOverlayDialog().getShowOverlayRegionsCheckBox().isSelected()) {
                showAllOverlayRegions();
            } else if (!getEditOverlayDialog().getShowOverlayRegionsCheckBox().isSelected()) {
                view.getImagePanel().updateImage();
            }
            //MakeOverlayRegionDialog Checkboxes-------------------------------------------------------------
        } else if (getMakeOverlayRegionDialog().getBottomNeighbourCheckBox() == (JCheckBox) evt.getItem()) {
            if (getMakeOverlayRegionDialog().getBottomNeighbourCheckBox().isSelected()) {
                getMakeOverlayRegionDialog().getBottomNeighbourComboBox().setEnabled(true);
            } else if (!getMakeOverlayRegionDialog().getBottomNeighbourCheckBox().isSelected()) {
                getMakeOverlayRegionDialog().getBottomNeighbourComboBox().setEnabled(false);
            }
        } else if (getMakeOverlayRegionDialog().getTopNeighbourCheckBox() == (JCheckBox) evt.getItem()) {
            if (getMakeOverlayRegionDialog().getTopNeighbourCheckBox().isSelected()) {
                getMakeOverlayRegionDialog().getTopNeighbourComboBox().setEnabled(true);
            } else if (!getMakeOverlayRegionDialog().getTopNeighbourCheckBox().isSelected()) {
                getMakeOverlayRegionDialog().getTopNeighbourComboBox().setEnabled(false);
            }
        } else if (getMakeOverlayRegionDialog().getLeftNeighbourCheckBox() == (JCheckBox) evt.getItem()) {
            if (getMakeOverlayRegionDialog().getLeftNeighbourCheckBox().isSelected()) {
                getMakeOverlayRegionDialog().getLeftNeighbourComboBox().setEnabled(true);
            } else if (!getMakeOverlayRegionDialog().getLeftNeighbourCheckBox().isSelected()) {
                getMakeOverlayRegionDialog().getLeftNeighbourComboBox().setEnabled(false);
            }
        } else if (getMakeOverlayRegionDialog().getRightNeighbourCheckBox() == (JCheckBox) evt.getItem()) {
            if (getMakeOverlayRegionDialog().getRightNeighbourCheckBox().isSelected()) {
                getMakeOverlayRegionDialog().getRightNeighbourComboBox().setEnabled(true);
            } else if (!getMakeOverlayRegionDialog().getRightNeighbourCheckBox().isSelected()) {
                getMakeOverlayRegionDialog().getRightNeighbourComboBox().setEnabled(false);
            }
        }
        //EditOverlayRegionDialog Checkboxes-------------------------------------------------------------
        else if (getEditOverlayRegionDialog().getTopNeighbourCheckBox() == (JCheckBox) evt.getItem()) {
            if (getEditOverlayRegionDialog().getTopNeighbourCheckBox().isSelected()) {
                getEditOverlayRegionDialog().getTopNeighbourComboBox().setEnabled(true);
            } else if (!getEditOverlayRegionDialog().getTopNeighbourCheckBox().isSelected()) {
                getEditOverlayRegionDialog().getTopNeighbourComboBox().setEnabled(false);
            }
        } else if (getEditOverlayRegionDialog().getBottomNeighbourCheckBox() == (JCheckBox) evt.getItem()) {
            if (getEditOverlayRegionDialog().getBottomNeighbourCheckBox().isSelected()) {
                getEditOverlayRegionDialog().getBottomNeighbourComboBox().setEnabled(true);
            } else if (!getEditOverlayRegionDialog().getBottomNeighbourCheckBox().isSelected()) {
                getEditOverlayRegionDialog().getBottomNeighbourComboBox().setEnabled(false);
            }
        } else if (getEditOverlayRegionDialog().getLeftNeighbourCheckBox() == (JCheckBox) evt.getItem()) {
            if (getEditOverlayRegionDialog().getLeftNeighbourCheckBox().isSelected()) {
                getEditOverlayRegionDialog().getLeftNeighbourComboBox().setEnabled(true);
            } else if (!getEditOverlayRegionDialog().getLeftNeighbourCheckBox().isSelected()) {
                getEditOverlayRegionDialog().getLeftNeighbourComboBox().setEnabled(false);
            }
        } else if (getEditOverlayRegionDialog().getRightNeighbourCheckBox() == (JCheckBox) evt.getItem()) {
            if (getEditOverlayRegionDialog().getRightNeighbourCheckBox().isSelected()) {
                getEditOverlayRegionDialog().getRightNeighbourComboBox().setEnabled(true);
            } else if (!getEditOverlayRegionDialog().getRightNeighbourCheckBox().isSelected()) {
                getEditOverlayRegionDialog().getRightNeighbourComboBox().setEnabled(false);
            }
        } else if (view.getGrabFocusCheckBox() == (JCheckBox) evt.getItem()) {
            if (view.getGrabFocusCheckBox().isSelected()) {
                showInformationMessage(RecordMessages.KEYBOARD_CONTROL_SELECTED_MESSAGE);
                view.getImagePanel().grabFocus();
                if (!model.getOverlayRegionsFromDocument(model.getCurrentDocument()).isEmpty()) {
                    Enumeration e = model.getOverlayRegionsFromDocument(model.getCurrentDocument()).elements();
                    OverlayRegion overlayRegion = (OverlayRegion) e.nextElement();
                    model.setCurrentOverlayRegion(overlayRegion);
                    paintOverlayRegionOnOverlay(model.getCurrentOverlayRegion());
                }
            } else if (!view.getGrabFocusCheckBox().isSelected()) {
                showInformationMessage(RecordMessages.MOUSE_CONTROL_SELECTED_MESSAGE);
                view.grabFocus();
            }
        } else if (view.getShowMarkersCheckBox() == (JCheckBox) evt.getItem()) {
            if (view.getShowMarkersCheckBox().isSelected()) {
                if (model.getCurrentObject() != null) {
                    view.getImagePanel().drawMarkersForObject(model.getCurrentObject());
                    ;
                } else {
                    showWarningMessage(RecordMessages.NO_OBJECT_LOADED_MESSAGE);
                }
            } else if ((!view.getShowMarkersCheckBox().isSelected()) &&
                    (!getEditOverlayDialog().getShowOverlayRegionsCheckBox().isSelected())) {
                view.getImagePanel().updateImage();
            }
        }
    }


    /**Paint the first overlayRegion of the overlay
     *
     */
    public void highlightFirstRegion(){
        RecordModel model = (RecordModel)getModel();
        if (!model.getOverlayRegionsFromDocument(model.getCurrentDocument()).isEmpty()) {
            Enumeration e = model.getOverlayRegionsFromDocument(model.getCurrentDocument()).elements();
            OverlayRegion overlayRegion = (OverlayRegion) e.nextElement();
            model.setCurrentOverlayRegion(overlayRegion);
            paintOverlayRegionOnOverlay(model.getCurrentOverlayRegion());
        }
    }

    /**
     * Handles all keyPressed events of the whole application.
     * @param evt the key pressed event
     */
    public void keyPressed(KeyEvent evt) {
    }

    /**
     * Handles all keyTyped events of the whole application.
     * @param evt the key typed event
     */
    public void keyTyped(KeyEvent evt) {
    }

    /**
     * Handles all keyReleased events of the whole application.
     * @param evt the key released event
     */
    public void keyReleased(KeyEvent evt) {
        RecordModel model = (RecordModel) getModel();
        RecordView view = (RecordView) getView();
        Enumeration enumerationOfAlternativeOverlays = getAlternativeOverlaysPreviewDialog().getGroup().getElements();
        if (view.getTreeTablePanel().getTreeTable().hasFocus()) {
            System.out.println("TreeTable has focus");
            if (evt.getKeyCode() == KeyEvent.VK_F1) {
                int selectedRow = view.getTreeTablePanel().getTreeTable().getSelectedRow();
                if (view.getTreeTablePanel().getTreeTable().getTree().isExpanded(selectedRow)) {
                    view.getTreeTablePanel().getTreeTable().getTree().collapseRow(selectedRow);
                    view.getTreeTablePanel().getTreeTable().getTree().setSelectionRow(selectedRow);
                } else if (view.getTreeTablePanel().getTreeTable().getTree().isCollapsed(selectedRow)) {
                    view.getTreeTablePanel().getTreeTable().getTree().expandRow(selectedRow);
                    view.getTreeTablePanel().getTreeTable().getTree().setSelectionRow(selectedRow);
                }
            }
        } else {
            if (view.getImagePanel().hasFocus()) {
                view.getGrabFocusCheckBox().setSelected(true);
            }
            if (evt.getKeyCode() == KeyEvent.VK_F5) {
                ((RecordView) getView()).getImagePanel().setFocusable(true);
                model.incrementOverlayRegionIndex();
                if (model.overlayRegionsAvailable()) {
                    Enumeration keyEnum = model.getCurrentOverlayRegions().keys();
                    OverlayRegion overlayRegion = (OverlayRegion) model.getCurrentOverlayRegions().get(keyEnum.nextElement());
                    model.setCurrentOverlayRegion(overlayRegion);
                    paintOverlayRegionOnOverlay(overlayRegion);
                }
            } else if (evt.getKeyCode() == KeyEvent.VK_LEFT) {
                if(!view.getImagePanel().hasFocus()){
                    view.getImagePanel().grabFocus();
                    highlightFirstRegion();
                }
                if (model.getCurrentOverlayRegion() != null) {
                    model.decrementOverlayRegionIndex();
                    String leftNeighbour = model.getCurrentOverlayRegion().getLeftNeighbour();
                    OverlayRegion overlayRegion = (OverlayRegion) model.getCurrentOverlayRegions().get(leftNeighbour);
                    if (overlayRegion != null) {
                        model.setCurrentOverlayRegion(overlayRegion);
                        paintOverlayRegionOnOverlay(overlayRegion);
                        showInformationMessage(RecordMessages.SWITCHED_TO_REGION_SUCESSFULL_MESSAGE + overlayRegion.getName());
                    } else {
                        showWarningMessage(RecordMessages.SWITCHED_TO_REGION_NOT_SUCESSFULL_MESSAGE);
                    }
                }
            } else if (evt.getKeyCode() == KeyEvent.VK_RIGHT) {
                if(!view.getImagePanel().hasFocus()){
                    view.getImagePanel().grabFocus();
                    highlightFirstRegion();
                }
                if (model.getCurrentOverlayRegion() != null) {
                    model.decrementOverlayRegionIndex();
                    String rightNeighbour = model.getCurrentOverlayRegion().getRightNeighbour();
                    OverlayRegion overlayRegion = (OverlayRegion) model.getCurrentOverlayRegions().get(rightNeighbour);
                    if (overlayRegion != null) {
                        model.setCurrentOverlayRegion(overlayRegion);
                        paintOverlayRegionOnOverlay(overlayRegion);
                        showInformationMessage(RecordMessages.SWITCHED_TO_REGION_SUCESSFULL_MESSAGE + overlayRegion.getName());
                    } else {
                        showWarningMessage(RecordMessages.SWITCHED_TO_REGION_NOT_SUCESSFULL_MESSAGE);
                    }
                }
            } else if (evt.getKeyCode() == KeyEvent.VK_UP) {
                if(!view.getImagePanel().hasFocus()){
                    view.getImagePanel().grabFocus();
                    highlightFirstRegion();
                }
                if (model.getCurrentOverlayRegion() != null) {
                    model.decrementOverlayRegionIndex();
                    String topNeighbour = model.getCurrentOverlayRegion().getTopNeighbour();
                    OverlayRegion overlayRegion = (OverlayRegion) model.getCurrentOverlayRegions().get(topNeighbour);
                    if (overlayRegion != null) {
                        model.setCurrentOverlayRegion(overlayRegion);
                        paintOverlayRegionOnOverlay(overlayRegion);
                        showInformationMessage(RecordMessages.SWITCHED_TO_REGION_SUCESSFULL_MESSAGE + overlayRegion.getName());
                    } else {
                        showWarningMessage(RecordMessages.SWITCHED_TO_REGION_NOT_SUCESSFULL_MESSAGE);
                    }
                }
            } else if (evt.getKeyCode() == KeyEvent.VK_DOWN) {
                if(!view.getImagePanel().hasFocus()){
                    view.getImagePanel().grabFocus();
                    highlightFirstRegion();
                }
                if (model.getCurrentOverlayRegion() != null) {
                    model.decrementOverlayRegionIndex();
                    String bottomNeighbour = model.getCurrentOverlayRegion().getBottomNeighbour();
                    OverlayRegion overlayRegion = (OverlayRegion) model.getCurrentOverlayRegions().get(bottomNeighbour);
                    if (overlayRegion != null) {
                        model.setCurrentOverlayRegion(overlayRegion);
                        paintOverlayRegionOnOverlay(overlayRegion);
                        showInformationMessage(RecordMessages.SWITCHED_TO_REGION_SUCESSFULL_MESSAGE + overlayRegion.getName());
                    } else {
                        showWarningMessage(RecordMessages.SWITCHED_TO_REGION_NOT_SUCESSFULL_MESSAGE);
                    }
                }
            } else if (evt.getKeyCode() == KeyEvent.VK_ENTER) {
                view.getImagePanel().grabFocus();
                if (getAlternativeOverlaysPreviewDialog().isShowing()) {
                    for (Enumeration e = enumerationOfAlternativeOverlays; e.hasMoreElements();) {
                        System.out.println("ENUM HAS MORE ELEMENTS");
                        PreviewRadioButton previewRadioButton =
                                (PreviewRadioButton) enumerationOfAlternativeOverlays.nextElement();
                        if (previewRadioButton.hasFocus()) {
                            try {
                                String target = previewRadioButton.getText();
                                model.changeOverlay(target);
                                view.getImagePanel().updateImage();
                                model.getHistoryVector().add(target);
                                updateAlternativeOverlays();
                                showInformationMessage(RecordMessages.CHANGED_FILE_MESSAGE + target);
                                hide(getAlternativeOverlaysPreviewDialog());
                                synchronizeOverlayTree();
                            } catch (Exception ex) {
                            }
                        }
                    }
                } else if (model.getCurrentOverlayRegion() != null) {
                    String target = model.getCurrentOverlayRegion().getTarget();
                    try {
                        model.changeOverlay(target);
                        view.getImagePanel().updateImage();
                        if (view.getShowMarkersCheckBox().isSelected()) {
                            view.getImagePanel().drawMarkersForObject(model.getCurrentObject());
                        }
                        if (!model.getOverlayRegionsFromDocument(model.getCurrentDocument()).isEmpty()) {
                            Enumeration e = model.getOverlayRegionsFromDocument(model.getCurrentDocument()).elements();
                            OverlayRegion overlayRegion = (OverlayRegion) e.nextElement();
                            model.setCurrentOverlayRegion(overlayRegion);
                            paintOverlayRegionOnOverlay(model.getCurrentOverlayRegion());
                        }
                        model.getHistoryVector().add(target);
                        synchronizeOverlayTree();
                        updateAlternativeOverlays();
                        showInformationMessage(RecordMessages.CHANGED_FILE_MESSAGE + target);
                    } catch (Exception e) {
                        System.out.println("Could not change to file " + target + " : " + e);
                        showErrorMessage(RecordMessages.COULD_NOT_CHANGED_FILE_MESSAGE + target + " :" + e);
                    }
                } else {
                    System.out.println("Keine Region ausgewhlt");
                }
            } else if (evt.getKeyCode() == KeyEvent.VK_ESCAPE) {
                /**
                 *the evaluation of escape events is divided. if the alternative preview dialog is open, pressing escape
                 * will cause getting back to last overlay. otherwise, escape will leed to the previous overlay
                 */

                /*isShowing() : test whether escape is pressed in alternative overlay dialog*/

                if (getAlternativeOverlaysPreviewDialog().isShowing()) {
                    System.out.println("Is showing");
                    try{
                        hide(getAlternativeOverlaysPreviewDialog());
                        System.out.println("Alternative Overlay Dialog hat Focus");
                    }catch(Exception e){
                        System.out.println("Could not hide alternativeOverlayPreviewDialog");
                    }
                    while (enumerationOfAlternativeOverlays.hasMoreElements()) {
                        //model.getHistoryVector().clear();
                        if (((PreviewRadioButton) enumerationOfAlternativeOverlays.nextElement()).hasFocus()) {
                            try {
                                model.changeOverlay(getOverlayBackup());
                                view.getImagePanel().updateImage();
                                if (view.getShowMarkersCheckBox().isSelected()) {
                                    view.getImagePanel().drawMarkersForObject(model.getCurrentObject());
                                }
                                updateAlternativeOverlays();
                                getAlternativeOverlaysPreviewDialog().reInitialize();
                                hide(getAlternativeOverlaysPreviewDialog());
                            } catch (Exception ex) {
                                System.out.println("Could not change file by pressing escape: " + ex);
                            }
                        }
                    }
                } else {
                    if (!model.getHistoryVector().isEmpty()) {
                        System.out.println("History-Vector besitzt Grsse: " + model.getHistoryVector().size());
                        try {
                            model.backToPreviousOverlay();
                            synchronizeOverlayTree();
                        } catch (Exception ex) {
                            System.out.println("Change file exception. Could not change file after history back command." + ex);
                            showErrorMessage(RecordMessages.BACK_TO_PREVIOUS_OVERLAY_NOT_SUCESSFULL_MESSAGE + ": " + ex);
                        }
                    } else {
                        System.out.println("History-Vector leer.");
                    }
                }
            } else if (evt.getKeyCode() == KeyEvent.VK_F4) {
            }
            if (getEditOverlayDialog().getShowOverlayRegionsCheckBox().isSelected()) {
                showAllOverlayRegions();
            }
        }
    }

    /**
     * Handles all mouseClicked events of the whole application.
     * there are three modes:
     *   1.)overlayRegionEditMode where a overlayRegion by mouseClick can be edited
     *   2.)drawPointMode where points for overlayRegions can be drawn
     *   3.)workingMode where a targetOverlayRegion can be reached by clicking
     * @param evt the mouse clicked event
     */
    public void mouseClicked(MouseEvent evt) {
        RecordView view = (RecordView) getView();
        RecordModel model = (RecordModel) getModel();
        ImagePanel panel = view.getImagePanel();
        if (evt.getClickCount()==2){
            TreePath path = view.getOverlayTree().getPathForLocation(evt.getX(),evt.getY());
            if(path!=null){
                if(path.getLastPathComponent().getClass()==Disease.class){
                    try{
                        Disease disease = (Disease)path.getLastPathComponent();
                        getMakeReportOnOverlayDialog().setTitle("Objective: "+disease.getDiseaseName());
                        getMakeReportOnOverlayDialog().getReportTextArea().setText(disease.getDiseaseDescription());
                        show(getMakeReportOnOverlayDialog());
                    }catch(Exception ex){
                    }
                }
                return;
            }
        }
        if ((evt.getModifiers() & InputEvent.BUTTON3_MASK) == InputEvent.BUTTON3_MASK) {
            if (model.getCurrentEpisode() != null) {
                if (model.getCurrentObject() != null) {
                    panel.drawMarker(evt.getX(), evt.getY());
                    model.addMarker(evt.getX(), evt.getY());
                    //showInformationMessage(RecordMessages.MARKER_DRAWN_MESSAGE);
                } else {
                    JOptionPane.showMessageDialog(null, "Bitte erst Befund schreiben, dann Marker zeichnen!", "Fehler!!!",
                            JOptionPane.ERROR_MESSAGE);
                }
            } else {
                JOptionPane.showMessageDialog(null, "Keine Episode geladen", "Fehler!!!", JOptionPane.ERROR_MESSAGE);
                showWarningMessage(RecordMessages.COULD_NOT_DRAW_MARKER_MESSAGE + " " +
                        RecordMessages.NO_EPISODE_LOADED_MESSAGE);
            }
        } else if (workingMode()) {
            boolean clickedOnOverlayRegion = false;
            Enumeration enumerationOfRegions = ((RecordModel) getModel()).getCurrentOverlayRegions().elements();
            while (enumerationOfRegions.hasMoreElements()) {
                OverlayRegion overlayRegion = (OverlayRegion) enumerationOfRegions.nextElement();
                if (overlayRegion.contains(evt.getX(), evt.getY())) {
                    clickedOnOverlayRegion = true;
                    if (overlayRegion.getName() != null) {
                    }
                    if (overlayRegion.getTarget() != null) {
                        //?? Remove this try catch block later!
                        //?? Couldn't throw Exception upwards cause this method header
                        //?? doesn't allow for it.

                            showInformationMessage("Try to change to " + overlayRegion.getTarget());
                         try {
                            model.changeOverlay(overlayRegion.getTarget());
                         } catch (Exception ex) {
                            System.out.println("Change file exception in mouseClicked(...) " + ex);
                            //showErrorMessage(RecordMessages.COULD_NOT_CHANGED_FILE_MESSAGE+overlayRegion.getTarget()+" :"+ex);
                            }
                            //view.getImagePanel().updateImage();
                            updateAlternativeOverlays();
                            model.getHistoryVector().add(overlayRegion.getTarget());
                            //synchronize the treeview
                            synchronizeOverlayTree();
                            showInformationMessage(RecordMessages.CHANGED_FILE_MESSAGE + overlayRegion.getTarget());
                            System.out.println("History-Vector hat Grsse :" + model.getHistoryVector().size());
                    } else {
                        System.out.println("Target ist nicht angezeigt. Die Region besitzt kein Target.");
                    }
                }
            }
        } else if (drawPointsMode()) {
            panel.getGraphics().setColor(Color.RED);
            panel.getGraphics().drawRect(evt.getX(), evt.getY(), 3, 3);
            if (!panel.getXCoordinates().isEmpty()) {
                System.out.println("Drawing line");
                int lastX = ((Integer) panel.getXCoordinates().lastElement()).intValue();
                int lastY = ((Integer) panel.getYCoordinates().lastElement()).intValue();
                panel.getGraphics().drawLine(lastX, lastY, evt.getX(), evt.getY());
            }
            panel.getXCoordinates().add(new Integer(evt.getX()));
            panel.getYCoordinates().add(new Integer(evt.getY()));
            getEditOverlayDialog().getDeleteLastPointButton().setEnabled(true);
            getEditOverlayDialog().getShowOverlayRegionButton().setEnabled(true);
            showInformationMessage(RecordMessages.REGION_POINT_DRAWN_MESSAGE);
        } else if (overlayRegionEditMode()) {
            Enumeration enumerationOfRegions = ((RecordModel) getModel()).getCurrentOverlayRegions().elements();
            while (enumerationOfRegions.hasMoreElements()) {
                OverlayRegion overlayRegion = (OverlayRegion) enumerationOfRegions.nextElement();
                if (overlayRegion.contains(evt.getX(), evt.getY())) {
                    showInformationMessage(RecordMessages.EDIT_REGION_MESSAGE + overlayRegion.getName());
                    getEditOverlayRegionDialog().reInitialize();
                    getEditOverlayRegionDialog().setOverlayRegionName(overlayRegion.getName());
                    getEditOverlayRegionDialog().setOverlayRegionTarget(overlayRegion.getTarget());
                    //first reset all checkboxes...
                    getEditOverlayRegionDialog().getTopNeighbourCheckBox().setSelected(false);
                    getEditOverlayRegionDialog().getBottomNeighbourCheckBox().setSelected(false);
                    getEditOverlayRegionDialog().getLeftNeighbourCheckBox().setSelected(false);
                    getEditOverlayRegionDialog().getRightNeighbourCheckBox().setSelected(false);
                    //then set all checkboxes as needed
                    if (model.getCurrentOverlayRegions().containsKey(overlayRegion.getTopNeighbour())) {
                        getEditOverlayRegionDialog().getTopNeighbourCheckBox().setSelected(true);
                        getEditOverlayRegionDialog().getTopNeighbourComboBox().setEnabled(true);
                        getEditOverlayRegionDialog().getTopNeighbourComboBox().setSelectedItem(overlayRegion.getTopNeighbour());
                    }
                    if (model.getCurrentOverlayRegions().containsKey(overlayRegion.getBottomNeighbour())) {
                        getEditOverlayRegionDialog().getBottomNeighbourCheckBox().setSelected(true);
                        getEditOverlayRegionDialog().getBottomNeighbourComboBox().setEnabled(true);
                        getEditOverlayRegionDialog().getBottomNeighbourComboBox().setSelectedItem(overlayRegion.getBottomNeighbour());
                    }
                    if (model.getCurrentOverlayRegions().containsKey(overlayRegion.getLeftNeighbour())) {
                        getEditOverlayRegionDialog().getLeftNeighbourCheckBox().setSelected(true);
                        getEditOverlayRegionDialog().getLeftNeighbourComboBox().setEnabled(true);
                        getEditOverlayRegionDialog().getLeftNeighbourComboBox().setSelectedItem(overlayRegion.getLeftNeighbour());
                    }
                    if (model.getCurrentOverlayRegions().containsKey(overlayRegion.getRightNeighbour())) {
                        getEditOverlayRegionDialog().getRightNeighbourCheckBox().setSelected(true);
                        getEditOverlayRegionDialog().getRightNeighbourComboBox().setEnabled(true);
                        getEditOverlayRegionDialog().getRightNeighbourComboBox().setSelectedItem(overlayRegion.getRightNeighbour());
                    }
                    try {
                        show(getEditOverlayRegionDialog());
                    } catch (Exception exception) {
                        System.out.println("Could not show editOverlayRegionDialog " + exception);
                    }
                }
            }
        }
    }

    /** Not implemented */
    public void mouseEntered(MouseEvent evt) {
    }

    /** Not implemented */
    public void mouseExited(MouseEvent evt) {
    }

    /** Not implemented */
    public void mouseReleased(MouseEvent evt) {
    }

    /** Not implemented */
    public void mousePressed(MouseEvent evt) {
    }

    /** Not implemented */
    public void mouseDragged(MouseEvent evt) {
    }

    /**
     *Mouse moves are registered. If the mouse moved over a overlayRegion area, the overlayRegion is
     * drawn. The overlayRegion info panel is also updated. If one overlayRegion is already painted, and
     * the mouse is still on it, it will not be painted again (see isPainted()). If the mouse moves
     * out of an overlayRegion the whole panel is repainted.
     * Of course in this case the info panel is also updated.
     *@param evt the mouse event
     */
    public void mouseMoved(MouseEvent evt) {
        RecordView view = (RecordView) getView();
        RecordModel model = (RecordModel) getModel();
        ImagePanel panel = view.getImagePanel();
        boolean oneOverlayRegionIsPainted = false;
        if (((RecordModel) getModel()).getCurrentOverlayRegions() != null) {
            Enumeration enumerationOfRegions = ((RecordModel) getModel()).getCurrentOverlayRegions().elements();
            while (enumerationOfRegions.hasMoreElements()) {
                OverlayRegion overlayRegion = (OverlayRegion) enumerationOfRegions.nextElement();
                if ((!overlayRegion.isPainted()) && (overlayRegion.contains(evt.getX(), evt.getY()))) {
                    //view.getImagePanel().setToolTipText(overlayRegion.getName());
                    model.setCurrentOverlayRegion(overlayRegion);
                    paintOverlayRegionOnOverlay(overlayRegion);
                    if (view.getShowMarkersCheckBox().isSelected()) {
                        if (model.getCurrentObject() != null) {
                            view.getImagePanel().drawMarkersForObject(model.getCurrentObject());
                            ;
                        }
                    }
                    showInformationMessage(RecordMessages.SHOW_CURRENT_REGION_MESSAGE + overlayRegion.getName());
                    break;
                } else if ((overlayRegion.isPainted()) && !(overlayRegion.contains(evt.getX(), evt.getY()))) {
                    clearOverlay();
                    if (view.getShowMarkersCheckBox().isSelected()) {
                        if (model.getCurrentObject() != null) {
                            view.getImagePanel().drawMarkersForObject(model.getCurrentObject());
                            ;
                        }
                    }
                    overlayRegion.setPainted(false);
                    showInformationMessage(RecordMessages.READY_MESSAGE);
                }
            }
        }
        evt.consume();
    }

    /**Paints an overlay region on an overlay.
     * @param overlayRegion the overlay region
     *
     * */
    public void paintOverlayRegionOnOverlay(OverlayRegion overlayRegion) {
        clearOverlay();
        RecordView view = (RecordView) getView();
        ImagePanel panel = view.getImagePanel();
        RecordModel model = (RecordModel) getModel();
        panel.update(panel.getGraphics());
        view.getOverlayRegionNameEntryLabel().setText(overlayRegion.getName());
        view.getOverlayRegionTargetEntryLabel().setText(overlayRegion.getTarget());
        panel.paintOverlayRegion(panel.getGraphics(), overlayRegion);
        panel.drawRegionPointsOnOverlay();
        overlayRegion.setPainted(true);
        Document doc = (Document) model.getImageHashtable().get(overlayRegion.getTarget());
        if (model.getImageFromDocument(doc) != null) {
            view.getPreviewPanel().setImage(model.getImageFromDocument(doc));
        }
        view.getPreviewPanel().updateGraphics();
        //oneOverlayRegionIsPainted = true;
    }

    /**Clears an overlay. This method repaints the panel showing the overlay and removes all painted overlay regions
     * in that way. It also resets regionNameEntryLabel, regionTargetEntryLabel and the preview panel.
     */
    public void clearOverlay() {
        RecordView view = (RecordView) getView();
        ImagePanel panel = view.getImagePanel();
        RecordModel model = (RecordModel) getModel();
        panel.update(panel.getGraphics());
        panel.drawRegionPointsOnOverlay();
        view.getOverlayRegionNameEntryLabel().setText("");
        view.getOverlayRegionTargetEntryLabel().setText("");
        view.getPreviewPanel().setImage(kit.getImage("bilder/empty.jpg"));
        view.getPreviewPanel().updateGraphics();
        if (getEditOverlayDialog().getShowOverlayRegionsCheckBox().isSelected()) {
            showAllOverlayRegions();
        }
    }

    /**
     * Here are all valueChanged events of the whole application handled. These are events from tables, or lists.
     *@param evt the list selection event
     */

    /*public void valueChanged(ListSelectionEvent evt) {
        RecordView view = (RecordView) getView();
        RecordModel model = (RecordModel) getModel();
        System.out.println("valueChanged");*/

    /*if (evt.getSource().equals(view.getPatientInfoPanel().getCaveList())) {
        System.out.println("CAVE-List selected");
        Object selectedValue = view.getPatientInfoPanel().getCaveList().getSelectedValue();
        Cave selectedCave = (Cave)model.getCaveByName((String)selectedValue)[0];
        view.getPatientInfoPanel().getCaveList().setToolTipText(selectedCave.getDescription());
    }*/

    /*if (evt.getSource().equals(view.getPatientInfoPanel().getProblemList())) {
        System.out.println("Problem-List selected");
        view.getDelProblem().setEnabled(true);
        Object selectedValue = view.getPatientInfoPanel().getProblemList().getSelectedValue();
        Problem selectedProblem = (Problem) model.getCurrentHealthRecord().getProblemByName((String) selectedValue);
        model.setCurrentProblem(selectedProblem);
    }
}     */

    /**
     * Here are all windowClosing events of the whole application handled.
     * @param evt the window event
     */
    public void windowClosing(WindowEvent evt) {
        RecordView view = (RecordView) getView();
        String windowClass = evt.getWindow().getClass().getName();
        if (windowClass == "topology.gui.view.RecordView") {
            System.exit(0);
        }
    }

    /**
     * Here are all valueChanged events of trees handled.
     * @param e the valueChanged event
     */
    public void valueChanged(TreeSelectionEvent e) {
        RecordModel model = (RecordModel) getModel();
        RecordView view = (RecordView) getView();
        Object node = new Object();
         System.out.println("TreeSelectionEvent");
        if(view.getTopologyChart().isShowing()){
            node = ((RecordView) getView()).getOverlayTree().getLastSelectedPathComponent();
        }if(((RecordView) getView()).getTreeTablePanel().isShowing()){
            node = ((RecordView) getView()).getTreeTablePanel().getTreeTable().getTree().getLastSelectedPathComponent();
        }if(getMakeDiseaseDialog().isShowing()){
            System.out.println("DiseaseDialog is Showing");
            node = getMakeDiseaseDialog().getOverlayTree().getLastSelectedPathComponent();
        }
        model.setCurrentTreePath(e.getNewLeadSelectionPath());
        if (node != null) {
            if (node.getClass() == Problem.class) {
                Problem currentProblem = ((Problem) node);
                if (currentProblem.hasEpisodes()) {
                    Episode currentEpisode = (Episode) currentProblem.getEpisodes()[0];
                    model.setCurrentEpisode(currentEpisode);
                }
                if (currentProblem != null) {
                    model.setCurrentProblem(currentProblem);
                    view.getTreeTablePanel().getNewEpisodeButton().setEnabled(true);
                    view.getTreeTablePanel().getRemoveProblemButton().setEnabled(true);
                    view.getTreeTablePanel().getRemoveEpisodeButton().setEnabled(false);
                    view.getTreeTablePanel().getNewPartialContactButton().setEnabled(false);
                    view.getTreeTablePanel().getRemovePartialContactButton().setEnabled(false);
                    view.getTreeTablePanel().getNewMedicamentButton().setEnabled(false);
                    view.getTreeTablePanel().getRemoveMedicamentButton().setEnabled(false);
                }
            } else if (node.getClass() == Episode.class) {
                setObjectIndex(1);
                Episode currentEpisode = ((Episode) node);
                Problem currentProblem = (Problem) currentEpisode.getParent();
                ((RecordModel) getModel()).setCurrentProblem(currentProblem);
                ((RecordModel) getModel()).setCurrentEpisode(currentEpisode);

                /*if(currentEpisode.hasObjects()){
                    view.getChangeObjectButton().setEnabled(true);
                    view.getRemoveCurrentObjectButton().setEnabled(true);
                    Objective firstObject = (Objective)currentEpisode.getObjectives().firstElement();
                    model.setCurrentObject(firstObject);
                    if(firstObject.hasMarkers()){
                        view.getShowMarkersCheckBox().setEnabled(true);
                    }else{
                        view.getShowMarkersCheckBox().setEnabled(false);
                    }
                }else{
                    view.getChangeObjectButton().setEnabled(false);
                    view.getShowMarkersCheckBox().setEnabled(false);
                } */

                view.getTreeTablePanel().getNewEpisodeButton().setEnabled(false);
                view.getTreeTablePanel().getRemoveProblemButton().setEnabled(true);
                view.getTreeTablePanel().getRemoveEpisodeButton().setEnabled(true);
                view.getTreeTablePanel().getNewEpisodeButton().setEnabled(true);
                view.getTreeTablePanel().getNewPartialContactButton().setEnabled(true);
                view.getTreeTablePanel().getRemovePartialContactButton().setEnabled(false);
                view.getTreeTablePanel().getNewMedicamentButton().setEnabled(false);
                view.getTreeTablePanel().getRemoveMedicamentButton().setEnabled(false);
            } else if (node.getClass() == PartialContact.class) {
                PartialContact currentPartialContact = (PartialContact) node;
                Episode currentEpisode = (Episode) currentPartialContact.getParent();
                Problem currentProblem = (Problem) currentEpisode.getParent();
                ((RecordModel) getModel()).setCurrentProblem(currentProblem);
                ((RecordModel) getModel()).setCurrentEpisode(currentEpisode);
                ((RecordModel) getModel()).setCurrentPartialContact(currentPartialContact);
                view.getTreeTablePanel().getNewEpisodeButton().setEnabled(true);
                view.getTreeTablePanel().getRemoveProblemButton().setEnabled(true);
                view.getTreeTablePanel().getNewPartialContactButton().setEnabled(true);
                view.getTreeTablePanel().getRemoveEpisodeButton().setEnabled(true);
                view.getTreeTablePanel().getRemovePartialContactButton().setEnabled(true);
                view.getTreeTablePanel().getNewMedicamentButton().setEnabled(false);
                view.getTreeTablePanel().getRemoveMedicamentButton().setEnabled(false);
            } else if (node.getClass() == Subjective.class) {
                Subjective soapSubject = ((Subjective) node);
                PartialContact currentPartialContact = (PartialContact) soapSubject.getParent();
                Episode currentEpisode = (Episode) currentPartialContact.getParent();
                Problem currentProblem = (Problem) currentEpisode.getParent();
                ((RecordModel) getModel()).setCurrentProblem(currentProblem);
                ((RecordModel) getModel()).setCurrentEpisode(currentEpisode);
                ((RecordModel) getModel()).setCurrentPartialContact(currentPartialContact);
                view.getTreeTablePanel().getNewEpisodeButton().setEnabled(true);
                view.getTreeTablePanel().getNewEpisodeButton().setEnabled(true);
                view.getTreeTablePanel().getRemoveProblemButton().setEnabled(true);
                view.getTreeTablePanel().getNewPartialContactButton().setEnabled(true);
                view.getTreeTablePanel().getRemoveEpisodeButton().setEnabled(true);
                view.getTreeTablePanel().getRemovePartialContactButton().setEnabled(true);
                view.getTreeTablePanel().getNewMedicamentButton().setEnabled(false);
                view.getTreeTablePanel().getRemoveMedicamentButton().setEnabled(false);
            } else if (node.getClass() == Objective.class) {
                Objective currentObject = ((Objective) node);
                model.setCurrentObject(currentObject);
                PartialContact currentPartialContact = (PartialContact) currentObject.getParent();
                model.setCurrentPartialContact(currentPartialContact);
                if (model.getCurrentObject().hasMarkers()) {
                    view.getShowMarkersCheckBox().setEnabled(true);
                } else {
                    view.getShowMarkersCheckBox().setEnabled(false);
                }
                Episode currentEpisode = (Episode) currentPartialContact.getParent();
                Problem currentProblem = (Problem) currentEpisode.getParent();
                String overlayName = currentObject.getOverlayName();
                try {
                    //setting the right overlay in the backgound...
                    model.setCurrentDocument((Document) model.getImageHashtable().get(overlayName));
                    model.setCurrentImage(model.getImageFromDocument(model.getCurrentDocument()));
                    view.getImagePanel().setImage(model.getCurrentImage());
                    //and upadating the alternative overlays
                    updateAlternativeOverlays();
                    if (view.getShowMarkersCheckBox().isSelected()) {
                        view.getImagePanel().drawMarkersForObject(model.getCurrentObject());
                    }
                    view.getImagePanel().setCurrentObjective(model.getCurrentObject());
                    view.getHistoryBackButton().setEnabled(false);
                    view.getReportTextArea().setText(model.getCurrentObject().getText().getValue());
                    getAlternativeOverlaysPreviewDialog().reInitialize();
                    showInformationMessage(RecordMessages.CHANGED_FILE_MESSAGE + overlayName);
                } catch (Exception ex) {
                    showWarningMessage(RecordMessages.COULD_NOT_CHANGED_FILE_MESSAGE + ex);
                }

                /*this repaint is needed because the image panel is updated after change file and this update
                 draws also on the tree table panel*/

                ((RecordView) getView()).getTreeTablePanel().repaint();
                ((RecordModel) getModel()).setCurrentProblem(currentProblem);
                ((RecordModel) getModel()).setCurrentEpisode(currentEpisode);
                ((RecordModel) getModel()).setCurrentPartialContact(currentPartialContact);
                ((RecordModel) getModel()).setCurrentObject(currentObject);
                view.getTreeTablePanel().getNewEpisodeButton().setEnabled(true);
                view.getTreeTablePanel().getRemoveProblemButton().setEnabled(true);
                view.getTreeTablePanel().getNewPartialContactButton().setEnabled(true);
                view.getTreeTablePanel().getRemoveEpisodeButton().setEnabled(true);
                view.getTreeTablePanel().getRemovePartialContactButton().setEnabled(true);
                view.getTreeTablePanel().getNewMedicamentButton().setEnabled(false);
                view.getTreeTablePanel().getRemoveMedicamentButton().setEnabled(false);
            } else if (node.getClass() == Assessment.class) {
                Assessment soapAssessment = ((Assessment) node);
                PartialContact currentPartialContact = (PartialContact) soapAssessment.getParent();
                Episode currentEpisode = (Episode) currentPartialContact.getParent();
                Problem currentProblem = (Problem) currentEpisode.getParent();
                ((RecordModel) getModel()).setCurrentProblem(currentProblem);
                ((RecordModel) getModel()).setCurrentEpisode(currentEpisode);
                ((RecordModel) getModel()).setCurrentPartialContact(currentPartialContact);
                view.getTreeTablePanel().getNewEpisodeButton().setEnabled(true);
                view.getTreeTablePanel().getRemoveProblemButton().setEnabled(true);
                view.getTreeTablePanel().getNewPartialContactButton().setEnabled(true);
                view.getTreeTablePanel().getRemoveEpisodeButton().setEnabled(true);
                view.getTreeTablePanel().getRemovePartialContactButton().setEnabled(true);
                view.getTreeTablePanel().getNewMedicamentButton().setEnabled(false);
                view.getTreeTablePanel().getRemoveMedicamentButton().setEnabled(false);
            } else if (node.getClass() == Plan.class) {
                Plan soapPlan = ((Plan) node);
                PartialContact currentPartialContact = (PartialContact) soapPlan.getParent();
                Episode currentEpisode = (Episode) currentPartialContact.getParent();
                Problem currentProblem = (Problem) currentEpisode.getParent();
                ((RecordModel) getModel()).setCurrentPartialContact(currentPartialContact);
                ((RecordModel) getModel()).setCurrentProblem(currentProblem);
                ((RecordModel) getModel()).setCurrentEpisode(currentEpisode);
                view.getTreeTablePanel().getNewEpisodeButton().setEnabled(true);
                view.getTreeTablePanel().getRemoveProblemButton().setEnabled(true);
                view.getTreeTablePanel().getNewPartialContactButton().setEnabled(true);
                view.getTreeTablePanel().getRemoveEpisodeButton().setEnabled(true);
                view.getTreeTablePanel().getRemovePartialContactButton().setEnabled(true);
                view.getTreeTablePanel().getNewMedicamentButton().setEnabled(true);
                view.getTreeTablePanel().getRemoveMedicamentButton().setEnabled(false);
            } else if (node.getClass() == Medication.class) {
                Medication currentMedication = (Medication) node;
                model.setCurrentMedication(currentMedication);
                Plan soapPlan = (Plan) currentMedication.getParent();
                PartialContact currentPartialContact = (PartialContact) soapPlan.getParent();
                Episode currentEpisode = (Episode) currentPartialContact.getParent();
                Problem currentProblem = (Problem) currentEpisode.getParent();
                model.setCurrentPartialContact(currentPartialContact);
                model.setCurrentProblem(currentProblem);
                model.setCurrentEpisode(currentEpisode);
                view.getTreeTablePanel().getNewEpisodeButton().setEnabled(true);
                view.getTreeTablePanel().getRemoveProblemButton().setEnabled(true);
                view.getTreeTablePanel().getNewPartialContactButton().setEnabled(true);
                view.getTreeTablePanel().getRemoveEpisodeButton().setEnabled(true);
                view.getTreeTablePanel().getRemovePartialContactButton().setEnabled(true);
                view.getTreeTablePanel().getNewMedicamentButton().setEnabled(true);
                view.getTreeTablePanel().getRemoveMedicamentButton().setEnabled(true);
            }else if (node.getClass() == Overlay.class) {
                Overlay overlay = (Overlay)node;
                try{
                    model.changeOverlay(overlay.getName());
                    updateAlternativeOverlays();
                    if(this.getMakeDiseaseDialog().isShowing()){
                        getMakeDiseaseDialog().getDiseaseNameTextField().setEditable(true);
                        getMakeDiseaseDialog().getDiseaseDescriptionTextArea().setEditable(true);
                        getMakeDiseaseDialog().getDiseaseNameTextField().setEnabled(true);
                        getMakeDiseaseDialog().getDiseaseDescriptionTextArea().setEnabled(true);
                        getMakeDiseaseDialog().getDiseaseNameTextField().setText("");
                        getMakeDiseaseDialog().getDiseaseDescriptionTextArea().setText("");
                    }
                }catch (Exception ex){
                    System.out.println("Could not change to overlay: "+overlay.getName()+" by tree selection. "+e);
                }
                if(getMakeDiseaseDialog().isShowing()){
                    getMakeDiseaseDialog().getCommitButton().setEnabled(false);
                    getMakeDiseaseDialog().getRemoveButton().setEnabled(true);
                }
            }else if (node.getClass() == String.class) {
                String altOverlayName = (String)node;
                Overlay altOverlay = (Overlay)model.getOverlayHashtable().get(altOverlayName);
                try{
                    model.changeOverlay(altOverlay.getName());
                    this.updateAlternativeOverlays();
                }catch (Exception ex){
                    System.out.println("Could not change to overlay: "+altOverlayName+" by tree selection. "+e);
                }
                if(getMakeDiseaseDialog().isShowing()){
                    getMakeDiseaseDialog().getCommitButton().setEnabled(false);
                    getMakeDiseaseDialog().getRemoveButton().setEnabled(false);
                }
            }else if (node.getClass() == Disease.class) {
                Disease disease = (Disease)node;
                getMakeDiseaseDialog().getDiseaseNameTextField().setText(disease.getDiseaseName());
                getMakeDiseaseDialog().getDiseaseDescriptionTextArea().setText(disease.getDiseaseDescription());
                view.getReportTextArea().setText(disease.getDiseaseDescription());
                try{
                    model.changeOverlay(((Overlay)disease.getParent()).getName());
                }catch(Exception ex){
                    System.out.println("Could not change to overlay "+((Overlay)disease.getParent()).getName()+" by clicking on disease.");
                }
                if(getMakeDiseaseDialog().isShowing()){
                    getMakeDiseaseDialog().getCommitButton().setEnabled(true);
                    getMakeDiseaseDialog().getRemoveButton().setEnabled(true);
                }
            }
        } else {
            //throw new NullPointerException("Could not get value from node. The node is null.");
        }
    }
    //----------------------------------Dialog lifecycles-------------------------------------------------------------------
    //Lifecycle of MakeOverlayDialog------------------------------------------------------------------------------------

    /**
     * Creates the MakeOverlayDialog.
     * @return the MakeOverlayDialog
     */
    public MakeOverlayDialog createMakeOverlayDialog() {
        MakeOverlayDialog d = new MakeOverlayDialog();
        if (d != null) {
            d.setModel(getModel());
            d.setController(this);
            d.initialize();
        } else {
            throw new NullPointerException("Could not create MakeOverlayDialog. The dialog is null.");
        }
        return d;
    }

    /** Gets the MakeOverlayDialog */
    public MakeOverlayDialog getMakeOverlayDialog() {
        return this.makeOverlayDialog;
    }

    /** Sets the MakeOverlayDialog */
    public void setMakeOverlayDialog(MakeOverlayDialog makeOverlayDialog) {
        this.makeOverlayDialog = makeOverlayDialog;
    }

    //Lifecycle of MakeOverlayRegionDialog------------------------------------------------------------------------------

    /**
     * Creates the MakeOverlayRegionDialog.
     * @return the makeOverlayRegionDialog
     */
    public MakeOverlayRegionDialog createMakeOverlayRegionDialog() {
        MakeOverlayRegionDialog mord = new MakeOverlayRegionDialog();
        mord.setModel(getModel());
        mord.setController(this);
        mord.initialize();
        return mord;
    }

    /**
     *Gets the MakeOverlayRegionDialog
     * @return the makeOverlayRegionDialog
     */
    public MakeOverlayRegionDialog getMakeOverlayRegionDialog() {
        return this.makeOverlayRegionDialog;
    }

    /**
     *Sets the MakeOverlayRegionDialog
     * @param makeOverlayRegionDialog the makeOverlayRegionDialog
     */
    public void setMakeOverlayRegionDialog(MakeOverlayRegionDialog makeOverlayRegionDialog) {
        this.makeOverlayRegionDialog = makeOverlayRegionDialog;
    }
    //Lifecycle of MakeProblemDialog------------------------------------------------------------------------------------

    /**
     * Creates the MakeProblemDialog.
     * @return the makeProblemDialog
     */
    public MakeProblemDialog createMakeProblemDialog() {
        MakeProblemDialog cpf = new MakeProblemDialog();
        cpf.setModel(getModel());
        cpf.setController(this);
        cpf.initialize();
        return cpf;
    }

    /**
     *Gets the MakeProblemDialog
     * @return the make problem dialog
     */
    public MakeProblemDialog getMakeProblemDialog() {
        return this.makeProblemDialog;
    }

    /**
     *Sets the MakeProblemDialog
     * @param makeProblemDialog the makeProblemDialog
     */
    public void setMakeProblemDialog(MakeProblemDialog makeProblemDialog) {
        this.makeProblemDialog = makeProblemDialog;
    }
    //Lifecycle of EditOverlayRegionDialog------------------------------------------------------------------------------

    /**
     * Creates the editOverlayRegionDialog.
     * @return the editOverlayRegionDialog
     */
    public EditOverlayRegionDialog createEditOverlayRegionDialog() {
        EditOverlayRegionDialog eord = new EditOverlayRegionDialog();
        eord.setModel(getModel());
        eord.setController(this);
        eord.initialize();
        return eord;
    }

    /**
     *Gets the editOverlayRegionDialog
     * @return  the editOverlayRegionDialog
     */
    public EditOverlayRegionDialog getEditOverlayRegionDialog() {
        return this.editOverlayRegionDialog;
    }

    /**
     *Sets the editOverlayRegionDialog
     * @param editOverlayRegionDialog the editOverlayRegionDialog
     */
    public void setEditOverlayRegionDialog(EditOverlayRegionDialog editOverlayRegionDialog) {
        this.editOverlayRegionDialog = editOverlayRegionDialog;
    }
    //Lifecycle of EditOverlayRegionDialog------------------------------------------------------------------------------

    /**
     * Creates the editOverlayDialog.
     * @return the editOverlayDialog
     */
    public EditOverlayDialog createEditOverlayDialog() {
        EditOverlayDialog eod = new EditOverlayDialog();
        eod.setModel(getModel());
        eod.setController(this);
        eod.initialize();
        return eod;
    }

    /**
     *Gets the editOverlayDialog
     * @return the editOverlayDialog
     */
    public EditOverlayDialog getEditOverlayDialog() {
        return this.editOverlayDialog;
    }

    /**
     *Sets the editOverlayDialog
     * @param the EditOverlayDialog*
     */
    public void setEditOverlayDialog(EditOverlayDialog editOverlayDialog) {
        this.editOverlayDialog = editOverlayDialog;
    }
    //Lifecycle of EditAlternativeOverlayDialog-------------------------------------------------------------------------

    /**
     * Creates the editOverlayDialog.
     * @return the editOverlayDialog
     */
    public EditAlternativeOverlayDialog createEditAlternativeOverlayDialog() {
        EditAlternativeOverlayDialog eod = new EditAlternativeOverlayDialog();
        eod.setModel(getModel());
        eod.setController(this);
        eod.initialize();
        return eod;
    }

    /**
     *Gets the EditOverlayDialog
     * @return  theEditOverlayDialog
     */
    public EditAlternativeOverlayDialog getEditAlternativeOverlaysDialog() {
        return this.editAlternativeOverlaysDialog;
    }

    /**
     *Sets the EditOverlayDialog
     * @param  the editOverlayDialog*
     */
    public void setEditAlternativeOverlaysDialog(EditAlternativeOverlayDialog editAlternativeOverlaysDialog) {
        this.editAlternativeOverlaysDialog = editAlternativeOverlaysDialog;
    }





    //Lifecycle of ReportOnOverlayDialog------------------------------------------------------------------------------

    /**
     * Creates the reportOnOverlayDialog.
     * @return the reportOnOverlayDialog
     */
    public MakeReportOnOverlayDialog createMakeReportOnOverlayDialog() {
        MakeReportOnOverlayDialog rood = new MakeReportOnOverlayDialog();
        rood.setModel(getModel());
        rood.setController(this);
        rood.initialize();
        return rood;
    }

    /**
     *Gets the reportOnOverlayDialog
     * @return the reportOnOverlayDialog
     */
    public MakeReportOnOverlayDialog getMakeReportOnOverlayDialog() {
        return this.makeReportOnOverlayDialog;
    }

    /**
     *Sets the ReportOnOverlayDialog
     * @param reportOnOverlayDialog the reportOnOverlayDialog
     */
    public void setReportOnOverlayDialog(MakeReportOnOverlayDialog reportOnOverlayDialog) {
        this.makeReportOnOverlayDialog = reportOnOverlayDialog;
    }

    /**
     * Loads patient. Open another application which is responsible for identifying a person.
     * A Person can be identified by using the CORBA/IDL PIDS service specified by the OMG
     * or by accessing this application's domain (local or remote) directly.
     * The patient data can be either read from a chip card (per chip card reader terminal)
     * or be given manually by typing in the name or ID of the patient.
     * Finally, if the patient could be identified, its health record will be retrieved.
     * @return the authors
     */
    public void loadPatient() {
        /*??
		// Read patient name from input field/dialog/ChipCard/PIDS Service.
		Dialog d = new InputDialog();
		String name = d.getInput();
		//??        String name = ((RecordView) getView()).getPatientNameTextField().getText();

		// Load patient data into model.
		((RecordModel) getModel()).loadData(name);
		*/
    }

    /**
     *Deleting an Item from all comboboxes that deal with overlays
     *@param itemName the item to delete
     */
    public void deleteItemFromComboBoxes(String itemName) {
        getEditOverlayDialog().getFileChooseCombobox().removeItem(itemName);
        getMakeOverlayRegionDialog().getTargetImageComboBox().removeItem(itemName);
    }

    /**
     * Adds an new item to all comboBoxes that deal with overlays
     * @param newItem the new item
     */
    public void addNewItemToAllComboBoxes(String newItem) {
        getEditOverlayDialog().getFileChooseCombobox().addItem(newItem);
        getMakeOverlayRegionDialog().getTargetImageComboBox().addItem(newItem);
    }

    /** Test whether the application is in the overlayRegionEditMode
     * @return true if the application is in overlayRegionEditMode, false if not
     *
     * */
    public boolean overlayRegionEditMode() {
        return getEditOverlayDialog().getEditOverlayRegionRadioButton().isSelected();
    }

    /** Test whether the application is in the drawPointsMode
     * @return true if the application is in drawPointsMode, false if not
     *
     * */
    public boolean drawPointsMode() {
        return getEditOverlayDialog().getPaintPointsRadioButton().isSelected();
    }

     /** Test whether the application is in the workingMode
     * @return true if the application is in workingMode, false if not
     *
     * */
    public boolean workingMode() {
        return getEditOverlayDialog().getWorkingRadioButton().isSelected();
    }

    /** Changes the current problem
     * @paran p the new problem
     *
     */
    public void changeProblem(Problem p) {
        if (((RecordModel)getModel()).getCurrentHealthRecord().hasProblems()) {
            if (p.hasEpisodes()) {
                Episode e = p.getLastEpisode();
            }
        }
        ((RecordModel)getModel()).changeProblem(p);
    }

     /** Not implemented
     *
     */
    public void focusGained(FocusEvent f) {
    }

    /**
     * Determines whether a component has lost focus. If imagePanel losts the focus, the grabFocusCheckBox is unselected.
     * @param f the focusEvent
     *
     */
    public void focusLost(FocusEvent f) {
        RecordView view = (RecordView) getView();
        if (!(view.getImagePanel().hasFocus())) {
            view.getGrabFocusCheckBox().setSelected(false);
            view.getImagePanel().setBorder(BorderFactory.createLineBorder(Color.BLACK));
        }
    }

    /**
     * Drawas all existing overlayRegions of the overlay on it.
     *
     */
    public void showAllOverlayRegions() {
        Enumeration enumerationOfRegions = ((RecordModel) getModel()).getCurrentOverlayRegions().elements();
        while (enumerationOfRegions.hasMoreElements()) {
            OverlayRegion overlayRegion = (OverlayRegion) enumerationOfRegions.nextElement();
            ((RecordView) getView()).getImagePanel().drawOverlayRegion(overlayRegion);
        }
    }

    /**
     *This method shows an information message in the status und information panel
     * @param message the information message
     */
    public void showInformationMessage(String message) {
        ((RecordView) getView()).getStatusAndInformationLabel().setText(message);
        ((RecordView) getView()).getStatusAndInformationLabel().setIcon(null);
    }

    /**
     *This method shows a warning message in the status und information panel
     * @param message the warning message
     */
    public void showWarningMessage(String message) {
        ((RecordView) getView()).getStatusAndInformationLabel().setText(message);
        ImageIcon warningIcon = new ImageIcon(RecordModel.RelativeIconDirectoryName + "warning.gif");
        ((RecordView) getView()).getStatusAndInformationLabel().setIcon(warningIcon);
    }

    /**
     *This method shows an error message in the status und information panel
     * @param message the error message
     */
    public void showErrorMessage(String message) {
        ((RecordView) getView()).getStatusAndInformationLabel().setText(message);
        ImageIcon warningIcon = new ImageIcon(RecordModel.RelativeIconDirectoryName + "error.gif");
        ((RecordView) getView()).getStatusAndInformationLabel().setIcon(warningIcon);
    }

    /**Removes the current problem from the current ehr
     *
     */
    public void removeCurrentProblemFromEHR() {
        RecordModel model = (RecordModel) getModel();
        RecordView view = (RecordView) getView();
        Object[] problemsOfEHR = model.getCurrentHealthRecord().getProblems();
        model.getCurrentHealthRecord().remove(model.getCurrentProblem().getIdentifier());
        try {
            model.changeOverlay(RecordModel.StartDocumentName);
        } catch (Exception ex) {
            showWarningMessage(RecordMessages.COULD_NOT_CHANGED_FILE_MESSAGE + ex);
        }
        view.getShowMarkersCheckBox().setEnabled(false);
        view.getChangeObjectButton().setEnabled(false);
        updateAlternativeOverlays();
        getAlternativeOverlaysPreviewDialog().reInitialize();
        view.getHistoryBackButton().setEnabled(false);
        showInformationMessage(RecordMessages.PROBLEM_SUCESSFULLY_REMOVED_MESSAGE);
    }

    /**Removes the current episode from the current ehr
     *
     */
    public void removeCurrentEpisodeFromEHR() {
        RecordModel model = (RecordModel) getModel();
        Episode currentEpisode = model.getCurrentEpisode();
        Problem currentProblem = model.getCurrentProblem();
        if (currentEpisode != null) {
            if (currentProblem != null) {
                currentProblem.remove(currentEpisode.getIdentifier());
                showInformationMessage(RecordMessages.EPISODE_SUCESSFULLY_REMOVED_MESSAGE);
            } else {
                showWarningMessage(RecordMessages.NO_PROBLEM_LOADED_MESSAGE);
            }
        } else {
            showWarningMessage(RecordMessages.NO_EPISODE_LOADED_MESSAGE);
        }
    }

     /**Removes the current partialContact from the current ehr
     *
     */
    public void removeCurrentPartialContactFromEHR() {
        RecordModel model = (RecordModel) getModel();
        Episode currentEpisode = model.getCurrentEpisode();
        Problem currentProblem = model.getCurrentProblem();
        PartialContact partialContact = model.getCurrentPartialContact();
        if (partialContact != null) {
            if (currentEpisode != null) {
                currentEpisode.remove(partialContact.getIdentifier());
                showInformationMessage(RecordMessages.PARTIAL_CONTACT_SUCESSFULLY_REMOVED_MESSAGE);
            } else {
                showWarningMessage(RecordMessages.NO_EPISODE_LOADED_MESSAGE);
            }
        } else {
            showWarningMessage(RecordMessages.NO_PARTIAL_CONTACT_LOADED_MESSAGE);
        }
    }

    /**Gets the name of the picture to use as a jpeg for the overlay
     *@return the picture to use
     */
    public String getPicToUse() {
        return picToUse;
    }

     /**Sets the name of the picture to use as a jpeg for the overlay
     *@return the picture to use
     */
    public void setPicToUse(String picToUse) {
        this.picToUse = picToUse;
    }

     /**Creates the alternativeOverlaysPreviewDialog
     *@return the alternativeOverlaysPreviewDialog
     */
    public AlternativeOverlaysPreviewDialog createAlternativeOverlaysPreviewDialog() {
        AlternativeOverlaysPreviewDialog d = new AlternativeOverlaysPreviewDialog();
        if (d != null) {
            d.setModel(getModel());
            d.setController(this);
            d.initialize();
        } else {
            throw new NullPointerException("Could not create AlternativeOverlaysPreviewDialog. The dialog is null.");
        }
        return d;
    }

     /**Gets the alternativeOverlaysPreviewDialog
     *@return the alternativeOverlaysPreviewDialog
     */
    public AlternativeOverlaysPreviewDialog getAlternativeOverlaysPreviewDialog() {
        return alternativeOverlaysPreviewDialog;
    }

     /**Sets the alternativeOverlaysPreviewDialog
     *@param alternativeOverlaysPreviewDialog the alternativeOverlaysPreviewDialog
     */
    public void setAlternativeOverlaysPreviewDialog(AlternativeOverlaysPreviewDialog alternativeOverlaysPreviewDialog) {
        this.alternativeOverlaysPreviewDialog = alternativeOverlaysPreviewDialog;
    }

     /**Gets the overlayBackup
     *@return the overlayBackup
     */
    public String getOverlayBackup() {
        return overlayBackup;
    }

     /**Sets the overlayBackup
     *@param overlayBackup the overlayBackup
     */
    public void setOverlayBackup(String overlayBackup) {
        this.overlayBackup = overlayBackup;
    }

    /**
     *Updates the vector containing alternative overlays for the current overlay.
     * This update is nessessary when changing to an other overlay. This can be done by selecting a region by mouse
     * or keyboard or changing to another overlay in the edit overlay dialog.
     * This method must not be invoked when changing to an alternative overlay because in this case the
     * alternative overlays do not change!!!
     */
    public void updateAlternativeOverlays() {
        RecordModel model = (RecordModel) getModel();
        if (model.getAlternativeOverlaysFromDocument(model.getCurrentDocument()) != null) { //if its null it is an overlay without alternatives
            Vector altOverlays = model.getAlternativeOverlaysFromDocument(model.getCurrentDocument());

            /*alternative documents are the alternative documents from the current document and the document itself*/

            model.setAlternativeOverlaysForCurrentOverlay(altOverlays);
        } else {
            model.setAlternativeOverlaysForCurrentOverlay(null);
        }
        getAlternativeOverlaysPreviewDialog().reInitialize();
    }

    /**Expands the tree at the given row
     * @param rowCount the number of row thar will be expanded
     */
    public void expandTreeTable(int rowCount) {
        RecordView view = (RecordView) getView();
        TreePath expandedTree = view.getTreeTablePanel().getTreeTable().getTree().getPathForRow(rowCount - 1);
        view.getTreeTablePanel().getTreeTable().getTree().expandPath(expandedTree);
    }


     /**Gets the object index
     * @return the object index
     */
    public int getObjectIndex() {
        return objectIndex;
    }


     /**Sets the object index
     * @param objectIndex the object index
     */
    public void setObjectIndex(int objectIndex) {
        this.objectIndex = objectIndex;
    }

    /**Creates the makeCaveDialog
     * @return the makeCaveDialog
     */
    public MakeCAVEDialog createMakeCAVEDialog() {
        MakeCAVEDialog d = new MakeCAVEDialog();
        if (d != null) {
            d.setModel(getModel());
            d.setController(this);
            d.initialize();
        } else {
            throw new NullPointerException("Could not create MakeCAVEDialog. The dialog is null.");
        }
        return d;
    }

     /**Gets the makeCaveDialog
     * @return the makeCaveDialog
     */
    public MakeCAVEDialog getMakeNewCAVEEntryDialog() {
        return makeNewCAVEEntryDialog;
    }

     /**Sets the makeCaveDialog
     * @param makeCaveDialog the makeCaveDialog
     */
    public void setMakeNewCAVEEntryDialog(MakeCAVEDialog makeNewCAVEEntryDialog) {
        this.makeNewCAVEEntryDialog = makeNewCAVEEntryDialog;
    }

    /**Creates the diseaseDialog
    *@return the diseaseDialog
    */
    public MakeDiseaseDialog createMakeDiseaseDialog() {
        MakeDiseaseDialog d = new MakeDiseaseDialog();
        if (d != null) {
            d.setModel(getModel());
            d.setController(this);
            d.initialize();
        } else {
            throw new NullPointerException("Could not create AlternativeOverlaysPreviewDialog. The dialog is null.");
        }
        return d;
    }
    /**Gets the diseaseDialog
     *
     * @return the makeDiseaseDialog
     */
    public MakeDiseaseDialog getMakeDiseaseDialog() {
        return makeDiseaseDialog;
    }

    /**Sets the diseaseDialog
     *
     * @param makediseaseDialog the diseaseDialog
     */
    public void setMakeDiseaseDialog(MakeDiseaseDialog makeDiseaseDialog) {
        this.makeDiseaseDialog = makeDiseaseDialog;
    }

    /**Expands the whole tree of the treeTable
     *
     */
    public void expandTree() {
        RecordModel model = (RecordModel) getModel();
        RecordView view = (RecordView) getView();
        //after every drastic change of the tree model it will be replaced by a new tree model.
        //this is not very elegant but it works :-)
        if (model.getCurrentHealthRecord() != null) {
            ObjectModel objectModel = new ObjectModel(model.getCurrentHealthRecord(), (RecordModel) getModel());
            view.getTreeTablePanel().setTreeTableModel(objectModel);
            //view.getTreeTablePanel().getTreeTable().getTree().expandPath(model.getCurrentTreePath());
            System.out.println("Expanding  tree!!!!!");
        } else {
            throw new NullPointerException("Could not expand tree. The current health record is null.");
        }
    }

    /** This method synchronizes the overlay shown in the imagePanel with the treeView on the left.
     * The selected overlay in the imagePanel will be selected in the treeView.
     *
     */
    public void synchronizeOverlayTree(){
        RecordModel model = (RecordModel)getModel();
        RecordView view = (RecordView)getView();
        Vector overlayHistoryVector = new Vector();
        //objects in the history vector are Strings. So the overlays have to be taken from the overlay hashtable.
        for(int zz=0;zz<model.getHistoryVector().size();zz++){
            String overlayName = (String)model.getHistoryVector().elementAt(zz);
            Overlay overlay = (Overlay)model.getOverlayHashtable().get(overlayName);
            System.out.println(zz+". Overlay in History Vector : "+overlay.getName());
            overlayHistoryVector.add(overlay);
        }
        TreePath path = new TreePath(overlayHistoryVector.toArray());
        view.getOverlayTree().scrollPathToVisible(path);
        view.getOverlayTree().setSelectionPath(path);
    }
}
