/*
 * $RCSfile: CheckBoxIcon.java,v $
 *
 * Copyright (c) 1999-2002. Jens Bohl. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.application.healthcare.record;

import javax.swing.*;
import java.awt.*;

public class CheckBoxIcon implements Icon {
    /** The title of the checkbox. */
    private String title;

    /** The height of the icon. */
    private int iconHeight;

    /** The width of the icon. */
    private int iconWidth;

    /** Indicates whether the icon is selected or not */
    private boolean selected;

    /** Indicates whether the icon is focused or not */
    private boolean focused;

    /** The outer rectangle height. */
    private static int outerRectangleHeight = 17;

    /** The outer rectangle width. */
    private static int outerRectangleWidth = 27;

    /** The inner rectangle height. */
    private static int innerRectangleHeight = 13;

    /** The inner rectangle width. */
    private static int innerRectangleWidth = 23;

    public CheckBoxIcon(String title, boolean focused, boolean selected) {
        setTitle(title);
        setFocused(focused);
        setSelected(selected);
        setIconHeight(getOuterRectangleHeight());
        setIconWidth(getOuterRectangleWidth());
    }

    public int getIconHeight() {
        return this.iconHeight;
    }

    public int getIconWidth() {
        return this.iconWidth;
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (isFocused()) {
            g.drawRect(x, y, getOuterRectangleHeight(), getOuterRectangleWidth());
            Color color3 = new Color(95, 115, 127);
            g.setColor(color3);
            g.fillRect(x, y, getOuterRectangleHeight(), getOuterRectangleWidth());
            g.setColor(Color.BLACK);
            g.drawRect(x + 2, y + 2, getInnerRectangleHeight(), getInnerRectangleWidth());
            g.setColor(Color.RED);
            g.fillRect(x + 2, y + 2, innerRectangleHeight, innerRectangleWidth);
            g.drawString(getTitle(), x, y);
        } else {
            g.drawRect(x, y, outerRectangleHeight, outerRectangleWidth);
            g.setColor(Color.GRAY);
            g.fillRect(x, y, outerRectangleHeight, outerRectangleWidth);
            g.drawRect(x + 2, y + 2, innerRectangleHeight, innerRectangleWidth);
            g.setColor(RecordModel.BackgroundColor);
            g.fillRect(x + 2, y + 2, innerRectangleHeight, innerRectangleWidth);
            g.setColor(Color.BLACK);
            g.drawString(getTitle(), x + 4, y + 13);
        }
        if (isSelected()) {
            g.setColor(Color.RED);
            g.drawString(getTitle(), x + 4, y + 13);

            /*g.drawLine(x+4,y+4,x+12,y+12);
            g.drawLine(x+4,y+12,x+12,y+4);

            g.drawLine(x+5,y+4,x+12,y+11);
            g.drawLine(x+4,y+11,x+11,y+4);*/
        }
    }

    public boolean isFocused() {
        return this.focused;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setIconHeight(int iconHeight) {
        this.iconHeight = iconHeight;
    }

    public void setIconWidth(int iconWidth) {
        this.iconWidth = iconWidth;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public void setFocused(boolean focused) {
        this.focused = focused;
    }

    public int getOuterRectangleHeight() {
        return outerRectangleHeight;
    }

    public void setOuterRectangleHeight(int outerRectangleHeight) {
        this.outerRectangleHeight = outerRectangleHeight;
    }

    public int getOuterRectangleWidth() {
        return outerRectangleWidth;
    }

    public void setOuterRectangleWidth(int outerRectangleWidth) {
        this.outerRectangleWidth = outerRectangleWidth;
    }

    public int getInnerRectangleHeight() {
        return innerRectangleHeight;
    }

    public void setInnerRectangleHeight(int innerRectangleHeight) {
        this.innerRectangleHeight = innerRectangleHeight;
    }

    public int getInnerRectangleWidth() {
        return innerRectangleWidth;
    }

    public void setInnerRectangleWidth(int innerRectangleWidth) {
        this.innerRectangleWidth = innerRectangleWidth;
    }
}
