/*
 * $RCSfile: SplashWindowView.java,v $
 *
 * Copyright (c) 1999-2002. Christian Heller. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.application.controller.splash;

import java.awt.*;
import java.awt.event.*;
import java.lang.*;
import java.net.*;
import javax.swing.*;
import org.resmedicinae.resmedlib.component.context.*;
import org.resmedicinae.resmedlib.component.view.*;
import org.resmedicinae.resmedlib.component.view.swing.*;

/**
 * This class represents a splash window view.
 *
 * It basically provides a nice logo and the application title.
 *
 * @version $Revision: 1.4 $ $Date: 2002/09/06 07:52:46 $ $Author: chrissy $
 * @author Christian Heller <christian.heller@tuxtax.de>
 */
public class SplashWindowView extends SwingView {

    /** The progress bar. */
    private ResProgressBar progressBar;

    //
    // Progress bar.
    //

    /**
     * Returns the progress bar.
     *
     * @return the progress bar
     */
    public ResProgressBar getProgressBar() {

        return this.progressBar;
    }

    /**
     * Sets the progress bar.
     *
     * @param progressBar the progress bar
     */
    public void setProgressBar(ResProgressBar progressBar) {

        this.progressBar = progressBar;
    }

    /**
     * Returns the default progress bar.
     *
     * @return the default progress bar
     */
    public ResProgressBar getDefaultProgressBar() {

        return createProgressBar();
    }

    /**
     * Resets the progress bar to default.
     */
    public void resetProgressBar() {

        setProgressBar(getDefaultProgressBar());
    }

    /*
     * Creates the progress bar.
     *
     * @return the progress bar
     * @exception NullPointerException if the progress bar is null
     * @exception NullPointerException if the model is null
     */
    public ResProgressBar createProgressBar() throws NullPointerException {

        ResProgressBar pb = new ResProgressBar();

        if (pb != null) {

            SplashWindowModel m = (SplashWindowModel) getModel();

            if (m != null) {

                pb.setBackground(Color.white);
                pb.setBorderPainted(false);
                pb.setStringPainted(true);
                pb.setMinimum(m.getMinimum());
                pb.setMaximum(m.getMaximum());
//??                pb.setSelectorString("name"); //?? pb.setString("Res Medicinae is starting up...");
//??                pb.setSelectorInt("current");

            } else {

                throw new NullPointerException("Could not read minimum and maximum. The model is null.");
            }

        } else {

            throw new NullPointerException("Could not create progress bar. The progress bar is null.");
        }

        return pb;
    }

    /**
     * Destroys the progress bar.
     */
    public void destroyProgressBar(ResProgressBar pb) {
    }

    //
    // Title panel.
    //

    /*
     * Creates the title panel.
     *
     * @return the title panel
     * @exception NullPointerException if the title panel is null
     */
    private ResPanel createTitlePanel() throws NullPointerException {

        ResPanel p = new ResPanel();

        if (p != null) {

            p.setBackground(Color.white);
            p.setLayout(new GridLayout(6, 1));
            p.add(new JLabel());
            p.add(new JLabel());
            p.add(createNameLabel());
            p.add(createVersionLabel());
            p.add(new JLabel());
            p.add(new JLabel());

        } else {

            throw new NullPointerException("Could not create title panel. The title panel is null.");
        }

        return p;
    }

    /*
     * Creates the name label.
     *
     * @return the name label
     * @exception NullPointerException if the name label is null
     */
    private ResLabel createNameLabel() throws NullPointerException {

        ResLabel l = new ResLabel();

        if (l != null) {

//??            l.setSelectorString("name");
            l.setFont(new Font(null, Font.BOLD, 32));

        } else {

            throw new NullPointerException("Could not create name label. The name label is null.");
        }

        return l;
    }

    /*
     * Creates the version label.
     *
     * @return the version label
     * @exception NullPointerException if the version label is null
     */
    private ResLabel createVersionLabel() throws NullPointerException {

        ResLabel l = new ResLabel();

        if (l != null) {

//??            l.setSelectorString("version");

        } else {

            throw new NullPointerException("Could not create version label. The version label is null.");
        }

        return l;
    }

    //
    // Icon label.
    //

    /*
     * Creates the icon label.
     *
     * @return the icon label
     * @exception NullPointerException if the icon label is null
     */
    private ResLabel createIconLabel() throws NullPointerException {

        ResLabel l = new ResLabel();

        if (l != null) {

            URL url = getClass().getResource("logo.jpeg");
            javax.swing.ImageIcon imageIcon = new javax.swing.ImageIcon(url);

            l.setIcon(imageIcon);

        } else {

            throw new NullPointerException("Could not create icon label. The icon label is null.");
        }

        return l;
    }

    //
    // Initializable.
    //

    /**
     * Initializes this component.
     */
    public void initialize() {

        // Set parameters.
        setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
        setDisplayMode(DisplayFactory.WINDOW_DISPLAY);
        setBackground(Color.white);
        setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Color.black));
        setLayout(new BorderLayout());

        // Add gui components.
        add(createTitlePanel(), BorderLayout.WEST);
        add(createIconLabel(), BorderLayout.EAST);
        add(createProgressBar(), BorderLayout.SOUTH);
    }

    /**
     * Finalizes this component.
     */
    public void finalizz() {
    }
}

