/*
 * $RCSfile: SplashWindowModel.java,v $
 *
 * Copyright (c) 1999-2002. Christian Heller. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.application.controller.splash;

import java.lang.*;
import org.resmedicinae.resmedlib.component.model.*;

/**
 * This class represents a splash window model.
 *
 * @version $Revision: 1.2 $ $Date: 2002/06/12 18:49:35 $ $Author: chrissy $
 * @author Christian Heller <christian.heller@tuxtax.de>
 */
public class SplashWindowModel extends Model {

    /** The minimum value. */
    private int minimum;

    /** The maximum value. */
    private int maximum;

    /** The current value. */
    private int currentValue;

    /** The message. */
    private String message;

    //
    // Minimum.
    //

    /**
     * Returns the minimum.
     *
     * @return the minimum
     */
    public int getMinimum() {

        return this.minimum;
    }

    /**
     * Sets the minimum.
     *
     * @param minimum the minimum
     */
    public void setMinimum(int minimum) {

        this.minimum = minimum;
    }

    /**
     * Creates a minimum.
     *
     * @return the minimum
     */
    public int createMinimum() {

        return 0;
    }

    /**
     * Destroys the minimum.
     *
     * @param min the minimum
     */
    public void destroyMinimum(int min) {
    }

    //
    // Maximum.
    //

    /**
     * Returns the maximum.
     *
     * @return the maximum
     */
    public int getMaximum() {

        return this.maximum;
    }

    /**
     * Sets the maximum.
     *
     * @param maximum the maximum
     */
    public void setMaximum(int maximum) {

        this.maximum = maximum;
    }

    /**
     * Creates a maximum.
     *
     * @return the maximum
     */
    public int createMaximum() {

        return 10;
    }

    /**
     * Destroys the maximum.
     *
     * @param max the maximum
     */
    public void destroyMaximum(int max) {
    }

    //
    // Current value.
    //

    /**
     * Returns the current value.
     *
     * @return the current value
     */
    public int getCurrentValue() {

        return this.currentValue;
    }

    /**
     * Sets the current value.
     *
     * @param currentValue the current value
     */
    public void setCurrentValue(int currentValue) {

        this.currentValue = currentValue;
    }

    /**
     * Creates a current value.
     *
     * @return the current value
     */
    public int createCurrentValue() {

        return 0;
    }

    /**
     * Destroys the current value.
     *
     * @param v the current value
     */
    public void destroyCurrentValue(int v) {
    }

    //
    // Message.
    //

    /**
     * Returns the message.
     *
     * @return the message
     */
    public String getMessage() {

        return this.message;
    }

    /**
     * Sets the message.
     *
     * @param message the message
     */
    public void setMessage(String message) {

        this.message = message;
    }

    /**
     * Creates a message.
     *
     * @return the message
     */
    public String createMessage() {

        return "Unspecified Message";
    }

    /*
     * Destroys the message.
     *
     * @param m the message
     */
    public void destroyMessage(String m) {
    }
}

