/*
 * $RCSfile: SplashWindow.java,v $
 *
 * Copyright (c) 1999-2002. Christian Heller. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.application.controller.splash;

import java.awt.event.*;
import java.lang.*;
import javax.swing.*;
import org.resmedicinae.application.controller.basic.*;
import org.resmedicinae.resmedlib.component.context.*;
import org.resmedicinae.resmedlib.component.control.*;
import org.resmedicinae.resmedlib.component.view.*;

/**
 * This class represents a splash window controller.
 *
 * @version $Revision: 1.2 $ $Date: 2002/06/12 18:49:35 $ $Author: chrissy $
 * @author Christian Heller <christian.heller@tuxtax.de>
 */
public class SplashWindow extends BasicController implements ActionListener {
    
    //
    // Control id constants.
    //

    /** The create splash window control id. */
    public static final String CREATE_SPLASH_WINDOW_CONTROL_ID = "create_splash_window";

    /** The destroy splash window control id. */
    public static final String DESTROY_SPLASH_WINDOW_CONTROL_ID = "destroy_splash_window";

    //
    // Attributes.
    //

    /** The timer. */
    private Timer timer;

    //
    // Timer.
    //

    /*
     * Creates a timer.
     *
     * @return the timer
     * @exception NullPointerException if the timer is null
     */
    public Timer createTimer() throws NullPointerException {

        // The timer constructor requires "int delay" and "action listener" as parameters.
        // The delay is given as int in milliseconds, i.e. 1000 ms = 1 s
        return new Timer(1000, this);
    }

    /*
     * Destroys the timer.
     *
     * @param t the timer
     * @exception NullPointerException if the timer is null
     */
    public void destroyTimer(Timer t) throws NullPointerException {

        if (t != null) {

            t.removeActionListener(this);

        } else {

            throw new NullPointerException("Could not destroy timer. The timer is null.");
        }
    }

    /*
     * Returns the default timer.
     *
     * @return the default timer
     */
    public Timer getDefaultTimer() {

        return createTimer();
    }

    /**
     * Returns the timer.
     *
     * @return the timer
     */
    public Timer getTimer() {

        return this.timer;
    }

    /**
     * Sets the timer.
     *
     * @param timer the timer
     */
    public void setTimer(Timer timer) {

        this.timer = timer;
    }

    /*
     * Resets the timer to default.
     *
     * @exception NullPointerException if the timer is null
     */
    public void resetTimer() throws NullPointerException {

        setTimer(getDefaultTimer());
    }

    //
    // View.
    //

    /**
     * Creates the view.
     *
     * @return the view
     * @exception NullPointerException if the view is null
     */
    public View createView() throws NullPointerException {

        SplashWindowView v = new SplashWindowView();

        if (v != null) {

            v.initialize();

        } else {

            throw new NullPointerException("Could not create view. The view is null.");
        }

        return v;
    }

    //
    // Contextualizable.
    //

    /**
     * Contextualizes this component.
     *
     * @param c the context
     * @exception NullPointerException if the context is null
     * @exception NullPointerException if the model is null
     */
    public void contextualize(Context c) throws NullPointerException {

        if (c != null) {

            SplashWindowModel m = (SplashWindowModel) getModel();

            if (m != null) {

                m.setMinimum(((Integer) c.getEntry("minimum")).intValue());
                m.setMaximum(((Integer) c.getEntry("maximum")).intValue());

            } else {

                throw new NullPointerException("Could not contextualize component. The model is null.");
            }

        } else {

            throw new NullPointerException("Could not contextualize component. The context is null.");
        }
    }

    /**
     * Decontextualizes this component.
     *
     * @param c the context
     * @exception NullPointerException if the context is null
     * @exception NullPointerException if the model is null
     */
    public void decontextualize(Context c) throws NullPointerException {

        if (c != null) {

            SplashWindowModel m = (SplashWindowModel) getModel();

            if (m != null) {

                m.setMinimum(m.createMinimum());
                m.setMaximum(m.createMaximum());

            } else {

                throw new NullPointerException("Could not contextualize component. The model is null.");
            }

        } else {

            throw new NullPointerException("Could not contextualize component. The context is null.");
        }
    }

    //
    // Advancable.
    //

    /*
     * Advances the progress bar to the given value.
     *
     * @param step the value to set the progress bar to
     * @param msg the message
     * @exception NullPointerException if the model is null
     * @exception Exception if the given value is outside the min-max scope
     */
    public void advance(int step, String msg) throws NullPointerException, Exception {

        SplashWindowModel m = (SplashWindowModel) getModel();

        if (m != null) {

            if ((step > m.getMinimum()) && ((step <= m.getMaximum()))) {

                m.setCurrentValue(step);
                m.setMessage(msg);

            } else {

                throw new Exception("Could not advance splash window progress bar. The given value is outside the min-max scope.");
            }

        } else {

            throw new NullPointerException("Could not advance splash window progress bar. The model is null.");
        }
    }

    /**
     * ??
     */
    public void actionPerformed(ActionEvent evt) {

/*??
        progressBar.setValue(model.getCurrentValue());
        taskOutput.append(model.getMessage() + newline);
        taskOutput.setCaretPosition(taskOutput.getDocument().getLength());

        if (model.done()) {

            Toolkit.getDefaultToolkit().beep();
            timer.stop();
            startButton.setEnabled(true);
            progressBar.setValue(progressBar.getMinimum());
        }
*/
    }
}

