/*
 * $RCSfile: LoginDialogView.java,v $
 *
 * Copyright (c) 1999-2002. Christian Heller. All rights reserved.
 *
 * This software is published under the GPL GNU General Public License.
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * http://www.resmedicinae.org
 * - Information in Medicine -
 */

package org.resmedicinae.application.controller.login;

import java.awt.*;
import java.awt.event.*;
import java.lang.*;
import javax.swing.*;
import org.resmedicinae.resmedlib.component.view.*;
import org.resmedicinae.resmedlib.component.view.swing.*;

/**
 * This class represents a login dialog view.
 *
 * @version $Revision: 1.2 $ $Date: 2002/06/12 18:49:35 $ $Author: chrissy $
 * @author Christian Heller <christian.heller@tuxtax.de>
 */
public class LoginDialogView extends SwingView {

    //
    // Head panel.
    //

    /**
     * Creates the head panel.
     *
     * @return the head panel
     * @exception NullPointerException if the head panel is null
     */
    private ResPanel createHeadPanel() throws NullPointerException {

        ResPanel p = new ResPanel();

        if (p != null) {

            p.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            p.setLayout(new BorderLayout());
            p.add(createTitleLabel(), BorderLayout.WEST);
            p.add(createVersionLabel(), BorderLayout.CENTER);
            p.add(createDateLabel(), BorderLayout.EAST);
            p.add(createSloganLabel(), BorderLayout.SOUTH);

        } else {

            throw new NullPointerException("Could not create head panel. The head panel is null.");
        }

        return p;
    }

    /**
     * Creates the title label.
     *
     * @return the title label
     * @exception NullPointerException if the title label is null
     */
    private ResLabel createTitleLabel() throws NullPointerException {

        ResLabel l = new ResLabel();

        if (l != null) {

//??            l.setSelectorString("name");
            l.setFont(new Font(null, Font.BOLD, 18));

        } else {

            throw new NullPointerException("Could not create title label. The title label is null.");
        }

        return l;
    }

    /**
     * Creates the version label.
     *
     * @return the version label
     * @exception NullPointerException if the version label is null
     */
    private ResLabel createVersionLabel() throws NullPointerException {

        ResLabel l = new ResLabel();

        if (l != null) {

//??            l.setSelectorString("version");
            l.setFont(new Font(null, Font.BOLD, 18));
            l.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));

        } else {

            throw new NullPointerException("Could not create version label. The version label is null.");
        }

        return l;
    }

    /**
     * Creates the date label.
     *
     * @return the date label
     * @exception NullPointerException if the date label is null
     */
    private ResLabel createDateLabel() throws NullPointerException {

        ResLabel l = new ResLabel();

        if (l != null) {

//??            l.setSelectorString("date");
            l.setHorizontalAlignment(ResLabel.RIGHT);

        } else {

            throw new NullPointerException("Could not create date label. The date label is null.");
        }

        return l;
    }

    /**
     * Creates the slogan label.
     *
     * @return the slogan label
     * @exception NullPointerException if the slogan label is null
     */
    private ResLabel createSloganLabel() throws NullPointerException {

        ResLabel l = new ResLabel();

        if (l != null) {

//??            l.setSelectorString("slogan");

        } else {

            throw new NullPointerException("Could not create slogan label. The slogan label is null.");
        }

        return l;
    }

    //
    // Tabbed pane.
    //

    /**
     * Creates the tabbed pane.
     *
     * @return the tabbed pane
     * @exception NullPointerException if the tabbed pane is null
     */
    private ResTabbedPane createTabbedPane() throws NullPointerException {

        ResTabbedPane tp = new ResTabbedPane();

        if (tp != null) {

            // Initialize tabbed pane.
            tp.addTab("Copyright", createCopyrightPanel());
            tp.addTab("Authors", new ResScrollPane(createAuthorsPanel()));
            tp.addTab("Thanks to", new ResScrollPane(createHelpersPanel()));
            tp.addTab("License", new ResScrollPane(createLicensePanel()));

        } else {

            throw new NullPointerException("Could not create tabbed pane. The tabbed pane is null.");
        }

        return tp;
    }

    /**
     * Creates the copyright panel.
     *
     * @return the copyright panel
     * @exception NullPointerException if the copyright panel is null
     */
    private ResPanel createCopyrightPanel() throws NullPointerException {

        ResPanel p = new ResPanel();

        if (p != null) {

            p.setLayout(new BorderLayout());
            p.add(createCopyrightLabel(), BorderLayout.NORTH);
            p.add(new ResScrollPane(createDescriptionTextPane()), BorderLayout.CENTER);

        } else {

            throw new NullPointerException("Could not create copyright panel. The copyright panel is null.");
        }

        return p;
    }

    /**
     * Creates the copyright label.
     *
     * @return the copyright label
     * @exception NullPointerException if the copyright label is null
     */
    private ResLabel createCopyrightLabel() throws NullPointerException {

        ResLabel l = new ResLabel();

        if (l != null) {

//??            l.setSelectorString("copyright");
            l.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));

        } else {

            throw new NullPointerException("Could not create copyright label. The copyright label is null.");
        }

        return l;
    }

    /**
     * Creates the description text pane.
     *
     * @return the description text pane
     * @exception NullPointerException if the description text pane is null
     */
    private ResTextPane createDescriptionTextPane() throws NullPointerException {

        ResTextPane tp = new ResTextPane();

        if (tp != null) {

//??            tp.setSelectorString("description");
            tp.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            tp.setEditable(false);

        } else {

            throw new NullPointerException("Could not create description text pane. The description text pane is null.");
        }

        return tp;
    }

    /**
     * Creates the authors panel.
     *
     * @return the authors panel
     * @exception NullPointerException if the authors panel is null
     */
    private ResPanel createAuthorsPanel() throws NullPointerException {

        ResPanel p = new ResPanel();

        if (p != null) {

            p.setLayout(new BorderLayout());
            p.add(createAuthorsTextPane(), BorderLayout.CENTER);

        } else {

            throw new NullPointerException("Could not create authors panel. The authors panel is null.");
        }

        return p;
    }

    /**
     * Creates the authors text pane.
     *
     * @return the authors text pane
     * @exception NullPointerException if the authors text pane is null
     */
    private ResTextPane createAuthorsTextPane() throws NullPointerException {

        ResTextPane tp = new ResTextPane();

        if (tp != null) {

//??            tp.setSelectorString("authors");
            tp.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            tp.setEditable(false);

        } else {

            throw new NullPointerException("Could not create authors text pane. The authors text pane is null.");
        }

        return tp;
    }

    /**
     * Creates the helpers panel.
     *
     * @return the helpers panel
     * @exception NullPointerException if the helpers panel is null
     */
    private ResPanel createHelpersPanel() throws NullPointerException {

        ResPanel p = new ResPanel();

        if (p != null) {

            p.setLayout(new BorderLayout());
            p.add(createHelpersTextPane(), BorderLayout.CENTER);

        } else {

            throw new NullPointerException("Could not create helpers panel. The helpers panel is null.");
        }

        return p;
    }

    /**
     * Creates the helpers text pane.
     *
     * @return the helpers text pane
     * @exception NullPointerException if the helpers text pane is null
     */
    private ResTextPane createHelpersTextPane() throws NullPointerException {

        ResTextPane tp = new ResTextPane();

        if (tp != null) {

//??            tp.setSelectorString("helpers");
            tp.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            tp.setEditable(false);

        } else {

            throw new NullPointerException("Could not create helpers text pane. The helpers text pane is null.");
        }

        return tp;
    }

    /**
     * Creates the license panel.
     *
     * @return the license panel
     * @exception NullPointerException if the license panel is null
     */
    private ResPanel createLicensePanel() throws NullPointerException {

        ResPanel p = new ResPanel();

        if (p != null) {

            p.setLayout(new BorderLayout());
            p.add(createLicenseTextPane(), BorderLayout.CENTER);

        } else {

            throw new NullPointerException("Could not create license panel. The license panel is null.");
        }

        return p;
    }

    /**
     * Creates the license text pane.
     *
     * @return the license text pane
     * @exception NullPointerException if the license text pane is null
     */
    private ResTextPane createLicenseTextPane() throws NullPointerException {

        ResTextPane tp = new ResTextPane();

        if (tp != null) {

//??            tp.setSelectorString("license");
            tp.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            tp.setEditable(false);

        } else {

            throw new NullPointerException("Could not create license text pane. The license text pane is null.");
        }

        return tp;
    }

    //
    // Button panel.
    //

    /**
     * Creates the button panel.
     *
     * @return the button panel
     * @exception NullPointerException if the button panel is null
     */
    private ResPanel createButtonPanel() throws NullPointerException {

        ResPanel p = new ResPanel();

        if (p != null) {

            p.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 0));
            p.setLayout(new BorderLayout());
            p.add(createCloseButton(), BorderLayout.EAST);

        } else {

            throw new NullPointerException("Could not create button panel. The button panel is null.");
        }

        return p;
    }

    /**
     * Creates the close button.
     *
     * @return the close button
     * @exception NullPointerException if the close button is null
     */
    private ResButton createCloseButton() throws NullPointerException {

        ResButton b = new ResButton();

        if (b != null) {

            b.setText("Close");
            b.setMnemonic(KeyEvent.VK_C);
            b.setControlId("close-test-change!!" /*??LoginDialogController.CLOSE_LOGIN_DIALOG_CONTROL_ID*/);
//??            b.setOwner(this);

        } else {

            throw new NullPointerException("Could not create close button. The close button is null.");
        }

        return b;
    }

    //
    // Initializable.
    //

    /**
     * Initializes this component.
     */
    public void initialize() {

        // Set parameters.
        setDisplayMode(DisplayFactory.MODAL_DIALOG_DISPLAY);
        setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        setLayout(new BorderLayout());
        setSize(new Dimension(700, 600));

        // Add gui components.
        add(createHeadPanel(), BorderLayout.NORTH);
        add(createTabbedPane(), BorderLayout.CENTER);
        add(createButtonPanel(), BorderLayout.SOUTH);
    }

    /**
     * Finalizes this component.
     */
    public void finalizz() {
    }
}

